/*
 * Decompiled with CFR 0.152.
 */
package arc.util;

import arc.Core;
import arc.files.Fi;
import arc.util.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class OS {
    public static final int cores = Runtime.getRuntime().availableProcessors();
    public static final String username = OS.prop("user.name");
    public static final String userHome = OS.prop("user.home");
    public static final String osName = OS.prop("os.name");
    public static final String osVersion = OS.prop("os.version");
    public static final String osArch = OS.prop("os.arch");
    public static final String osArchBits = OS.prop("sun.arch.data.model");
    public static final String javaVersion = OS.prop("java.version");
    public static final int javaVersionNumber = isAndroid || isIos || javaVersion == null || !javaVersion.contains(".") ? 0 : (javaVersion.startsWith("1.") ? 8 : Strings.parseInt(javaVersion.substring(0, javaVersion.indexOf(46)), 8));
    public static boolean isWindows = OS.propNoNull("os.name").contains("Windows");
    public static boolean isLinux = OS.propNoNull("os.name").contains("Linux") || OS.propNoNull("os.name").contains("BSD");
    public static boolean isMac = OS.propNoNull("os.name").contains("Mac");
    public static boolean isIos = false;
    public static boolean isAndroid = false;
    public static boolean isARM = OS.propNoNull("os.arch").startsWith("arm") || OS.propNoNull("os.arch").startsWith("aarch64");
    public static boolean is64Bit;

    public static String getAppDataDirectoryString(String appname) {
        if (isWindows) {
            return OS.env("AppData") + "\\\\" + appname;
        }
        if (isIos || isAndroid) {
            return Core.files.getLocalStoragePath();
        }
        if (isLinux) {
            if (System.getenv("XDG_DATA_HOME") != null) {
                String dir = System.getenv("XDG_DATA_HOME");
                if (!dir.endsWith("/")) {
                    dir = dir + "/";
                }
                return dir + appname + "/";
            }
            return userHome + "/.local/share/" + appname + "/";
        }
        if (isMac) {
            return userHome + "/Library/Application Support/" + appname + "/";
        }
        return "";
    }

    public static String getWindowsTmpDir() {
        String temp = OS.env("TEMP");
        if (temp != null) {
            return temp;
        }
        String tmp = OS.env("TMP");
        if (tmp != null) {
            return tmp;
        }
        return "C:\\Windows\\TEMP";
    }

    public static String exec(boolean logErr, String ... args) {
        try {
            String line;
            Process process = Runtime.getRuntime().exec(args);
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream(), Strings.utf8));
            StringBuilder result = new StringBuilder();
            while ((line = in.readLine()) != null) {
                result.append(line).append("\n");
            }
            if (logErr) {
                BufferedReader inerr = new BufferedReader(new InputStreamReader(process.getErrorStream(), Strings.utf8));
                while ((line = inerr.readLine()) != null) {
                    result.append(line).append("\n");
                }
            }
            if (result.length() > 0 && result.charAt(result.length() - 1) == '\n') {
                result.setLength(result.length() - 1);
            }
            return result.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String exec(String ... args) {
        return OS.exec(false, args);
    }

    public static boolean execSafe(String command) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(command).getInputStream(), Strings.utf8));
            while ((line = in.readLine()) != null) {
                System.out.println(line);
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean execSafe(String ... command) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(command).getInputStream(), Strings.utf8));
            while ((line = in.readLine()) != null) {
                System.out.println(line);
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static Fi getAppDataDirectory(String appname) {
        return Core.files.absolute(OS.getAppDataDirectoryString(appname));
    }

    public static boolean hasProp(String name) {
        return System.getProperty(name) != null;
    }

    public static String prop(String name) {
        return System.getProperty(name);
    }

    public static boolean hasEnv(String name) {
        return System.getenv(name) != null;
    }

    public static String env(String name) {
        return System.getenv(name);
    }

    public static String propNoNull(String name) {
        String s = OS.prop(name);
        return s == null ? "" : s;
    }

    static {
        boolean bl = is64Bit = OS.propNoNull("os.arch").contains("64") || OS.propNoNull("os.arch").startsWith("armv8");
        if (OS.propNoNull("java.runtime.name").contains("Android Runtime") || OS.propNoNull("java.vm.vendor").contains("The Android Project") || OS.propNoNull("java.vendor").contains("The Android Project")) {
            isAndroid = true;
            isWindows = false;
            isLinux = false;
            isMac = false;
            is64Bit = false;
        }
        if (OS.propNoNull("moe.platform.name").equals("iOS") || !isAndroid && !isWindows && !isLinux && !isMac) {
            isIos = true;
            isAndroid = false;
            isWindows = false;
            isLinux = false;
            isMac = false;
            is64Bit = false;
        }
    }
}

