/*
 * Decompiled with CFR 0.152.
 */
package arc.scene.ui;

import arc.Core;
import arc.func.Boolp;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.Scene;
import arc.scene.event.ChangeListener;
import arc.scene.event.ClickListener;
import arc.scene.event.HandCursorListener;
import arc.scene.event.InputEvent;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.layout.Table;
import arc.scene.utils.Disableable;
import arc.struct.SnapshotSeq;
import arc.util.pooling.Pools;

public class Button
extends Table
implements Disableable {
    boolean isChecked;
    boolean isDisabled;
    ButtonGroup buttonGroup;
    Boolp disabledProvider;
    private ButtonStyle style;
    private ClickListener clickListener;
    private boolean programmaticChangeEvents;

    public Button(ButtonStyle style) {
        this.initialize();
        this.setStyle(style);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public Button() {
        this.initialize();
        this.style = Core.scene.getStyle(ButtonStyle.class);
        Drawable background = this.isPressed() && !this.isDisabled() ? (this.style.down == null ? this.style.up : this.style.down) : (this.isDisabled() && this.style.disabled != null ? this.style.disabled : (this.isChecked && this.style.checked != null ? (this.isOver() && this.style.checkedOver != null ? this.style.checkedOver : this.style.checked) : (this.isOver() && this.style.over != null ? this.style.over : this.style.up)));
        this.setBackground(background);
    }

    public Button(Drawable up) {
        this(new ButtonStyle(up, null, null));
    }

    public Button(Drawable up, Drawable down) {
        this(new ButtonStyle(up, down, null));
    }

    public Button(Drawable up, Drawable down, Drawable checked) {
        this(new ButtonStyle(up, down, checked));
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.disabledProvider != null) {
            this.setDisabled(this.disabledProvider.get());
        }
    }

    private void initialize() {
        this.touchable = Touchable.enabled;
        this.clickListener = new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (Button.this.isDisabled()) {
                    return;
                }
                Button.this.setChecked(!Button.this.isChecked, true);
            }
        };
        this.addListener(this.clickListener);
        this.addListener(new HandCursorListener());
    }

    void setChecked(boolean isChecked, boolean fireEvent) {
        if (this.isChecked == isChecked) {
            return;
        }
        if (this.buttonGroup != null && !this.buttonGroup.canCheck(this, isChecked)) {
            return;
        }
        this.isChecked = isChecked;
        if (fireEvent) {
            ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class, ChangeListener.ChangeEvent::new);
            if (this.fire(changeEvent)) {
                this.isChecked = !isChecked;
            }
            Pools.free(changeEvent);
        }
    }

    public void toggle() {
        this.setChecked(!this.isChecked);
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean isChecked) {
        this.setChecked(isChecked, this.programmaticChangeEvents);
    }

    public boolean isPressed() {
        return this.clickListener.isVisualPressed();
    }

    public boolean isOver() {
        return this.clickListener.isOver();
    }

    public ClickListener getClickListener() {
        return this.clickListener;
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setDisabled(Boolp prov) {
        this.disabledProvider = prov;
    }

    @Override
    public void setDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public boolean childrenPressed() {
        boolean[] b = new boolean[]{false};
        Vec2 v = new Vec2();
        this.forEach(element -> {
            element.stageToLocalCoordinates(v.set(Core.input.mouseX(), Core.input.mouseY()));
            if (element instanceof Button && ((Button)element).getClickListener().isOver((Element)element, v.x, v.y)) {
                b[0] = true;
            }
        });
        return b[0];
    }

    public void setProgrammaticChangeEvents(boolean programmaticChangeEvents) {
        this.programmaticChangeEvents = programmaticChangeEvents;
    }

    public ButtonStyle getStyle() {
        return this.style;
    }

    public void setStyle(ButtonStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        Drawable background = this.isPressed() && !this.isDisabled() ? (style.down == null ? style.up : style.down) : (this.isDisabled() && style.disabled != null ? style.disabled : (this.isChecked && style.checked != null ? (this.isOver() && style.checkedOver != null ? style.checkedOver : style.checked) : (this.isOver() && style.over != null ? style.over : style.up)));
        this.setBackground(background);
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    @Override
    public void draw() {
        int i;
        float offsetY;
        float offsetX;
        this.validate();
        boolean isDisabled = this.isDisabled();
        boolean isPressed = this.isPressed();
        boolean isChecked = this.isChecked();
        boolean isOver = this.isOver();
        Drawable background = null;
        if (isDisabled && this.style.disabled != null) {
            background = this.style.disabled;
        } else if (isPressed && this.style.down != null) {
            background = this.style.down;
        } else if (isChecked && this.style.checked != null) {
            background = this.style.checkedOver != null && isOver ? this.style.checkedOver : this.style.checked;
        } else if (isOver && this.style.over != null) {
            background = this.style.over;
        } else if (this.style.up != null) {
            background = this.style.up;
        }
        this.setBackground(background);
        if (isPressed && !isDisabled) {
            offsetX = this.style.pressedOffsetX;
            offsetY = this.style.pressedOffsetY;
        } else if (isChecked && !isDisabled) {
            offsetX = this.style.checkedOffsetX;
            offsetY = this.style.checkedOffsetY;
        } else {
            offsetX = this.style.unpressedOffsetX;
            offsetY = this.style.unpressedOffsetY;
        }
        SnapshotSeq<Element> children = this.getChildren();
        for (i = 0; i < children.size; ++i) {
            ((Element)children.get(i)).moveBy(offsetX, offsetY);
        }
        super.draw();
        for (i = 0; i < children.size; ++i) {
            ((Element)children.get(i)).moveBy(-offsetX, -offsetY);
        }
        Scene stage = this.getScene();
        if (stage != null && stage.getActionsRequestRendering() && isPressed != this.clickListener.isPressed()) {
            Core.graphics.requestRendering();
        }
    }

    @Override
    public float getPrefWidth() {
        float width = super.getPrefWidth();
        if (this.style.up != null) {
            width = Math.max(width, this.style.up.getMinWidth());
        }
        if (this.style.down != null) {
            width = Math.max(width, this.style.down.getMinWidth());
        }
        if (this.style.checked != null) {
            width = Math.max(width, this.style.checked.getMinWidth());
        }
        return width;
    }

    @Override
    public float getPrefHeight() {
        float height = super.getPrefHeight();
        if (this.style.up != null) {
            height = Math.max(height, this.style.up.getMinHeight());
        }
        if (this.style.down != null) {
            height = Math.max(height, this.style.down.getMinHeight());
        }
        if (this.style.checked != null) {
            height = Math.max(height, this.style.checked.getMinHeight());
        }
        return height;
    }

    @Override
    public float getMinWidth() {
        return this.getPrefWidth();
    }

    @Override
    public float getMinHeight() {
        return this.getPrefHeight();
    }

    public static class ButtonStyle
    extends Style {
        public Drawable up;
        public Drawable down;
        public Drawable over;
        public Drawable checked;
        public Drawable checkedOver;
        public Drawable disabled;
        public float pressedOffsetX;
        public float pressedOffsetY;
        public float unpressedOffsetX;
        public float unpressedOffsetY;
        public float checkedOffsetX;
        public float checkedOffsetY;

        public ButtonStyle() {
        }

        public ButtonStyle(Drawable up, Drawable down, Drawable checked) {
            this.up = up;
            this.down = down;
            this.checked = checked;
        }

        public ButtonStyle(ButtonStyle style) {
            this.up = style.up;
            this.down = style.down;
            this.over = style.over;
            this.checked = style.checked;
            this.checkedOver = style.checkedOver;
            this.disabled = style.disabled;
            this.pressedOffsetX = style.pressedOffsetX;
            this.pressedOffsetY = style.pressedOffsetY;
            this.unpressedOffsetX = style.unpressedOffsetX;
            this.unpressedOffsetY = style.unpressedOffsetY;
            this.checkedOffsetX = style.checkedOffsetX;
            this.checkedOffsetY = style.checkedOffsetY;
        }
    }
}

