/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics;

import arc.files.Fi;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.util.ArcRuntimeException;
import arc.util.Disposable;
import arc.util.Pack;
import arc.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;

public class PixmapIO {
    public static void writePng(Fi file, Pixmap pixmap) {
        try {
            PngWriter writer = new PngWriter((int)((float)(pixmap.width * pixmap.height) * 1.5f));
            try {
                writer.setFlipY(false);
                writer.write(file, pixmap);
            }
            finally {
                writer.dispose();
            }
        }
        catch (IOException ex) {
            throw new ArcRuntimeException("Error writing PNG: " + file, ex);
        }
    }

    public static Pixmap readPNG(Fi file) {
        try {
            PngReader reader = new PngReader();
            ByteBuffer result = reader.read(new ByteArrayInputStream(file.readBytes()));
            return new Pixmap(result, reader.width, reader.height);
        }
        catch (Exception e) {
            throw new ArcRuntimeException("Error reading PNG: " + file, e);
        }
    }

    public static class PngWriter
    implements Disposable {
        private static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        private static final int IHDR = 1229472850;
        private static final int IDAT = 1229209940;
        private static final int IEND = 1229278788;
        private static final byte COLOR_ARGB = 6;
        private static final byte COMPRESSION_DEFLATE = 0;
        private static final byte FILTER_NONE = 0;
        private static final byte INTERLACE_NONE = 0;
        private final ChunkBuffer buffer;
        private final Deflater deflater;
        private boolean flipY = true;

        public PngWriter() {
            this(16384);
        }

        public PngWriter(int initialBufferSize) {
            this.buffer = new ChunkBuffer(initialBufferSize);
            this.deflater = new Deflater();
        }

        public void setFlipY(boolean flipY) {
            this.flipY = flipY;
        }

        public void setCompression(int level) {
            this.deflater.setLevel(level);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(Fi file, Pixmap pixmap) throws IOException {
            OutputStream output = file.write(false);
            try {
                this.write(output, pixmap);
            }
            finally {
                Streams.close(output);
            }
        }

        public void write(OutputStream output, Pixmap pixmap) throws IOException {
            DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
            DataOutputStream dataOutput = new DataOutputStream(output);
            dataOutput.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(pixmap.width);
            this.buffer.writeInt(pixmap.height);
            this.buffer.writeByte(8);
            this.buffer.writeByte(6);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            int lineLen = pixmap.width * 4;
            byte[] curLine = new byte[lineLen + 1];
            ByteBuffer pixels = pixmap.pixels;
            int oldPosition = pixels.position();
            int h = pixmap.height;
            for (int y = 0; y < h; ++y) {
                int py = this.flipY ? h - y - 1 : y;
                pixels.position(py * lineLen);
                pixels.get(curLine, 1, lineLen);
                deflaterOutput.write(curLine, 0, lineLen + 1);
            }
            pixels.position(oldPosition);
            deflaterOutput.finish();
            this.buffer.endChunk(dataOutput);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutput);
            output.flush();
        }

        @Override
        public void dispose() {
            this.deflater.end();
        }

        static class ChunkBuffer
        extends DataOutputStream {
            final ByteArrayOutputStream buffer;
            final CRC32 crc;

            ChunkBuffer(int initialSize) {
                this(new ByteArrayOutputStream(initialSize), new CRC32());
            }

            private ChunkBuffer(ByteArrayOutputStream buffer, CRC32 crc) {
                super(new CheckedOutputStream(buffer, crc));
                this.buffer = buffer;
                this.crc = crc;
            }

            public void endChunk(DataOutputStream target) throws IOException {
                this.flush();
                target.writeInt(this.buffer.size() - 4);
                this.buffer.writeTo(target);
                target.writeInt((int)this.crc.getValue());
                this.buffer.reset();
                this.crc.reset();
            }
        }
    }

    public static class PngReader {
        private static final int ctypeRgba = 6;
        private static final int ctypePalette = 3;
        private static final int ctypeRgb = 2;
        public int width;
        public int height;
        public byte bitDepth;
        public byte colorType;
        public byte compression;
        public byte filter;
        public byte interlace;
        private int dataLen;
        private int cs;
        private byte[] imgData = null;
        private ByteBuffer buf = null;
        private int[] palette;

        public ByteBuffer read(InputStream in) throws IOException {
            this.readChunks(new DataInputStream(in));
            if (this.buf != null) {
                this.buf.clear();
            }
            this.buf = ByteBuffer.allocateDirect(this.cs);
            try {
                this.getImage(this.buf);
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
            this.buf.flip();
            return this.buf;
        }

        private void readChunks(DataInputStream in) throws IOException {
            int chunkType;
            int chunkLen;
            if (this.imgData == null && in.available() > 4) {
                long header = in.readLong();
                if (header != -8552249625308161526L) {
                    String headerString = Long.toHexString(header);
                    throw new IOException(headerString.startsWith("ffd8ff") ? "This is a JPEG, not a PNG." : "This isn't a PNG. Header: 0x" + headerString);
                }
            } else if (this.imgData == null) {
                this.width = 0;
                return;
            }
            this.dataLen = 0;
            while ((chunkLen = in.readInt()) > 0 && chunkLen <= 99998192 && (chunkType = in.readInt()) != 1229278788) {
                if (chunkType == 1229209940) {
                    in.readFully(this.imgData, this.dataLen, chunkLen);
                    this.dataLen += chunkLen;
                } else if (chunkType == 1229472850) {
                    this.width = in.readInt();
                    this.height = in.readInt();
                    this.bitDepth = in.readByte();
                    this.colorType = in.readByte();
                    this.compression = in.readByte();
                    this.filter = in.readByte();
                    this.interlace = in.readByte();
                    this.cs = 4 * this.width * this.height;
                    this.imgData = new byte[in.available()];
                    if (this.bitDepth == 16) {
                        throw new IOException("16-bit depth is not supported.");
                    }
                    if (this.colorType == 3 && this.bitDepth < 4) {
                        throw new IOException("Only PNG palettes with 4 or 8-bit depth are supported. Depth given: " + this.bitDepth);
                    }
                    if (this.colorType != 3 && this.colorType != 2 && this.colorType != 6) {
                        throw new IOException("Unsupported color type: " + this.colorType + " (Note that grayscale is not supported)");
                    }
                    if (this.interlace != 0) {
                        throw new IOException("PNG interlacing is not supported.");
                    }
                } else if (this.colorType == 3 && chunkType == 1347179589) {
                    int colors = chunkLen / 3;
                    this.palette = new int[colors];
                    for (int i = 0; i < colors; ++i) {
                        this.palette[i] = Color.packRgba(in.readUnsignedByte(), in.readUnsignedByte(), in.readUnsignedByte(), 255);
                    }
                } else if (this.colorType == 3 && chunkType == 1951551059) {
                    for (int i = 0; i < chunkLen; ++i) {
                        this.palette[i] = this.palette[i] & 0xFFFFFF00 | in.readUnsignedByte();
                    }
                } else {
                    byte[] chunkData = new byte[chunkLen];
                    in.readFully(chunkData);
                }
                in.readInt();
            }
        }

        private void getImage(ByteBuffer bb) throws DataFormatException {
            int bpx = this.colorType == 3 ? 1 : (this.colorType == 2 ? 3 : 4);
            int wT = this.width * 4;
            int v = (this.bitDepth == 4 ? this.width / 2 : this.width) * bpx + 1;
            Inflater inflater = new Inflater();
            inflater.setInput(this.imgData, 0, this.dataLen);
            byte[] prev = new byte[wT + 1];
            byte[] row = new byte[wT + 1];
            int i = 1;
            for (int s = 0; s < this.height; ++s) {
                inflater.inflate(row, 0, v);
                byte first = row[0];
                if (first != 0) {
                    if (first == 1) {
                        i += bpx;
                        while (i < v) {
                            int n = i;
                            row[n] = (byte)(row[n] + row[i - bpx]);
                            ++i;
                        }
                    } else if (first == 2) {
                        while (i < v) {
                            int n = i;
                            row[n] = (byte)(row[n] + prev[i]);
                            ++i;
                        }
                    } else if (first == 3) {
                        while (i < bpx + 1) {
                            int n = i;
                            row[n] = (byte)(row[n] + ((prev[i] & 0xFF) >>> 1));
                            ++i;
                        }
                        while (i < v) {
                            int n = i;
                            row[n] = (byte)(row[n] + ((prev[i] & 0xFF) + (row[i - bpx] & 0xFF) >>> 1));
                            ++i;
                        }
                    } else {
                        while (i < bpx + 1) {
                            int n = i;
                            row[n] = (byte)(row[n] + prev[i]);
                            ++i;
                        }
                        while (i < v) {
                            int n = i;
                            row[n] = (byte)(row[n] + PngReader.paeth(row[i - bpx] & 0xFF, prev[i] & 0xFF, prev[i - bpx] & 0xFF));
                            ++i;
                        }
                    }
                }
                if (bpx == 3) {
                    ByteBuffer wRow = ByteBuffer.wrap(row);
                    for (i = 1; i < v; i += bpx) {
                        bb.putInt((wRow.getInt(i) & 0xFFFFFF00) + 255);
                    }
                } else if (bpx == 1) {
                    if (this.bitDepth == 4) {
                        for (i = 1; i < v; i += bpx) {
                            bb.putInt(this.palette[Pack.leftByte(row[i])]);
                            bb.putInt(this.palette[Pack.rightByte(row[i])]);
                        }
                    } else {
                        for (i = 1; i < v; i += bpx) {
                            bb.putInt(this.palette[row[i] & 0xFF]);
                        }
                    }
                } else {
                    bb.put(row, 1, v - 1);
                }
                byte[] swap = prev;
                prev = row;
                row = swap;
                i = 1;
            }
            bb.position(bb.capacity());
            this.imgData = null;
        }

        private static int ab(int a) {
            int b = a >> 8;
            return (a ^ b) - b;
        }

        private static int paeth(int a, int b, int c) {
            int pa = b - c;
            int pb = a - c;
            int pc = PngReader.ab(pa + pb);
            return (pa = PngReader.ab(pa)) <= (pb = PngReader.ab(pb)) && pa <= pc ? a : (pb <= pc ? b : c);
        }
    }
}

