/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.modules;

import arc.math.WindowedMean;
import arc.struct.Bits;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.type.Liquid;
import mindustry.world.modules.BlockModule;

public class LiquidModule
extends BlockModule {
    private static final int windowSize = 3;
    private static final Interval flowTimer = new Interval(2);
    private static final float pollScl = 20.0f;
    private static WindowedMean[] cacheFlow;
    private static float[] cacheSums;
    private static float[] displayFlow;
    private static final Bits cacheBits;
    private float[] liquids;
    private Liquid current;
    @Nullable
    private WindowedMean[] flow;

    public LiquidModule() {
        this.liquids = new float[Vars.content.liquids().size];
        this.current = Vars.content.liquid(0);
    }

    public void updateFlow() {
        if (flowTimer.get(1, 20.0f)) {
            if (this.flow == null) {
                int i;
                if (cacheFlow == null || cacheFlow.length != this.liquids.length) {
                    cacheFlow = new WindowedMean[this.liquids.length];
                    for (i = 0; i < this.liquids.length; ++i) {
                        LiquidModule.cacheFlow[i] = new WindowedMean(3);
                    }
                    cacheSums = new float[this.liquids.length];
                    displayFlow = new float[this.liquids.length];
                } else {
                    for (i = 0; i < this.liquids.length; ++i) {
                        cacheFlow[i].reset();
                    }
                    Arrays.fill(cacheSums, 0.0f);
                    cacheBits.clear();
                }
                Arrays.fill(displayFlow, -1.0f);
                this.flow = cacheFlow;
            }
            boolean updateFlow = flowTimer.get(30.0f);
            for (int i = 0; i < this.liquids.length; ++i) {
                this.flow[i].add(cacheSums[i]);
                if (cacheSums[i] > 0.0f) {
                    cacheBits.set(i);
                }
                LiquidModule.cacheSums[i] = 0.0f;
                if (!updateFlow) continue;
                LiquidModule.displayFlow[i] = this.flow[i].hasEnoughData() ? this.flow[i].mean() / 20.0f : -1.0f;
            }
        }
    }

    public void stopFlow() {
        this.flow = null;
    }

    public float getFlowRate(Liquid liquid) {
        return this.flow == null ? -1.0f : displayFlow[liquid.id] * 60.0f;
    }

    public boolean hasFlowLiquid(Liquid liquid) {
        return this.flow != null && cacheBits.get(liquid.id);
    }

    public Liquid current() {
        return this.current;
    }

    public void reset(Liquid liquid, float amount) {
        Arrays.fill(this.liquids, 0.0f);
        this.liquids[liquid.id] = amount;
        this.current = liquid;
    }

    public void set(Liquid liquid, float amount) {
        if (amount >= this.liquids[this.current.id]) {
            this.current = liquid;
        }
        this.liquids[liquid.id] = amount;
    }

    public float currentAmount() {
        return this.liquids[this.current.id];
    }

    public float get(Liquid liquid) {
        return this.liquids[liquid.id];
    }

    public void clear() {
        Arrays.fill(this.liquids, 0.0f);
    }

    public void add(Liquid liquid, float amount) {
        short s = liquid.id;
        this.liquids[s] = this.liquids[s] + amount;
        this.current = liquid;
        if (this.flow != null) {
            short s2 = liquid.id;
            cacheSums[s2] = cacheSums[s2] + Math.max(amount, 0.0f);
        }
    }

    public void handleFlow(Liquid liquid, float amount) {
        if (this.flow != null) {
            short s = liquid.id;
            cacheSums[s] = cacheSums[s] + Math.max(amount, 0.0f);
        }
    }

    public void remove(Liquid liquid, float amount) {
        this.add(liquid, Math.max(-amount, -this.liquids[liquid.id]));
    }

    public void each(LiquidConsumer cons) {
        for (int i = 0; i < this.liquids.length; ++i) {
            if (!(this.liquids[i] > 0.0f)) continue;
            cons.accept(Vars.content.liquid(i), this.liquids[i]);
        }
    }

    public float sum(LiquidCalculator calc) {
        float sum = 0.0f;
        for (int i = 0; i < this.liquids.length; ++i) {
            if (!(this.liquids[i] > 0.0f)) continue;
            sum += calc.get(Vars.content.liquid(i), this.liquids[i]);
        }
        return sum;
    }

    @Override
    public void write(Writes write) {
        int amount = 0;
        for (float liquid : this.liquids) {
            if (!(liquid > 0.0f)) continue;
            ++amount;
        }
        write.s(amount);
        for (int i = 0; i < this.liquids.length; ++i) {
            if (!(this.liquids[i] > 0.0f)) continue;
            write.s(i);
            write.f(this.liquids[i]);
        }
    }

    @Override
    public void read(Reads read, boolean legacy) {
        Arrays.fill(this.liquids, 0.0f);
        int count = legacy ? read.ub() : (int)read.s();
        for (int j = 0; j < count; ++j) {
            Liquid liq = Vars.content.liquid(legacy ? read.ub() : (int)read.s());
            float amount = read.f();
            if (liq == null) continue;
            short liquidid = liq.id;
            this.liquids[liquidid] = amount;
            if (!(amount > this.liquids[this.current.id])) continue;
            this.current = liq;
        }
    }

    static {
        cacheBits = new Bits();
    }

    public static interface LiquidConsumer {
        public void accept(Liquid var1, float var2);
    }

    public static interface LiquidCalculator {
        public float get(Liquid var1, float var2);
    }
}

