/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.world.blocks.distribution.DirectionBridge;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class DuctBridge
extends DirectionBridge {
    public float speed = 5.0f;

    public DuctBridge(String name) {
        super(name);
        this.itemCapacity = 4;
        this.hasItems = true;
        this.underBullets = true;
        this.isDuct = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.itemsMoved, 60.0f / this.speed, StatUnit.itemsSecond);
    }

    public class DuctBridgeBuild
    extends DirectionBridge.DirectionBridgeBuild {
        public float progress = 0.0f;

        @Override
        public void updateTile() {
            Item next;
            this.lastLink = this.findLink();
            DirectionBridge.DirectionBridgeBuild link = this.lastLink;
            if (link != null) {
                link.occupied[this.rotation % 4] = this;
                if (this.items.any() && link.items.total() < link.block.itemCapacity) {
                    this.progress += this.edelta();
                    while (this.progress > DuctBridge.this.speed) {
                        next = this.items.take();
                        if (next != null && link.items.total() < link.block.itemCapacity) {
                            link.handleItem(this, next);
                        }
                        this.progress -= DuctBridge.this.speed;
                    }
                }
            }
            if (link == null && this.items.any() && this.moveForward(next = this.items.first())) {
                this.items.remove(next, 1);
            }
            for (int i = 0; i < 4; ++i) {
                if (this.occupied[i] != null && this.occupied[i].rotation == i && this.occupied[i].isValid() && this.occupied[i].lastLink == this) continue;
                this.occupied[i] = null;
            }
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            if (this.findLink() == null) {
                return false;
            }
            byte rel = this.relativeToEdge(source.tile);
            return this.items.total() < DuctBridge.this.itemCapacity && rel != this.rotation && this.occupied[(rel + 2) % 4] == null;
        }
    }
}

