/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type.weather;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.gen.Groups;
import mindustry.gen.Unit;
import mindustry.gen.WeatherState;
import mindustry.type.Weather;

public class ParticleWeather
extends Weather {
    public String particleRegion = "circle-shadow";
    public Color color = Color.white.cpy();
    public TextureRegion region;
    public float yspeed = -2.0f;
    public float xspeed = 0.25f;
    public float padding = 16.0f;
    public float sizeMin = 2.4f;
    public float sizeMax = 12.0f;
    public float density = 1200.0f;
    public float minAlpha = 1.0f;
    public float maxAlpha = 1.0f;
    public float force = 0.0f;
    public float noiseScale = 2000.0f;
    public float baseSpeed = 6.1f;
    public float sinSclMin = 30.0f;
    public float sinSclMax = 80.0f;
    public float sinMagMin = 1.0f;
    public float sinMagMax = 7.0f;
    public Color noiseColor = this.color;
    public boolean drawNoise = false;
    public boolean drawParticles = true;
    public boolean useWindVector = false;
    public boolean randomParticleRotation = false;
    public int noiseLayers = 1;
    public float noiseLayerSpeedM = 1.1f;
    public float noiseLayerAlphaM = 0.8f;
    public float noiseLayerSclM = 0.99f;
    public float noiseLayerColorM = 1.0f;
    public String noisePath = "noiseAlpha";
    @Nullable
    public Texture noise;

    public ParticleWeather(String name) {
        super(name);
    }

    @Override
    public void load() {
        super.load();
        this.region = Core.atlas.find(this.particleRegion);
        if (this.drawNoise && Core.assets != null) {
            Core.assets.load("sprites/" + this.noisePath + ".png", Texture.class);
        }
    }

    @Override
    public void update(WeatherState state) {
        float speed = this.force * state.intensity * Time.delta;
        if (speed > 0.001f) {
            float windx = state.windVector.x * speed;
            float windy = state.windVector.y * speed;
            for (Unit unit : Groups.unit) {
                unit.impulse(windx, windy);
            }
        }
    }

    @Override
    public void drawOver(WeatherState state) {
        float windy;
        float windx;
        if (this.useWindVector) {
            float speed = this.baseSpeed * state.intensity;
            windx = state.windVector.x * speed;
            windy = state.windVector.y * speed;
        } else {
            windx = this.xspeed;
            windy = this.yspeed;
        }
        if (this.drawNoise) {
            if (this.noise == null) {
                this.noise = Core.assets.get("sprites/" + this.noisePath + ".png", Texture.class);
                this.noise.setWrap(Texture.TextureWrap.repeat);
                this.noise.setFilter(Texture.TextureFilter.linear);
            }
            float sspeed = 1.0f;
            float sscl = 1.0f;
            float salpha = 1.0f;
            float offset = 0.0f;
            Color col = Tmp.c1.set(this.noiseColor);
            for (int i = 0; i < this.noiseLayers; ++i) {
                ParticleWeather.drawNoise(this.noise, this.noiseColor, this.noiseScale * sscl, state.opacity * salpha * this.opacityMultiplier, sspeed * (this.useWindVector ? 1.0f : this.baseSpeed), state.intensity, windx, windy, offset);
                sspeed *= this.noiseLayerSpeedM;
                salpha *= this.noiseLayerAlphaM;
                sscl *= this.noiseLayerSclM;
                offset += 0.29f;
                col.mul(this.noiseLayerColorM);
            }
        }
        if (this.drawParticles) {
            ParticleWeather.drawParticles(this.region, this.color, this.sizeMin, this.sizeMax, this.density, state.intensity, state.opacity, windx, windy, this.minAlpha, this.maxAlpha, this.sinSclMin, this.sinSclMax, this.sinMagMin, this.sinMagMax, this.randomParticleRotation);
        }
    }
}

