/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type.ammo;

import arc.graphics.Color;
import mindustry.content.Fx;
import mindustry.entities.Units;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.AmmoType;
import mindustry.type.Item;

public class ItemAmmoType
implements AmmoType {
    public float range = 85.0f;
    public int ammoPerItem = 15;
    public Item item;

    public ItemAmmoType(Item item) {
        this.item = item;
    }

    public ItemAmmoType(Item item, int ammoPerItem) {
        this.item = item;
        this.ammoPerItem = ammoPerItem;
    }

    public ItemAmmoType() {
    }

    @Override
    public String icon() {
        return this.item.emoji();
    }

    @Override
    public Color color() {
        return this.item.color;
    }

    @Override
    public Color barColor() {
        return Pal.ammo;
    }

    @Override
    public void resupply(Unit unit) {
        if ((float)unit.type.ammoCapacity - unit.ammo < (float)this.ammoPerItem) {
            return;
        }
        float range = unit.hitSize + this.range;
        Building build = Units.closestBuilding(unit.team, unit.x, unit.y, range, u -> u.canResupply() && u.items != null && u.items.has(this.item));
        if (build != null) {
            Fx.itemTransfer.at(build.x, build.y, (float)this.ammoPerItem / 2.0f, this.item.color, unit);
            unit.ammo = Math.min(unit.ammo + (float)this.ammoPerItem, (float)unit.type.ammoCapacity);
            build.items.remove(this.item, 1);
        }
    }
}

