/*
 * Decompiled with CFR 0.152.
 */
package arc.packer;

import arc.files.Fi;
import arc.graphics.Pixmap;
import arc.graphics.PixmapIO;
import arc.graphics.Pixmaps;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureAtlas;
import arc.math.Mathf;
import arc.packer.GridPacker;
import arc.packer.ImageProcessor;
import arc.packer.MaxRectsPacker;
import arc.packer.TexturePackerFileProcessor;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.Strings;
import arc.util.io.Writes;
import arc.util.serialization.Json;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class TexturePacker {
    String rootPath;
    private final Settings settings;
    private final Packer packer;
    private final ImageProcessor imageProcessor;
    private final Seq<InputImage> inputImages = new Seq();

    public TexturePacker(File rootDir, Settings settings) {
        this.settings = settings;
        if (settings.pot) {
            if (settings.maxWidth != Mathf.nextPowerOfTwo(settings.maxWidth)) {
                throw new RuntimeException("If pot is true, maxWidth must be a power of two: " + settings.maxWidth);
            }
            if (settings.maxHeight != Mathf.nextPowerOfTwo(settings.maxHeight)) {
                throw new RuntimeException("If pot is true, maxHeight must be a power of two: " + settings.maxHeight);
            }
        }
        if (settings.multipleOfFour) {
            if (settings.maxWidth % 4 != 0) {
                throw new RuntimeException("If mod4 is true, maxWidth must be evenly divisible by 4: " + settings.maxWidth);
            }
            if (settings.maxHeight % 4 != 0) {
                throw new RuntimeException("If mod4 is true, maxHeight must be evenly divisible by 4: " + settings.maxHeight);
            }
        }
        this.packer = settings.grid ? new GridPacker(settings) : new MaxRectsPacker(settings);
        this.imageProcessor = new ImageProcessor(settings);
        this.setRootDir(rootDir);
    }

    public TexturePacker(Settings settings) {
        this(null, settings);
    }

    public void setRootDir(File rootDir) {
        if (rootDir == null) {
            this.rootPath = null;
            return;
        }
        this.rootPath = rootDir.getAbsolutePath().replace('\\', '/');
        if (!this.rootPath.endsWith("/")) {
            this.rootPath = this.rootPath + "/";
        }
    }

    public void addImage(File file) {
        InputImage inputImage = new InputImage();
        inputImage.file = file;
        inputImage.rootPath = this.rootPath;
        this.inputImages.add(inputImage);
    }

    public void addImage(Pixmap image, String name) {
        InputImage inputImage = new InputImage();
        inputImage.image = image;
        inputImage.name = name;
        this.inputImages.add(inputImage);
    }

    public void pack(File outputDir, String packFileName) {
        if (packFileName.endsWith(this.settings.atlasExtension)) {
            packFileName = packFileName.substring(0, packFileName.length() - this.settings.atlasExtension.length());
        }
        outputDir.mkdirs();
        int n = this.settings.scale.length;
        for (int i = 0; i < n; ++i) {
            this.imageProcessor.setScale(this.settings.scale[i]);
            this.imageProcessor.setResampling(this.settings.scaleResampling);
            int nn = this.inputImages.size;
            for (int ii = 0; ii < nn; ++ii) {
                InputImage inputImage = this.inputImages.get(ii);
                if (inputImage.file != null) {
                    this.imageProcessor.addImage(inputImage.file, inputImage.rootPath);
                    continue;
                }
                this.imageProcessor.addImage(inputImage.image, inputImage.name);
            }
            Seq<Page> pages = this.packer.pack(this.imageProcessor.getImages());
            String scaledPackFileName = this.settings.getScaledPackFileName(packFileName, i);
            this.writeImages(outputDir, scaledPackFileName, pages);
            try {
                this.writePackFile(outputDir, scaledPackFileName, pages);
            }
            catch (IOException ex) {
                throw new RuntimeException("Error writing pack file.", ex);
            }
            this.imageProcessor.clear();
        }
    }

    private void writeImages(File outputDir, String scaledPackFileName, Seq<Page> pages) {
        File packFileNoExt = new File(outputDir, scaledPackFileName);
        File packDir = packFileNoExt.getParentFile();
        String imageName = packFileNoExt.getName();
        int fileIndex = 0;
        int pn = pages.size;
        for (int p = 0; p < pn; ++p) {
            File outputFile;
            Page page = pages.get(p);
            int width = page.width;
            int height = page.height;
            if (this.settings.edgePadding) {
                int edgePadX = this.settings.paddingX;
                int edgePadY = this.settings.paddingY;
                if (this.settings.duplicatePadding) {
                    edgePadX /= 2;
                    edgePadY /= 2;
                }
                page.x = edgePadX;
                page.y = edgePadY;
                width += edgePadX * 2;
                height += edgePadY * 2;
            }
            if (this.settings.pot) {
                width = Mathf.nextPowerOfTwo(width);
                height = Mathf.nextPowerOfTwo(height);
            }
            if (this.settings.multipleOfFour) {
                width = width % 4 == 0 ? width : width + 4 - width % 4;
                height = height % 4 == 0 ? height : height + 4 - height % 4;
            }
            width = Math.max(this.settings.minWidth, width);
            height = Math.max(this.settings.minHeight, height);
            page.imageWidth = width;
            page.imageHeight = height;
            while ((outputFile = new File(packDir, imageName + (fileIndex++ == 0 ? "" : Integer.valueOf(fileIndex)) + "." + this.settings.outputFormat)).exists()) {
            }
            new Fi(outputFile).parent().mkdirs();
            page.imageName = outputFile.getName();
            Pixmap canvas = new Pixmap(width, height);
            if (!this.settings.silent) {
                System.out.println("| Writing " + canvas.width + "x" + canvas.height + ": " + outputFile);
            }
            int rn = page.outputRects.size;
            for (int r = 0; r < rn; ++r) {
                Rect rect = page.outputRects.get(r);
                Pixmap image = rect.getImage(this.imageProcessor);
                int iw = image.width;
                int ih = image.height;
                int rectX = page.x + rect.x;
                int rectY = page.y + page.height - rect.y - (rect.height - this.settings.paddingY);
                if (this.settings.duplicatePadding) {
                    int j;
                    int i;
                    int amountX = this.settings.paddingX / 2;
                    int amountY = this.settings.paddingY / 2;
                    if (rect.rotated) {
                        for (i = 1; i <= amountX; ++i) {
                            for (j = 1; j <= amountY; ++j) {
                                canvas.set(rectX - j, rectY + iw - 1 + i, image.getRaw(0, 0));
                                canvas.set(rectX + ih - 1 + j, rectY + iw - 1 + i, image.getRaw(0, ih - 1));
                                canvas.set(rectX - j, rectY - i, image.getRaw(iw - 1, 0));
                                canvas.set(rectX + ih - 1 + j, rectY - i, image.getRaw(iw - 1, ih - 1));
                            }
                        }
                        for (i = 1; i <= amountY; ++i) {
                            for (j = 0; j < iw; ++j) {
                                canvas.set(rectX - i, rectY + iw - 1 - j, image.getRaw(j, 0));
                                canvas.set(rectX + ih - 1 + i, rectY + iw - 1 - j, image.getRaw(j, ih - 1));
                            }
                        }
                        for (i = 1; i <= amountX; ++i) {
                            for (j = 0; j < ih; ++j) {
                                canvas.set(rectX + j, rectY - i, image.getRaw(iw - 1, j));
                                canvas.set(rectX + j, rectY + iw - 1 + i, image.getRaw(0, j));
                            }
                        }
                    } else {
                        for (i = 1; i <= amountX; ++i) {
                            for (j = 1; j <= amountY; ++j) {
                                canvas.set(rectX - i, rectY - j, image.getRaw(0, 0));
                                canvas.set(rectX - i, rectY + ih - 1 + j, image.getRaw(0, ih - 1));
                                canvas.set(rectX + iw - 1 + i, rectY - j, image.getRaw(iw - 1, 0));
                                canvas.set(rectX + iw - 1 + i, rectY + ih - 1 + j, image.getRaw(iw - 1, ih - 1));
                            }
                        }
                        for (i = 1; i <= amountY; ++i) {
                            TexturePacker.copy(image, 0, 0, iw, 1, canvas, rectX, rectY - i, rect.rotated);
                            TexturePacker.copy(image, 0, ih - 1, iw, 1, canvas, rectX, rectY + ih - 1 + i, rect.rotated);
                        }
                        for (i = 1; i <= amountX; ++i) {
                            TexturePacker.copy(image, 0, 0, 1, ih, canvas, rectX - i, rectY, rect.rotated);
                            TexturePacker.copy(image, iw - 1, 0, 1, ih, canvas, rectX + iw - 1 + i, rectY, rect.rotated);
                        }
                    }
                }
                TexturePacker.copy(image, 0, 0, iw, ih, canvas, rectX, rectY, rect.rotated);
            }
            if (this.settings.bleed) {
                Pixmaps.bleed(canvas, this.settings.bleedIterations);
            }
            if (this.settings.outputFormat.equalsIgnoreCase("apix")) {
                PixmapIO.writeApix(new Fi(outputFile), canvas);
                continue;
            }
            if (this.settings.outputFormat.equalsIgnoreCase("png")) {
                PixmapIO.writePng(new Fi(outputFile), canvas);
                continue;
            }
            throw new ArcRuntimeException("Unsupported image format: '" + this.settings.outputFormat + "'. Must be one of: apix, png");
        }
    }

    private static void copy(Pixmap src, int x, int y, int w, int h, Pixmap dst, int dx, int dy, boolean rotated) {
        if (rotated) {
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    dst.set(dx + j, dy + w - i - 1, src.getRaw(x + i, y + j));
                }
            }
        } else {
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    dst.setRaw(dx + i, dy + j, src.getRaw(x + i, y + j));
                }
            }
        }
    }

    private void writePackFile(File outputDir, String scaledPackFileName, Seq<Page> pages) throws IOException {
        Fi packFile = new Fi(outputDir).child(scaledPackFileName + this.settings.atlasExtension);
        Fi packDir = packFile.parent();
        packDir.mkdirs();
        boolean existed = packFile.exists() && packFile.length() > 0L;
        try (Writes write = packFile.writes(true);){
            if (!existed) {
                write.b(TextureAtlas.TextureAtlasData.formatHeader);
                write.b(0);
            }
            for (Page page : pages) {
                write.b(1);
                write.str(page.imageName);
                write.s(page.imageWidth);
                write.s(page.imageHeight);
                write.b(this.settings.filterMin.ordinal());
                write.b(this.settings.filterMag.ordinal());
                write.b(this.settings.wrapX.ordinal());
                write.b(this.settings.wrapY.ordinal());
                write.i(page.outputRects.sum(i -> 1 + i.aliases.size()));
                page.outputRects.sort();
                for (Rect rect : page.outputRects) {
                    this.writeRect(write, page, rect, rect.name);
                    Seq<Alias> aliases = new Seq<Alias>(rect.aliases.toArray(new Alias[0]));
                    aliases.sort();
                    for (Alias alias : aliases) {
                        Rect aliasRect = new Rect();
                        aliasRect.set(rect);
                        alias.apply(aliasRect);
                        this.writeRect(write, page, aliasRect, alias.name);
                    }
                }
            }
        }
    }

    private void writeRect(Writes write, Page page, Rect rect, String name) throws IOException {
        int i;
        boolean offsets = rect.originalWidth != rect.regionWidth || rect.originalHeight != rect.regionHeight;
        write.str(Rect.getAtlasName(name, this.settings.flattenPaths));
        write.s(page.x + rect.x);
        write.s(page.y + page.height - rect.y - (rect.height - this.settings.paddingY));
        write.s(rect.regionWidth);
        write.s(rect.regionHeight);
        write.bool(offsets);
        if (offsets) {
            write.s(rect.offsetX);
            write.s(rect.originalHeight - rect.regionHeight - rect.offsetY);
            write.s(rect.originalWidth);
            write.s(rect.originalHeight);
        }
        write.bool(rect.splits != null);
        if (rect.splits != null) {
            for (i = 0; i < 4; ++i) {
                write.s(rect.splits[i]);
            }
        }
        write.bool(rect.pads != null);
        if (rect.pads != null) {
            for (i = 0; i < 4; ++i) {
                write.s(rect.pads[i]);
            }
        }
    }

    public static void process(String input, String output, String packFileName) {
        TexturePacker.process(new Settings(), input, output, packFileName);
    }

    public static void process(Settings settings, String input, String output, String packFileName) {
        try {
            TexturePackerFileProcessor processor = new TexturePackerFileProcessor(settings, packFileName);
            processor.process(new File(input), new File(output));
        }
        catch (Exception ex) {
            throw new RuntimeException("Error packing images: " + Strings.getFinalMessage(ex), ex);
        }
    }

    public static boolean isModified(String input, String output, String packFileName, Settings settings) {
        String packFullFileName = output;
        if (!packFullFileName.endsWith("/")) {
            packFullFileName = packFullFileName + "/";
        }
        packFullFileName = packFullFileName + packFileName;
        File outputFile = new File(packFullFileName = packFullFileName + settings.atlasExtension);
        if (!outputFile.exists()) {
            return true;
        }
        File inputFile = new File(input);
        if (!inputFile.exists()) {
            throw new IllegalArgumentException("Input file does not exist: " + inputFile.getAbsolutePath());
        }
        return TexturePacker.isModified(inputFile, outputFile.lastModified());
    }

    private static boolean isModified(File file, long lastModified) {
        if (file.lastModified() > lastModified) {
            return true;
        }
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                if (!TexturePacker.isModified(child, lastModified)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean processIfModified(String input, String output, String packFileName) {
        Settings settings = new Settings();
        if (TexturePacker.isModified(input, output, packFileName, settings)) {
            TexturePacker.process(settings, input, output, packFileName);
            return true;
        }
        return false;
    }

    public static boolean processIfModified(Settings settings, String input, String output, String packFileName) {
        if (TexturePacker.isModified(input, output, packFileName, settings)) {
            TexturePacker.process(settings, input, output, packFileName);
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        Settings settings = null;
        String input = null;
        String output = null;
        String packFileName = "pack.aatls";
        switch (args.length) {
            case 4: {
                settings = new Json().fromJson(Settings.class, new FileReader(args[3]));
            }
            case 3: {
                packFileName = args[2];
            }
            case 2: {
                output = args[1];
            }
            case 1: {
                input = args[0];
                break;
            }
            default: {
                System.out.println("Usage: inputDir [outputDir] [packFileName] [settingsFileName]");
                System.exit(0);
            }
        }
        if (output == null) {
            File inputFile = new File(input);
            output = new File(inputFile.getParentFile(), inputFile.getName() + "-packed").getAbsolutePath();
        }
        if (settings == null) {
            settings = new Settings();
        }
        TexturePacker.process(settings, input, output, packFileName);
    }

    public static class Settings
    implements Cloneable {
        public boolean pot = true;
        public boolean multipleOfFour;
        public int paddingX = 2;
        public int paddingY = 2;
        public boolean edgePadding = true;
        public boolean duplicatePadding = false;
        public boolean rotation;
        public int minWidth = 16;
        public int minHeight = 16;
        public int maxWidth = 1024;
        public int maxHeight = 1024;
        public boolean square = false;
        public boolean stripWhitespaceX;
        public boolean stripWhitespaceY;
        public boolean stripWhitespaceCenter;
        public String[] ignoredWhitespaceStrings = new String[0];
        public int alphaThreshold;
        public Texture.TextureFilter filterMin = Texture.TextureFilter.nearest;
        public Texture.TextureFilter filterMag = Texture.TextureFilter.nearest;
        public Texture.TextureWrap wrapX = Texture.TextureWrap.clampToEdge;
        public Texture.TextureWrap wrapY = Texture.TextureWrap.clampToEdge;
        public boolean alias = true;
        public String outputFormat = "png";
        public boolean ignoreBlankImages = true;
        public boolean fast = true;
        public boolean silent;
        public boolean printAliases;
        public boolean combineSubdirectories;
        public boolean ignore;
        public boolean flattenPaths;
        public boolean bleed = true;
        public int bleedIterations = 2;
        public boolean grid;
        public float[] scale = new float[]{1.0f};
        public String[] scaleSuffix = new String[]{""};
        public boolean scaleResampling = true;
        public String atlasExtension = ".aatls";

        public Settings copy() {
            try {
                return (Settings)this.clone();
            }
            catch (Exception e) {
                throw new RuntimeException("java is a disaster", e);
            }
        }

        public String getScaledPackFileName(String packFileName, int scaleIndex) {
            if (this.scaleSuffix[scaleIndex].length() > 0) {
                packFileName = packFileName + this.scaleSuffix[scaleIndex];
            } else {
                float scaleValue = this.scale[scaleIndex];
                if (this.scale.length != 1) {
                    packFileName = (scaleValue == (float)((int)scaleValue) ? Integer.toString((int)scaleValue) : Float.toString(scaleValue)) + "/" + packFileName;
                }
            }
            return packFileName;
        }
    }

    public static interface Packer {
        public Seq<Page> pack(Seq<Rect> var1);
    }

    static final class InputImage {
        File file;
        String rootPath;
        String name;
        Pixmap image;

        InputImage() {
        }
    }

    public static class Rect
    implements Comparable<Rect> {
        public String name;
        public int offsetX;
        public int offsetY;
        public int regionWidth;
        public int regionHeight;
        public int originalWidth;
        public int originalHeight;
        public int x;
        public int y;
        public int width;
        public int height;
        public boolean rotated;
        public Set<Alias> aliases = new HashSet<Alias>();
        public int[] splits;
        public int[] pads;
        public boolean canRotate = true;
        boolean isPatch;
        Pixmap pixmap;
        Fi file;
        int score1;
        int score2;

        Rect(Pixmap source, int left, int top, int newWidth, int newHeight, boolean isPatch) {
            this.pixmap = source.width == newWidth && source.height == newHeight && left == 0 && top == 0 ? source : source.crop(left, top, newWidth, newHeight);
            this.offsetX = left;
            this.offsetY = top;
            this.regionWidth = newWidth;
            this.regionHeight = newHeight;
            this.originalWidth = source.width;
            this.originalHeight = source.height;
            this.width = newWidth;
            this.height = newHeight;
            this.isPatch = isPatch;
        }

        public Pixmap getImage(ImageProcessor imageProcessor) {
            if (this.pixmap != null) {
                return this.pixmap;
            }
            Pixmap image = new Pixmap(this.file);
            String name = this.name;
            if (this.isPatch) {
                name = name + ".9";
            }
            return imageProcessor.processImage(image, name).getImage(null);
        }

        Rect() {
        }

        Rect(Rect rect) {
            this.x = rect.x;
            this.y = rect.y;
            this.width = rect.width;
            this.height = rect.height;
        }

        void set(Rect rect) {
            this.name = rect.name;
            this.pixmap = rect.pixmap;
            this.offsetX = rect.offsetX;
            this.offsetY = rect.offsetY;
            this.regionWidth = rect.regionWidth;
            this.regionHeight = rect.regionHeight;
            this.originalWidth = rect.originalWidth;
            this.originalHeight = rect.originalHeight;
            this.x = rect.x;
            this.y = rect.y;
            this.width = rect.width;
            this.height = rect.height;
            this.rotated = rect.rotated;
            this.aliases = rect.aliases;
            this.splits = rect.splits;
            this.pads = rect.pads;
            this.canRotate = rect.canRotate;
            this.score1 = rect.score1;
            this.score2 = rect.score2;
            this.file = rect.file;
            this.isPatch = rect.isPatch;
        }

        @Override
        public int compareTo(Rect o) {
            return this.name.compareTo(o.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Rect other = (Rect)obj;
            if (this.name == null) {
                return other.name == null;
            }
            return this.name.equals(other.name);
        }

        public String toString() {
            return this.name + "[" + this.x + "," + this.y + " " + this.width + "x" + this.height + "]";
        }

        public static String getAtlasName(String name, boolean flattenPaths) {
            return flattenPaths ? new Fi(name).name() : name;
        }
    }

    public static class Page {
        public String imageName;
        public Seq<Rect> outputRects;
        public Seq<Rect> remainingRects;
        public float occupancy;
        public int x;
        public int y;
        public int width;
        public int height;
        public int imageWidth;
        public int imageHeight;
    }

    public static class Alias
    implements Comparable<Alias> {
        public String name;
        public int index;
        public int[] splits;
        public int[] pads;
        public int offsetX;
        public int offsetY;
        public int originalWidth;
        public int originalHeight;

        public Alias(Rect rect) {
            this.name = rect.name;
            this.splits = rect.splits;
            this.pads = rect.pads;
            this.offsetX = rect.offsetX;
            this.offsetY = rect.offsetY;
            this.originalWidth = rect.originalWidth;
            this.originalHeight = rect.originalHeight;
        }

        public void apply(Rect rect) {
            rect.name = this.name;
            rect.splits = this.splits;
            rect.pads = this.pads;
            rect.offsetX = this.offsetX;
            rect.offsetY = this.offsetY;
            rect.originalWidth = this.originalWidth;
            rect.originalHeight = this.originalHeight;
        }

        @Override
        public int compareTo(Alias o) {
            return this.name.compareTo(o.name);
        }
    }
}

