/*
 * Decompiled with CFR 0.152.
 */
package arc.fx.util;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.gl.FrameBuffer;

public final class PingPongBuffer {
    private final FrameBuffer buffer1;
    private final FrameBuffer buffer2;
    private FrameBuffer bufDst;
    private FrameBuffer bufSrc;
    private boolean writeState;
    private boolean capturing;
    private Texture.TextureWrap wrapU = Texture.TextureWrap.clampToEdge;
    private Texture.TextureWrap wrapV = Texture.TextureWrap.clampToEdge;
    private Texture.TextureFilter filterMin = Texture.TextureFilter.linear;
    private Texture.TextureFilter filterMag = Texture.TextureFilter.linear;

    public PingPongBuffer(Pixmap.Format fbFormat) {
        this(fbFormat, Core.graphics.getWidth(), Core.graphics.getHeight());
    }

    public PingPongBuffer(Pixmap.Format fbFormat, int width, int height) {
        this(fbFormat, width, height, false, false);
    }

    public PingPongBuffer(Pixmap.Format fbFormat, int width, int height, boolean depth, boolean stencil) {
        this.buffer1 = new FrameBuffer(fbFormat, width, height, depth, stencil);
        this.buffer2 = new FrameBuffer(fbFormat, width, height, depth, stencil);
        this.rebind();
        this.writeState = false;
        this.bufDst = this.buffer1;
        this.bufSrc = this.buffer2;
    }

    public void dispose() {
        this.buffer1.dispose();
        this.buffer2.dispose();
    }

    public void resize(int width, int height) {
        this.buffer1.resize(width, height);
        this.buffer2.resize(width, height);
        this.rebind();
    }

    public void rebind() {
        Texture texture;
        if (this.buffer1 != null) {
            texture = (Texture)this.buffer1.getTexture();
            texture.setWrap(this.wrapU, this.wrapV);
            texture.setFilter(this.filterMin, this.filterMag);
        }
        if (this.buffer2 != null) {
            texture = (Texture)this.buffer2.getTexture();
            texture.setWrap(this.wrapU, this.wrapV);
            texture.setFilter(this.filterMin, this.filterMag);
        }
    }

    public void begin() {
        if (this.capturing) {
            throw new IllegalStateException("Ping pong buffer is already in capturing state.");
        }
        this.capturing = true;
        this.bufDst.begin();
    }

    public void swap() {
        if (this.capturing) {
            this.bufDst.end();
        }
        if (this.writeState) {
            this.bufSrc = this.buffer1;
            this.bufDst = this.buffer2;
        } else {
            this.bufSrc = this.buffer2;
            this.bufDst = this.buffer1;
        }
        if (this.capturing) {
            this.bufDst.begin();
        }
        this.writeState = !this.writeState;
    }

    public void end() {
        if (!this.capturing) {
            throw new IllegalStateException("Ping pong is not in capturing state. You should call begin() before calling end().");
        }
        this.bufDst.end();
        this.capturing = false;
    }

    public Texture getSrcTexture() {
        return (Texture)this.bufSrc.getTexture();
    }

    public FrameBuffer getSrcBuffer() {
        return this.bufSrc;
    }

    public Texture getDstTexture() {
        return (Texture)this.bufDst.getTexture();
    }

    public FrameBuffer getDstBuffer() {
        return this.bufDst;
    }

    public void setTextureParams(Texture.TextureWrap u, Texture.TextureWrap v, Texture.TextureFilter min, Texture.TextureFilter mag) {
        this.wrapU = u;
        this.wrapV = v;
        this.filterMin = min;
        this.filterMag = mag;
        this.rebind();
    }

    public void clear(Color clearColor) {
        this.clear(clearColor.r, clearColor.g, clearColor.b, clearColor.a);
    }

    public void clear(float r, float g, float b, float a) {
        boolean wasCapturing = this.capturing;
        if (!wasCapturing) {
            this.begin();
        }
        Gl.clearColor(r, g, b, a);
        Gl.clear(16384);
        this.swap();
        Gl.clear(16384);
        if (!wasCapturing) {
            this.end();
        }
    }
}

