/*
 * Decompiled with CFR 0.152.
 */
package arc.fx.filters;

import arc.Application;
import arc.Core;
import arc.fx.FxFilter;
import arc.fx.filters.CopyFilter;
import arc.fx.util.FxBufferQueue;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.gl.FrameBuffer;

public class MotionBlurFilter
extends FxFilter {
    private final CopyFilter copyFilter = new CopyFilter();
    private final FxBufferQueue localBuffer = new FxBufferQueue(Pixmap.Format.rgba8888, Core.app.getType() == Application.ApplicationType.web ? 2 : 1);
    public float blurOpacity = 0.9f;
    public Texture lastFrameTex;

    public MotionBlurFilter(BlurFunction blurFunction) {
        super(MotionBlurFilter.compileShader(Core.files.classpath("vfxshaders/screenspace.vert"), Core.files.classpath("vfxshaders/" + blurFunction.fragmentShaderName + ".frag")));
        this.rebind();
    }

    @Override
    public void resize(int width, int height) {
        this.copyFilter.resize(width, height);
        this.localBuffer.resize(width, height);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.copyFilter.dispose();
        this.localBuffer.dispose();
    }

    @Override
    public void rebind() {
        super.rebind();
        this.copyFilter.rebind();
        this.localBuffer.rebind();
    }

    @Override
    public void setParams() {
        this.shader.setUniformi("u_texture0", 0);
        if (this.lastFrameTex != null) {
            this.shader.setUniformi("u_texture1", 1);
        }
        this.shader.setUniformf("u_blurOpacity", this.blurOpacity);
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
        if (this.lastFrameTex != null) {
            this.lastFrameTex.bind(1);
        }
    }

    @Override
    public void render(FrameBuffer src, FrameBuffer dst) {
        FrameBuffer prevFrame = this.localBuffer.changeToNext();
        this.setInput(src).setOutput(prevFrame).render();
        this.lastFrameTex = (Texture)prevFrame.getTexture();
        this.copyFilter.setInput(prevFrame).setOutput(dst).render();
    }

    public static enum BlurFunction {
        MAX("motionblur-max"),
        MIX("motionblur-mix");

        final String fragmentShaderName;

        private BlurFunction(String fragmentShaderName) {
            this.fragmentShaderName = fragmentShaderName;
        }
    }
}

