/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.campaign;

import arc.Core;
import arc.Events;
import arc.Graphics;
import arc.audio.Music;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.core.UI;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.entities.Lightning;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Musics;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Shaders;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.LaunchAnimator;
import mindustry.world.blocks.storage.CoreBlock;

public class Accelerator
extends Block {
    public TextureRegion arrowRegion;
    public TextureRegion selectArrowRegion;
    public Block launchBlock = Blocks.coreNucleus;
    public float powerBufferRequirement;
    @Nullable
    public Seq<Planet> launchCandidates;
    public Music launchMusic = Musics.coreLaunch;
    public float launchDuration = 120.0f;
    public float chargeDuration = 220.0f;
    public float buildDuration = 120.0f;
    public Interp landZoomInterp = Interp.pow4In;
    public Interp chargeZoomInterp = Interp.pow4In;
    public float landZoomFrom = 0.02f;
    public float landZoomTo = 4.0f;
    public float chargeZoomTo = 5.0f;
    public int chargeRings = 4;
    public float ringRadBase = 60.0f;
    public float ringRadSpacing = 25.0f;
    public float ringRadPow = 1.6f;
    public float ringStroke = 3.0f;
    public float ringSpeedup = 1.4f;
    public float chargeRingMerge = 2.0f;
    public float ringArrowRad = 3.0f;
    public float ringHandleTilt = 0.8f;
    public float ringHandleLen = 30.0f;
    public Color ringColor = Pal.accent;
    public int launchLightning = 20;
    public Color lightningColor = Pal.accent;
    public float lightningDamage = 40.0f;
    public float lightningOffset = 24.0f;
    public int lightningLengthMin = 5;
    public int lightningLengthMax = 25;
    public double lightningLaunchChance = 0.8;
    protected int[] capacities = new int[0];

    public Accelerator(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.hasItems = true;
        this.hasPower = true;
        this.itemCapacity = 8000;
        this.configurable = true;
        this.emitLight = true;
        this.lightRadius = 70.0f;
        this.lightColor = Pal.accent;
    }

    @Override
    public void init() {
        this.itemCapacity = 0;
        this.capacities = new int[Vars.content.items().size];
        for (ItemStack stack : this.launchBlock.requirements) {
            this.capacities[stack.item.id] = stack.amount;
            this.itemCapacity += stack.amount;
        }
        this.consumeItems(this.launchBlock.requirements);
        super.init();
    }

    @Override
    public void setBars() {
        super.setBars();
        if (this.powerBufferRequirement > 0.0f) {
            this.addBar("powerBufferRequirement", b -> new Bar(() -> Core.bundle.format("bar.powerbuffer", UI.formatAmount((long)b.power.graph.getBatteryStored()), UI.formatAmount((long)this.powerBufferRequirement)), () -> Pal.powerBar, () -> b.power.graph.getBatteryStored() / this.powerBufferRequirement));
        }
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    public class AcceleratorBuild
    extends Building
    implements LaunchAnimator {
        public float heat;
        public float statusLerp;
        public float progress;
        public float time;
        public float launchHeat;
        public boolean launching;
        public float launchTime;
        protected float cloudSeed;

        @Override
        public void updateTile() {
            super.updateTile();
            this.heat = Mathf.lerpDelta(this.heat, this.launching ? 1.0f : this.efficiency, 0.05f);
            this.statusLerp = Mathf.lerpDelta(this.statusLerp, this.power.status, 0.05f);
            this.time = !this.launching ? (this.time += Time.delta * this.efficiency) : Mathf.slerpDelta(this.time, 0.0f, 0.4f);
            this.launchHeat = Mathf.lerpDelta(this.launchHeat, this.launching ? 1.0f : 0.0f, 0.1f);
            if (this.efficiency >= 0.0f) {
                this.progress += Time.delta * this.efficiency / Accelerator.this.buildDuration;
                this.progress = Math.min(this.progress, 1.0f);
            }
        }

        @Override
        public float progress() {
            return this.progress;
        }

        @Override
        public void draw() {
            float rot;
            int i;
            super.draw();
            for (int l = 0; l < 4; ++l) {
                float length = 7.0f + (float)l * 5.0f;
                Draw.color(Tmp.c1.set(Pal.darkMetal).lerp(this.team.color, this.statusLerp), Pal.darkMetal, Mathf.absin(Time.time + (float)l * 50.0f, 10.0f, 1.0f));
                for (i = 0; i < 4; ++i) {
                    rot = (float)i * 90.0f + 45.0f;
                    Draw.rect(Accelerator.this.arrowRegion, this.x + Angles.trnsx(rot, length), this.y + Angles.trnsy(rot, length), rot + 180.0f);
                }
            }
            if (this.launching) {
                Draw.reset();
                Draw.blend(Blending.additive);
                Fill.light(this.x, this.y, 15, (float)(Accelerator.this.launchBlock.size * 8) * 1.0f, Tmp.c2.set(Pal.accent).a(this.launchTime / Accelerator.this.chargeDuration), Tmp.c1.set(Pal.accent).a(0.0f));
                Draw.blend();
                Draw.rect(Accelerator.this.launchBlock.fullIcon, this.x, this.y);
                Draw.z(100.0f);
                Draw.mixcol(Pal.accent, Mathf.clamp(this.launchTime / Accelerator.this.chargeDuration));
                Draw.color(1.0f, 1.0f, 1.0f, Interp.pow2In.apply(Mathf.clamp(this.launchTime / Accelerator.this.chargeDuration * 0.7f)));
                Draw.rect(Accelerator.this.launchBlock.fullIcon, this.x, this.y);
                Draw.reset();
            } else {
                Drawf.shadow(this.x, this.y, (float)(Accelerator.this.launchBlock.size * 8) * 2.0f, this.progress);
                Draw.draw(40.0f, () -> {
                    Draw.color(Pal.accent, this.heat);
                    TextureRegion[] textureRegionArray = Accelerator.this.launchBlock.getGeneratedIcons();
                    int n = textureRegionArray.length;
                    for (int i = 0; i < n; ++i) {
                        TextureRegion region;
                        Shaders.blockbuild.region = region = textureRegionArray[i];
                        Shaders.blockbuild.time = this.time;
                        Shaders.blockbuild.progress = this.progress;
                        Draw.rect(region, this.x, this.y);
                        Draw.flush();
                    }
                    Draw.color();
                });
            }
            Draw.reset();
            if (this.heat < 1.0E-4f) {
                return;
            }
            float rad = (float)(Accelerator.this.size * 8) / 2.0f * 0.74f * Mathf.lerp(1.0f, 1.3f, this.launchHeat);
            float scl = 2.0f;
            Draw.z(99.9999f);
            Lines.stroke(1.75f * this.heat, Pal.accent);
            Lines.square(this.x, this.y, rad * 1.22f, Mathf.lerp(45.0f, 0.0f, this.launchHeat));
            Lines.stroke(3.0f * this.heat, Pal.accent);
            Lines.square(this.x, this.y, rad * Mathf.lerp(1.0f, 1.3f, this.launchHeat), 45.0f + this.time / scl);
            Lines.square(this.x, this.y, rad * Mathf.lerp(1.0f, 1.8f, this.launchHeat), Mathf.lerp(45.0f, 0.0f, this.launchHeat) - this.time / scl);
            Draw.color(this.team.color);
            Draw.alpha(Mathf.clamp(this.heat * 3.0f));
            for (i = 0; i < 4; ++i) {
                rot = (float)i * 90.0f + 45.0f + -this.time / 3.0f % 360.0f;
                float length = 26.0f * this.heat * Mathf.lerp(1.0f, 1.5f, this.launchHeat);
                Draw.rect(Accelerator.this.arrowRegion, this.x + Angles.trnsx(rot, length), this.y + Angles.trnsy(rot, length), rot + 180.0f);
            }
            Draw.reset();
        }

        @Override
        public void drawLight() {
            Drawf.light(this.x, this.y, Accelerator.this.lightRadius, Accelerator.this.lightColor, this.launchHeat);
        }

        public boolean canLaunch() {
            return this.isValid() && !Vars.net.client() && Vars.state.isCampaign() && this.efficiency > 0.0f && this.power.graph.getBatteryStored() >= Accelerator.this.powerBufferRequirement - 1.0E-5f && this.progress >= 1.0f && !this.launching;
        }

        @Override
        public Graphics.Cursor getCursor() {
            return this.canLaunch() ? Graphics.Cursor.SystemCursor.hand : super.getCursor();
        }

        @Override
        public void drawSelect() {
            super.drawSelect();
            if (this.power.graph.getBatteryStored() < Accelerator.this.powerBufferRequirement && !this.launching) {
                Accelerator.this.drawPlaceText(Core.bundle.get("bar.nobatterypower"), this.tile.x, this.tile.y, false);
            }
        }

        @Override
        public void buildConfiguration(Table table) {
            this.deselect();
            if (!this.canLaunch()) {
                return;
            }
            Vars.ui.planet.showPlanetLaunch(Vars.state.rules.sector, Accelerator.this.launchCandidates == null ? Vars.state.rules.sector.planet.launchCandidates : Accelerator.this.launchCandidates, sector -> {
                if (this.canLaunch()) {
                    this.consume();
                    this.power.graph.useBatteries(Accelerator.this.powerBufferRequirement);
                    this.progress = 0.0f;
                    Vars.renderer.showLaunch(this);
                    Time.runTask(this.launchDuration() - 6.0f, () -> {
                        this.launching = false;
                        sector.planet.unlockedOnLand.each(UnlockableContent::unlock);
                        Vars.universe.clearLoadoutInfo();
                        Vars.universe.updateLoadout((CoreBlock)Accelerator.this.launchBlock);
                        Vars.control.playSector((Sector)sector);
                    });
                }
            });
            Events.fire(EventType.Trigger.acceleratorUse);
        }

        @Override
        public int getMaximumAccepted(Item item) {
            return Accelerator.this.capacities[item.id];
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.items.get(item) < this.getMaximumAccepted(item);
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.progress = read.f();
            }
        }

        @Override
        public float launchDuration() {
            return Accelerator.this.launchDuration + Accelerator.this.chargeDuration;
        }

        @Override
        public Music landMusic() {
            return Accelerator.this.launchMusic;
        }

        @Override
        public Music launchMusic() {
            return Accelerator.this.launchMusic;
        }

        @Override
        public void beginLaunch(boolean launching) {
            if (!launching) {
                return;
            }
            this.launching = true;
            Fx.coreLaunchConstruct.at(this.x, this.y, Accelerator.this.launchBlock.size);
            this.cloudSeed = Mathf.random(1.0f);
            float margin = 30.0f;
            Image image = new Image();
            image.color.a = 0.0f;
            image.touchable = Touchable.disabled;
            image.setFillParent(true);
            image.actions(Actions.delay((this.launchDuration() - margin) / 60.0f), Actions.fadeIn(margin / 60.0f, Interp.pow2In), Actions.delay(0.1f), Actions.remove());
            image.update(() -> {
                image.toFront();
                Vars.ui.loadfrag.toFront();
                if (Vars.state.isMenu()) {
                    image.remove();
                }
            });
            Core.scene.add(image);
            Time.run(Accelerator.this.chargeDuration, () -> {
                Fx.coreLaunchConstruct.at(this.x, this.y, Accelerator.this.launchBlock.size);
                Fx.launchAccelerator.at(this.x, this.y);
                Effect.shake(10.0f, 14.0f, this);
                for (int i = 0; i < Accelerator.this.launchLightning; ++i) {
                    float a = Mathf.random(360.0f);
                    Lightning.create(this.team, Accelerator.this.lightningColor, Accelerator.this.lightningDamage, this.x + Angles.trnsx(a, Accelerator.this.lightningOffset), this.y + Angles.trnsy(a, Accelerator.this.lightningOffset), a, Mathf.random(Accelerator.this.lightningLengthMin, Accelerator.this.lightningLengthMax));
                }
                float spacing = 12.0f;
                for (int i = 0; i < 13; ++i) {
                    int fi = i;
                    Time.run((float)i * 1.1f, () -> {
                        float radius = (float)this.block.size / 2.0f + 1.0f + spacing * (float)fi;
                        int rays = Mathf.ceil(radius * (float)Math.PI * 2.0f / 6.0f);
                        for (int r = 0; r < rays; ++r) {
                            float oy;
                            float angle;
                            float ox;
                            Tile t;
                            if (!Mathf.chance(0.7f - (float)fi * 0.02f) || (t = Vars.world.tileWorld(this.x + (ox = Angles.trnsx(angle = (float)r * 360.0f / (float)rays, radius)), this.y + (oy = Angles.trnsy(angle, radius)))) == null) continue;
                            Fx.coreLandDust.at(t.worldx(), t.worldy(), angle + Mathf.range(30.0f), Tmp.c1.set(t.floor().mapColor).mul(1.7f + Mathf.range(0.15f)));
                        }
                    });
                }
            });
        }

        @Override
        public void endLaunch() {
            this.launching = false;
            this.launchTime = 0.0f;
        }

        @Override
        public float zoomLaunch() {
            float rawTime = this.launchDuration() - Vars.renderer.getLandTime();
            float shake = rawTime < Accelerator.this.chargeDuration ? Interp.pow10In.apply(Mathf.clamp(rawTime / Accelerator.this.chargeDuration)) : 0.0f;
            Core.camera.position.set(this.x, this.y).add(Tmp.v1.setToRandomDirection().scl(shake * 2.0f));
            if (rawTime < Accelerator.this.chargeDuration) {
                float fin = rawTime / Accelerator.this.chargeDuration;
                return Accelerator.this.chargeZoomInterp.apply(Scl.scl(Accelerator.this.landZoomTo), Scl.scl(Accelerator.this.chargeZoomTo), fin);
            }
            float rawFin = Vars.renderer.getLandTimeIn();
            float fin = 1.0f - Mathf.clamp(1.0f - rawFin - Accelerator.this.chargeDuration / (Accelerator.this.launchDuration + Accelerator.this.chargeDuration)) / (1.0f - Accelerator.this.chargeDuration / (Accelerator.this.launchDuration + Accelerator.this.chargeDuration));
            return Accelerator.this.landZoomInterp.apply(Scl.scl(Accelerator.this.landZoomFrom), Scl.scl(Accelerator.this.landZoomTo), fin);
        }

        @Override
        public void updateLaunch() {
            float in = Vars.renderer.getLandTimeIn() * this.launchDuration();
            this.launchTime = this.launchDuration() - in;
            float tsize = Mathf.sample(CoreBlock.thrusterSizes, (in + 35.0f) / this.launchDuration());
            float rawFin = Vars.renderer.getLandTimeIn();
            float chargeFin = 1.0f - Mathf.clamp((1.0f - rawFin) / (Accelerator.this.chargeDuration / (Accelerator.this.launchDuration + Accelerator.this.chargeDuration)));
            float chargeFout = 1.0f - chargeFin;
            if (in > Accelerator.this.launchDuration && Mathf.chanceDelta(Accelerator.this.lightningLaunchChance * (double)Interp.pow3In.apply(chargeFout))) {
                float a = Mathf.random(360.0f);
                Lightning.create(this.team, Accelerator.this.lightningColor, Accelerator.this.lightningDamage, this.x + Angles.trnsx(a, Accelerator.this.lightningOffset), this.y + Angles.trnsy(a, Accelerator.this.lightningOffset), a, Mathf.random(Accelerator.this.lightningLengthMin, Accelerator.this.lightningLengthMax));
            }
        }

        @Override
        public void drawLaunch() {
            float f;
            Texture clouds = Core.assets.get("sprites/clouds.png", Texture.class);
            float rawFin = Vars.renderer.getLandTimeIn();
            float rawTime = this.launchDuration() - Vars.renderer.getLandTime();
            float fin = 1.0f - Mathf.clamp(1.0f - rawFin - Accelerator.this.chargeDuration / (Accelerator.this.launchDuration + Accelerator.this.chargeDuration)) / (1.0f - Accelerator.this.chargeDuration / (Accelerator.this.launchDuration + Accelerator.this.chargeDuration));
            float chargeFin = 1.0f - Mathf.clamp((1.0f - rawFin) / (Accelerator.this.chargeDuration / (Accelerator.this.launchDuration + Accelerator.this.chargeDuration)));
            float chargeFout = 1.0f - chargeFin;
            float cameraScl = Vars.renderer.getDisplayScale();
            float fout = 1.0f - fin;
            float scl = Scl.scl(4.0f) / cameraScl;
            float pfin = Interp.pow3Out.apply(fin);
            float pf = Interp.pow2In.apply(fout);
            Draw.color(Pal.lightTrail);
            Angles.randLenVectors(1L, pfin, 100, 800.0f * scl * pfin, (ax, ay, ffin, ffout) -> {
                Lines.stroke(scl * ffin * pf * 3.0f);
                Lines.lineAngle(this.x + ax, this.y + ay, Mathf.angle(ax, ay), (ffin * 20.0f + 1.0f) * scl);
            });
            Draw.color();
            if (rawTime >= Accelerator.this.chargeDuration) {
                this.drawLanding(fin, this.x, this.y);
            }
            Draw.color();
            Draw.mixcol(Color.white, Interp.pow5In.apply(fout));
            if (Vars.renderer.isLaunching() && (f = Mathf.clamp(1.0f - fout * 12.0f)) > 0.001f) {
                Draw.mixcol(Pal.accent, f);
            }
            if (Vars.state.rules.cloudColor.a > 1.0E-4f) {
                float scaling = 1700.0f;
                float sscl = Math.max(1.0f + Mathf.clamp(fin + 0.3f) * -2.0f, 0.0f) * cameraScl;
                Tmp.tr1.set(clouds);
                Tmp.tr1.set((Core.camera.position.x - Core.camera.width / 2.0f * sscl) / scaling, (Core.camera.position.y - Core.camera.height / 2.0f * sscl) / scaling, (Core.camera.position.x + Core.camera.width / 2.0f * sscl) / scaling, (Core.camera.position.y + Core.camera.height / 2.0f * sscl) / scaling);
                Tmp.tr1.scroll(10.0f * this.cloudSeed, 10.0f * this.cloudSeed);
                Draw.alpha(Mathf.sample(CoreBlock.cloudAlphas, fin + 0.25f) * 0.81f);
                Draw.mixcol(Vars.state.rules.cloudColor, Vars.state.rules.cloudColor.a);
                Draw.rect(Tmp.tr1, Core.camera.position.x, Core.camera.position.y, Core.camera.width, Core.camera.height);
                Draw.reset();
            }
        }

        @Override
        public void drawLaunchGlobalZ() {
            float rawFin = Vars.renderer.getLandTimeIn();
            float chargeFin = 1.0f - Mathf.clamp((1.0f - rawFin) / (Accelerator.this.chargeDuration / (Accelerator.this.launchDuration + Accelerator.this.chargeDuration)));
            float fin = 1.0f - Mathf.clamp(1.0f - rawFin - Accelerator.this.chargeDuration / (Accelerator.this.launchDuration + Accelerator.this.chargeDuration)) / (1.0f - Accelerator.this.chargeDuration / (Accelerator.this.launchDuration + Accelerator.this.chargeDuration));
            float fout = 1.0f - fin;
            float chargeFout = 1.0f - chargeFin;
            chargeFout = Mathf.clamp(chargeFout - fout * 2.0f);
            float spacing = 1.0f / ((float)Accelerator.this.chargeRings + Accelerator.this.chargeRingMerge);
            for (int i = 0; i < Accelerator.this.chargeRings; ++i) {
                float cfin = Mathf.clamp((chargeFout * Accelerator.this.ringSpeedup - spacing * (float)i) / (spacing * (1.0f + Accelerator.this.chargeRingMerge)));
                if (!(cfin > 0.0f)) continue;
                this.drawRing(Accelerator.this.ringRadBase + Accelerator.this.ringRadSpacing * Mathf.pow((float)i, Accelerator.this.ringRadPow), cfin);
            }
        }

        protected void drawRing(float radius, float fin) {
            float angle;
            int i;
            Draw.z(110.0f);
            float fout = 1.0f - fin;
            float rotate = Interp.pow4In.apply(fout) * 90.0f;
            float rad = radius + 20.0f * Interp.pow4In.apply(fout);
            Lines.stroke(Accelerator.this.ringStroke * fin, Accelerator.this.ringColor);
            Draw.color(Pal.command, Accelerator.this.ringColor, fin);
            for (i = 0; i < 4; ++i) {
                angle = (float)i * 90.0f + 45.0f + rotate;
                Lines.beginLine();
                Lines.linePoint(Tmp.v1.trns(angle - Accelerator.this.ringHandleLen, rad * Accelerator.this.ringHandleTilt).add(this.x, this.y));
                Lines.linePoint(Tmp.v2.trns(angle, rad).add(this.x, this.y));
                Lines.linePoint(Tmp.v3.trns(angle + Accelerator.this.ringHandleLen, rad * Accelerator.this.ringHandleTilt).add(this.x, this.y));
                Lines.endLine(false);
            }
            Draw.scl(fin);
            for (i = 0; i < 4; ++i) {
                angle = (float)i * 90.0f + rotate;
                Draw.rect(Accelerator.this.selectArrowRegion, this.x + Angles.trnsx(angle, rad), this.y + Angles.trnsy(angle, rad), angle + 180.0f + 45.0f);
            }
            Draw.scl();
        }

        protected void drawLanding(float fin, float x, float y) {
            float rawTime = this.launchDuration() - Vars.renderer.getLandTime();
            float fout = 1.0f - fin;
            float scl = rawTime < Accelerator.this.chargeDuration ? 1.0f : Scl.scl(4.0f) / Vars.renderer.getDisplayScale();
            float shake = 0.0f;
            float s = (float)Accelerator.this.launchBlock.region.width * Accelerator.this.launchBlock.region.scl() * scl * 3.6f * Interp.pow2Out.apply(fout);
            float rotation = Interp.pow2In.apply(fout) * 135.0f;
            x += Mathf.range(shake);
            y += Mathf.range(shake);
            float thrustOpen = 0.25f;
            float thrusterFrame = fin >= thrustOpen ? 1.0f : fin / thrustOpen;
            float thrusterSize = Mathf.sample(CoreBlock.thrusterSizes, fin);
            if (Vars.renderer.isLaunching()) {
                Interp.PowOut i = Interp.pow2Out;
                thrusterFrame = i.apply(Mathf.clamp(fout * 13.0f));
                thrusterSize = i.apply(Mathf.clamp(fout * 9.0f));
            }
            Draw.color(Pal.lightTrail);
            Draw.rect("circle-shadow", x, y, s, s);
            Draw.scl(scl);
            float strength = (1.0f + (float)(Accelerator.this.launchBlock.size - 3) / 2.5f) * scl * thrusterSize * (0.95f + Mathf.absin(2.0f, 0.1f));
            float offset = (float)(Accelerator.this.launchBlock.size - 3) * 3.0f * scl;
            for (int i = 0; i < 4; ++i) {
                Tmp.v1.trns((float)(i * 90) + rotation, 1.0f);
                Tmp.v1.setLength(((float)(Accelerator.this.launchBlock.size * 8) / 2.0f + 1.0f) * scl + strength * 2.0f + offset);
                Draw.color(this.team.color);
                Fill.circle(Tmp.v1.x + x, Tmp.v1.y + y, 6.0f * strength);
                Tmp.v1.setLength(((float)(Accelerator.this.launchBlock.size * 8) / 2.0f + 1.0f) * scl + strength * 0.5f + offset);
                Draw.color(Color.white);
                Fill.circle(Tmp.v1.x + x, Tmp.v1.y + y, 3.5f * strength);
            }
            this.drawLandingThrusters(x, y, rotation, thrusterFrame);
            Drawf.spinSprite(Accelerator.this.launchBlock.region, x, y, rotation);
            Draw.alpha(Interp.pow4In.apply(thrusterFrame));
            this.drawLandingThrusters(x, y, rotation, thrusterFrame);
            Draw.alpha(1.0f);
            if (Accelerator.this.launchBlock.teamRegions[this.team.id] == Accelerator.this.launchBlock.teamRegion) {
                Draw.color(this.team.color);
            }
            Drawf.spinSprite(Accelerator.this.launchBlock.teamRegions[this.team.id], x, y, rotation);
            Draw.color();
            Draw.scl();
            Draw.reset();
        }

        protected void drawLandingThrusters(float x, float y, float rotation, float frame) {
            CoreBlock core = (CoreBlock)Accelerator.this.launchBlock;
            float length = core.thrusterLength * (frame - 1.0f) - 0.25f;
            float alpha = Draw.getColorAlpha();
            for (int j = 0; j < 2; ++j) {
                for (int i = 0; i < 4; ++i) {
                    TextureRegion reg = i >= 2 ? core.thruster2 : core.thruster1;
                    float rot = (float)(i * 90) + rotation % 90.0f;
                    Tmp.v1.trns(rot, length * Draw.xscl);
                    if (j == 1) {
                        Tmp.v1.rotate(-90.0f);
                        Draw.alpha(rotation % 90.0f / 90.0f * alpha);
                        Draw.rect(reg, x + Tmp.v1.x, y + Tmp.v1.y, rot -= 90.0f);
                        continue;
                    }
                    Draw.alpha(alpha);
                    Draw.rect(reg, x + Tmp.v1.x, y + Tmp.v1.y, rot);
                }
            }
            Draw.alpha(1.0f);
        }
    }
}

