/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import mindustry.content.Blocks;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Block;

public class RiverNoiseFilter
extends GenerateFilter {
    public float scl = 40.0f;
    public float threshold = 0.0f;
    public float threshold2 = 0.1f;
    public float octaves = 1.0f;
    public float falloff = 0.5f;
    public Block floor = Blocks.water;
    public Block floor2 = Blocks.deepwater;
    public Block block = Blocks.sandWall;
    public Block target = Blocks.air;

    @Override
    public FilterOption[] options() {
        return new FilterOption[]{new FilterOption.SliderOption("scale", () -> this.scl, f -> {
            this.scl = f;
        }, 1.0f, 500.0f), new FilterOption.SliderOption("threshold", () -> this.threshold, f -> {
            this.threshold = f;
        }, -1.0f, 1.0f), new FilterOption.SliderOption("threshold2", () -> this.threshold2, f -> {
            this.threshold2 = f;
        }, -1.0f, 1.0f), new FilterOption.SliderOption("octaves", () -> this.octaves, f -> {
            this.octaves = f;
        }, 1.0f, 10.0f), new FilterOption.SliderOption("falloff", () -> this.falloff, f -> {
            this.falloff = f;
        }, 0.0f, 1.0f), new FilterOption.BlockOption("target", () -> this.target, b -> {
            this.target = b;
        }, FilterOption.anyOptional), new FilterOption.BlockOption("block", () -> this.block, b -> {
            this.block = b;
        }, FilterOption.wallsOptional), new FilterOption.BlockOption("floor", () -> this.floor, b -> {
            this.floor = b;
        }, FilterOption.floorsOptional), new FilterOption.BlockOption("floor2", () -> this.floor2, b -> {
            this.floor2 = b;
        }, FilterOption.floorsOptional)};
    }

    @Override
    public char icon() {
        return '\uf8fd';
    }

    @Override
    public void apply(GenerateFilter.GenerateInput in) {
        float noise = this.rnoise(in.x, in.y, (int)this.octaves, this.scl, this.falloff, 1.0f);
        if (noise >= this.threshold && (this.target == Blocks.air || in.floor == this.target || in.block == this.target)) {
            if (this.floor != Blocks.air) {
                in.floor = this.floor;
            }
            if (in.block.solid && this.block != Blocks.air && in.block != Blocks.air) {
                in.block = this.block;
            }
            if (noise >= this.threshold2 && this.floor2 != Blocks.air) {
                in.floor = this.floor2;
            }
        }
    }
}

