/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.core.GameState;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Schematic;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.net.Host;
import mindustry.net.NetConnection;
import mindustry.net.Packets;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Sector;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.storage.CoreBlock;

public class EventType {

    public static class AdminRequestEvent {
        public final Player player;
        @Nullable
        public final Player other;
        public final Packets.AdminAction action;

        public AdminRequestEvent(Player player, Player other, Packets.AdminAction action) {
            this.player = player;
            this.other = other;
            this.action = action;
        }
    }

    public static class PlayerIpUnbanEvent {
        public final String ip;

        public PlayerIpUnbanEvent(String ip) {
            this.ip = ip;
        }
    }

    public static class PlayerIpBanEvent {
        public final String ip;

        public PlayerIpBanEvent(String ip) {
            this.ip = ip;
        }
    }

    public static class PlayerUnbanEvent {
        @Nullable
        public final Player player;
        public final String uuid;

        public PlayerUnbanEvent(Player player, String uuid) {
            this.player = player;
            this.uuid = uuid;
        }
    }

    public static class PlayerBanEvent {
        @Nullable
        public final Player player;
        public final String uuid;

        public PlayerBanEvent(Player player, String uuid) {
            this.player = player;
            this.uuid = uuid;
        }
    }

    public static class PlayerLeave {
        public final Player player;

        public PlayerLeave(Player player) {
            this.player = player;
        }
    }

    public static class PlayerConnect {
        public final Player player;

        public PlayerConnect(Player player) {
            this.player = player;
        }
    }

    public static class PlayerJoin {
        public final Player player;

        public PlayerJoin(Player player) {
            this.player = player;
        }
    }

    public static class PlayerConnectionConfirmed {
        public final Player player;

        public PlayerConnectionConfirmed(Player player) {
            this.player = player;
        }
    }

    public static class ConnectPacketEvent {
        public final NetConnection connection;
        public final Packets.ConnectPacket packet;

        public ConnectPacketEvent(NetConnection connection, Packets.ConnectPacket packet) {
            this.connection = connection;
            this.packet = packet;
        }
    }

    public static class ConnectionEvent {
        public final NetConnection connection;

        public ConnectionEvent(NetConnection connection) {
            this.connection = connection;
        }
    }

    public static class UnitChangeEvent {
        public final Player player;
        public final Unit unit;

        public UnitChangeEvent(Player player, Unit unit) {
            this.player = player;
            this.unit = unit;
        }
    }

    public static class UnitUnloadEvent {
        public final Unit unit;

        public UnitUnloadEvent(Unit unit) {
            this.unit = unit;
        }
    }

    public static class UnitSpawnEvent {
        public final Unit unit;

        public UnitSpawnEvent(Unit unit) {
            this.unit = unit;
        }
    }

    public static class UnitCreateEvent {
        public final Unit unit;
        @Nullable
        public final Building spawner;
        @Nullable
        public final Unit spawnerUnit;

        public UnitCreateEvent(Unit unit, Building spawner, Unit spawnerUnit) {
            this.unit = unit;
            this.spawner = spawner;
            this.spawnerUnit = spawnerUnit;
        }

        public UnitCreateEvent(Unit unit, Building spawner) {
            this(unit, spawner, null);
        }
    }

    public static class UnitDrownEvent {
        public final Unit unit;

        public UnitDrownEvent(Unit unit) {
            this.unit = unit;
        }
    }

    public static class UnitDamageEvent {
        public Unit unit;
        public Bullet bullet;

        public UnitDamageEvent set(Unit unit, Bullet bullet) {
            this.unit = unit;
            this.bullet = bullet;
            return this;
        }
    }

    public static class UnitBulletDestroyEvent {
        public Unit unit;
        public Bullet bullet;

        public UnitBulletDestroyEvent(Unit unit, Bullet bullet) {
            this.unit = unit;
            this.bullet = bullet;
        }

        public UnitBulletDestroyEvent() {
        }
    }

    public static class UnitDestroyEvent {
        public final Unit unit;

        public UnitDestroyEvent(Unit unit) {
            this.unit = unit;
        }
    }

    public static class BuildingBulletDestroyEvent {
        public Building build;
        public Bullet bullet;

        public BuildingBulletDestroyEvent(Building build, Bullet bullet) {
            this.build = build;
            this.bullet = bullet;
        }

        public BuildingBulletDestroyEvent() {
        }
    }

    public static class GeneratorPressureExplodeEvent {
        public final Building build;

        public GeneratorPressureExplodeEvent(Building build) {
            this.build = build;
        }
    }

    public static class BlockDestroyEvent {
        public final Tile tile;

        public BlockDestroyEvent(Tile tile) {
            this.tile = tile;
        }
    }

    public static class BuildSelectEvent {
        public final Tile tile;
        public final Team team;
        public final Unit builder;
        public final boolean breaking;

        public BuildSelectEvent(Tile tile, Team team, Unit builder, boolean breaking) {
            this.tile = tile;
            this.team = team;
            this.builder = builder;
            this.breaking = breaking;
        }
    }

    public static class BuildRotateEvent {
        public final Building build;
        @Nullable
        public final Unit unit;
        public final int previous;

        public BuildRotateEvent(Building build, @Nullable Unit unit, int previous) {
            this.build = build;
            this.unit = unit;
            this.previous = previous;
        }
    }

    public static class BlockBuildEndEvent {
        public final Tile tile;
        public final Team team;
        @Nullable
        public final Unit unit;
        public final boolean breaking;
        @Nullable
        public final Object config;

        public BlockBuildEndEvent(Tile tile, @Nullable Unit unit, Team team, boolean breaking, @Nullable Object config) {
            this.tile = tile;
            this.team = team;
            this.unit = unit;
            this.breaking = breaking;
            this.config = config;
        }
    }

    public static class BlockBuildBeginEvent {
        public final Tile tile;
        public final Team team;
        @Nullable
        public final Unit unit;
        public final boolean breaking;

        public BlockBuildBeginEvent(Tile tile, Team team, Unit unit, boolean breaking) {
            this.tile = tile;
            this.team = team;
            this.unit = unit;
            this.breaking = breaking;
        }
    }

    public static class ResearchEvent {
        public final UnlockableContent content;

        public ResearchEvent(UnlockableContent content) {
            this.content = content;
        }
    }

    public static class UnlockEvent {
        public final UnlockableContent content;

        public UnlockEvent(UnlockableContent content) {
            this.content = content;
        }
    }

    public static class StateChangeEvent {
        public final GameState.State from;
        public final GameState.State to;

        public StateChangeEvent(GameState.State from, GameState.State to) {
            this.from = from;
            this.to = to;
        }
    }

    public static class CoreChangeEvent {
        public CoreBlock.CoreBuild core;

        public CoreChangeEvent(CoreBlock.CoreBuild core) {
            this.core = core;
        }
    }

    public static class BuildTeamChangeEvent {
        public Team previous;
        public Building build;

        public BuildTeamChangeEvent set(Team previous, Building build) {
            this.build = build;
            this.previous = previous;
            return this;
        }
    }

    public static class TileOverlayChangeEvent {
        public Tile tile;
        public Floor previous;
        public Floor overlay;

        public TileOverlayChangeEvent set(Tile tile, Floor previous, Floor overlay) {
            this.tile = tile;
            this.previous = previous;
            this.overlay = overlay;
            return this;
        }
    }

    public static class TileFloorChangeEvent {
        public Tile tile;
        public Floor previous;
        public Floor floor;

        public TileFloorChangeEvent set(Tile tile, Floor previous, Floor floor) {
            this.tile = tile;
            this.previous = previous;
            this.floor = floor;
            return this;
        }
    }

    public static class TileChangeEvent {
        public Tile tile;

        public TileChangeEvent set(Tile tile) {
            this.tile = tile;
            return this;
        }
    }

    public static class TilePreChangeEvent {
        public Tile tile;

        public TilePreChangeEvent set(Tile tile) {
            this.tile = tile;
            return this;
        }
    }

    public static class BuildDamageEvent {
        public Building build;
        public Bullet source;

        public BuildDamageEvent set(Building build, Bullet source) {
            this.build = build;
            this.source = source;
            return this;
        }
    }

    public static class GameOverEvent {
        public final Team winner;

        public GameOverEvent(Team winner) {
            this.winner = winner;
        }
    }

    public static class BuildingCommandEvent {
        public final Player player;
        public final Building building;
        public final Vec2 position;

        public BuildingCommandEvent(Player player, Building building, Vec2 position) {
            this.player = player;
            this.building = building;
            this.position = position;
        }
    }

    public static class UnitControlEvent {
        public final Player player;
        @Nullable
        public final Unit unit;

        public UnitControlEvent(Player player, @Nullable Unit unit) {
            this.player = player;
            this.unit = unit;
        }
    }

    public static class PayloadDropEvent {
        public final Unit carrier;
        @Nullable
        public final Unit unit;
        @Nullable
        public final Building build;

        public PayloadDropEvent(Unit carrier, Unit unit) {
            this.carrier = carrier;
            this.unit = unit;
            this.build = null;
        }

        public PayloadDropEvent(Unit carrier, Building build) {
            this.carrier = carrier;
            this.build = build;
            this.unit = null;
        }
    }

    public static class PickupEvent {
        public final Unit carrier;
        @Nullable
        public final Unit unit;
        @Nullable
        public final Building build;

        public PickupEvent(Unit carrier, Unit unit) {
            this.carrier = carrier;
            this.unit = unit;
            this.build = null;
        }

        public PickupEvent(Unit carrier, Building build) {
            this.carrier = carrier;
            this.build = build;
            this.unit = null;
        }
    }

    public static class TapEvent {
        public final Player player;
        public final Tile tile;

        public TapEvent(Player player, Tile tile) {
            this.tile = tile;
            this.player = player;
        }
    }

    public static class ConfigEvent {
        public final Building tile;
        @Nullable
        public final Player player;
        public final Object value;

        public ConfigEvent(Building tile, @Nullable Player player, Object value) {
            this.tile = tile;
            this.player = player;
            this.value = value;
        }
    }

    public static class DepositEvent {
        public final Building tile;
        public final Player player;
        public final Item item;
        public final int amount;

        public DepositEvent(Building tile, Player player, Item item, int amount) {
            this.tile = tile;
            this.player = player;
            this.item = item;
            this.amount = amount;
        }
    }

    public static class WithdrawEvent {
        public final Building tile;
        public final Player player;
        public final Item item;
        public final int amount;

        public WithdrawEvent(Building tile, Player player, Item item, int amount) {
            this.tile = tile;
            this.player = player;
            this.item = item;
            this.amount = amount;
        }
    }

    public static class SectorCaptureEvent {
        public final Sector sector;
        public final boolean initialCapture;

        public SectorCaptureEvent(Sector sector, boolean initialCapture) {
            this.sector = sector;
            this.initialCapture = initialCapture;
        }
    }

    public static class ClientChatEvent {
        public final String message;

        public ClientChatEvent(String message) {
            this.message = message;
        }
    }

    public static class PlayerChatEvent {
        public final Player player;
        public final String message;

        public PlayerChatEvent(Player player, String message) {
            this.player = player;
            this.message = message;
        }
    }

    public static class TextInputEvent {
        public final Player player;
        public final int textInputId;
        @Nullable
        public final String text;

        public TextInputEvent(Player player, int textInputId, String text) {
            this.player = player;
            this.textInputId = textInputId;
            this.text = text;
        }
    }

    public static class MenuOptionChooseEvent {
        public final Player player;
        public final int menuId;
        public final int option;

        public MenuOptionChooseEvent(Player player, int menuId, int option) {
            this.player = player;
            this.menuId = menuId;
            this.option = option;
        }
    }

    public static class ClientServerConnectEvent {
        public final String ip;
        public final int port;

        public ClientServerConnectEvent(String ip, int port) {
            this.ip = ip;
            this.port = port;
        }
    }

    public static class ClientPreConnectEvent {
        public final Host host;

        public ClientPreConnectEvent(Host host) {
            this.host = host;
        }
    }

    public static class SchematicCreateEvent {
        public final Schematic schematic;

        public SchematicCreateEvent(Schematic schematic) {
            this.schematic = schematic;
        }
    }

    public static class SectorLaunchLoadoutEvent {
        public final Sector sector;
        public final Sector from;
        public final Schematic loadout;

        public SectorLaunchLoadoutEvent(Sector sector, Sector from, Schematic loadout) {
            this.sector = sector;
            this.from = from;
            this.loadout = loadout;
        }
    }

    public static class SectorLaunchEvent {
        public final Sector sector;

        public SectorLaunchEvent(Sector sector) {
            this.sector = sector;
        }
    }

    public static class LaunchItemEvent {
        public final ItemStack stack;

        public LaunchItemEvent(ItemStack stack) {
            this.stack = stack;
        }
    }

    public static class SectorInvasionEvent {
        public final Sector sector;

        public SectorInvasionEvent(Sector sector) {
            this.sector = sector;
        }
    }

    public static class SectorLoseEvent {
        public final Sector sector;

        public SectorLoseEvent(Sector sector) {
            this.sector = sector;
        }
    }

    public static class SaveLoadEvent {
        public final boolean isMap;

        public SaveLoadEvent(boolean isMap) {
            this.isMap = isMap;
        }
    }

    public static class ContentPatchLoadEvent {
        public final Seq<String> patches;

        public ContentPatchLoadEvent(Seq<String> patches) {
            this.patches = patches;
        }
    }

    public static class WorldLoadEndEvent {
    }

    public static class WorldLoadBeginEvent {
    }

    public static class WorldLoadEvent {
    }

    public static class FileTreeInitEvent {
    }

    public static class MusicRegisterEvent {
    }

    public static class ClientLoadEvent {
    }

    public static class ModContentLoadEvent {
    }

    public static class AtlasPackEvent {
    }

    public static class ContentInitEvent {
    }

    public static class BlockInfoEvent {
    }

    public static class CoreItemDeliverEvent {
    }

    public static class TurretAmmoDeliverEvent {
    }

    public static class LineConfirmEvent {
    }

    public static class TurnEvent {
    }

    public static class WaveEvent {
    }

    public static class HostEvent {
    }

    public static class ResetEvent {
    }

    public static class PlayEvent {
    }

    public static class DisposeEvent {
    }

    public static class ServerLoadEvent {
    }

    public static class ClientCreateEvent {
    }

    public static class SaveWriteEvent {
    }

    public static class MapPublishEvent {
    }

    public static class MapMakeEvent {
    }

    public static class ResizeEvent {
    }

    public static class LoseEvent {
    }

    public static class WinEvent {
    }

    public static enum Trigger {
        shock,
        cannotUpgrade,
        openConsole,
        blastFreeze,
        impactPower,
        blastGenerator,
        shockwaveTowerUse,
        forceProjectorBreak,
        thoriumReactorOverheat,
        neoplasmReact,
        fireExtinguish,
        acceleratorUse,
        newGame,
        tutorialComplete,
        flameAmmo,
        resupplyTurret,
        turretCool,
        enablePixelation,
        exclusionDeath,
        suicideBomb,
        openWiki,
        teamCoreDamage,
        socketConfigChanged,
        update,
        beforeGameUpdate,
        afterGameUpdate,
        unitCommandChange,
        unitCommandPosition,
        unitCommandAttack,
        importMod,
        draw,
        drawOver,
        preDraw,
        postDraw,
        uiDrawBegin,
        uiDrawEnd,
        universeDrawBegin,
        universeDraw,
        universeDrawEnd;

    }
}

