/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.PixmapTextureData;
import arc.math.geom.Rect;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.Disposable;
import arc.util.Nullable;
import arc.util.Structs;
import java.util.Arrays;

public class PixmapPacker
implements Disposable {
    final Seq<Page> pages = new Seq();
    boolean packToTexture;
    boolean disposed;
    int pageWidth;
    int pageHeight;
    int padding;
    boolean duplicateBorder;
    boolean stripWhitespaceX;
    boolean stripWhitespaceY;
    Color transparentColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    PackStrategy packStrategy;

    public PixmapPacker(int pageWidth, int pageHeight, int padding, boolean duplicateBorder) {
        this(pageWidth, pageHeight, padding, duplicateBorder, false, false, new GuillotineStrategy());
    }

    public PixmapPacker(int pageWidth, int pageHeight, int padding, boolean duplicateBorder, PackStrategy packStrategy) {
        this(pageWidth, pageHeight, padding, duplicateBorder, false, false, packStrategy);
    }

    public PixmapPacker(int pageWidth, int pageHeight, int padding, boolean duplicateBorder, boolean stripWhitespaceX, boolean stripWhitespaceY, PackStrategy packStrategy) {
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
        this.padding = padding;
        this.duplicateBorder = duplicateBorder;
        this.stripWhitespaceX = stripWhitespaceX;
        this.stripWhitespaceY = stripWhitespaceY;
        this.packStrategy = packStrategy;
    }

    public void sort(Seq<PixmapRegion> images) {
        this.packStrategy.sort(images);
    }

    public synchronized Rect pack(Pixmap image) {
        return this.pack(null, image);
    }

    public synchronized Rect pack(String name, Pixmap image) {
        return this.pack(name, new PixmapRegion(image));
    }

    public synchronized Rect pack(String name, PixmapRegion image) {
        return this.pack(name, image, null, null);
    }

    public synchronized Rect pack(String name, int width, int height) {
        PixmapPackerRect stored;
        if (this.disposed) {
            return null;
        }
        PixmapPackerRect prev = null;
        Page prevPage = null;
        if (name != null && (stored = (PixmapPackerRect)this.getRect(name)) != null && (int)stored.width == width && (int)stored.height == height) {
            prev = stored;
            prevPage = this.getPage(name);
        }
        PixmapPackerRect rect = new PixmapPackerRect(0, 0, width, height);
        if (rect.width > (float)this.pageWidth || rect.height > (float)this.pageHeight) {
            if (name == null) {
                throw new ArcRuntimeException("Page size too small for pixmap.");
            }
            throw new ArcRuntimeException("Page size too small for pixmap: " + name);
        }
        if (prev != null && prevPage != null) {
            int y;
            Page page = prevPage;
            rect = prev;
            page.dirty = true;
            int ey = y + (int)rect.height;
            for (y = (int)rect.y; y < ey; ++y) {
                int x;
                int ex = x + (int)rect.width;
                for (x = (int)rect.x; x < ex; ++x) {
                    page.image.setRaw(x, y, Color.clearRgba);
                }
            }
        } else {
            Page page = this.packStrategy.pack(this, name, rect);
            if (name != null) {
                page.rects.put(name, rect);
                page.addedRects.add(name);
            }
        }
        return rect;
    }

    public synchronized Rect pack(@Nullable String name, PixmapRegion image, int[] splits, int[] pads) {
        Page page;
        PixmapPackerRect rect;
        PixmapPackerRect next;
        if (this.disposed) {
            return null;
        }
        PixmapPackerRect prev = null;
        Page prevPage = null;
        if (name != null && (next = (PixmapPackerRect)this.getRect(name)) != null && (int)next.width == image.width && (int)next.height == image.height) {
            prev = next;
            prevPage = this.getPage(name);
        }
        boolean isPatch = name != null && name.endsWith(".9");
        Pixmap pixmapToDispose = null;
        if (isPatch && splits == null) {
            rect = new PixmapPackerRect(0, 0, image.width - 2, image.height - 2);
            pixmapToDispose = new Pixmap(image.width - 2, image.height - 2);
            rect.splits = this.getSplits(image);
            rect.pads = this.getPads(image, rect.splits);
            pixmapToDispose.draw(image, 0, 0, 1, 1, image.width - 1, image.height - 1);
            image = new PixmapRegion(pixmapToDispose);
        } else {
            rect = new PixmapPackerRect(0, 0, image.width, image.height);
            rect.splits = splits;
            rect.pads = pads;
        }
        if (isPatch) {
            name = name.split("\\.")[0];
        }
        if (rect.width > (float)this.pageWidth || rect.height > (float)this.pageHeight) {
            if (name == null) {
                throw new ArcRuntimeException("Page size too small for pixmap.");
            }
            throw new ArcRuntimeException("Page size too small for pixmap: " + name);
        }
        if (prev != null && prevPage != null && !isPatch) {
            page = prevPage;
            rect = prev;
        } else {
            page = this.packStrategy.pack(this, name, rect);
            if (name != null) {
                page.rects.put(name, rect);
                page.addedRects.add(name);
            }
        }
        int rectX = (int)rect.x;
        int rectY = (int)rect.y;
        int rectWidth = (int)rect.width;
        int rectHeight = (int)rect.height;
        if (this.packToTexture && !this.duplicateBorder && page.texture != null && !page.dirty) {
            page.texture.bind();
            Gl.texSubImage2D(page.texture.glTarget, 0, rectX, rectY, rectWidth, rectHeight, image.pixmap.getGLFormat(), image.pixmap.getGLType(), image.pixmap.pixels);
        } else {
            page.dirty = true;
        }
        page.image.draw(image, rectX, rectY);
        if (this.duplicateBorder) {
            int imageWidth = image.width;
            int imageHeight = image.height;
            page.image.draw(image, 0, 0, 1, 1, rectX - 1, rectY - 1, 1, 1);
            page.image.draw(image, imageWidth - 1, 0, 1, 1, rectX + rectWidth, rectY - 1, 1, 1);
            page.image.draw(image, 0, imageHeight - 1, 1, 1, rectX - 1, rectY + rectHeight, 1, 1);
            page.image.draw(image, imageWidth - 1, imageHeight - 1, 1, 1, rectX + rectWidth, rectY + rectHeight, 1, 1);
            page.image.draw(image, 0, 0, imageWidth, 1, rectX, rectY - 1, rectWidth, 1);
            page.image.draw(image, 0, imageHeight - 1, imageWidth, 1, rectX, rectY + rectHeight, rectWidth, 1);
            page.image.draw(image, 0, 0, 1, imageHeight, rectX - 1, rectY, 1, rectHeight);
            page.image.draw(image, imageWidth - 1, 0, 1, imageHeight, rectX + rectWidth, rectY, 1, rectHeight);
        }
        if (pixmapToDispose != null) {
            pixmapToDispose.dispose();
        }
        return rect;
    }

    public Seq<Page> getPages() {
        return this.pages;
    }

    public synchronized Rect getRect(String name) {
        for (Page page : this.pages) {
            Rect rect = (Rect)page.rects.get(name);
            if (rect == null) continue;
            return rect;
        }
        return null;
    }

    public synchronized PixmapRegion getRegion(String name) {
        for (Page page : this.pages) {
            Rect rect = (Rect)page.rects.get(name);
            if (rect == null) continue;
            return new PixmapRegion(page.getPixmap(), (int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
        }
        return null;
    }

    public synchronized Page getPage(String name) {
        for (Page page : this.pages) {
            Rect rect = (Rect)page.rects.get(name);
            if (rect == null) continue;
            return page;
        }
        return null;
    }

    public synchronized int getPageIndex(String name) {
        for (int i = 0; i < this.pages.size; ++i) {
            Rect rect = (Rect)this.pages.get((int)i).rects.get(name);
            if (rect == null) continue;
            return i;
        }
        return -1;
    }

    @Override
    public synchronized void dispose() {
        for (Page page : this.pages) {
            if (page.texture != null) continue;
            page.image.dispose();
        }
        this.disposed = true;
    }

    public void forceDispose() {
        for (Page page : this.pages) {
            if (page.image == null) continue;
            page.image.dispose();
        }
        this.disposed = true;
    }

    public synchronized TextureAtlas generateTextureAtlas(Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, boolean useMipMaps) {
        TextureAtlas atlas = new TextureAtlas();
        this.updateTextureAtlas(atlas, minFilter, magFilter, useMipMaps, true);
        return atlas;
    }

    public synchronized void updateTextureAtlas(TextureAtlas atlas, Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, boolean useMipMaps) {
        this.updateTextureAtlas(atlas, minFilter, magFilter, useMipMaps, true);
    }

    public synchronized void updateTextureAtlas(TextureAtlas atlas, Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, boolean useMipMaps, boolean clearRects) {
        this.updatePageTextures(minFilter, magFilter, useMipMaps);
        for (Page page : this.pages) {
            if (page.addedRects.size <= 0) continue;
            for (String name : page.addedRects) {
                PixmapPackerRect rect = (PixmapPackerRect)page.rects.get(name);
                TextureAtlas.AtlasRegion region = new TextureAtlas.AtlasRegion(page.texture, (int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
                if (rect.splits != null) {
                    region.splits = rect.splits;
                    region.pads = rect.pads;
                }
                region.name = name;
                region.offsetX = rect.offsetX;
                region.offsetY = (int)((float)rect.originalHeight - rect.height - (float)rect.offsetY);
                region.originalWidth = rect.originalWidth;
                region.originalHeight = rect.originalHeight;
                atlas.getRegions().add(region);
                atlas.getRegionMap().put(name, region);
            }
            if (clearRects) {
                page.addedRects.clear();
            }
            atlas.getTextures().add(page.texture);
        }
    }

    public synchronized void updateTextureRegions(Seq<TextureRegion> regions, Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, boolean useMipMaps) {
        this.updatePageTextures(minFilter, magFilter, useMipMaps);
        while (regions.size < this.pages.size) {
            regions.add(new TextureRegion(this.pages.get((int)regions.size).texture));
        }
    }

    public synchronized void updatePageTextures(Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, boolean useMipMaps) {
        for (Page page : this.pages) {
            page.updateTexture(minFilter, magFilter, useMipMaps);
        }
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int pageWidth) {
        this.pageWidth = pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public boolean getDuplicateBorder() {
        return this.duplicateBorder;
    }

    public void setDuplicateBorder(boolean duplicateBorder) {
        this.duplicateBorder = duplicateBorder;
    }

    public boolean getPackToTexture() {
        return this.packToTexture;
    }

    public void setPackToTexture(boolean packToTexture) {
        this.packToTexture = packToTexture;
    }

    public Color getTransparentColor() {
        return this.transparentColor;
    }

    public void setTransparentColor(Color color) {
        this.transparentColor.set(color);
    }

    private int[] getSplits(PixmapRegion raster) {
        int startX = this.getSplitPoint(raster, 1, 0, true, true);
        int endX = this.getSplitPoint(raster, startX, 0, false, true);
        int startY = this.getSplitPoint(raster, 0, 1, true, false);
        int endY = this.getSplitPoint(raster, 0, startY, false, false);
        this.getSplitPoint(raster, endX + 1, 0, true, true);
        this.getSplitPoint(raster, 0, endY + 1, true, false);
        if (startX == 0 && endX == 0 && startY == 0 && endY == 0) {
            return null;
        }
        if (startX != 0) {
            --startX;
            endX = raster.width - 2 - (endX - 1);
        } else {
            endX = raster.width - 2;
        }
        endY = startY != 0 ? raster.height - 2 - (endY - 1) : raster.height - 2;
        return new int[]{startX, endX, --startY, endY};
    }

    private int[] getPads(PixmapRegion raster, int[] splits) {
        int bottom = raster.height - 1;
        int right = raster.width - 1;
        int startX = this.getSplitPoint(raster, 1, bottom, true, true);
        int startY = this.getSplitPoint(raster, right, 1, true, false);
        int endX = 0;
        int endY = 0;
        if (startX != 0) {
            endX = this.getSplitPoint(raster, startX + 1, bottom, false, true);
        }
        if (startY != 0) {
            endY = this.getSplitPoint(raster, right, startY + 1, false, false);
        }
        this.getSplitPoint(raster, endX + 1, bottom, true, true);
        this.getSplitPoint(raster, right, endY + 1, true, false);
        if (startX == 0 && endX == 0 && startY == 0 && endY == 0) {
            return null;
        }
        if (startX == 0 && endX == 0) {
            startX = -1;
            endX = -1;
        } else if (startX > 0) {
            --startX;
            endX = raster.width - 2 - (endX - 1);
        } else {
            endX = raster.width - 2;
        }
        if (startY == 0 && endY == 0) {
            startY = -1;
            endY = -1;
        } else {
            endY = startY > 0 ? raster.height - 2 - (endY - 1) : raster.height - 2;
        }
        int[] pads = new int[]{startX, endX, --startY, endY};
        if (splits != null && Arrays.equals(pads, splits)) {
            return null;
        }
        return pads;
    }

    private int getSplitPoint(PixmapRegion raster, int startX, int startY, boolean startPoint, boolean xAxis) {
        int end = xAxis ? raster.width : raster.height;
        int breakA = startPoint ? 255 : 0;
        int x = startX;
        int y = startY;
        for (int next = xAxis ? startX : startY; next != end; ++next) {
            if (xAxis) {
                x = next;
            } else {
                y = next;
            }
            int a = raster.getA(x, y);
            if (a != breakA) continue;
            return next;
        }
        return 0;
    }

    public static class GuillotineStrategy
    implements PackStrategy {
        @Override
        public void sort(Seq<PixmapRegion> pixmaps) {
            pixmaps.sort(Structs.comparingInt(o -> Math.max(o.width, o.height)));
        }

        @Override
        public Page pack(PixmapPacker packer, String name, Rect rect) {
            GuillotinePage page;
            if (packer.pages.size == 0) {
                page = new GuillotinePage(packer);
                packer.pages.add(page);
            } else {
                page = (GuillotinePage)packer.pages.peek();
            }
            int padding = packer.padding;
            rect.width += (float)padding;
            rect.height += (float)padding;
            Node node = this.insert(page.root, rect);
            if (node == null) {
                page = new GuillotinePage(packer);
                packer.pages.add(page);
                node = this.insert(page.root, rect);
            }
            node.full = true;
            rect.set(node.rect.x, node.rect.y, node.rect.width - (float)padding, node.rect.height - (float)padding);
            return page;
        }

        private Node insert(Node node, Rect rect) {
            if (!node.full && node.leftChild != null && node.rightChild != null) {
                Node newNode = this.insert(node.leftChild, rect);
                if (newNode == null) {
                    newNode = this.insert(node.rightChild, rect);
                }
                return newNode;
            }
            if (node.full) {
                return null;
            }
            if (node.rect.width == rect.width && node.rect.height == rect.height) {
                return node;
            }
            if (node.rect.width < rect.width || node.rect.height < rect.height) {
                return null;
            }
            node.leftChild = new Node();
            node.rightChild = new Node();
            int deltaWidth = (int)node.rect.width - (int)rect.width;
            int deltaHeight = (int)node.rect.height - (int)rect.height;
            if (deltaWidth > deltaHeight) {
                node.leftChild.rect.x = node.rect.x;
                node.leftChild.rect.y = node.rect.y;
                node.leftChild.rect.width = rect.width;
                node.leftChild.rect.height = node.rect.height;
                node.rightChild.rect.x = node.rect.x + rect.width;
                node.rightChild.rect.y = node.rect.y;
                node.rightChild.rect.width = node.rect.width - rect.width;
                node.rightChild.rect.height = node.rect.height;
            } else {
                node.leftChild.rect.x = node.rect.x;
                node.leftChild.rect.y = node.rect.y;
                node.leftChild.rect.width = node.rect.width;
                node.leftChild.rect.height = rect.height;
                node.rightChild.rect.x = node.rect.x;
                node.rightChild.rect.y = node.rect.y + rect.height;
                node.rightChild.rect.width = node.rect.width;
                node.rightChild.rect.height = node.rect.height - rect.height;
            }
            return this.insert(node.leftChild, rect);
        }

        public static class GuillotinePage
        extends Page {
            Node root = new Node();

            public GuillotinePage(PixmapPacker packer) {
                super(packer);
                this.root.rect.x = packer.padding;
                this.root.rect.y = packer.padding;
                this.root.rect.width = packer.pageWidth - packer.padding * 2;
                this.root.rect.height = packer.pageHeight - packer.padding * 2;
            }

            public GuillotinePage(PixmapPacker packer, Pixmap base) {
                super(base);
                this.root.rect.x = packer.padding;
                this.root.rect.y = packer.padding;
                this.root.rect.width = packer.pageWidth - packer.padding * 2;
                this.root.rect.height = packer.pageHeight - packer.padding * 2;
            }
        }

        static final class Node {
            public final Rect rect = new Rect();
            public Node leftChild;
            public Node rightChild;
            public boolean full;

            Node() {
            }
        }
    }

    public static interface PackStrategy {
        public void sort(Seq<PixmapRegion> var1);

        public Page pack(PixmapPacker var1, String var2, Rect var3);
    }

    public static class PixmapPackerRect
    extends Rect {
        public int[] splits;
        public int[] pads;
        int offsetX;
        int offsetY;
        int originalWidth;
        int originalHeight;

        public PixmapPackerRect(int x, int y, int width, int height) {
            super(x, y, width, height);
            this.offsetX = 0;
            this.offsetY = 0;
            this.originalWidth = width;
            this.originalHeight = height;
        }

        public PixmapPackerRect(int x, int y, int width, int height, int left, int top, int originalWidth, int originalHeight) {
            super(x, y, width, height);
            this.offsetX = left;
            this.offsetY = top;
            this.originalWidth = originalWidth;
            this.originalHeight = originalHeight;
        }
    }

    public static class Page {
        final Seq<String> addedRects = new Seq();
        OrderedMap<String, PixmapPackerRect> rects = new OrderedMap();
        Pixmap image;
        Texture texture;
        boolean dirty;

        public Page(PixmapPacker packer) {
            this.image = new Pixmap(packer.pageWidth, packer.pageHeight);
            Color transparentColor = packer.getTransparentColor();
            if (transparentColor.rgba() != 0) {
                this.image.fill(transparentColor);
            }
        }

        public Page(Pixmap pixmap) {
            this.image = pixmap;
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public Pixmap getPixmap() {
            return this.image;
        }

        public OrderedMap<String, PixmapPackerRect> getRects() {
            return this.rects;
        }

        public Texture getTexture() {
            return this.texture;
        }

        public boolean updateTexture(Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, boolean useMipMaps) {
            if (this.texture != null) {
                if (!this.dirty) {
                    return false;
                }
                this.texture.load(this.texture.getTextureData());
            } else {
                this.texture = new Texture(new PixmapTextureData(this.image, useMipMaps, false)){

                    @Override
                    public void dispose() {
                        super.dispose();
                        image.dispose();
                    }
                };
                this.texture.setFilter(minFilter, magFilter);
            }
            this.dirty = false;
            return true;
        }
    }

    public static class SkylineStrategy
    implements PackStrategy {
        @Override
        public void sort(Seq<PixmapRegion> images) {
            images.sort((o1, o2) -> o1.height - o2.height);
        }

        @Override
        public Page pack(PixmapPacker packer, String name, Rect rect) {
            int padding = packer.padding;
            int pageWidth = packer.pageWidth - padding * 2;
            int pageHeight = packer.pageHeight - padding * 2;
            int rectWidth = (int)rect.width + padding;
            int rectHeight = (int)rect.height + padding;
            int n = packer.pages.size;
            for (int i = 0; i < n; ++i) {
                SkylinePage page = (SkylinePage)packer.pages.get(i);
                SkylinePage.Row bestRow = null;
                int nn = page.rows.size - 1;
                for (int ii = 0; ii < nn; ++ii) {
                    SkylinePage.Row row = page.rows.get(ii);
                    if (row.x + rectWidth >= pageWidth || row.y + rectHeight >= pageHeight || rectHeight > row.height || bestRow != null && row.height >= bestRow.height) continue;
                    bestRow = row;
                }
                if (bestRow == null) {
                    SkylinePage.Row row = page.rows.peek();
                    if (row.y + rectHeight >= pageHeight) continue;
                    if (row.x + rectWidth < pageWidth) {
                        row.height = Math.max(row.height, rectHeight);
                        bestRow = row;
                    } else if (row.y + row.height + rectHeight < pageHeight) {
                        bestRow = new SkylinePage.Row();
                        bestRow.y = row.y + row.height;
                        bestRow.height = rectHeight;
                        page.rows.add(bestRow);
                    }
                }
                if (bestRow == null) continue;
                rect.x = bestRow.x;
                rect.y = bestRow.y;
                bestRow.x += rectWidth;
                return page;
            }
            SkylinePage page = new SkylinePage(packer);
            packer.pages.add(page);
            SkylinePage.Row row = new SkylinePage.Row();
            row.x = padding + rectWidth;
            row.y = padding;
            row.height = rectHeight;
            page.rows.add(row);
            rect.x = padding;
            rect.y = padding;
            return page;
        }

        static class SkylinePage
        extends Page {
            Seq<Row> rows = new Seq();

            public SkylinePage(PixmapPacker packer) {
                super(packer);
            }

            static class Row {
                int x;
                int y;
                int height;

                Row() {
                }
            }
        }
    }
}

