/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Interp;
import arc.util.Time;
import mindustry.gen.Building;
import mindustry.world.draw.DrawBlock;

public class DrawCircles
extends DrawBlock {
    public Color color = Color.valueOf("7457ce");
    public int amount = 5;
    public int sides = 15;
    public float strokeMin = 0.2f;
    public float strokeMax = 2.0f;
    public float timeScl = 160.0f;
    public float radius = 12.0f;
    public float radiusOffset = 0.0f;
    public float x = 0.0f;
    public float y = 0.0f;
    public Interp strokeInterp = Interp.pow3In;

    public DrawCircles(Color color) {
        this.color = color;
    }

    public DrawCircles() {
    }

    @Override
    public void draw(Building build) {
        if (build.warmup() <= 0.001f) {
            return;
        }
        Draw.color(this.color, build.warmup() * this.color.a);
        for (int i = 0; i < this.amount; ++i) {
            float life = (Time.time / this.timeScl + (float)i / (float)this.amount) % 1.0f;
            Lines.stroke(build.warmup() * this.strokeInterp.apply(this.strokeMax, this.strokeMin, life));
            Lines.poly(build.x + this.x, build.y + this.y, this.sides, this.radiusOffset + life * this.radius);
        }
        Draw.reset();
    }
}

