/*
 * Decompiled with CFR 0.152.
 */
package arc.math;

import arc.Core;
import arc.func.Floatc2;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Vec2;

public class Angles {
    private static final Rand rand = new Rand();
    private static final Vec2 rv = new Vec2();

    public static float forwardDistance(float angle1, float angle2) {
        return Math.abs(angle1 - angle2);
    }

    public static float backwardDistance(float angle1, float angle2) {
        return 360.0f - Math.abs(angle1 - angle2);
    }

    public static boolean within(float a, float b, float margin) {
        return Angles.angleDist(a, b) <= margin;
    }

    public static float angleDist(float a, float b) {
        return Math.min((a = Mathf.mod(a, 360.0f)) - (b = Mathf.mod(b, 360.0f)) < 0.0f ? a - b + 360.0f : a - b, b - a < 0.0f ? b - a + 360.0f : b - a);
    }

    public static boolean near(float a, float b, float range) {
        return Angles.angleDist(a, b) < range;
    }

    public static float clampRange(float angle, float dest, float range) {
        float dst = Angles.angleDist(angle, dest);
        return dst <= range ? angle : Angles.moveToward(angle, dest, dst - range);
    }

    public static float moveToward(float angle, float to, float speed) {
        if (Math.abs(Angles.angleDist(angle, to)) < speed) {
            return to;
        }
        angle = (angle = Mathf.mod(angle, 360.0f)) > (to = Mathf.mod(to, 360.0f)) == Angles.backwardDistance(angle, to) > Angles.forwardDistance(angle, to) ? (angle -= speed) : (angle += speed);
        return angle;
    }

    public static float angle(float x, float y) {
        return Angles.angle(0.0f, 0.0f, x, y);
    }

    public static float angle(float x, float y, float x2, float y2) {
        float ang = Mathf.atan2(x2 - x, y2 - y) * 57.295776f;
        if (ang < 0.0f) {
            ang += 360.0f;
        }
        return ang;
    }

    public static float angleRad(float x, float y, float x2, float y2) {
        return Mathf.atan2(x2 - x, y2 - y);
    }

    public static float trnsx(float angle, float len) {
        return len * Mathf.cosDeg(angle);
    }

    public static float trnsy(float angle, float len) {
        return len * Mathf.sinDeg(angle);
    }

    public static float trnsx(float angle, float x, float y) {
        return Angles.rv.set((float)x, (float)y).rotate((float)angle).x;
    }

    public static float trnsy(float angle, float x, float y) {
        return Angles.rv.set((float)x, (float)y).rotate((float)angle).y;
    }

    public static float mouseAngle(float cx, float cy) {
        Vec2 avector = Core.camera.project(cx, cy);
        return Angles.angle(avector.x, avector.y, Core.input.mouseX(), Core.input.mouseY());
    }

    public static void circleVectors(int points, float length, Floatc2 pos) {
        for (int i = 0; i < points; ++i) {
            float f = (float)i * 360.0f / (float)points;
            pos.get(Angles.trnsx(f, length), Angles.trnsy(f, length));
        }
    }

    public static void circleVectors(int points, float length, float offset, Floatc2 pos) {
        for (int i = 0; i < points; ++i) {
            float f = (float)i * 360.0f / (float)points + offset;
            pos.get(Angles.trnsx(f, length), Angles.trnsy(f, length));
        }
    }

    public static void randVectors(long seed, int amount, float length, Floatc2 cons) {
        rand.setSeed(seed);
        for (int i = 0; i < amount; ++i) {
            rv.trns(rand.random(360.0f), length);
            cons.get(Angles.rv.x, Angles.rv.y);
        }
    }

    public static void randLenVectors(long seed, int amount, float length, Floatc2 cons) {
        rand.setSeed(seed);
        for (int i = 0; i < amount; ++i) {
            rv.trns(rand.random(360.0f), rand.random(length));
            cons.get(Angles.rv.x, Angles.rv.y);
        }
    }

    public static void randLenVectors(long seed, int amount, float minLength, float length, Floatc2 cons) {
        rand.setSeed(seed);
        for (int i = 0; i < amount; ++i) {
            rv.trns(rand.random(360.0f), minLength + rand.random(length));
            cons.get(Angles.rv.x, Angles.rv.y);
        }
    }

    public static void randLenVectors(long seed, int amount, float length, float angle, float range, Floatc2 cons) {
        rand.setSeed(seed);
        for (int i = 0; i < amount; ++i) {
            rv.trns(angle + rand.range(range), rand.random(length));
            cons.get(Angles.rv.x, Angles.rv.y);
        }
    }

    public static void randLenVectors(long seed, int amount, float length, float angle, float range, float spread, Floatc2 cons) {
        rand.setSeed(seed);
        for (int i = 0; i < amount; ++i) {
            rv.trns(angle + rand.range(range), rand.random(length));
            cons.get(Angles.rv.x + rand.range(spread), Angles.rv.y + rand.range(spread));
        }
    }

    public static void randLenVectors(long seed, float fin, int amount, float length, ParticleConsumer cons) {
        rand.setSeed(seed);
        for (int i = 0; i < amount; ++i) {
            float l = rand.nextFloat();
            rv.trns(rand.random(360.0f), length * l * fin);
            cons.accept(Angles.rv.x, Angles.rv.y, fin * l, (1.0f - fin) * l);
        }
    }

    public static void randLenVectors(long seed, float fin, int amount, float length, float angle, float range, ParticleConsumer cons) {
        rand.setSeed(seed);
        for (int i = 0; i < amount; ++i) {
            rv.trns(angle + rand.range(range), rand.random(length * fin));
            cons.accept(Angles.rv.x, Angles.rv.y, fin * rand.nextFloat(), 0.0f);
        }
    }

    public static interface ParticleConsumer {
        public void accept(float var1, float var2, float var3, float var4);
    }
}

