/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawWeave
extends DrawBlock {
    public TextureRegion weave;

    @Override
    public void draw(Building build) {
        Draw.rect(this.weave, build.x, build.y, build.totalProgress());
        Draw.color(Pal.accent);
        Draw.alpha(build.warmup());
        Lines.lineAngleCenter(build.x + Mathf.sin(build.totalProgress(), 6.0f, 2.6666667f * (float)build.block.size), build.y, 90.0f, (float)(build.block.size * 8) / 2.0f);
        Draw.reset();
    }

    @Override
    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.weave};
    }

    @Override
    public void load(Block block) {
        this.weave = Core.atlas.find(block.name + "-weave");
    }
}

