/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.Rand;
import arc.util.Time;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Prop;

public class SeaBush
extends Prop {
    public TextureRegion botRegion;
    public TextureRegion centerRegion;
    public int lobesMin = 7;
    public int lobesMax = 7;
    public float botAngle = 60.0f;
    public float origin = 0.1f;
    public float sclMin = 30.0f;
    public float sclMax = 50.0f;
    public float magMin = 5.0f;
    public float magMax = 15.0f;
    public float timeRange = 40.0f;
    public float spread = 0.0f;
    static Rand rand = new Rand();

    public SeaBush(String name) {
        super(name);
        this.variants = 0;
    }

    @Override
    public void drawBase(Tile tile) {
        Draw.z(this.layer);
        rand.setSeed(tile.pos());
        float offset = rand.random(180.0f);
        int lobes = rand.random(this.lobesMin, this.lobesMax);
        for (int i = 0; i < lobes; ++i) {
            float ba = (float)i / (float)lobes * 360.0f + offset + rand.range(this.spread);
            float angle = ba + Mathf.sin(Time.time + rand.random(0.0f, this.timeRange), rand.random(this.sclMin, this.sclMax), rand.random(this.magMin, this.magMax));
            float w = (float)this.region.width * this.region.scl();
            float h = (float)this.region.height * this.region.scl();
            TextureRegion region = Angles.angleDist(ba, 225.0f) <= this.botAngle ? this.botRegion : this.region;
            Draw.rect(region, tile.worldx() - Angles.trnsx(angle, this.origin) + w * 0.5f, tile.worldy() - Angles.trnsy(angle, this.origin), w, h, this.origin * 4.0f, h / 2.0f, angle);
        }
        if (this.centerRegion.found()) {
            Draw.rect(this.centerRegion, tile.worldx(), tile.worldy());
        }
    }
}

