/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.scene.Element;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.util.Log;
import java.util.Locale;
import mindustry.Vars;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class LanguageDialog
extends BaseDialog {
    public static final ObjectMap<String, String> displayNames = ObjectMap.of("ca", "Catal\u00e0", "id_ID", "Bahasa Indonesia", "da", "Dansk", "de", "Deutsch", "et", "Eesti", "en", "English", "es", "Espa\u00f1ol", "eu", "Euskara", "fil", "Filipino", "fr", "Fran\u00e7ais", "it", "Italiano", "lt", "Lietuvi\u0173", "hu", "Magyar", "nl", "Nederlands", "nl_BE", "Nederlands (Belgi\u00eb)", "pl", "Polski", "pt_BR", "Portugu\u00eas (Brasil)", "pt_PT", "Portugu\u00eas (Portugal)", "ro", "Rom\u00e2n\u0103", "fi", "Suomi", "sv", "Svenska", "vi", "Ti\u1ebfng Vi\u1ec7t", "tk", "T\u00fcrkmen dili", "tr", "T\u00fcrk\u00e7e", "cs", "\u010ce\u0161tina", "be", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f", "bg", "\u0411\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438", "ru", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "sr", "\u0421\u0440\u043f\u0441\u043a\u0438", "uk_UA", "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430", "th", "\u0e44\u0e17\u0e22", "zh_CN", "\u7b80\u4f53\u4e2d\u6587", "zh_TW", "\u6b63\u9ad4\u4e2d\u6587", "ja", "\u65e5\u672c\u8a9e", "ko", "\ud55c\uad6d\uc5b4", "router", "router");
    private Locale lastLocale;

    public LanguageDialog() {
        super("@settings.language");
        this.addCloseButton();
        this.setup();
    }

    public static String getDisplayName(Locale locale) {
        String str = locale.toString().replace("in_ID", "id_ID");
        return displayNames.get(str, str);
    }

    private void setup() {
        Table langs = new Table();
        langs.marginRight(24.0f).marginLeft(24.0f);
        ScrollPane pane = new ScrollPane((Element)langs);
        pane.setScrollingDisabled(true, false);
        ButtonGroup group = new ButtonGroup();
        for (Locale loc : Vars.locales) {
            TextButton button = new TextButton(LanguageDialog.getDisplayName(loc), Styles.flatTogglet);
            button.clicked(() -> {
                if (this.getLocale().equals(loc)) {
                    return;
                }
                Core.settings.put("locale", loc.toString());
                Log.info("Setting locale: @", loc.toString());
                Vars.player.locale = loc.toString();
                Vars.ui.showInfo("@language.restart");
            });
            langs.add(button).group(group).update((T t) -> t.setChecked(loc.equals(this.getLocale()))).size(400.0f, 50.0f).row();
        }
        this.cont.add(pane);
    }

    public Locale getLocale() {
        String loc = Core.settings.getString("locale");
        if (loc.equals("default")) {
            this.findClosestLocale();
        }
        if (this.lastLocale == null || !this.lastLocale.toString().equals(loc)) {
            if (loc.contains("_")) {
                String[] split = loc.split("_");
                this.lastLocale = new Locale(split[0], split[1]);
            } else {
                this.lastLocale = new Locale(loc);
            }
        }
        return this.lastLocale;
    }

    void findClosestLocale() {
        for (Locale l : Vars.locales) {
            if (!l.equals(Locale.getDefault())) continue;
            Core.settings.put("locale", l.toString());
            return;
        }
        for (Locale l : Vars.locales) {
            if (!l.getLanguage().equals(Locale.getDefault().getLanguage())) continue;
            Core.settings.put("locale", l.toString());
            return;
        }
        Core.settings.put("locale", new Locale("en").toString());
    }
}

