/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.math.geom.Position;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.World;
import mindustry.entities.EntityGroup;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.IndexableEntity__all;
import mindustry.gen.Posc;
import mindustry.gen.Teamc;
import mindustry.gen.Unitc;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.storage.CoreBlock;

public class PosTeam
implements Entityc,
IndexableEntity__all,
Posc,
Teamc {
    protected transient boolean added;
    public transient int id = EntityGroup.nextId();
    protected transient int index__all = -1;
    public Team team = Team.derelict;
    public float x;
    public float y;

    protected PosTeam() {
    }

    @Override
    @Nullable
    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Override
    @Nullable
    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    @Override
    @Nullable
    public CoreBlock.CoreBuild closestCore() {
        return Vars.state.teams.closestCore(this.x, this.y, this.team);
    }

    @Override
    @Nullable
    public CoreBlock.CoreBuild closestEnemyCore() {
        return Vars.state.teams.closestEnemyCore(this.x, this.y, this.team);
    }

    @Override
    @Nullable
    public CoreBlock.CoreBuild core() {
        return this.team.core();
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public float y() {
        return this.y;
    }

    @Override
    public int classId() {
        return 28;
    }

    @Override
    public int id() {
        return this.id;
    }

    public String toString() {
        return "PosTeam#" + this.id;
    }

    @Override
    public Team team() {
        return this.team;
    }

    @Override
    public void id(int id) {
        this.id = id;
    }

    @Override
    public void setIndex__all(int index) {
        this.index__all = index;
    }

    @Override
    public void team(Team team) {
        this.team = team;
    }

    @Override
    public void x(float x) {
        this.x = x;
    }

    @Override
    public void y(float y) {
        this.y = y;
    }

    @Override
    public <T extends Entityc> T self() {
        return (T)this;
    }

    @Override
    public <T> T as() {
        return (T)this;
    }

    @Override
    public boolean cheating() {
        return this.team.rules().cheat;
    }

    @Override
    public boolean inFogTo(Team viewer) {
        return this.team != viewer && !Vars.fogControl.isVisible(viewer, this.x, this.y);
    }

    @Override
    public boolean isAdded() {
        return this.added;
    }

    @Override
    public boolean isLocal() {
        Unitc u;
        PosTeam posTeam;
        return this == Vars.player || (posTeam = this) instanceof Unitc && (u = (Unitc)((Object)posTeam)).controller() == Vars.player;
    }

    @Override
    public boolean isRemote() {
        Unitc u;
        PosTeam posTeam = this;
        return posTeam instanceof Unitc && (u = (Unitc)((Object)posTeam)).isPlayer() && !this.isLocal();
    }

    @Override
    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    @Override
    public boolean serialize() {
        return true;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public int tileX() {
        return World.toTile(this.x);
    }

    @Override
    public int tileY() {
        return World.toTile(this.y);
    }

    @Override
    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    @Override
    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public static PosTeam create() {
        return new PosTeam();
    }

    @Override
    public void add() {
        if (this.added) {
            return;
        }
        this.index__all = Groups.all.addIndex(this);
        this.added = true;
    }

    @Override
    public void afterRead() {
    }

    @Override
    public void afterReadAll() {
    }

    @Override
    public void beforeWrite() {
    }

    @Override
    public void read(Reads read) {
        this.afterRead();
    }

    @Override
    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.removeIndex(this, this.index__all);
        this.index__all = -1;
        this.added = false;
    }

    @Override
    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    @Override
    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    @Override
    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    @Override
    public void update() {
    }

    @Override
    public void write(Writes write) {
    }
}

