/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import mindustry.Vars;
import mindustry.game.Difficulty;
import mindustry.game.Rules;
import mindustry.game.Team;
import mindustry.gen.Groups;
import mindustry.type.Planet;

public class CampaignRules {
    public Difficulty difficulty = Difficulty.normal;
    public boolean fog;
    public boolean showSpawns;
    public boolean sectorInvasion;
    public boolean randomWaveAI;
    public boolean legacyLaunchPads;
    public boolean rtsAI;
    public boolean clearSectorOnLose;

    public void apply(Planet planet, Rules rules) {
        rules.staticFog = rules.fog = this.fog;
        rules.showSpawns = this.showSpawns;
        rules.randomWaveAI = this.randomWaveAI;
        rules.objectiveTimerMultiplier = this.difficulty.waveTimeMultiplier;
        if (planet.showRtsAIRule) {
            boolean enabled = this.rtsAI && rules.attackMode;
            boolean swapped = rules.teams.get((Team)rules.waveTeam).rtsAi != enabled;
            rules.teams.get((Team)rules.waveTeam).rtsAi = enabled;
            rules.teams.get((Team)rules.waveTeam).rtsMaxSquad = 15;
            if (swapped && Vars.state.isGame()) {
                Groups.unit.each(u -> {
                    if (u.team == rules.waveTeam && !u.isPlayer()) {
                        u.resetController();
                    }
                });
            }
        }
        rules.teams.get((Team)rules.waveTeam).blockHealthMultiplier = this.difficulty.enemyHealthMultiplier;
        rules.teams.get((Team)rules.waveTeam).unitHealthMultiplier = this.difficulty.enemyHealthMultiplier;
        rules.teams.get((Team)rules.waveTeam).unitCostMultiplier = 1.0f / this.difficulty.enemySpawnMultiplier;
        rules.teams.get((Team)rules.waveTeam).unitBuildSpeedMultiplier = this.difficulty.enemySpawnMultiplier;
    }
}

