/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.struct.LongSeq;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.gen.TileOp;
import mindustry.gen.TileOpData;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

public class DrawOperation {
    static final byte opFloor = 0;
    static final byte opBlock = 1;
    static final byte opRotation = 2;
    static final byte opTeam = 3;
    static final byte opOverlay = 4;
    static final byte opData = 5;
    static final byte opDataExtra = 6;
    private LongSeq array = new LongSeq();

    public boolean isEmpty() {
        return this.array.isEmpty();
    }

    public int size() {
        return this.array.size;
    }

    public void remove(int amount) {
        this.array.setSize(Math.max(0, this.array.size - amount));
    }

    public void addOperation(long op) {
        this.array.add(op);
    }

    public void undo() {
        for (int i = this.array.size - 1; i >= 0; --i) {
            this.updateTile(i);
        }
    }

    public void redo() {
        for (int i = 0; i < this.array.size; ++i) {
            this.updateTile(i);
        }
    }

    private void updateTile(int i) {
        long l = this.array.get(i);
        this.array.set(i, TileOp.get(TileOp.x(l), TileOp.y(l), TileOp.type(l), this.getTile(Vars.editor.tile(TileOp.x(l), TileOp.y(l)), TileOp.type(l))));
        this.setTile(Vars.editor.tile(TileOp.x(l), TileOp.y(l)), TileOp.type(l), TileOp.value(l));
    }

    int getTile(Tile tile, int type) {
        byte by;
        switch (type) {
            case 0: {
                by = tile.floorID();
                break;
            }
            case 4: {
                by = tile.overlayID();
                break;
            }
            case 1: {
                by = tile.blockID();
                break;
            }
            case 2: {
                if (tile.build == null) {
                    by = 0;
                    break;
                }
                by = (byte)tile.build.rotation;
                break;
            }
            case 3: {
                by = tile.getTeamID();
                break;
            }
            case 5: {
                by = (byte)TileOpData.get(tile.data, tile.floorData, tile.overlayData);
                break;
            }
            case 6: {
                by = tile.extraData;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type.");
            }
        }
        return by;
    }

    void setTile(Tile tile, int type, int to) {
        if (type == 1 || type == 3 || type == 2) {
            tile.getLinkedTiles(t -> {
                Vars.editor.renderer.updateBlock((Tile)t);
                Vars.editor.renderer.updateStatic(t.x, t.y);
            });
        } else {
            Vars.editor.renderer.updateStatic(tile.x, tile.y);
        }
        Vars.editor.load(() -> {
            switch (type) {
                case 0: {
                    Block patt2384$temp = Vars.content.block(to);
                    if (!(patt2384$temp instanceof Floor)) break;
                    Floor floor = (Floor)patt2384$temp;
                    tile.setFloor(floor);
                    break;
                }
                case 4: {
                    Block patt2572$temp = Vars.content.block(to);
                    if (!(patt2572$temp instanceof Floor)) break;
                    Floor floor = (Floor)patt2572$temp;
                    tile.setOverlay(floor);
                    break;
                }
                case 1: {
                    Block block = Vars.content.block(to);
                    tile.setBlock(block, tile.team(), tile.build == null ? 0 : tile.build.rotation);
                    if (tile.build == null) break;
                    tile.build.enabled = true;
                    break;
                }
                case 2: {
                    if (tile.build == null) break;
                    tile.build.rotation = to;
                    break;
                }
                case 3: {
                    tile.setTeam(Team.get(to));
                    break;
                }
                case 5: {
                    tile.data = TileOpData.data(to);
                    tile.floorData = TileOpData.floorData(to);
                    tile.overlayData = TileOpData.overlayData(to);
                    break;
                }
                case 6: {
                    tile.extraData = to;
                }
            }
        });
        if (type == 1 || type == 3 || type == 2) {
            tile.getLinkedTiles(t -> {
                Vars.editor.renderer.updateBlock((Tile)t);
                Vars.editor.renderer.updateStatic(t.x, t.y);
            });
        }
    }

    class TileOpDataStruct {
        byte data;
        byte floorData;
        byte overlayData;

        TileOpDataStruct() {
        }
    }

    class TileOpStruct {
        int x;
        int y;
        int type;
        int value;

        TileOpStruct() {
        }
    }
}

