/*
 * Decompiled with CFR 0.152.
 */
package arc.scene;

import arc.Core;
import arc.func.Boolf;
import arc.func.Boolp;
import arc.func.Cons;
import arc.func.Floatc;
import arc.func.Floatc2;
import arc.func.Prov;
import arc.graphics.Camera;
import arc.graphics.Color;
import arc.graphics.g2d.ScissorStack;
import arc.input.KeyCode;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.scene.Action;
import arc.scene.Group;
import arc.scene.Scene;
import arc.scene.actions.Actions;
import arc.scene.event.ChangeListener;
import arc.scene.event.ClickListener;
import arc.scene.event.EventListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.SceneEvent;
import arc.scene.event.Touchable;
import arc.scene.utils.Disableable;
import arc.struct.DelayedRemovalSeq;
import arc.struct.Seq;
import arc.struct.SnapshotSeq;
import arc.util.pooling.Pools;

public class Element {
    public final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public float originX;
    public float originY;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float rotation;
    public String name;
    public boolean fillParent;
    public Vec2 translation = new Vec2(0.0f, 0.0f);
    public boolean visible = true;
    public Object userObject;
    public Touchable touchable = Touchable.enabled;
    public Group parent;
    public Boolp visibility;
    public Prov<Touchable> touchablility;
    public boolean cullable = true;
    private final DelayedRemovalSeq<EventListener> listeners = new DelayedRemovalSeq(0);
    private final DelayedRemovalSeq<EventListener> captureListeners = new DelayedRemovalSeq(0);
    private final Seq<Action> actions = new Seq(0);
    public float x;
    public float y;
    protected float width;
    protected float height;
    protected float parentAlpha = 1.0f;
    private Scene stage;
    private boolean needsLayout = true;
    private boolean layoutEnabled = true;
    private Runnable update;

    public void draw() {
        this.validate();
    }

    public void act(float delta) {
        Seq<Action> actions = this.actions;
        if (actions.size > 0) {
            if (this.stage != null && this.stage.getActionsRequestRendering()) {
                Core.graphics.requestRendering();
            }
            for (int i = 0; i < actions.size; ++i) {
                int actionIndex;
                Action action = actions.get(i);
                if (!action.act(delta) || i >= actions.size) continue;
                Action current = actions.get(i);
                int n = actionIndex = current == action ? i : actions.indexOf(action, true);
                if (actionIndex == -1) continue;
                actions.remove(actionIndex);
                action.setActor(null);
                --i;
            }
        }
        if (this.touchablility != null) {
            this.touchable = this.touchablility.get();
        }
        if (this.update != null) {
            this.update.run();
        }
    }

    public void updateVisibility() {
        if (this.visibility != null) {
            this.visible = this.visibility.get();
        }
    }

    public boolean hasMouse() {
        Element e = Core.scene.hit(Core.input.mouseX(), Core.input.mouseY(), true);
        return e == this || e != null && e.isDescendantOf(this);
    }

    public boolean hasKeyboard() {
        return Core.scene.getKeyboardFocus() == this;
    }

    public boolean hasScroll() {
        return Core.scene.getScrollFocus() == this;
    }

    public void requestKeyboard() {
        Core.scene.setKeyboardFocus(this);
    }

    public void requestScroll() {
        Core.scene.setScrollFocus(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fire(SceneEvent event) {
        event.targetActor = this;
        Seq ancestors = Pools.obtain(Seq.class, Seq::new);
        Group parent = this.parent;
        while (parent != null) {
            ancestors.add(parent);
            parent = parent.parent;
        }
        try {
            int i;
            T[] ancestorsArray = ancestors.items;
            for (i = ancestors.size - 1; i >= 0; --i) {
                Group currentTarget = (Group)ancestorsArray[i];
                currentTarget.notify(event, true);
                if (!event.stopped) continue;
                boolean bl = event.cancelled;
                return bl;
            }
            this.notify(event, true);
            if (event.stopped) {
                i = event.cancelled ? 1 : 0;
                return i != 0;
            }
            this.notify(event, false);
            if (!event.bubbles) {
                i = event.cancelled;
                return i != 0;
            }
            if (event.stopped) {
                i = event.cancelled;
                return i != 0;
            }
            int n = ancestors.size;
            for (i = 0; i < n; ++i) {
                ((Group)ancestorsArray[i]).notify(event, false);
                if (!event.stopped) continue;
                boolean bl = event.cancelled;
                return bl;
            }
            boolean bl = event.cancelled;
            return bl;
        }
        finally {
            ancestors.clear();
            Pools.free(ancestors);
        }
    }

    public boolean notify(SceneEvent event, boolean capture) {
        DelayedRemovalSeq<EventListener> listeners;
        if (event.targetActor == null) {
            throw new IllegalArgumentException("The event target cannot be null.");
        }
        DelayedRemovalSeq<EventListener> delayedRemovalSeq = listeners = capture ? this.captureListeners : this.listeners;
        if (listeners.size == 0) {
            return event.cancelled;
        }
        event.listenerActor = this;
        event.capture = capture;
        listeners.begin();
        int n = listeners.size;
        for (int i = 0; i < n; ++i) {
            EventListener listener = (EventListener)listeners.get(i);
            if (!listener.handle(event)) continue;
            event.handle();
            if (!(event instanceof InputEvent)) continue;
            InputEvent inputEvent = (InputEvent)event;
            if (inputEvent.type != InputEvent.InputEventType.touchDown) continue;
            this.getScene().addTouchFocus(listener, this, inputEvent.targetActor, inputEvent.pointer, inputEvent.keyCode);
        }
        listeners.end();
        return event.cancelled;
    }

    public Element hit(float x, float y, boolean touchable) {
        if (touchable && this.touchable != Touchable.enabled) {
            return null;
        }
        Element e = this;
        return x >= e.translation.x && x < this.width + e.translation.x && y >= e.translation.y && y < this.height + e.translation.y ? this : null;
    }

    public boolean remove() {
        return this.parent != null && this.parent.removeChild(this, true);
    }

    public void dragged(final Floatc2 cons) {
        this.addListener(new InputListener(){
            float lastX;
            float lastY;

            @Override
            public void touchDragged(InputEvent event, float mx, float my, int pointer) {
                if (Core.app.isMobile() && pointer != 0) {
                    return;
                }
                cons.get(mx - this.lastX, my - this.lastY);
                this.lastX = mx;
                this.lastY = my;
            }

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                if (Core.app.isMobile() && pointer != 0) {
                    return false;
                }
                this.lastX = x;
                this.lastY = y;
                return true;
            }
        });
    }

    public void scrolled(final Floatc cons) {
        this.addListener(new InputListener(){

            @Override
            public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
                cons.get(amountY);
                return true;
            }
        });
    }

    public boolean addListener(EventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        if (!this.listeners.contains(listener, true)) {
            this.listeners.add(listener);
            return true;
        }
        return false;
    }

    public boolean removeListener(EventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        return this.listeners.remove(listener, true);
    }

    public Seq<EventListener> getListeners() {
        return this.listeners;
    }

    public boolean addCaptureListener(EventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        if (!this.captureListeners.contains(listener, true)) {
            this.captureListeners.add(listener);
        }
        return true;
    }

    public boolean removeCaptureListener(EventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        return this.captureListeners.remove(listener, true);
    }

    public Seq<EventListener> getCaptureListeners() {
        return this.captureListeners;
    }

    public void addAction(Action action) {
        action.setActor(this);
        this.actions.add(action);
        if (this.stage != null && this.stage.getActionsRequestRendering()) {
            Core.graphics.requestRendering();
        }
    }

    public void actions(Action ... actions) {
        this.addAction(Actions.sequence(actions));
    }

    public void removeAction(Action action) {
        if (this.actions.remove(action, true)) {
            action.setActor(null);
        }
    }

    public Seq<Action> getActions() {
        return this.actions;
    }

    public boolean hasActions() {
        return this.actions.size > 0;
    }

    public void clearActions() {
        for (int i = this.actions.size - 1; i >= 0; --i) {
            this.actions.get(i).setActor(null);
        }
        this.actions.clear();
    }

    public void clearListeners() {
        this.listeners.clear();
        this.captureListeners.clear();
    }

    public void clear() {
        this.clearActions();
        this.clearListeners();
    }

    public Scene getScene() {
        return this.stage;
    }

    protected void setScene(Scene stage) {
        this.stage = stage;
    }

    public boolean isDescendantOf(Boolf<Element> actor) {
        Element parent = this;
        while (parent != null) {
            if (actor.get(parent)) {
                return true;
            }
            parent = parent.parent;
        }
        return false;
    }

    public boolean isDescendantOf(Element actor) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        Element parent = this;
        while (parent != null) {
            if (parent == actor) {
                return true;
            }
            parent = parent.parent;
        }
        return false;
    }

    public boolean isAscendantOf(Element actor) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        while (actor != null) {
            if (actor == this) {
                return true;
            }
            actor = actor.parent;
        }
        return false;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean isTouchable() {
        return this.touchable == Touchable.enabled;
    }

    public float getX(int alignment) {
        float x = this.x;
        if ((alignment & 0x10) != 0) {
            x += this.width;
        } else if ((alignment & 8) == 0) {
            x += this.width / 2.0f;
        }
        return x;
    }

    public float getY(int alignment) {
        float y = this.y;
        if ((alignment & 2) != 0) {
            y += this.height;
        } else if ((alignment & 4) == 0) {
            y += this.height / 2.0f;
        }
        return y;
    }

    public void setPosition(float x, float y) {
        if (this.x != x || this.y != y) {
            this.x = x;
            this.y = y;
        }
    }

    public void setPosition(float x, float y, int alignment) {
        if ((alignment & 0x10) != 0) {
            x -= this.width;
        } else if ((alignment & 8) == 0) {
            x -= this.width / 2.0f;
        }
        if ((alignment & 2) != 0) {
            y -= this.height;
        } else if ((alignment & 4) == 0) {
            y -= this.height / 2.0f;
        }
        if (this.x != x || this.y != y) {
            this.x = x;
            this.y = y;
        }
    }

    public void moveBy(float x, float y) {
        if (x != 0.0f || y != 0.0f) {
            this.x += x;
            this.y += y;
        }
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        if (this.width != width) {
            this.width = width;
            this.sizeChanged();
        }
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        if (this.height != height) {
            this.height = height;
            this.sizeChanged();
        }
    }

    public float getTop() {
        return this.y + this.height;
    }

    public float getRight() {
        return this.x + this.width;
    }

    protected void sizeChanged() {
        this.invalidate();
    }

    protected void rotationChanged() {
    }

    public void setSize(float size) {
        this.setSize(size, size);
    }

    public void setSize(float width, float height) {
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.sizeChanged();
        }
    }

    public void sizeBy(float size) {
        if (size != 0.0f) {
            this.width += size;
            this.height += size;
            this.sizeChanged();
        }
    }

    public void sizeBy(float width, float height) {
        if (width != 0.0f || height != 0.0f) {
            this.width += width;
            this.height += height;
            this.sizeChanged();
        }
    }

    public void setBounds(float x, float y, float width, float height) {
        if (this.x != x || this.y != y) {
            this.x = x;
            this.y = y;
        }
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.sizeChanged();
        }
    }

    public void setOrigin(float originX, float originY) {
        this.originX = originX;
        this.originY = originY;
    }

    public void setOrigin(int alignment) {
        this.originX = (alignment & 8) != 0 ? 0.0f : ((alignment & 0x10) != 0 ? this.width : this.width / 2.0f);
        this.originY = (alignment & 4) != 0 ? 0.0f : ((alignment & 2) != 0 ? this.height : this.height / 2.0f);
    }

    public void setScale(float scaleXY) {
        this.scaleX = scaleXY;
        this.scaleY = scaleXY;
    }

    public void setScale(float scaleX, float scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }

    public void scaleBy(float scale) {
        this.scaleX += scale;
        this.scaleY += scale;
    }

    public void scaleBy(float scaleX, float scaleY) {
        this.scaleX += scaleX;
        this.scaleY += scaleY;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float degrees) {
        if (this.rotation != degrees) {
            this.rotation = degrees;
            this.rotationChanged();
        }
    }

    public void setRotationOrigin(float degrees, int align) {
        this.setOrigin(align);
        if (this.rotation != degrees) {
            this.rotation = degrees;
            this.rotationChanged();
        }
    }

    public void rotateBy(float amountInDegrees) {
        if (amountInDegrees != 0.0f) {
            this.rotation += amountInDegrees;
            this.rotationChanged();
        }
    }

    public void setColor(float r, float g, float b, float a) {
        this.color.set(r, g, b, a);
    }

    public void setColor(Color color) {
        this.color.set(color);
    }

    public void toFront() {
        this.setZIndex(Integer.MAX_VALUE);
    }

    public void toBack() {
        this.setZIndex(0);
    }

    public int getZIndex() {
        Group parent = this.parent;
        if (parent == null) {
            return -1;
        }
        return parent.children.indexOf(this, true);
    }

    public void setZIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("ZIndex cannot be < 0.");
        }
        Group parent = this.parent;
        if (parent == null) {
            return;
        }
        SnapshotSeq<Element> children = parent.children;
        if (children.size == 1) {
            return;
        }
        if (children.get(index = Math.min(index, children.size - 1)) == this) {
            return;
        }
        if (!((Seq)children).remove(this, true)) {
            return;
        }
        ((Seq)children).insert(index, this);
    }

    public boolean clipBegin() {
        return this.clipBegin(this.x, this.y, this.width, this.height);
    }

    public boolean clipBegin(float x, float y, float width, float height) {
        if (width <= 0.0f || height <= 0.0f) {
            return false;
        }
        Rect tableBounds = Rect.tmp;
        tableBounds.x = x;
        tableBounds.y = y;
        tableBounds.width = width;
        tableBounds.height = height;
        Scene stage = this.stage;
        Rect scissorBounds = Pools.obtain(Rect.class, Rect::new);
        stage.calculateScissors(tableBounds, scissorBounds);
        if (ScissorStack.push(scissorBounds)) {
            return true;
        }
        Pools.free(scissorBounds);
        return false;
    }

    public void clipEnd() {
        Pools.free(ScissorStack.pop());
    }

    public Vec2 screenToLocalCoordinates(Vec2 screenCoords) {
        Scene stage = this.stage;
        if (stage == null) {
            return screenCoords;
        }
        return this.stageToLocalCoordinates(stage.screenToStageCoordinates(screenCoords));
    }

    public Vec2 stageToLocalCoordinates(Vec2 stageCoords) {
        if (this.parent != null) {
            this.parent.stageToLocalCoordinates(stageCoords);
        }
        this.parentToLocalCoordinates(stageCoords);
        return stageCoords;
    }

    public Vec2 localToStageCoordinates(Vec2 localCoords) {
        return this.localToAscendantCoordinates(null, localCoords);
    }

    public Vec2 localToParentCoordinates(Vec2 localCoords) {
        float rotation = -this.rotation;
        float scaleX = this.scaleX;
        float scaleY = this.scaleY;
        float x = this.x + this.translation.x;
        float y = this.y + this.translation.y;
        if (rotation == 0.0f) {
            if (scaleX == 1.0f && scaleY == 1.0f) {
                localCoords.x += x;
                localCoords.y += y;
            } else {
                float originX = this.originX;
                float originY = this.originY;
                localCoords.x = (localCoords.x - originX) * scaleX + originX + x;
                localCoords.y = (localCoords.y - originY) * scaleY + originY + y;
            }
        } else {
            float cos = (float)Math.cos(rotation * ((float)Math.PI / 180));
            float sin = (float)Math.sin(rotation * ((float)Math.PI / 180));
            float originX = this.originX;
            float originY = this.originY;
            float tox = (localCoords.x - originX) * scaleX;
            float toy = (localCoords.y - originY) * scaleY;
            localCoords.x = tox * cos + toy * sin + originX + x;
            localCoords.y = tox * -sin + toy * cos + originY + y;
        }
        return localCoords;
    }

    public Vec2 localToAscendantCoordinates(Element ascendant, Vec2 localCoords) {
        Element actor = this;
        while (actor != null) {
            actor.localToParentCoordinates(localCoords);
            actor = actor.parent;
            if (actor != ascendant) continue;
            break;
        }
        return localCoords;
    }

    public Vec2 parentToLocalCoordinates(Vec2 parentCoords) {
        float rotation = this.rotation;
        float scaleX = this.scaleX;
        float scaleY = this.scaleY;
        float childX = this.x + this.translation.x;
        float childY = this.y + this.translation.y;
        if (rotation == 0.0f) {
            if (scaleX == 1.0f && scaleY == 1.0f) {
                parentCoords.x -= childX;
                parentCoords.y -= childY;
            } else {
                float originX = this.originX;
                float originY = this.originY;
                parentCoords.x = (parentCoords.x - childX - originX) / scaleX + originX;
                parentCoords.y = (parentCoords.y - childY - originY) / scaleY + originY;
            }
        } else {
            float cos = (float)Math.cos(rotation * ((float)Math.PI / 180));
            float sin = (float)Math.sin(rotation * ((float)Math.PI / 180));
            float originX = this.originX;
            float originY = this.originY;
            float tox = parentCoords.x - childX - originX;
            float toy = parentCoords.y - childY - originY;
            parentCoords.x = (tox * cos + toy * sin) / scaleX + originX;
            parentCoords.y = (tox * -sin + toy * cos) / scaleY + originY;
        }
        return parentCoords;
    }

    public float getMinWidth() {
        return this.getPrefWidth();
    }

    public float getMinHeight() {
        return this.getPrefHeight();
    }

    public float getPrefWidth() {
        return 0.0f;
    }

    public float getPrefHeight() {
        return 0.0f;
    }

    public float getMaxWidth() {
        return 0.0f;
    }

    public float getMaxHeight() {
        return 0.0f;
    }

    public void setLayoutEnabled(boolean enabled) {
        this.layoutEnabled = enabled;
        if (enabled) {
            this.invalidateHierarchy();
        }
    }

    public void validate() {
        if (!this.layoutEnabled) {
            return;
        }
        Group parent = this.parent;
        if (this.fillParent && parent != null) {
            this.setSize(parent.getWidth(), parent.getHeight());
        }
        if (!this.needsLayout) {
            return;
        }
        this.needsLayout = false;
        this.layout();
    }

    public boolean needsLayout() {
        return this.needsLayout;
    }

    public void invalidate() {
        this.needsLayout = true;
    }

    public void invalidateHierarchy() {
        if (!this.layoutEnabled) {
            return;
        }
        this.invalidate();
        Group parent = this.parent;
        if (parent != null) {
            parent.invalidateHierarchy();
        }
    }

    public void pack() {
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.validate();
    }

    public void setFillParent(boolean fillParent) {
        this.fillParent = fillParent;
    }

    public void layout() {
    }

    public void keepInStage() {
        if (this.stage == null) {
            return;
        }
        Camera camera = this.stage.getCamera();
        float parentWidth = this.stage.getWidth();
        float parentHeight = this.stage.getHeight();
        if (this.getX(16) - camera.position.x > parentWidth / 2.0f) {
            this.setPosition(camera.position.x + parentWidth / 2.0f, this.getY(16), 16);
        }
        if (this.getX(8) - camera.position.x < -parentWidth / 2.0f) {
            this.setPosition(camera.position.x - parentWidth / 2.0f, this.getY(8), 8);
        }
        if (this.getY(2) - camera.position.y > parentHeight / 2.0f) {
            this.setPosition(this.getX(2), camera.position.y + parentHeight / 2.0f, 2);
        }
        if (this.getY(4) - camera.position.y < -parentHeight / 2.0f) {
            this.setPosition(this.getX(4), camera.position.y - parentHeight / 2.0f, 4);
        }
    }

    public void setTranslation(float x, float y) {
        this.translation.x = x;
        this.translation.y = y;
    }

    public void keyDown(KeyCode key, Runnable l) {
        this.keyDown(k -> {
            if (k == key) {
                l.run();
            }
        });
    }

    public void keyDown(final Cons<KeyCode> cons) {
        this.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent event, KeyCode keycode) {
                cons.get(keycode);
                return true;
            }
        });
    }

    public void fireClick() {
        for (EventListener listener : this.getListeners()) {
            if (!(listener instanceof ClickListener)) continue;
            ((ClickListener)listener).clicked(new InputEvent(), -1.0f, -1.0f);
        }
    }

    public ClickListener clicked(Runnable r) {
        return this.clicked(KeyCode.mouseLeft, r);
    }

    public ClickListener clicked(KeyCode button, Runnable r) {
        return this.clicked((ClickListener l) -> l.setButton(button), r);
    }

    public ClickListener clicked(Cons<ClickListener> tweaker, Runnable r) {
        return this.clicked(tweaker, (ClickListener e) -> r.run());
    }

    public ClickListener clicked(Cons<ClickListener> tweaker, final Cons<ClickListener> runner) {
        final Element elem = this;
        ClickListener click = new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!(runner == null || elem instanceof Disableable && ((Disableable)((Object)elem)).isDisabled())) {
                    runner.get(this);
                }
            }
        };
        this.addListener(click);
        tweaker.get(click);
        return click;
    }

    public InputListener tapped(final Runnable r) {
        InputListener result = new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                r.run();
                event.stop();
                return true;
            }
        };
        this.addListener(result);
        return result;
    }

    public void hovered(final Runnable r) {
        this.addListener(new InputListener(){

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Element fromActor) {
                r.run();
            }
        });
    }

    public void exited(final Runnable r) {
        this.addListener(new InputListener(){

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Element fromActor) {
                r.run();
            }
        });
    }

    public void released(final Runnable r) {
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                r.run();
            }
        });
    }

    public void change() {
        this.fire(new ChangeListener.ChangeEvent());
    }

    public void changed(final Runnable r) {
        final Element elem = this;
        this.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Element actor) {
                if (!(elem instanceof Disableable) || !((Disableable)((Object)elem)).isDisabled()) {
                    r.run();
                }
            }
        });
    }

    public Element update(Runnable r) {
        this.update = r;
        return this;
    }

    public Element visible(Boolp vis) {
        this.visibility = vis;
        return this;
    }

    public void touchable(Prov<Touchable> touch) {
        this.touchablility = touch;
    }

    public String toString() {
        int dotIndex;
        String name = this.name;
        if (name == null && (dotIndex = (name = super.toString().split("@")[0]).lastIndexOf(46)) != -1) {
            name = name.substring(dotIndex + 1);
        }
        return name;
    }
}

