/*
 * Decompiled with CFR 0.152.
 */
package arc;

import arc.Core;
import arc.files.Fi;
import arc.func.Cons;
import arc.func.Prov;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.OS;
import arc.util.Structs;
import arc.util.Threads;
import arc.util.Time;
import arc.util.io.FastDeflaterOutputStream;
import arc.util.io.ReusableByteInStream;
import arc.util.serialization.Json;
import arc.util.serialization.UBJsonReader;
import arc.util.serialization.UBJsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.zip.InflaterInputStream;

public class Settings {
    protected static final byte typeBool = 0;
    protected static final byte typeInt = 1;
    protected static final byte typeLong = 2;
    protected static final byte typeFloat = 3;
    protected static final byte typeString = 4;
    protected static final byte typeBinary = 5;
    protected static final int maxBackups = 10;
    protected static final int minBackupIntervalMs = 120000;
    protected Fi dataDirectory;
    protected String appName = "app";
    protected ObjectMap<String, Object> defaults = new ObjectMap();
    protected HashMap<String, Object> values = new HashMap();
    protected boolean modified;
    protected Cons<Throwable> errorHandler;
    protected boolean hasErrored;
    protected boolean shouldAutosave = true;
    protected boolean loaded = false;
    protected boolean writeCompressed = false;
    private long lastBackupTime;
    protected ExecutorService executor = Threads.executor("Settings Backup", 1);
    protected ByteArrayOutputStream byteStream = new ByteArrayOutputStream(32);
    protected ReusableByteInStream byteInputStream = new ReusableByteInStream();
    protected UBJsonReader ureader = new UBJsonReader();
    protected Json json = new Json();

    public void setJson(Json json) {
        this.json = json;
    }

    public void setCompressed(boolean compressed) {
        this.writeCompressed = compressed;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String name) {
        this.appName = name;
    }

    public void setErrorHandler(Cons<Throwable> handler) {
        this.errorHandler = handler;
    }

    public void setAutosave(boolean autosave) {
        this.shouldAutosave = autosave;
    }

    public boolean modified() {
        return this.modified;
    }

    public synchronized void load() {
        try {
            this.loadValues();
        }
        catch (Throwable error) {
            Log.err("Error loading settings", error);
            if (this.errorHandler != null) {
                if (!this.hasErrored) {
                    this.errorHandler.get(error);
                }
            } else {
                throw error;
            }
            this.hasErrored = true;
        }
        this.loaded = true;
    }

    public synchronized void forceSave() {
        if (!this.loaded) {
            return;
        }
        try {
            this.saveValues();
        }
        catch (Throwable error) {
            Log.err("Error writing settings", error);
            if (this.errorHandler != null) {
                if (!this.hasErrored) {
                    this.errorHandler.get(error);
                }
            } else {
                throw error;
            }
            this.hasErrored = true;
        }
        this.modified = false;
    }

    public synchronized void manualSave() {
        if (this.loaded) {
            this.forceSave();
        }
    }

    public synchronized void autosave() {
        if (this.modified && this.shouldAutosave) {
            this.forceSave();
            this.modified = false;
        }
    }

    public synchronized void loadValues() {
        if (!this.getSettingsFile().exists() && !this.getBackupSettingsFile().exists()) {
            return;
        }
        try {
            this.loadValues(this.getSettingsFile());
            this.getSettingsFile().copyTo(this.getBackupSettingsFile());
        }
        catch (Throwable e) {
            Log.err("Failed to load base settings file, attempting to load backup.", e);
            Seq<Fi> attempts = this.getBackupFolder().seq().add(this.getBackupSettingsFile());
            attempts.sort(Structs.comparingLong(f -> -f.lastModified()));
            for (Fi attempt : attempts) {
                try {
                    this.loadValues(attempt);
                    attempt.copyTo(this.getSettingsFile());
                    Log.info("Loaded backup settings file successfully!");
                    return;
                }
                catch (Throwable e3) {
                    Log.err("Failed to load backup settings file.", e3);
                }
            }
        }
    }

    public synchronized void loadValues(Fi file) throws IOException {
        byte[] header = new byte[2];
        file.readBytes(header, 0, 2);
        boolean compressed = header[0] == 120 && (header[1] == 1 || header[1] == 94 || header[1] == -100 || header[1] == -38);
        try (DataInputStream stream = new DataInputStream(compressed ? new InflaterInputStream(file.read(8192)) : file.read(8192));){
            int amount = stream.readInt();
            if (amount <= 0) {
                throw new IOException("0 values are not allowed.");
            }
            block13: for (int i = 0; i < amount; ++i) {
                String key = stream.readUTF();
                byte type = stream.readByte();
                switch (type) {
                    case 0: {
                        this.values.put(key, stream.readBoolean());
                        continue block13;
                    }
                    case 1: {
                        this.values.put(key, stream.readInt());
                        continue block13;
                    }
                    case 2: {
                        this.values.put(key, stream.readLong());
                        continue block13;
                    }
                    case 3: {
                        this.values.put(key, Float.valueOf(stream.readFloat()));
                        continue block13;
                    }
                    case 4: {
                        this.values.put(key, stream.readUTF());
                        continue block13;
                    }
                    case 5: {
                        int length = stream.readInt();
                        byte[] bytes = new byte[length];
                        stream.readFully(bytes);
                        this.values.put(key, bytes);
                        continue block13;
                    }
                    default: {
                        throw new IOException("Unknown key type: " + type);
                    }
                }
            }
            int end = stream.read();
            if (end != -1) {
                throw new IOException("Trailing settings data; expected EOF, but got: " + end);
            }
        }
    }

    public synchronized void saveValues() {
        Fi file = this.getSettingsFile();
        try (DataOutputStream stream = new DataOutputStream(this.writeCompressed ? new FastDeflaterOutputStream(file.write(false, 8192)) : file.write(false, 8192));){
            stream.writeInt(this.values.size());
            for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                stream.writeUTF(entry.getKey());
                Object value = entry.getValue();
                if (value instanceof Boolean) {
                    stream.writeByte(0);
                    stream.writeBoolean((Boolean)value);
                    continue;
                }
                if (value instanceof Integer) {
                    stream.writeByte(1);
                    stream.writeInt((Integer)value);
                    continue;
                }
                if (value instanceof Long) {
                    stream.writeByte(2);
                    stream.writeLong((Long)value);
                    continue;
                }
                if (value instanceof Float) {
                    stream.writeByte(3);
                    stream.writeFloat(((Float)value).floatValue());
                    continue;
                }
                if (value instanceof String) {
                    stream.writeByte(4);
                    stream.writeUTF((String)value);
                    continue;
                }
                if (!(value instanceof byte[])) continue;
                stream.writeByte(5);
                stream.writeInt(((byte[])value).length);
                stream.write((byte[])value);
            }
        }
        catch (Throwable e) {
            file.delete();
            throw new RuntimeException("Error writing preferences: " + file, e);
        }
        if (Time.timeSinceMillis(this.lastBackupTime) > 120000L) {
            this.lastBackupTime = Time.millis();
            this.executor.submit(() -> {
                Settings settings = this;
                synchronized (settings) {
                    Fi backupFolder = this.getBackupFolder();
                    Seq<Fi> previous = backupFolder.seq();
                    previous.sort(Structs.comparingLong(f -> -f.lastModified()));
                    file.copyTo(backupFolder.child(System.currentTimeMillis() + ".bin"));
                    while (previous.size >= 10) {
                        previous.pop().delete();
                    }
                }
            });
        }
    }

    public Fi getSettingsFile() {
        return this.getDataDirectory().child("settings.bin");
    }

    public Fi getBackupFolder() {
        return this.getDataDirectory().child("settings_backups");
    }

    public Fi getBackupSettingsFile() {
        return this.getDataDirectory().child("settings_backup.bin");
    }

    public Fi getDataDirectory() {
        return this.dataDirectory == null ? Core.files.absolute(OS.getAppDataDirectoryString(this.appName)) : this.dataDirectory;
    }

    public void setDataDirectory(Fi file) {
        this.dataDirectory = file;
    }

    public synchronized void defaults(Object ... objects) {
        for (int i = 0; i < objects.length; i += 2) {
            this.defaults.put((String)objects[i], objects[i + 1]);
        }
    }

    public synchronized void clear() {
        this.values.clear();
    }

    public synchronized Object getDefault(String name) {
        return this.defaults.get(name);
    }

    public synchronized boolean has(String name) {
        return this.values.containsKey(name);
    }

    public synchronized Object get(String name, Object def) {
        return this.values.containsKey(name) ? this.values.get(name) : def;
    }

    public boolean isModified() {
        return this.modified;
    }

    public synchronized void putJson(String name, Object value) {
        this.putJson(name, null, value);
    }

    public synchronized void putJson(String name, Class<?> elementType, Object value) {
        this.byteStream.reset();
        this.json.setWriter(new UBJsonWriter(this.byteStream));
        this.json.writeValue(value, value == null ? null : value.getClass(), elementType);
        this.put(name, this.byteStream.toByteArray());
        this.modified = true;
    }

    public synchronized <T> T getJson(String name, Class<T> type, Class elementType, Prov<T> def) {
        try {
            if (!this.has(name)) {
                return def.get();
            }
            this.byteInputStream.setBytes(this.getBytes(name));
            return this.json.readValue(type, elementType, this.ureader.parse(this.byteInputStream));
        }
        catch (Throwable e) {
            return def.get();
        }
    }

    public <T> T getJson(String name, Class<T> type, Prov<T> def) {
        return this.getJson(name, type, null, def);
    }

    public float getFloat(String name, float def) {
        return ((Float)this.get(name, Float.valueOf(def))).floatValue();
    }

    public long getLong(String name, long def) {
        return (Long)this.get(name, def);
    }

    public Long getLong(String name) {
        return this.getLong(name, 0L);
    }

    public int getInt(String name, int def) {
        return (Integer)this.get(name, def);
    }

    public boolean getBool(String name, boolean def) {
        return (Boolean)this.get(name, def);
    }

    public byte[] getBytes(String name, byte[] def) {
        return (byte[])this.get(name, def);
    }

    public String getString(String name, String def) {
        return (String)this.get(name, def);
    }

    public float getFloat(String name) {
        return this.getFloat(name, ((Float)this.defaults.get(name, Float.valueOf(0.0f))).floatValue());
    }

    public int getInt(String name) {
        return this.getInt(name, (Integer)this.defaults.get(name, 0));
    }

    public boolean getBool(String name) {
        return this.getBool(name, (Boolean)this.defaults.get(name, false));
    }

    public void getBoolOnce(String name, Runnable run) {
        if (!this.getBool(name, false)) {
            run.run();
            this.put(name, true);
        }
    }

    public boolean getBoolOnce(String name) {
        boolean val = this.getBool(name, false);
        this.put(name, true);
        return val;
    }

    public byte[] getBytes(String name) {
        return this.getBytes(name, (byte[])this.defaults.get(name));
    }

    public String getString(String name) {
        return this.getString(name, (String)this.defaults.get(name));
    }

    public void putAll(ObjectMap<String, Object> map) {
        for (ObjectMap.Entry entry : map.entries()) {
            this.put((String)entry.key, entry.value);
        }
    }

    public synchronized void put(String name, Object object) {
        if (!(object instanceof Float || object instanceof Integer || object instanceof Boolean || object instanceof Long || object instanceof String || object instanceof byte[])) {
            throw new IllegalArgumentException("Invalid object stored: " + (object == null ? null : object.getClass()) + ".");
        }
        this.values.put(name, object);
        this.modified = true;
    }

    public synchronized void remove(String name) {
        this.values.remove(name);
        this.modified = true;
    }

    public synchronized Iterable<String> keys() {
        return this.values.keySet();
    }

    public synchronized int keySize() {
        return this.values.size();
    }
}

