/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.util.Time;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawCultivator
extends DrawBlock {
    public Color plantColor = Color.valueOf("5541b1");
    public Color plantColorLight = Color.valueOf("7457ce");
    public Color bottomColor = Color.valueOf("474747");
    public int bubbles = 12;
    public int sides = 8;
    public float strokeMin = 0.2f;
    public float spread = 3.0f;
    public float timeScl = 70.0f;
    public float recurrence = 6.0f;
    public float radius = 3.0f;
    public TextureRegion middle;

    @Override
    public void draw(Building build) {
        Drawf.liquid(this.middle, build.x, build.y, build.warmup(), this.plantColor);
        Draw.color(this.bottomColor, this.plantColorLight, build.warmup());
        rand.setSeed(build.pos());
        for (int i = 0; i < this.bubbles; ++i) {
            float x = rand.range(this.spread);
            float y = rand.range(this.spread);
            float life = 1.0f - (Time.time / this.timeScl + rand.random(this.recurrence)) % this.recurrence;
            if (!(life > 0.0f)) continue;
            Lines.stroke(build.warmup() * (life + this.strokeMin));
            Lines.poly(build.x + x, build.y + y, this.sides, (1.0f - life) * this.radius);
        }
        Draw.color();
    }

    @Override
    public void load(Block block) {
        this.middle = Core.atlas.find(block.name + "-middle");
    }
}

