/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.scene.ui.layout.Table;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.content.Planets;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.type.SectorPreset;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.WorldParams;

public class SectorGenerateDialog
extends BaseDialog {
    Planet planet = Planets.erekir;
    int sector = 0;
    int seed = 0;

    public SectorGenerateDialog() {
        super("@editor.sectorgenerate");
        this.setup();
    }

    void setup() {
        this.cont.clear();
        this.buttons.clear();
        this.addCloseButton();
        this.cont.defaults().left();
        this.cont.add("@editor.planet").padRight(10.0f);
        this.cont.button(this.planet.localizedName, () -> {
            BaseDialog dialog = new BaseDialog("");
            dialog.cont.pane((Table p) -> {
                p.background(Tex.button).margin(10.0f);
                int i = 0;
                for (Planet plan : Vars.content.planets()) {
                    if (plan.generator == null || plan.sectors.size == 0 || !plan.accessible) continue;
                    p.button(plan.localizedName, Styles.flatTogglet, () -> {
                        this.planet = plan;
                        this.sector = Math.min(this.sector, this.planet.sectors.size - 1);
                        this.seed = 0;
                        dialog.hide();
                    }).size(110.0f, 45.0f).checked(this.planet == plan);
                    if (++i % 4 != 0) continue;
                    p.row();
                }
            });
            dialog.setFillParent(false);
            dialog.addCloseButton();
            dialog.show();
        }).size(200.0f, 40.0f).get().getLabel().setText(() -> this.planet.localizedName);
        this.cont.row();
        this.cont.add("@editor.sector").padRight(10.0f);
        this.cont.field(this.sector + "", text -> {
            this.sector = Strings.parseInt(text);
        }).width(200.0f).valid(text -> this.planet.sectors.size > Strings.parseInt(text, 99999) && Strings.parseInt(text, 9999) >= 0);
        this.cont.row();
        this.cont.add("@editor.seed").padRight(10.0f);
        this.cont.field(this.seed + "", text -> {
            this.seed = Strings.parseInt(text);
        }).width(200.0f).valid(Strings::canParseInt);
        this.cont.row();
        this.cont.label(() -> "[ " + this.planet.sectors.get(this.sector).getSize() + "x" + this.planet.sectors.get(this.sector).getSize() + " ]").color(Pal.accent).center().labelAlign(1).padTop(5.0f).colspan(2);
        this.buttons.button("@editor.apply", Icon.ok, () -> Vars.ui.loadAnd(() -> {
            this.apply();
            this.hide();
        }));
    }

    void apply() {
        Vars.ui.loadAnd(() -> {
            Vars.editor.clearOp();
            Vars.editor.load(() -> {
                Sector sectorobj = this.planet.sectors.get(this.sector);
                SectorPreset preset = sectorobj.preset;
                sectorobj.preset = null;
                Vars.logic.reset();
                WorldParams params = new WorldParams();
                params.seedOffset = this.seed;
                params.saveInfo = false;
                Vars.world.loadSector(sectorobj, params);
                sectorobj.preset = preset;
                Vars.editor.updateRenderer();
                Vars.state.rules.sector = null;
                Vars.editor.tags.put("genfilters", "{}");
            });
        });
    }
}

