/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics;

import arc.Core;
import arc.files.Fi;
import arc.func.IntIntf;
import arc.func.Intc2;
import arc.graphics.Color;
import arc.graphics.PixmapIO;
import arc.graphics.g2d.PixmapRegion;
import arc.math.Mathf;
import arc.util.ArcNativesLoader;
import arc.util.ArcRuntimeException;
import arc.util.Disposable;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;

public class Pixmap
implements Disposable {
    public int width;
    public int height;
    public ByteBuffer pixels;
    long handle;

    public Pixmap(int width, int height) {
        this.load(width, height);
    }

    public Pixmap(byte[] encodedData) {
        this(encodedData, 0, encodedData.length);
    }

    public Pixmap(byte[] encodedData, int offset, int len) {
        this.load(encodedData, offset, len, null);
    }

    public Pixmap(String file) {
        this(Core.files == null ? Fi.get(file) : Core.files.internal(file));
    }

    public Pixmap(Fi file) {
        byte[] bytes = file.readBytes();
        this.load(bytes, 0, bytes.length, file.toString());
    }

    public Pixmap(ByteBuffer buffer, int width, int height) {
        if (!buffer.isDirect()) {
            throw new ArcRuntimeException("Pixmaps may only use direct/native ByteBuffers!");
        }
        this.width = width;
        this.height = height;
        this.pixels = buffer;
        this.handle = -1L;
        buffer.position(0).limit(buffer.capacity());
    }

    public Pixmap copy() {
        Pixmap out = new Pixmap(this.width, this.height);
        this.pixels.position(0);
        out.pixels.position(0);
        out.pixels.put(this.pixels);
        out.pixels.position(0);
        return out;
    }

    public void each(Intc2 cons) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                cons.get(x, y);
            }
        }
    }

    public void replace(IntIntf func) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.setRaw(x, y, func.get(this.getRaw(x, y)));
            }
        }
    }

    public void fill(int color) {
        int len = this.width * this.height * 4;
        for (int i = 0; i < len; i += 4) {
            this.pixels.putInt(i, color);
        }
    }

    public void fill(Color color) {
        this.fill(color.rgba());
    }

    public boolean in(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height;
    }

    public Pixmap crop(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            throw new IllegalStateException("input is disposed.");
        }
        Pixmap pixmap = new Pixmap(width, height);
        pixmap.draw(this, 0, 0, x, y, width, height);
        return pixmap;
    }

    public Pixmap flipY() {
        Pixmap copy = new Pixmap(this.width, this.height);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                copy.setRaw(x, this.height - 1 - y, this.getRaw(x, y));
            }
        }
        return copy;
    }

    public Pixmap flipX() {
        Pixmap copy = new Pixmap(this.width, this.height);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                copy.set(this.width - 1 - x, y, this.getRaw(x, y));
            }
        }
        return copy;
    }

    public Pixmap outline(Color color, int radius) {
        return this.outline(color.rgba(), radius);
    }

    public Pixmap outline(int color, int radius) {
        Pixmap pixmap = this.copy();
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (this.getA(x, y) != 0) continue;
                boolean found = false;
                block2: for (int dx = -radius; dx <= radius; ++dx) {
                    for (int dy = -radius; dy <= radius; ++dy) {
                        if (dx * dx + dy * dy > radius * radius || Pixmap.empty(this.get(x + dx, y + dy))) continue;
                        found = true;
                        break block2;
                    }
                }
                if (!found) continue;
                pixmap.setRaw(x, y, color);
            }
        }
        return pixmap;
    }

    public void drawLine(int x1, int y1, int x2, int y2, int color) {
        int x = x1;
        int dx = Math.abs(x2 - x);
        int sx = x < x2 ? 1 : -1;
        int y = y1;
        int dy = Math.abs(y2 - y);
        int sy = y < y2 ? 1 : -1;
        int err = dx - dy;
        while (true) {
            this.set(x, y, color);
            if (x == x2 && y == y2) {
                return;
            }
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y += sy;
        }
    }

    public void drawRect(int x, int y, int width, int height, int color) {
        this.hline(x, x + width - 1, y, color);
        this.hline(x, x + width - 1, y + height - 1, color);
        this.vline(y, y + height - 1, x, color);
        this.vline(y, y + height - 1, x + width - 1, color);
    }

    void circlePoints(int cx, int cy, int x, int y, int col) {
        if (x == 0) {
            this.set(cx, cy + y, col);
            this.set(cx, cy - y, col);
            this.set(cx + y, cy, col);
            this.set(cx - y, cy, col);
        } else if (x == y) {
            this.set(cx + x, cy + y, col);
            this.set(cx - x, cy + y, col);
            this.set(cx + x, cy - y, col);
            this.set(cx - x, cy - y, col);
        } else if (x < y) {
            this.set(cx + x, cy + y, col);
            this.set(cx - x, cy + y, col);
            this.set(cx + x, cy - y, col);
            this.set(cx - x, cy - y, col);
            this.set(cx + y, cy + x, col);
            this.set(cx - y, cy + x, col);
            this.set(cx + y, cy - x, col);
            this.set(cx - y, cy - x, col);
        }
    }

    public void drawCircle(int x, int y, int radius, int col) {
        int px = 0;
        int py = radius;
        int p = (5 - radius * 4) / 4;
        this.circlePoints(x, y, px, py, col);
        while (px < py) {
            p = p < 0 ? (p += 2 * px + 1) : (p += 2 * (++px - --py) + 1);
            this.circlePoints(x, y, px, py, col);
        }
    }

    public void draw(PixmapRegion region) {
        this.draw(region.pixmap, region.x, region.y, region.width, region.height, 0, 0, region.width, region.height);
    }

    public void draw(PixmapRegion region, boolean blend) {
        this.draw(region.pixmap, region.x, region.y, region.width, region.height, 0, 0, region.width, region.height, false, blend);
    }

    public void draw(PixmapRegion region, int x, int y) {
        this.draw(region.pixmap, region.x, region.y, region.width, region.height, x, y, region.width, region.height);
    }

    public void draw(PixmapRegion region, int x, int y, int width, int height) {
        this.draw(region.pixmap, region.x, region.y, region.width, region.height, x, y, width, height);
    }

    public void draw(PixmapRegion region, int x, int y, int srcx, int srcy, int srcWidth, int srcHeight) {
        this.draw(region.pixmap, x, y, region.x + srcx, region.y + srcy, srcWidth, srcHeight);
    }

    public void draw(PixmapRegion region, int srcx, int srcy, int srcWidth, int srcHeight, int dstx, int dsty, int dstWidth, int dstHeight) {
        this.draw(region.pixmap, region.x + srcx, region.y + srcy, srcWidth, srcHeight, dstx, dsty, dstWidth, dstHeight);
    }

    public void draw(Pixmap pixmap, boolean blend) {
        this.draw(pixmap, 0, 0, pixmap.width, pixmap.height, 0, 0, pixmap.width, pixmap.height, false, blend);
    }

    public void draw(Pixmap pixmap) {
        this.draw(pixmap, 0, 0);
    }

    public void draw(Pixmap pixmap, int x, int y) {
        this.draw(pixmap, x, y, 0, 0, pixmap.width, pixmap.height);
    }

    public void draw(Pixmap pixmap, int x, int y, boolean blending) {
        this.draw(pixmap, 0, 0, pixmap.width, pixmap.height, x, y, pixmap.width, pixmap.height, false, blending);
    }

    public void draw(Pixmap pixmap, int x, int y, int width, int height) {
        this.draw(pixmap, x, y, width, height, false);
    }

    public void draw(Pixmap pixmap, int x, int y, int width, int height, boolean filter) {
        this.draw(pixmap, 0, 0, pixmap.width, pixmap.height, x, y, width, height, filter);
    }

    public void draw(Pixmap pixmap, int x, int y, int srcx, int srcy, int srcWidth, int srcHeight) {
        this.draw(pixmap, srcx, srcy, srcWidth, srcHeight, x, y, srcWidth, srcHeight);
    }

    public void draw(Pixmap pixmap, int srcx, int srcy, int srcWidth, int srcHeight, int dstx, int dsty, int dstWidth, int dstHeight) {
        this.draw(pixmap, srcx, srcy, srcWidth, srcHeight, dstx, dsty, dstWidth, dstHeight, false);
    }

    public void draw(Pixmap pixmap, int srcx, int srcy, int srcWidth, int srcHeight, int dstx, int dsty, int dstWidth, int dstHeight, boolean filtering) {
        this.draw(pixmap, srcx, srcy, srcWidth, srcHeight, dstx, dsty, dstWidth, dstHeight, filtering, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void draw(Pixmap pixmap, int srcx, int srcy, int srcWidth, int srcHeight, int dstx, int dsty, int dstWidth, int dstHeight, boolean filtering, boolean blending) {
        int width = this.width;
        int height = this.height;
        int owidth = pixmap.width;
        int oheight = pixmap.height;
        if (srcWidth == 0 || srcHeight == 0 || dstWidth == 0 || dstHeight == 0) {
            return;
        }
        if (srcWidth == dstWidth && srcHeight == dstHeight) {
            int sy = srcy;
            int dy = dsty;
            if (blending) {
                while (sy < srcy + srcHeight) {
                    if (sy >= 0 && dy >= 0) {
                        if (sy >= oheight || dy >= height) return;
                        int sx = srcx;
                        int dx = dstx;
                        while (sx < srcx + srcWidth) {
                            if (sx >= 0 && dx >= 0) {
                                if (sx >= owidth || dx >= width) break;
                                this.setRaw(dx, dy, Pixmap.blend(pixmap.getRaw(sx, sy), this.getRaw(dx, dy)));
                            }
                            ++sx;
                            ++dx;
                        }
                    }
                    ++sy;
                    ++dy;
                }
                return;
            } else if (this.pixels != pixmap.pixels) {
                ByteBuffer pixels = this.pixels;
                ByteBuffer otherPixels = pixmap.pixels;
                int endY = Math.min(Math.min(dsty + Math.min(dstHeight, oheight), height), dsty - srcy + oheight);
                int startX = Math.max(dstx, 0);
                int endX = Math.min(Math.min(dstx + Math.min(dstWidth, owidth), width), dstx - srcx + owidth);
                int offsetY = dsty - srcy;
                int scanX = Math.max(Math.max(srcx, -dstx), 0);
                int scanWidth = (endX - startX) * 4;
                for (int startY = Math.max(dsty, 0); startY < endY; ++startY) {
                    int offset = (startY * width + startX) * 4;
                    int otherOffset = ((startY - offsetY) * owidth + scanX) * 4;
                    pixels.position(offset);
                    otherPixels.limit(otherOffset + scanWidth);
                    otherPixels.position(otherOffset);
                    pixels.put(otherPixels);
                }
                pixels.position(0);
                otherPixels.position(0);
                otherPixels.limit(otherPixels.capacity());
                return;
            } else {
                while (sy < srcy + srcHeight) {
                    if (sy >= 0 && dy >= 0) {
                        if (sy >= oheight || dy >= height) return;
                        int sx = srcx;
                        int dx = dstx;
                        while (sx < srcx + srcWidth) {
                            if (sx >= 0 && dx >= 0) {
                                if (sx >= owidth || dx >= width) break;
                                this.setRaw(dx, dy, pixmap.getRaw(sx, sy));
                            }
                            ++sx;
                            ++dx;
                        }
                    }
                    ++sy;
                    ++dy;
                }
            }
            return;
        } else if (filtering) {
            float x_ratio = ((float)srcWidth - 1.0f) / (float)dstWidth;
            float y_ratio = ((float)srcHeight - 1.0f) / (float)dstHeight;
            int rX = Math.max(Mathf.round(x_ratio), 1);
            int rY = Math.max(Mathf.round(y_ratio), 1);
            int spitch = 4 * owidth;
            ByteBuffer spixels = pixmap.pixels;
            block5: for (int i = 0; i < dstHeight; ++i) {
                int sy = (int)((float)i * y_ratio) + srcy;
                int dy = i + dsty;
                float ydiff = y_ratio * (float)i + (float)srcy - (float)sy;
                if (sy < 0 || dy < 0) continue;
                if (sy >= oheight || dy >= height) return;
                for (int j = 0; j < dstWidth; ++j) {
                    int sx = (int)((float)j * x_ratio) + srcx;
                    int dx = j + dstx;
                    float xdiff = x_ratio * (float)j + (float)srcx - (float)sx;
                    if (sx < 0 || dx < 0) continue;
                    if (sx >= owidth || dx >= width) continue block5;
                    int srcp = (sx + sy * owidth) * 4;
                    int c1 = spixels.getInt(srcp);
                    int c2 = sx + rX < srcWidth ? spixels.getInt(srcp + 4 * rX) : c1;
                    int c3 = sy + rY < srcHeight ? spixels.getInt(srcp + spitch * rY) : c1;
                    int c4 = sx + rX < srcWidth && sy + rY < srcHeight ? spixels.getInt(srcp + 4 * rX + spitch * rY) : c1;
                    float ta = (1.0f - xdiff) * (1.0f - ydiff);
                    float tb = xdiff * (1.0f - ydiff);
                    float tc = (1.0f - xdiff) * ydiff;
                    float td = xdiff * ydiff;
                    int r = (int)((float)((c1 & 0xFF000000) >>> 24) * ta + (float)((c2 & 0xFF000000) >>> 24) * tb + (float)((c3 & 0xFF000000) >>> 24) * tc + (float)((c4 & 0xFF000000) >>> 24) * td) & 0xFF;
                    int g = (int)((float)((c1 & 0xFF0000) >>> 16) * ta + (float)((c2 & 0xFF0000) >>> 16) * tb + (float)((c3 & 0xFF0000) >>> 16) * tc + (float)((c4 & 0xFF0000) >>> 16) * td) & 0xFF;
                    int b = (int)((float)((c1 & 0xFF00) >>> 8) * ta + (float)((c2 & 0xFF00) >>> 8) * tb + (float)((c3 & 0xFF00) >>> 8) * tc + (float)((c4 & 0xFF00) >>> 8) * td) & 0xFF;
                    int a = (int)((float)(c1 & 0xFF) * ta + (float)(c2 & 0xFF) * tb + (float)(c3 & 0xFF) * tc + (float)(c4 & 0xFF) * td) & 0xFF;
                    int srccol = r << 24 | g << 16 | b << 8 | a;
                    this.setRaw(dx, dy, !blending ? srccol : Pixmap.blend(srccol, this.getRaw(dx, dy)));
                }
            }
            return;
        } else {
            int xratio = (srcWidth << 16) / dstWidth + 1;
            int yratio = (srcHeight << 16) / dstHeight + 1;
            block7: for (int i = 0; i < dstHeight; ++i) {
                int sy = (i * yratio >> 16) + srcy;
                int dy = i + dsty;
                if (sy < 0 || dy < 0) continue;
                if (sy >= oheight || dy >= height) return;
                for (int j = 0; j < dstWidth; ++j) {
                    int sx = (j * xratio >> 16) + srcx;
                    int dx = j + dstx;
                    if (sx < 0 || dx < 0) continue;
                    if (sx >= owidth || dx >= width) continue block7;
                    this.setRaw(dx, dy, !blending ? pixmap.getRaw(sx, sy) : Pixmap.blend(pixmap.getRaw(sx, sy), this.getRaw(dx, dy)));
                }
            }
        }
    }

    public void fillRect(int x, int y, int width, int height, int color) {
        int x2 = x + width - 1;
        int y2 = y + height - 1;
        if (x >= this.width) {
            return;
        }
        if (y >= this.height) {
            return;
        }
        if (x2 < 0) {
            return;
        }
        if (y2 < 0) {
            return;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x2 >= this.width) {
            x2 = this.width - 1;
        }
        if (y2 >= this.height) {
            y2 = this.height - 1;
        }
        ++y2;
        while (y != y2) {
            this.hline(x, x2, y, color);
            ++y;
        }
    }

    public void fillCircle(int x, int y, int radius, int color) {
        int f = 1 - radius;
        int ddF_x = 1;
        int ddF_y = -2 * radius;
        int px = 0;
        int py = radius;
        this.hline(x, x, y + radius, color);
        this.hline(x, x, y - radius, color);
        this.hline(x - radius, x + radius, y, color);
        while (px < py) {
            if (f >= 0) {
                --py;
                f += (ddF_y += 2);
            }
            f += (ddF_x += 2);
            this.hline(x - ++px, x + px, y + py, color);
            this.hline(x - px, x + px, y - py, color);
            this.hline(x - py, x + py, y + px, color);
            this.hline(x - py, x + py, y - px, color);
        }
    }

    public int get(int x, int y) {
        return this.in(x, y) ? this.pixels.getInt((x + y * this.width) * 4) : 0;
    }

    public int getRaw(int x, int y) {
        return this.pixels.getInt((x + y * this.width) * 4);
    }

    public int getA(int x, int y) {
        return this.pixels.get((x + y * this.width) * 4 + 3) & 0xFF;
    }

    public boolean empty(int x, int y) {
        return this.pixels.get((x + y * this.width) * 4 + 3) == 0;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public void dispose() {
        if (this.handle <= 0L) {
            return;
        }
        Pixmap.free(this.handle);
        this.handle = 0L;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public void set(int x, int y, Color color) {
        this.set(x, y, color.rgba());
    }

    public void set(int x, int y, int color) {
        if (this.in(x, y)) {
            this.pixels.putInt((x + y * this.width) * 4, color);
        }
    }

    public void setRaw(int x, int y, int color) {
        this.pixels.putInt((x + y * this.width) * 4, color);
    }

    public int getGLFormat() {
        return 6408;
    }

    public int getGLInternalFormat() {
        return 6408;
    }

    public int getGLType() {
        return 5121;
    }

    public ByteBuffer getPixels() {
        if (this.handle == 0L) {
            throw new ArcRuntimeException("Pixmap already disposed");
        }
        return this.pixels;
    }

    void hline(int x1, int x2, int y, int color) {
        if (y < 0 || y >= this.height) {
            return;
        }
        if (x1 > x2) {
            int tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (x1 >= this.width) {
            return;
        }
        if (x2 < 0) {
            return;
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (x2 >= this.width) {
            x2 = this.width - 1;
        }
        ++x2;
        while (x1 != x2) {
            this.setRaw(x1++, y, color);
        }
    }

    void vline(int y1, int y2, int x, int color) {
        if (x < 0 || x >= this.width) {
            return;
        }
        if (y1 > y2) {
            int tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        if (y1 >= this.height) {
            return;
        }
        if (y2 < 0) {
            return;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y2 >= this.height) {
            y2 = this.height - 1;
        }
        ++y2;
        while (y1 != y2) {
            this.setRaw(x, y1++, color);
        }
    }

    public static int blend(int src, int dst) {
        int src_a = src & 0xFF;
        if (src_a == 0) {
            return dst;
        }
        int dst_a = dst & 0xFF;
        if (dst_a == 0) {
            return src;
        }
        int dst_b = dst >>> 8 & 0xFF;
        int dst_g = dst >>> 16 & 0xFF;
        int dst_r = dst >>> 24 & 0xFF;
        dst_a -= dst_a * src_a / 255;
        int a = dst_a + src_a;
        dst_r = (dst_r * dst_a + (src >>> 24 & 0xFF) * src_a) / a;
        dst_g = (dst_g * dst_a + (src >>> 16 & 0xFF) * src_a) / a;
        dst_b = (dst_b * dst_a + (src >>> 8 & 0xFF) * src_a) / a;
        return dst_r << 24 | dst_g << 16 | dst_b << 8 | a;
    }

    public static boolean empty(int i) {
        return (i & 0xFF) == 0;
    }

    private void load(byte[] encodedData, int offset, int len, String file) {
        if (ArcNativesLoader.loaded) {
            try {
                long[] nativeData = new long[3];
                this.pixels = Pixmap.loadJni(nativeData, encodedData, offset, len);
                if (this.pixels == null) {
                    throw new ArcRuntimeException("Error loading pixmap from image data: " + Pixmap.getFailureReason() + (file == null ? "" : " (" + file + ")"));
                }
                this.handle = nativeData[0];
                this.width = (int)nativeData[1];
                this.height = (int)nativeData[2];
                this.pixels.position(0).limit(this.pixels.capacity());
            }
            catch (ArcRuntimeException e) {
                if (e.getMessage() != null && e.getMessage().contains("Corrupt JPEG")) {
                    try {
                        this.loadJava(encodedData, offset, len, file);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw e;
            }
        } else {
            this.loadJava(encodedData, offset, len, file);
        }
    }

    private void loadJava(byte[] encodedData, int offset, int len, String file) {
        try {
            PixmapIO.PngReader reader = new PixmapIO.PngReader();
            this.pixels = reader.read(new ByteArrayInputStream(encodedData, offset, len));
            this.width = reader.width;
            this.height = reader.height;
            this.handle = -1L;
            this.pixels.position(0).limit(this.pixels.capacity());
        }
        catch (Exception e) {
            throw new ArcRuntimeException("Failed to load PNG data" + (file == null ? "" : " (" + file + ")"), e);
        }
    }

    private void load(int width, int height) {
        if (ArcNativesLoader.loaded) {
            long[] nativeData = new long[3];
            this.pixels = Pixmap.createJni(nativeData, width, height);
            if (this.pixels == null) {
                throw new ArcRuntimeException("Error creating pixmap (out of memory?)");
            }
            this.pixels.limit(this.pixels.capacity());
            this.handle = nativeData[0];
            this.width = (int)nativeData[1];
            this.height = (int)nativeData[2];
        } else {
            this.handle = -1L;
            this.width = width;
            this.height = height;
            this.pixels = ByteBuffer.allocateDirect(width * height * 4);
        }
    }

    public String toString() {
        return "Pixmap:" + this.width + "x" + this.height;
    }

    static native ByteBuffer loadJni(long[] var0, byte[] var1, int var2, int var3);

    static native ByteBuffer createJni(long[] var0, int var1, int var2);

    static native void free(long var0);

    static native String getFailureReason();

    public static enum Format {
        alpha(5121, 6406),
        intensity(5121, 6406),
        luminanceAlpha(5121, 6410),
        rgb565(33635, 6407),
        rgba4444(32819, 6408),
        rgb888(5121, 6407),
        rgba8888(5121, 6408);

        public static final Format[] all;
        public final int glFormat;
        public final int glType;

        private Format(int glType, int glFormat) {
            this.glFormat = glFormat;
            this.glType = glType;
        }

        static {
            all = Format.values();
        }
    }
}

