/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.payloads;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.ctype.Content;
import mindustry.entities.Puddles;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.type.ItemStack;
import mindustry.ui.Bar;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.PayloadBlock;
import mindustry.world.blocks.payloads.UnitPayload;

public class PayloadDeconstructor
extends PayloadBlock {
    public float maxPayloadSize = 4.0f;
    public float deconstructSpeed = 2.5f;
    public int dumpRate = 4;

    public PayloadDeconstructor(String name) {
        super(name);
        this.outputsPayload = false;
        this.acceptsPayload = true;
        this.update = true;
        this.rotate = false;
        this.solid = true;
        this.size = 5;
        this.payloadSpeed = 1.0f;
        this.clipSize = 120.0f;
        this.hasItems = true;
        this.hasPower = true;
        this.itemCapacity = 100;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.topRegion};
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("progress", e -> new Bar("bar.progress", Pal.ammo, () -> e.progress));
    }

    public class PayloadDeconstructorBuild
    extends PayloadBlock.PayloadBlockBuild<Payload> {
        @Nullable
        public Payload deconstructing;
        @Nullable
        public float[] accum;
        public float progress;
        public float time;
        public float speedScl;

        @Override
        public void draw() {
            Draw.rect(PayloadDeconstructor.this.region, this.x, this.y);
            for (int i = 0; i < 4; ++i) {
                if (!this.blends(i)) continue;
                Draw.rect(PayloadDeconstructor.this.inRegion, this.x, this.y, (float)(i * 90 - 180));
            }
            Draw.z(35.0f);
            this.drawPayload();
            if (this.deconstructing != null) {
                this.deconstructing.set(this.x + this.payVector.x, this.y + this.payVector.y, this.payRotation);
                Draw.z(35.0f);
                this.deconstructing.drawShadow(1.0f - this.progress);
                Draw.draw(35.0f, () -> {
                    Drawf.construct(this.x, this.y, this.deconstructing.icon(), Pal.remove, this.deconstructing instanceof BuildPayload ? 0.0f : this.payRotation - 90.0f, 1.0f - this.progress, 1.0f - this.progress, this.time);
                    Draw.color(Pal.remove);
                    Draw.alpha(1.0f);
                    Lines.lineAngleCenter(this.x + Mathf.sin(this.time, 20.0f, 4.0f * (float)this.block.size - 3.0f), this.y, 90.0f, (float)(this.block.size * 8) - 6.0f);
                    Draw.reset();
                });
            }
            Draw.rect(PayloadDeconstructor.this.topRegion, this.x, this.y);
        }

        @Override
        public boolean acceptUnitPayload(Unit unit) {
            return this.payload == null && this.deconstructing == null && unit.type.allowedInPayloads && !unit.spawnedByCore && unit.type.getTotalRequirements().length > 0 && unit.hitSize / 8.0f <= PayloadDeconstructor.this.maxPayloadSize;
        }

        @Override
        public void handlePayload(Building source, Payload payload) {
            super.handlePayload(source, payload);
            this.accum = null;
        }

        @Override
        public boolean acceptPayload(Building source, Payload payload) {
            return this.deconstructing == null && this.payload == null && super.acceptPayload(source, payload) && payload.requirements().length > 0 && payload.fits(PayloadDeconstructor.this.maxPayloadSize);
        }

        @Override
        public void updateTile() {
            super.updateTile();
            if (this.items.total() > 0) {
                for (int i = 0; i < PayloadDeconstructor.this.dumpRate; ++i) {
                    this.dumpAccumulate();
                }
            }
            if (this.deconstructing == null) {
                this.progress = 0.0f;
            }
            this.payRotation = Angles.moveToward(this.payRotation, 90.0f, PayloadDeconstructor.this.payloadRotateSpeed * this.edelta());
            if (this.deconstructing != null) {
                int i;
                boolean canProgress;
                ItemStack[] reqs = this.deconstructing.requirements();
                if (this.accum == null || reqs.length != this.accum.length) {
                    this.accum = new float[reqs.length];
                }
                boolean bl = canProgress = this.items.total() <= PayloadDeconstructor.this.itemCapacity;
                if (canProgress) {
                    for (float ac : this.accum) {
                        if (!(ac >= 1.0f)) continue;
                        canProgress = false;
                        break;
                    }
                }
                if (canProgress) {
                    Payload ac;
                    float shift = this.edelta() * PayloadDeconstructor.this.deconstructSpeed / this.deconstructing.buildTime();
                    float realShift = Math.min(shift, 1.0f - this.progress);
                    if (this.progress == 0.0f && shift > 0.0f && (ac = this.deconstructing) instanceof BuildPayload) {
                        BuildPayload pay = (BuildPayload)ac;
                        Building build = pay.build;
                        if (build.liquids != null && build.liquids.currentAmount() > 0.0f) {
                            float perCell = build.liquids.currentAmount() / (float)(this.block.size * this.block.size) * 2.0f;
                            this.tile.getLinkedTiles(other -> Puddles.deposit(other, build.liquids.current(), perCell));
                        }
                    }
                    this.progress += shift;
                    this.time += this.edelta();
                    for (int i2 = 0; i2 < reqs.length; ++i2) {
                        int n = i2;
                        this.accum[n] = this.accum[n] + (float)reqs[i2].amount * (this.deconstructing instanceof BuildPayload ? Vars.state.rules.buildCostMultiplier : Vars.state.rules.unitCost(this.team)) * realShift;
                    }
                }
                this.speedScl = Mathf.lerpDelta(this.speedScl, canProgress ? 1.0f : 0.0f, 0.1f);
                for (i = 0; i < reqs.length; ++i) {
                    int taken = Math.min((int)this.accum[i], PayloadDeconstructor.this.itemCapacity - this.items.total());
                    if (taken <= 0) continue;
                    this.items.add(reqs[i].item, taken);
                    int n = i;
                    this.accum[n] = this.accum[n] - (float)taken;
                }
                if (this.progress >= 1.0f) {
                    canProgress = true;
                    for (i = 0; i < reqs.length; ++i) {
                        if (!Mathf.equal(this.accum[i], 1.0f, 1.0E-4f)) continue;
                        if (this.items.total() < PayloadDeconstructor.this.itemCapacity) {
                            this.items.add(reqs[i].item, 1);
                            this.accum[i] = 0.0f;
                            continue;
                        }
                        canProgress = false;
                        break;
                    }
                    if (canProgress) {
                        Fx.breakBlock.at(this.x, this.y, this.deconstructing.size() / 8.0f);
                        this.deconstructing = null;
                        this.accum = null;
                    }
                }
            } else if (this.moveInPayload(false) && this.payload != null) {
                this.accum = new float[this.payload.requirements().length];
                this.deconstructing = this.payload;
                this.payload = null;
                this.progress = 0.0f;
            }
        }

        @Override
        public double sense(Content content) {
            Payload payload = this.deconstructing;
            if (payload instanceof UnitPayload) {
                UnitPayload up = (UnitPayload)payload;
                return up.unit.type == content ? 1.0 : 0.0;
            }
            payload = this.deconstructing;
            if (payload instanceof BuildPayload) {
                BuildPayload bp = (BuildPayload)payload;
                return bp.build.block == content ? 1.0 : 0.0;
            }
            return super.sense(content);
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return this.progress;
            }
            return super.sense(sensor);
        }

        @Override
        public boolean shouldConsume() {
            return this.deconstructing != null && this.enabled;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
            if (this.accum != null) {
                write.s(this.accum.length);
                for (float v : this.accum) {
                    write.f(v);
                }
            } else {
                write.s(0);
            }
            Payload.write(this.deconstructing, write);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.progress = read.f();
            int accums = read.s();
            if (accums > 0) {
                this.accum = new float[accums];
                for (int i = 0; i < accums; ++i) {
                    this.accum[i] = read.f();
                }
            }
            this.deconstructing = Payload.read(read);
        }
    }
}

