/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Gl;
import arc.graphics.Mesh;
import arc.graphics.Texture;
import arc.graphics.VertexAttribute;
import arc.graphics.g2d.Batch;
import arc.graphics.g2d.ForkJoinHolder;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.Shader;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.struct.IntIntMap;
import arc.util.Structs;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RecursiveAction;

public class SpriteBatch
extends Batch {
    public static final int VERTEX_SIZE = 6;
    public static final int SPRITE_SIZE = 24;
    private static final int initialSize = 10000;
    private static final float[] emptyVertices = new float[0];
    static ForkJoinHolder commonPool;
    boolean multithreaded = Core.app != null && (Core.app.getVersion() >= 21 && !Core.app.isIOS() || Core.app.isDesktop());
    protected Mesh mesh;
    protected FloatBuffer buffer;
    final float[] tmpVertices = new float[24];
    float[] requestVerts = new float[240000];
    int requestVertOffset = 0;
    protected boolean sort;
    protected boolean flushing;
    protected DrawRequest[] requests = new DrawRequest[10000];
    protected DrawRequest[] copy = new DrawRequest[0];
    protected int[] requestZ = new int[10000];
    protected int numRequests = 0;
    protected int[] contiguous = new int[2048];
    protected int[] contiguousCopy = new int[2048];
    protected int intZ = Float.floatToRawIntBits(this.z + 16.0f);

    public SpriteBatch() {
        this(4096, null);
    }

    public SpriteBatch(int size) {
        this(size, null);
    }

    public SpriteBatch(int size, Shader defaultShader) {
        if (size > 8191) {
            throw new IllegalArgumentException("Can't have more than 8191 sprites per batch: " + size);
        }
        if (size > 0) {
            this.projectionMatrix.setOrtho(0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
            this.mesh = new Mesh(true, false, size * 4, size * 6, VertexAttribute.position, VertexAttribute.color, VertexAttribute.texCoords, VertexAttribute.mixColor);
            int len = size * 6;
            short[] indices = new short[len];
            short j = 0;
            int i = 0;
            while (i < len) {
                indices[i] = j;
                indices[i + 1] = (short)(j + 1);
                indices[i + 2] = (short)(j + 2);
                indices[i + 3] = (short)(j + 2);
                indices[i + 4] = (short)(j + 3);
                indices[i + 5] = j;
                i += 6;
                j = (short)(j + 4);
            }
            this.mesh.setIndices(indices);
            this.mesh.getVerticesBuffer().position(0);
            this.mesh.getVerticesBuffer().limit(this.mesh.getVerticesBuffer().capacity());
            if (defaultShader == null) {
                this.shader = SpriteBatch.createShader();
                this.ownsShader = true;
            } else {
                this.shader = defaultShader;
            }
            this.mesh.getIndicesBuffer();
            this.buffer = this.mesh.getVerticesBuffer();
        } else {
            this.shader = null;
        }
        for (int i = 0; i < this.requests.length; ++i) {
            this.requests[i] = new DrawRequest();
        }
        if (this.multithreaded) {
            try {
                commonPool = new ForkJoinHolder();
            }
            catch (Throwable t) {
                this.multithreaded = false;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.mesh != null) {
            this.mesh.dispose();
        }
    }

    @Override
    protected void setSort(boolean sort) {
        if (this.sort != sort) {
            this.flush();
        }
        this.sort = sort;
    }

    @Override
    protected void setShader(Shader shader, boolean apply) {
        if (!this.flushing && this.sort) {
            throw new IllegalArgumentException("Shaders cannot be set while sorting is enabled. Set shaders inside Draw.run(...).");
        }
        super.setShader(shader, apply);
    }

    @Override
    protected void setBlending(Blending blending) {
        this.blending = blending;
    }

    @Override
    protected void z(float z) {
        if (z == this.z) {
            return;
        }
        this.z = z;
        this.intZ = Float.floatToRawIntBits(z + 16.0f);
    }

    @Override
    protected void discard() {
        super.discard();
        this.buffer.position(0);
    }

    @Override
    protected void draw(Texture texture, float[] spriteVertices, int offset, int count) {
        if (this.sort && !this.flushing) {
            int num = this.numRequests;
            if (num > 0) {
                DrawRequest last = this.requests[num - 1];
                if (last.run == null && last.texture == texture && last.blending == this.blending && this.requestZ[num - 1] == this.intZ) {
                    if (spriteVertices != emptyVertices) {
                        this.prepare(count);
                        System.arraycopy(spriteVertices, offset, this.requestVerts, this.requestVertOffset, count);
                        this.requestVertOffset += count;
                    }
                    last.verticesLength += count;
                    return;
                }
            }
            if (num >= this.requests.length) {
                this.expandRequests();
            }
            DrawRequest req = this.requests[num];
            if (spriteVertices != emptyVertices) {
                req.verticesOffset = this.requestVertOffset;
                this.prepare(count);
                System.arraycopy(spriteVertices, offset, this.requestVerts, this.requestVertOffset, count);
                this.requestVertOffset += count;
            } else {
                req.verticesOffset = offset;
            }
            req.verticesLength = count;
            this.requestZ[num] = this.intZ;
            req.texture = texture;
            req.blending = this.blending;
            req.run = null;
            ++this.numRequests;
        } else {
            this.drawSuper(texture, spriteVertices, offset, count);
        }
    }

    @Override
    protected void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float rotation) {
        if (!this.sort || this.flushing) {
            this.drawSuper(region, x, y, originX, originY, width, height, rotation);
            return;
        }
        int pos = this.requestVertOffset;
        this.requestVertOffset += 24;
        this.prepare(24);
        this.constructVertices(this.requestVerts, pos, region, x, y, originX, originY, width, height, rotation);
        this.draw(region.texture, emptyVertices, pos, 24);
    }

    @Override
    protected void draw(Runnable request) {
        if (this.sort && !this.flushing) {
            if (this.numRequests >= this.requests.length) {
                this.expandRequests();
            }
            DrawRequest req = this.requests[this.numRequests];
            req.run = request;
            req.blending = this.blending;
            this.requestZ[this.numRequests] = this.intZ;
            req.texture = null;
            ++this.numRequests;
        } else {
            request.run();
        }
    }

    protected void prepare(int i) {
        if (this.requestVertOffset + i >= this.requestVerts.length) {
            this.requestVerts = Arrays.copyOf(this.requestVerts, this.requestVerts.length << 1);
        }
    }

    protected void expandRequests() {
        DrawRequest[] requests = this.requests;
        DrawRequest[] newRequests = Arrays.copyOf(requests, requests.length * 7 / 4);
        for (int i = requests.length; i < newRequests.length; ++i) {
            newRequests[i] = new DrawRequest();
        }
        this.requests = newRequests;
        this.requestZ = Arrays.copyOf(this.requestZ, newRequests.length);
    }

    @Override
    protected void flush() {
        if (!this.flushing) {
            this.flushing = true;
            this.flushRequests();
            this.flushing = false;
        }
        if (this.idx == 0) {
            return;
        }
        this.getShader().bind();
        this.setupMatrices();
        if (this.customShader != null && this.apply) {
            this.customShader.apply();
        }
        Gl.depthMask(false);
        int count = this.idx / 24 * 6;
        this.blending.apply();
        this.lastTexture.bind();
        Mesh mesh = this.mesh;
        mesh.getVerticesBuffer();
        this.buffer.position(0);
        this.buffer.limit(this.idx);
        mesh.render(this.getShader(), 4, 0, count);
        this.buffer.limit(this.buffer.capacity());
        this.buffer.position(0);
        this.idx = 0;
    }

    protected void flushRequests() {
        if (this.numRequests == 0) {
            return;
        }
        this.sortRequests();
        float preColor = this.colorPacked;
        float preMixColor = this.mixColorPacked;
        Blending preBlending = this.blending;
        float[] vertices = this.requestVerts;
        DrawRequest[] r = this.copy;
        int num = this.numRequests;
        for (int j = 0; j < num; ++j) {
            DrawRequest req = r[j];
            super.setBlending(req.blending);
            if (req.run != null) {
                req.run.run();
                req.run = null;
                continue;
            }
            if (req.texture == null) continue;
            this.drawSuper(req.texture, vertices, req.verticesOffset, req.verticesLength);
        }
        this.colorPacked = preColor;
        this.mixColorPacked = preMixColor;
        this.blending = preBlending;
        this.numRequests = 0;
        this.requestVertOffset = 0;
    }

    protected void drawSuper(Texture texture, float[] spriteVertices, int offset, int count) {
        int verticesLength;
        int remainingVertices = verticesLength = this.buffer.capacity();
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if ((remainingVertices -= this.idx) == 0) {
            this.flush();
            remainingVertices = verticesLength;
        }
        int copyCount = Math.min(remainingVertices, count);
        this.buffer.put(spriteVertices, offset, copyCount);
        this.idx += copyCount;
        count -= copyCount;
        while (count > 0) {
            this.flush();
            copyCount = Math.min(verticesLength, count);
            this.buffer.put(spriteVertices, offset += copyCount, copyCount);
            this.idx += copyCount;
            count -= copyCount;
        }
    }

    protected void drawSuper(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float rotation) {
        Texture texture = region.texture;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.idx == this.buffer.capacity()) {
            this.flush();
        }
        this.idx += 24;
        this.constructVertices(this.tmpVertices, 0, region, x, y, originX, originY, width, height, rotation);
        this.buffer.put(this.tmpVertices);
    }

    protected final void constructVertices(float[] vertices, int idx, TextureRegion region, float x, float y, float originX, float originY, float width, float height, float rotation) {
        float u = region.u;
        float v = region.v2;
        float u2 = region.u2;
        float v2 = region.v;
        float color = this.colorPacked;
        float mixColor = this.mixColorPacked;
        if (!Mathf.zero(rotation)) {
            float worldOriginX = x + originX;
            float worldOriginY = y + originY;
            float fx = -originX;
            float fy = -originY;
            float fx2 = width - originX;
            float fy2 = height - originY;
            float cos = Mathf.cosDeg(rotation);
            float sin = Mathf.sinDeg(rotation);
            float x1 = cos * fx - sin * fy + worldOriginX;
            float y1 = sin * fx + cos * fy + worldOriginY;
            float x2 = cos * fx - sin * fy2 + worldOriginX;
            float y2 = sin * fx + cos * fy2 + worldOriginY;
            float x3 = cos * fx2 - sin * fy2 + worldOriginX;
            float y3 = sin * fx2 + cos * fy2 + worldOriginY;
            float x4 = x1 + (x3 - x2);
            float y4 = y3 - (y2 - y1);
            vertices[idx] = x1;
            vertices[idx + 1] = y1;
            vertices[idx + 2] = color;
            vertices[idx + 3] = u;
            vertices[idx + 4] = v;
            vertices[idx + 5] = mixColor;
            vertices[idx + 6] = x2;
            vertices[idx + 7] = y2;
            vertices[idx + 8] = color;
            vertices[idx + 9] = u;
            vertices[idx + 10] = v2;
            vertices[idx + 11] = mixColor;
            vertices[idx + 12] = x3;
            vertices[idx + 13] = y3;
            vertices[idx + 14] = color;
            vertices[idx + 15] = u2;
            vertices[idx + 16] = v2;
            vertices[idx + 17] = mixColor;
            vertices[idx + 18] = x4;
            vertices[idx + 19] = y4;
            vertices[idx + 20] = color;
            vertices[idx + 21] = u2;
            vertices[idx + 22] = v;
            vertices[idx + 23] = mixColor;
        } else {
            float fx2 = x + width;
            float fy2 = y + height;
            vertices[idx] = x;
            vertices[idx + 1] = y;
            vertices[idx + 2] = color;
            vertices[idx + 3] = u;
            vertices[idx + 4] = v;
            vertices[idx + 5] = mixColor;
            vertices[idx + 6] = x;
            vertices[idx + 7] = fy2;
            vertices[idx + 8] = color;
            vertices[idx + 9] = u;
            vertices[idx + 10] = v2;
            vertices[idx + 11] = mixColor;
            vertices[idx + 12] = fx2;
            vertices[idx + 13] = fy2;
            vertices[idx + 14] = color;
            vertices[idx + 15] = u2;
            vertices[idx + 16] = v2;
            vertices[idx + 17] = mixColor;
            vertices[idx + 18] = fx2;
            vertices[idx + 19] = y;
            vertices[idx + 20] = color;
            vertices[idx + 21] = u2;
            vertices[idx + 22] = v;
            vertices[idx + 23] = mixColor;
        }
    }

    public static Shader createShader() {
        return new Shader("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nattribute vec4 a_mix_color;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec4 v_mix_color;\nvarying vec2 v_texCoords;\n\nvoid main(){\n   v_color = a_color;\n   v_color.a = v_color.a * (255.0/254.0);\n   v_mix_color = a_mix_color;\n   v_mix_color.a *= (255.0/254.0);\n   v_texCoords = a_texCoord0;\n   gl_Position = u_projTrans * a_position;\n}", "\nvarying lowp vec4 v_color;\nvarying lowp vec4 v_mix_color;\nvarying highp vec2 v_texCoords;\nuniform highp sampler2D u_texture;\n\nvoid main(){\n  vec4 c = texture2D(u_texture, v_texCoords);\n  gl_FragColor = v_color * mix(c, vec4(v_mix_color.rgb, c.a), v_mix_color.a);\n}");
    }

    protected void sortRequests() {
        if (this.multithreaded) {
            this.sortRequestsThreaded();
        } else {
            this.sortRequestsStandard();
        }
    }

    protected void sortRequestsThreaded() {
        int numRequests = this.numRequests;
        int[] itemZ = this.requestZ;
        int[] contiguous = this.contiguous;
        int ci = 0;
        int cl = contiguous.length;
        int z = itemZ[0];
        int startI = 0;
        for (int i = 1; i < numRequests; ++i) {
            if (itemZ[i] == z) continue;
            contiguous[ci] = z;
            contiguous[ci + 1] = startI;
            contiguous[ci + 2] = i - startI;
            if ((ci += 3) + 3 > cl) {
                contiguous = Arrays.copyOf(contiguous, cl <<= 1);
            }
            startI = i;
            z = itemZ[startI];
        }
        contiguous[ci] = z;
        contiguous[ci + 1] = startI;
        contiguous[ci + 2] = numRequests - startI;
        this.contiguous = contiguous;
        int L = ci / 3 + 1;
        if (this.contiguousCopy.length < contiguous.length) {
            this.contiguousCopy = new int[contiguous.length];
        }
        int[] sorted = CountingSort.countingSortMapMT(contiguous, this.contiguousCopy, L);
        int[] locs = contiguous;
        locs[0] = 0;
        int ptr = 0;
        for (int i = 0; i < L; ++i) {
            locs[i + 1] = ptr += sorted[i * 3 + 2];
        }
        if (this.copy.length < this.requests.length) {
            this.copy = new DrawRequest[this.requests.length];
        }
        PopulateTask.tasks = sorted;
        PopulateTask.src = this.requests;
        PopulateTask.dest = this.copy;
        PopulateTask.locs = locs;
        SpriteBatch.commonPool.pool.invoke(new PopulateTask(0, L));
    }

    protected void sortRequestsStandard() {
        int numRequests = this.numRequests;
        int[] itemZ = this.requestZ;
        int[] contiguous = this.contiguous;
        int ci = 0;
        int cl = contiguous.length;
        int z = itemZ[0];
        int startI = 0;
        for (int i = 1; i < numRequests; ++i) {
            if (itemZ[i] == z) continue;
            contiguous[ci] = z;
            contiguous[ci + 1] = startI;
            contiguous[ci + 2] = i - startI;
            if ((ci += 3) + 3 > cl) {
                contiguous = Arrays.copyOf(contiguous, cl <<= 1);
            }
            startI = i;
            z = itemZ[startI];
        }
        contiguous[ci] = z;
        contiguous[ci + 1] = startI;
        contiguous[ci + 2] = numRequests - startI;
        this.contiguous = contiguous;
        int L = ci / 3 + 1;
        if (this.contiguousCopy.length < contiguous.length) {
            this.contiguousCopy = new int[contiguous.length];
        }
        int[] sorted = CountingSort.countingSortMap(contiguous, this.contiguousCopy, L);
        if (this.copy.length < numRequests) {
            this.copy = new DrawRequest[numRequests + (numRequests >> 3)];
        }
        int ptr = 0;
        DrawRequest[] items = this.requests;
        DrawRequest[] dest = this.copy;
        for (int i = 0; i < L * 3; i += 3) {
            int pos = sorted[i + 1];
            int length = sorted[i + 2];
            if (length < 10) {
                int end = pos + length;
                int sj = pos;
                int dj = ptr;
                while (sj < end) {
                    dest[dj] = items[sj];
                    ++sj;
                    ++dj;
                }
            } else {
                System.arraycopy(items, pos, dest, ptr, Math.min(length, dest.length - ptr));
            }
            ptr += length;
        }
    }

    protected static class DrawRequest {
        int verticesOffset;
        int verticesLength;
        Texture texture;
        Blending blending;
        Runnable run;

        protected DrawRequest() {
        }
    }

    static class CountingSort {
        private static final int processors;
        static int[] locs;
        static final int[][] locses;
        static final IntIntMap[] countses;
        private static Point2[] entries;
        private static int[] entries3;
        private static int[] entries3a;
        private static Integer[] entriesBacking;
        private static final CountingSortTask[] tasks;
        private static final CountingSortTask2[] task2s;
        private static final Future<?>[] futures;

        CountingSort() {
        }

        static int[] countingSortMapMT(int[] arr, int[] swap, int end) {
            int i2;
            IntIntMap[] countses = CountingSort.countses;
            int[][] locs = locses;
            int threads = Math.min(processors, (end + 4095) / 4096);
            int thread_size = end / threads + 1;
            CountingSortTask[] tasks = CountingSort.tasks;
            CountingSortTask2[] task2s = CountingSort.task2s;
            Future<?>[] futures = CountingSort.futures;
            CountingSortTask2.src = arr;
            CountingSortTask.arr = arr;
            CountingSortTask2.dest = swap;
            int s = 0;
            int thread = 0;
            while (thread < threads) {
                CountingSortTask task = tasks[thread];
                int stop = Math.min(s + thread_size, end);
                task.set(s, stop, thread);
                task2s[thread].set(s, stop, thread);
                futures[thread] = SpriteBatch.commonPool.pool.submit(task);
                ++thread;
                s += thread_size;
            }
            int unique = 0;
            for (int i3 = 0; i3 < threads; ++i3) {
                try {
                    futures[i3].get();
                }
                catch (InterruptedException | ExecutionException e) {
                    SpriteBatch.commonPool.pool.execute(tasks[i3]);
                }
                unique += countses[i3].size;
            }
            int L = unique;
            if (entriesBacking.length < L) {
                entriesBacking = new Integer[L * 3 / 2];
                entries3 = new int[L * 3 * 3 / 2];
                entries3a = new int[L * 3 * 3 / 2];
            }
            int[] entries = entries3;
            int[] entries3a = CountingSort.entries3a;
            Integer[] entriesBacking = CountingSort.entriesBacking;
            int j = 0;
            for (i2 = 0; i2 < threads; ++i2) {
                if (countses[i2].size == 0) continue;
                IntIntMap.Entries countEntries = countses[i2].entries();
                IntIntMap.Entry entry = countEntries.next();
                entries[j] = entry.key;
                entries[j + 1] = entry.value;
                entries[j + 2] = i2;
                j += 3;
                while (countEntries.hasNext) {
                    countEntries.next();
                    entries[j] = entry.key;
                    entries[j + 1] = entry.value;
                    entries[j + 2] = i2;
                    j += 3;
                }
            }
            for (i2 = 0; i2 < L; ++i2) {
                entriesBacking[i2] = i2;
            }
            Arrays.sort(entriesBacking, 0, L, Structs.comparingInt(i -> entries[i * 3]));
            for (i2 = 0; i2 < L; ++i2) {
                int from = entriesBacking[i2] * 3;
                int to = i2 * 3;
                entries3a[to] = entries[from];
                entries3a[to + 1] = entries[from + 1];
                entries3a[to + 2] = entries[from + 2];
            }
            int pos = 0;
            for (i2 = 0; i2 < L * 3; i2 += 3) {
                int[] nArray = locs[entries3a[i2 + 2]];
                int n = entries3a[i2 + 1];
                int n2 = nArray[n] + pos;
                nArray[n] = n2;
                pos = n2;
            }
            for (int thread2 = 0; thread2 < threads; ++thread2) {
                futures[thread2] = SpriteBatch.commonPool.pool.submit(task2s[thread2]);
            }
            for (i2 = 0; i2 < threads; ++i2) {
                try {
                    futures[i2].get();
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    SpriteBatch.commonPool.pool.execute(task2s[i2]);
                }
            }
            return swap;
        }

        static int[] countingSortMap(int[] arr, int[] swap, int end) {
            int i;
            int[] locs = CountingSort.locs;
            IntIntMap counts = countses[0];
            counts.clear();
            int unique = 0;
            int end3 = end * 3;
            for (int i2 = 0; i2 < end3; i2 += 3) {
                int loc;
                arr[i2] = loc = counts.getOrPut(arr[i2], unique);
                if (loc == unique) {
                    if (unique >= locs.length) {
                        locs = Arrays.copyOf(locs, unique * 3 / 2);
                    }
                    locs[unique++] = 1;
                    continue;
                }
                int n = loc;
                locs[n] = locs[n] + 1;
            }
            CountingSort.locs = locs;
            if (entries.length < unique) {
                int prevLength = entries.length;
                Point2[] entries = CountingSort.entries = Arrays.copyOf(CountingSort.entries, unique * 3 / 2);
                for (int i3 = prevLength; i3 < entries.length; ++i3) {
                    entries[i3] = new Point2();
                }
            }
            Point2[] entries = CountingSort.entries;
            IntIntMap.Entries countEntries = counts.entries();
            IntIntMap.Entry entry = countEntries.next();
            entries[0].set(entry.key, entry.value);
            int j = 1;
            while (countEntries.hasNext) {
                countEntries.next();
                entries[j++].set(entry.key, entry.value);
            }
            Arrays.sort(entries, 0, unique, Structs.comparingInt(p -> p.x));
            int prev = entries[0].y;
            for (i = 1; i < unique; ++i) {
                int next = entries[i].y;
                locs[next] = locs[next] + locs[prev];
                prev = next;
            }
            i = end - 1;
            int i3 = i * 3;
            while (i >= 0) {
                int n = arr[i3];
                int n2 = locs[n] - 1;
                locs[n] = n2;
                int destPos = n2 * 3;
                swap[destPos] = arr[i3];
                swap[destPos + 1] = arr[i3 + 1];
                swap[destPos + 2] = arr[i3 + 2];
                --i;
                i3 -= 3;
            }
            return swap;
        }

        static {
            int i;
            processors = Runtime.getRuntime().availableProcessors() * 8;
            locs = new int[100];
            locses = new int[processors][100];
            countses = new IntIntMap[processors];
            entries = new Point2[100];
            entries3 = new int[300];
            entries3a = new int[300];
            entriesBacking = new Integer[100];
            tasks = new CountingSortTask[processors];
            task2s = new CountingSortTask2[processors];
            futures = new Future[processors];
            for (i = 0; i < countses.length; ++i) {
                CountingSort.countses[i] = new IntIntMap();
            }
            for (i = 0; i < entries.length; ++i) {
                CountingSort.entries[i] = new Point2();
            }
            for (i = 0; i < processors; ++i) {
                CountingSort.tasks[i] = new CountingSortTask();
                CountingSort.task2s[i] = new CountingSortTask2();
            }
        }

        static class CountingSortTask
        implements Runnable {
            static int[] arr;
            int start;
            int end;
            int id;

            CountingSortTask() {
            }

            public void set(int start, int end, int id) {
                this.start = start;
                this.end = end;
                this.id = id;
            }

            @Override
            public void run() {
                int id = this.id;
                int start = this.start;
                int end = this.end;
                int[] locs = locses[id];
                int[] arr = CountingSortTask.arr;
                IntIntMap counts = countses[id];
                counts.clear();
                int unique = 0;
                for (int i = start; i < end; ++i) {
                    int loc;
                    arr[i * 3] = loc = counts.getOrPut(arr[i * 3], unique);
                    if (loc == unique) {
                        if (unique >= locs.length) {
                            locs = Arrays.copyOf(locs, unique * 3 / 2);
                        }
                        locs[unique++] = 1;
                        continue;
                    }
                    int n = loc;
                    locs[n] = locs[n] + 1;
                }
                CountingSort.locses[id] = locs;
            }
        }

        static class CountingSortTask2
        implements Runnable {
            static int[] src;
            static int[] dest;
            int start;
            int end;
            int id;

            CountingSortTask2() {
            }

            public void set(int start, int end, int id) {
                this.start = start;
                this.end = end;
                this.id = id;
            }

            @Override
            public void run() {
                int start = this.start;
                int end = this.end;
                int[] locs = locses[this.id];
                int[] src = CountingSortTask2.src;
                int[] dest = CountingSortTask2.dest;
                int i = end - 1;
                int i3 = i * 3;
                while (i >= start) {
                    int n = src[i3];
                    int n2 = locs[n] - 1;
                    locs[n] = n2;
                    int destPos = n2 * 3;
                    dest[destPos] = src[i3];
                    dest[destPos + 1] = src[i3 + 1];
                    dest[destPos + 2] = src[i3 + 2];
                    --i;
                    i3 -= 3;
                }
            }
        }
    }

    static class PopulateTask
    extends RecursiveAction {
        int from;
        int to;
        static int[] tasks;
        static DrawRequest[] src;
        static DrawRequest[] dest;
        static int[] locs;

        PopulateTask(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public PopulateTask() {
        }

        @Override
        protected void compute() {
            int[] locs = PopulateTask.locs;
            if (this.to - this.from > 1 && locs[this.to] - locs[this.from] > 2048) {
                int half = locs[this.to] + locs[this.from] >> 1;
                int mid = Arrays.binarySearch(locs, this.from, this.to, half);
                if (mid < 0) {
                    mid = -mid - 1;
                }
                if (mid != this.from && mid != this.to) {
                    PopulateTask.invokeAll(new PopulateTask(this.from, mid), new PopulateTask(mid, this.to));
                    return;
                }
            }
            DrawRequest[] src = PopulateTask.src;
            DrawRequest[] dest = PopulateTask.dest;
            int[] tasks = PopulateTask.tasks;
            for (int i = this.from; i < this.to; ++i) {
                int point = i * 3;
                int pos = tasks[point + 1];
                int length = tasks[point + 2];
                if (length < 10) {
                    int end = pos + length;
                    int sj = pos;
                    int dj = locs[i];
                    while (sj < end) {
                        dest[dj] = src[sj];
                        ++sj;
                        ++dj;
                    }
                    continue;
                }
                System.arraycopy(src, pos, dest, locs[i], Math.min(length, dest.length - locs[i]));
            }
        }
    }
}

