/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.content.Fx;
import mindustry.content.Liquids;
import mindustry.entities.Effect;
import mindustry.game.Team;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.production.Pump;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.Stat;

public class SolidPump
extends Pump {
    public Liquid result = Liquids.water;
    public Effect updateEffect = Fx.none;
    public float updateEffectChance = 0.02f;
    public float rotateSpeed = 1.0f;
    public float baseEfficiency = 1.0f;
    @Nullable
    public Attribute attribute;
    public TextureRegion rotatorRegion;

    public SolidPump(String name) {
        super(name);
        this.hasPower = true;
        this.envEnabled = 1;
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        this.drawPotentialLinks(x, y);
        if (this.attribute != null) {
            this.drawPlaceText(Core.bundle.format("bar.efficiency", Math.round(Math.max(this.sumAttribute(this.attribute, x, y) / (float)this.size / (float)this.size + this.percentSolid(x, y) * this.baseEfficiency, 0.0f) * 100.0f)), x, y, valid);
        }
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("efficiency", entity -> new Bar(() -> Core.bundle.formatFloat("bar.pumpspeed", entity.lastPump * 60.0f, 1), () -> Pal.ammo, () -> entity.warmup * entity.efficiency));
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.output);
        this.stats.add(Stat.output, this.result, 60.0f * this.pumpAmount, true);
        if (this.attribute != null) {
            this.stats.add(this.baseEfficiency > 1.0E-4f ? Stat.affinities : Stat.tiles, this.attribute, this.floating, 1.0f, this.baseEfficiency <= 0.001f);
        }
    }

    @Override
    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        float sum = tile.getLinkedTilesAs((Block)this, tempTiles).sumf(t -> this.canPump((Tile)t) ? this.baseEfficiency + (this.attribute != null ? t.floor().attributes.get(this.attribute) : 0.0f) : 0.0f);
        return sum > 1.0E-5f;
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    protected boolean canPump(Tile tile) {
        return tile != null && !tile.floor().isLiquid;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.rotatorRegion, this.topRegion};
    }

    public class SolidPumpBuild
    extends Pump.PumpBuild {
        public float warmup;
        public float pumpTime;
        public float boost;
        public float validTiles;
        public float lastPump;

        @Override
        public void drawCracks() {
        }

        @Override
        public void pickedUp() {
            this.validTiles = 0.0f;
            this.boost = 0.0f;
        }

        @Override
        public void draw() {
            Draw.rect(SolidPump.this.region, this.x, this.y);
            Draw.z(30.1f);
            super.drawCracks();
            Draw.z(30.2f);
            Drawf.liquid(SolidPump.this.liquidRegion, this.x, this.y, this.liquids.get(SolidPump.this.result) / SolidPump.this.liquidCapacity, SolidPump.this.result.color);
            Drawf.spinSprite(SolidPump.this.rotatorRegion, this.x, this.y, this.pumpTime * SolidPump.this.rotateSpeed);
            Draw.rect(SolidPump.this.topRegion, this.x, this.y);
        }

        @Override
        public boolean shouldConsume() {
            return this.liquids.get(SolidPump.this.result) < SolidPump.this.liquidCapacity - 0.01f;
        }

        @Override
        public void updateTile() {
            this.liquidDrop = SolidPump.this.result;
            float fraction = Math.max(this.validTiles + this.boost + (SolidPump.this.attribute == null ? 0.0f : SolidPump.this.attribute.env()), 0.0f);
            if (this.efficiency > 0.0f && this.typeLiquid() < SolidPump.this.liquidCapacity - 0.001f) {
                float maxPump = Math.min(SolidPump.this.liquidCapacity - this.typeLiquid(), SolidPump.this.pumpAmount * this.delta() * fraction * this.efficiency);
                this.liquids.add(SolidPump.this.result, maxPump);
                this.lastPump = maxPump / Time.delta;
                this.warmup = Mathf.lerpDelta(this.warmup, 1.0f, 0.02f);
                if (Mathf.chance(this.delta() * SolidPump.this.updateEffectChance)) {
                    SolidPump.this.updateEffect.at(this.x + Mathf.range((float)SolidPump.this.size * 2.0f), this.y + Mathf.range((float)SolidPump.this.size * 2.0f));
                }
            } else {
                this.warmup = Mathf.lerpDelta(this.warmup, 0.0f, 0.02f);
                this.lastPump = 0.0f;
            }
            this.pumpTime += this.warmup * this.edelta();
            this.dumpLiquid(SolidPump.this.result);
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityAdded();
            this.boost = SolidPump.this.sumAttribute(SolidPump.this.attribute, this.tile.x, this.tile.y) / (float)SolidPump.this.size / (float)SolidPump.this.size;
            this.validTiles = 0.0f;
            for (Tile other : this.tile.getLinkedTiles(tempTiles)) {
                if (!SolidPump.this.canPump(other)) continue;
                this.validTiles += SolidPump.this.baseEfficiency / (float)(SolidPump.this.size * SolidPump.this.size);
            }
        }

        public float typeLiquid() {
            return this.liquids.get(SolidPump.this.result);
        }
    }
}

