/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.planet;

import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Geometry;
import arc.math.geom.Vec3;
import arc.util.Nullable;
import arc.util.noise.Ridged;
import arc.util.noise.Simplex;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Loadouts;
import mindustry.game.Schematics;
import mindustry.game.Waves;
import mindustry.graphics.g3d.PlanetParams;
import mindustry.maps.generators.BlankPlanetGenerator;
import mindustry.type.Sector;
import mindustry.world.blocks.environment.Floor;

public class AsteroidGenerator
extends BlankPlanetGenerator {
    public int min = 20;
    public int max = 30;
    public int octaves = 2;
    public int foct = 3;
    public float radMin = 12.0f;
    public float radMax = 60.0f;
    public float persistence = 0.4f;
    public float scale = 30.0f;
    public float mag = 0.46f;
    public float thresh = 1.0f;
    public float fmag = 0.5f;
    public float fscl = 50.0f;
    public float fper = 0.6f;
    public float stoneChance = 0.0f;
    public float iceChance = 0.0f;
    public float carbonChance = 0.0f;
    public float berylChance = 0.0f;
    public float ferricChance = 1.0f;
    public float thoriumScl = 1.0f;
    public float copperScale = 1.0f;
    public float leadScale = 1.0f;
    public float graphiteScale = 1.0f;
    public float berylliumScale = 1.0f;
    @Nullable
    Rand rand;
    int seed;

    public AsteroidGenerator() {
        this.defaultLoadout = Loadouts.basicNucleus;
    }

    void asteroid(int ax, int ay, int radius) {
        Floor floor = (this.rand.chance(this.iceChance) ? Blocks.ice : (this.rand.chance(this.carbonChance) ? Blocks.carbonStone : (this.rand.chance(this.berylChance) ? Blocks.beryllicStone : (this.rand.chance(this.ferricChance) ? Blocks.ferricStone : Blocks.stone)))).asFloor();
        for (int x = ax - radius; x <= ax + radius; ++x) {
            for (int y = ay - radius; y <= ay + radius; ++y) {
                if (!this.tiles.in(x, y) || !(Mathf.dst(x, y, ax, ay) / (float)radius + Simplex.noise2d(this.seed, this.octaves, this.persistence, 1.0f / this.scale, x, y) * this.mag < this.thresh)) continue;
                this.tiles.getn(x, y).setFloor(floor);
            }
        }
    }

    @Override
    public void generate() {
        this.seed = Vars.state.rules.sector.planet.id;
        int sx = this.width / 2;
        int sy = this.height / 2;
        this.rand = new Rand(this.seed);
        Floor background = Blocks.empty.asFloor();
        this.tiles.eachTile(t -> t.setFloor(background));
        this.asteroid(sx, sy, this.rand.random(30, 50));
        int amount = this.rand.random(this.min, this.max);
        for (int i = 0; i < amount; ++i) {
            float radius = this.rand.random(this.radMin, this.radMax);
            float ax = this.rand.random(radius, (float)this.width - radius);
            float ay = this.rand.random(radius, (float)this.height - radius);
            this.asteroid((int)ax, (int)ay, (int)radius);
        }
        int smalls = this.rand.random(this.min, this.max) * 3;
        for (int i = 0; i < smalls; ++i) {
            float radius = this.rand.random(1, 8);
            float ax = this.rand.random(radius, (float)this.width - radius);
            float ay = this.rand.random(radius, (float)this.height - radius);
            this.asteroid((int)ax, (int)ay, (int)radius);
        }
        this.pass((x, y) -> {
            if (this.floor != background && Ridged.noise2d(this.seed, x, y, this.foct, this.fper, 1.0f / this.fscl) - Ridged.noise2d(this.seed, x, y, 1, 1.0, 5.0) / 2.7f > this.fmag) {
                this.floor = Blocks.stone;
            }
        });
        this.pass((x, y) -> {
            if (this.floor == background || Ridged.noise2d(this.seed + 1, x, y, 4, 0.7f, 0.01666666753590107) > 0.45f || Mathf.within(x, y, sx, sy, 20.0f + Ridged.noise2d(this.seed, x, y, 3, 0.5, 0.03333333507180214) * 6.0f)) {
                return;
            }
            int radius = 6;
            for (int dx = x - radius; dx <= x + radius; ++dx) {
                for (int dy = y - radius; dy <= y + radius; ++dy) {
                    if (!Mathf.within(dx, dy, x, y, (float)radius + 1.0E-4f) || !this.tiles.in(dx, dy) || this.tiles.getn(dx, dy).floor() != background) continue;
                    return;
                }
            }
            this.block = this.floor.asFloor().wall;
        });
        this.pass((x, y) -> {
            if (this.floor == Blocks.ferricStone && this.rand.chance(0.02)) {
                this.floor = Blocks.ferricCraters;
            }
            if (this.floor == Blocks.stone && this.rand.chance(0.02)) {
                this.floor = Blocks.craters;
            }
        });
        this.decoration(0.017f);
        this.oreAround(Blocks.oreLead, Blocks.stoneWall, 3, 70.0f, 0.6f * this.leadScale);
        this.ore(Blocks.oreCopper, Blocks.ferricStone, 5.0f, 0.8f * this.copperScale);
        this.ore(Blocks.oreThorium, Blocks.beryllicStone, 4.0f, 0.9f * this.thoriumScl);
        this.ore(Blocks.oreThorium, Blocks.carbonStone, 4.0f, 0.9f * this.thoriumScl);
        this.wallOre(Blocks.carbonWall, Blocks.graphiticWall, 35.0f, 0.57f * this.graphiteScale);
        this.wallOre(Blocks.beryllicStoneWall, Blocks.wallOreBeryllium, 50.0f, 0.62f * this.berylliumScale);
        this.pass((x, y) -> {
            if (this.floor != Blocks.stone) {
                return;
            }
            int i = 4;
            if (Math.abs(0.5f - this.noise(x, (float)(y + i * 999) - (float)x * 1.5f, 2.0, 0.65, 60 + i * 2)) > 0.26f) {
                this.ore = Blocks.oreTitanium;
            }
        });
        int spawnSide = this.rand.random(3);
        int sizeOffset = this.width / 2 - 1;
        this.tiles.getn(sizeOffset * Geometry.d8edge[spawnSide].x + this.width / 2, sizeOffset * Geometry.d8edge[spawnSide].y + this.height / 2).setOverlay(Blocks.spawn);
        Schematics.placeLaunchLoadout(sx, sy);
        Vars.state.rules.planetBackground = new PlanetParams(){
            {
                this.planet = ((AsteroidGenerator)AsteroidGenerator.this).sector.planet;
                this.zoom = 1.0f;
                this.camPos = new Vec3(1.2388899f, 1.6047299f, 2.4758825f);
            }
        };
        Vars.state.rules.dragMultiplier = 0.7f;
        Vars.state.rules.borderDarkness = false;
        Vars.state.rules.waves = true;
        Vars.state.rules.showSpawns = true;
        Vars.state.rules.spawns = Waves.generate(0.5f, this.rand, false, true, false);
    }

    @Override
    public int getSectorSize(Sector sector) {
        return 500;
    }
}

