/*
 * Decompiled with CFR 0.152.
 */
package arc.net.dns;

import arc.files.Fi;
import arc.net.dns.NameserverProvider;
import arc.struct.Seq;
import arc.util.OS;
import java.io.BufferedReader;
import java.net.InetSocketAddress;
import java.util.StringTokenizer;

public final class ResolvConfNameserverProvider
implements NameserverProvider {
    @Override
    public Seq<InetSocketAddress> getNameservers() {
        Seq<InetSocketAddress> out = new Seq<InetSocketAddress>();
        if (!this.tryParseResolveConf("/etc/resolv.conf", out)) {
            this.tryParseResolveConf("sys:/etc/resolv.cfg", out);
        }
        return out;
    }

    private boolean tryParseResolveConf(String path, Seq<InetSocketAddress> out) {
        Fi conf = new Fi(path);
        if (conf.exists()) {
            boolean bl;
            block10: {
                BufferedReader reader = conf.reader(1024);
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        StringTokenizer tokenizer = new StringTokenizer(line);
                        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equals("nameserver")) continue;
                        out.add(new InetSocketAddress(tokenizer.nextToken(), 53));
                    }
                    bl = true;
                    if (reader == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                reader.close();
            }
            return bl;
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        return !OS.isWindows && !OS.isAndroid;
    }
}

