/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.Eachable;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.draw.DrawBlock;

public class DrawLiquidOutputs
extends DrawBlock {
    public TextureRegion[][] liquidOutputRegions;

    @Override
    public void draw(Building build) {
        GenericCrafter crafter = (GenericCrafter)build.block;
        if (crafter.outputLiquids == null) {
            return;
        }
        for (int i = 0; i < crafter.outputLiquids.length; ++i) {
            int side;
            int n = side = i < crafter.liquidOutputDirections.length ? crafter.liquidOutputDirections[i] : -1;
            if (side == -1) continue;
            int realRot = (side + build.rotation) % 4;
            Draw.rect(this.liquidOutputRegions[realRot > 1 ? 1 : 0][i], build.x, build.y, (float)(realRot * 90));
        }
    }

    @Override
    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        GenericCrafter crafter = (GenericCrafter)block;
        if (crafter.outputLiquids == null) {
            return;
        }
        for (int i = 0; i < crafter.outputLiquids.length; ++i) {
            int side;
            int n = side = i < crafter.liquidOutputDirections.length ? crafter.liquidOutputDirections[i] : -1;
            if (side == -1) continue;
            int realRot = (side + plan.rotation) % 4;
            Draw.rect(this.liquidOutputRegions[realRot > 1 ? 1 : 0][i], plan.drawx(), plan.drawy(), (float)(realRot * 90));
        }
    }

    @Override
    public void load(Block block) {
        GenericCrafter crafter = this.expectCrafter(block);
        if (crafter.outputLiquids == null) {
            return;
        }
        this.liquidOutputRegions = new TextureRegion[2][crafter.outputLiquids.length];
        for (int i = 0; i < crafter.outputLiquids.length; ++i) {
            for (int j = 1; j <= 2; ++j) {
                this.liquidOutputRegions[j - 1][i] = Core.atlas.find(block.name + "-" + crafter.outputLiquids[i].liquid.name + "-output" + j);
            }
        }
    }
}

