/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.Events;
import arc.func.Prov;
import arc.graphics.Color;
import arc.input.KeyBind;
import arc.input.KeyCode;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.event.ClickListener;
import arc.scene.event.HandCursorListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.struct.Bits;
import arc.struct.ObjectFloatMap;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.ai.UnitStance;
import mindustry.ai.types.CommandAI;
import mindustry.content.Blocks;
import mindustry.core.UI;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.entities.units.UnitController;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.input.InputHandler;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;
import mindustry.ui.Displayable;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.StatValues;

public class PlacementFragment {
    final int rowWidth = 4;
    public Category currentCategory = Category.distribution;
    Seq<Block> returnArray = new Seq();
    Seq<Block> returnArray2 = new Seq();
    Seq<Category> returnCatArray = new Seq();
    boolean[] categoryEmpty = new boolean[Category.all.length];
    ObjectMap<Category, Block> selectedBlocks = new ObjectMap();
    ObjectFloatMap<Category> scrollPositions = new ObjectFloatMap();
    @Nullable
    Block menuHoverBlock;
    @Nullable
    Displayable hover;
    @Nullable
    Building lastFlowBuild;
    @Nullable
    Building nextFlowBuild;
    @Nullable
    Object lastDisplayState;
    @Nullable
    Team lastTeam;
    boolean wasHovered;
    Table blockTable;
    Table toggler;
    Table topTable;
    Table blockCatTable;
    Table commandTable;
    Stack mainStack;
    ScrollPane blockPane;
    Runnable rebuildCommand;
    boolean blockSelectEnd;
    boolean wasCommandMode;
    int blockSelectSeq;
    long blockSelectSeqMillis;
    KeyBind[] blockSelect = new KeyBind[]{Binding.blockSelect01, Binding.blockSelect02, Binding.blockSelect03, Binding.blockSelect04, Binding.blockSelect05, Binding.blockSelect06, Binding.blockSelect07, Binding.blockSelect08, Binding.blockSelect09, Binding.blockSelect10, Binding.blockSelectLeft, Binding.blockSelectRight, Binding.blockSelectUp, Binding.blockSelectDown};

    public PlacementFragment() {
        Events.on(EventType.WorldLoadEvent.class, event -> Core.app.post(() -> {
            this.currentCategory = Category.distribution;
            Vars.control.input.block = null;
            this.rebuild();
        }));
        Events.run((Object)EventType.Trigger.unitCommandChange, () -> {
            if (this.rebuildCommand != null) {
                this.rebuildCommand.run();
            }
        });
        Events.on(EventType.UnlockEvent.class, event -> {
            if (event.content instanceof Block) {
                this.rebuild();
            }
        });
        Events.on(EventType.ResetEvent.class, event -> this.selectedBlocks.clear());
        Events.run((Object)EventType.Trigger.update, () -> {
            if (this.lastFlowBuild != null && this.lastFlowBuild != this.nextFlowBuild) {
                if (this.lastFlowBuild.flowItems() != null) {
                    this.lastFlowBuild.flowItems().stopFlow();
                }
                if (this.lastFlowBuild.liquids != null) {
                    this.lastFlowBuild.liquids.stopFlow();
                }
            }
            this.lastFlowBuild = this.nextFlowBuild;
            if (this.nextFlowBuild != null) {
                if (this.nextFlowBuild.flowItems() != null) {
                    this.nextFlowBuild.flowItems().updateFlow();
                }
                if (this.nextFlowBuild.liquids != null) {
                    this.nextFlowBuild.liquids.updateFlow();
                }
            }
        });
    }

    public Displayable hover() {
        return this.hover;
    }

    public void rebuild() {
        Group group = this.toggler.parent;
        int index = this.toggler.getZIndex();
        this.toggler.remove();
        this.build(group);
        this.toggler.setZIndex(index);
    }

    boolean updatePick(InputHandler input) {
        Tile tile = Vars.world.tileWorld(Core.input.mouseWorldX(), Core.input.mouseWorldY());
        if (tile != null && Core.input.keyTap(Binding.pick) && Vars.player.isBuilder() && !Core.scene.hasDialog()) {
            Block block;
            Building build = tile.build;
            if (build != null && build.inFogTo(Vars.player.team())) {
                build = null;
            }
            if (build == null) {
                block = null;
            } else if (build instanceof ConstructBlock.ConstructBuild) {
                ConstructBlock.ConstructBuild c = (ConstructBlock.ConstructBuild)build;
                block = c.current;
            } else {
                block = build.block;
            }
            Block tryBlock = block;
            Object tryConfig = build == null || !build.block.copyConfig ? null : build.config();
            for (BuildPlan req : Vars.player.unit().plans()) {
                if (req.breaking || !req.block.bounds(req.x, req.y, Tmp.r1).contains(Core.input.mouseWorld())) continue;
                tryBlock = req.block;
                tryConfig = req.config;
                break;
            }
            if (tryBlock == null && Vars.state.rules.editor) {
                Block block2 = tile.block() != Blocks.air ? tile.block() : (tile.overlay() != Blocks.air ? tile.overlay() : (tryBlock = tile.floor() != Blocks.air ? tile.floor() : null));
            }
            if (tryBlock != null && build == null && tryConfig == null) {
                tryConfig = tryBlock.getConfig(tile);
            }
            if (tryBlock != null && (tryBlock.isVisible() && this.unlocked(tryBlock) || Vars.state.rules.editor)) {
                input.block = tryBlock;
                tryBlock.lastConfig = tryConfig;
                if (tryBlock.isVisible()) {
                    this.currentCategory = input.block.category;
                }
                tryBlock.onPicked(tile);
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean gridUpdate(InputHandler input) {
        int i;
        block27: {
            Block hovering;
            Block block;
            Building build;
            this.scrollPositions.put(this.currentCategory, this.blockPane.getScrollY());
            if (this.updatePick(input)) {
                return true;
            }
            if (Vars.ui.chatfrag.shown()) return false;
            if (Vars.ui.consolefrag.shown()) return false;
            if (Core.scene.hasKeyboard()) {
                return false;
            }
            for (i = 0; i < this.blockSelect.length; ++i) {
                if (!Core.input.keyTap(this.blockSelect[i])) continue;
                if (i <= 9) {
                    if (this.blockSelectEnd || Time.timeSinceMillis(this.blockSelectSeqMillis) > 400L) {
                        if (this.getUnlockedByCategory(Category.all[i]).isEmpty()) return true;
                        this.currentCategory = Category.all[i];
                        if (input.block != null) {
                            input.block = this.getSelectedBlock(this.currentCategory);
                        }
                        this.blockSelectEnd = false;
                        this.blockSelectSeq = 0;
                        this.blockSelectSeqMillis = Time.millis();
                        return true;
                    }
                    if (this.blockSelectSeq == 0) {
                        this.blockSelectSeq = i + 1;
                    } else {
                        i += (this.blockSelectSeq - (i != 9 ? 0 : 1)) * 10;
                        this.blockSelectEnd = true;
                    }
                    Seq<Block> blocks = this.getByCategory(this.currentCategory);
                    if (i >= blocks.size) return true;
                    if (!this.unlocked(blocks.get(i))) {
                        return true;
                    }
                    input.block = i < blocks.size ? blocks.get(i) : null;
                    this.selectedBlocks.put(this.currentCategory, input.block);
                    this.blockSelectSeqMillis = Time.millis();
                    return true;
                }
                break block27;
            }
            if (Core.input.keyTap(Binding.categoryPrev)) {
                i = 0;
                do {
                    this.currentCategory = this.currentCategory.prev();
                } while (this.categoryEmpty[this.currentCategory.ordinal()] && ++i < this.categoryEmpty.length);
                input.block = this.getSelectedBlock(this.currentCategory);
                return true;
            }
            if (Core.input.keyTap(Binding.categoryNext)) {
                i = 0;
                do {
                    this.currentCategory = this.currentCategory.next();
                } while (this.categoryEmpty[this.currentCategory.ordinal()] && ++i < this.categoryEmpty.length);
                input.block = this.getSelectedBlock(this.currentCategory);
                return true;
            }
            if (!Core.input.keyTap(Binding.blockInfo)) return false;
            Displayable blocks = this.hovered();
            if (blocks instanceof Unit) {
                Unit unit = (Unit)blocks;
                if (unit.type.unlockedNow()) {
                    Vars.ui.content.show(unit.type());
                    return false;
                }
            }
            if ((build = Vars.world.buildWorld(Core.input.mouseWorld().x, Core.input.mouseWorld().y)) == null) {
                block = null;
            } else if (build instanceof ConstructBlock.ConstructBuild) {
                ConstructBlock.ConstructBuild c = (ConstructBlock.ConstructBuild)build;
                block = c.current;
            } else {
                block = hovering = build.block;
            }
            Block displayBlock = this.menuHoverBlock != null ? this.menuHoverBlock : (input.block != null ? input.block : hovering);
            if (displayBlock == null) return false;
            if (!displayBlock.unlockedNow()) return false;
            Vars.ui.content.show(displayBlock);
            Events.fire(new EventType.BlockInfoEvent());
            return false;
        }
        Seq<Block> blocks = this.getUnlockedByCategory(this.currentCategory);
        Block currentBlock = this.getSelectedBlock(this.currentCategory);
        int j = 0;
        while (j < blocks.size) {
            if (blocks.get(j) == currentBlock) {
                switch (i) {
                    case 10: {
                        j = (j - 1 + blocks.size) % blocks.size;
                        break;
                    }
                    case 11: {
                        j = (j + 1) % blocks.size;
                        break;
                    }
                    case 12: {
                        j = j > 3 ? j - 4 : blocks.size - blocks.size % 4 + j;
                        j -= j < blocks.size ? 0 : 4;
                        break;
                    }
                    case 13: {
                        j = j < blocks.size - 4 ? j + 4 : j % 4;
                        break;
                    }
                }
                input.block = blocks.get(j);
                this.selectedBlocks.put(this.currentCategory, input.block);
                return true;
            }
            ++j;
        }
        return true;
    }

    public void build(Group parent) {
        parent.fill(full -> {
            this.toggler = full;
            full.bottom().right().visible(() -> Vars.ui.hudfrag.shown);
            full.table(frame -> {
                Runnable rebuildCategory = () -> {
                    this.blockTable.clear();
                    this.blockTable.top().margin(5.0f);
                    int index = 0;
                    ButtonGroup group = new ButtonGroup();
                    group.setMinCheckCount(0);
                    for (Block block : this.getUnlockedByCategory(this.currentCategory)) {
                        if (!this.unlocked(block)) continue;
                        if (index++ % 4 == 0) {
                            this.blockTable.row();
                        }
                        ImageButton button = this.blockTable.button((Drawable)new TextureRegionDrawable(block.uiIcon), Styles.selecti, () -> {
                            if (this.unlocked(block)) {
                                if ((Core.input.keyDown(KeyCode.shiftLeft) || Core.input.keyDown(KeyCode.controlLeft)) && Fonts.getUnicode(block.name) != 0) {
                                    Core.app.setClipboardText((char)Fonts.getUnicode(block.name) + "");
                                    Vars.ui.showInfoFade("@copied");
                                } else {
                                    Vars.control.input.block = Vars.control.input.block == block ? null : block;
                                    this.selectedBlocks.put(this.currentCategory, Vars.control.input.block);
                                }
                            }
                        }).size(46.0f).group(group).name("block-" + block.name).get();
                        button.resizeImage(32.0f);
                        button.update(() -> {
                            CoreBlock.CoreBuild core = Vars.player.core();
                            Color color = (Vars.state.rules.infiniteResources || core != null && (core.items.has(block.requirements, Vars.state.rules.buildCostMultiplier) || Vars.state.rules.infiniteResources)) && Vars.player.isBuilder() ? Color.white : Color.gray;
                            button.forEach(elem -> elem.setColor(color));
                            button.setChecked(Vars.control.input.block == block);
                            if (!block.isPlaceable()) {
                                button.forEach(elem -> elem.setColor(Color.darkGray));
                            }
                        });
                        button.hovered(() -> {
                            this.menuHoverBlock = block;
                        });
                        button.exited(() -> {
                            if (this.menuHoverBlock == block) {
                                this.menuHoverBlock = null;
                            }
                        });
                    }
                    if (index < 4) {
                        for (int i = 0; i < 4 - index; ++i) {
                            this.blockTable.add().size(46.0f);
                        }
                    }
                    this.blockTable.act(0.0f);
                    this.blockPane.setScrollYForce(this.scrollPositions.get(this.currentCategory, 0.0f));
                    Core.app.post(() -> {
                        this.blockPane.setScrollYForce(this.scrollPositions.get(this.currentCategory, 0.0f));
                        this.blockPane.act(0.0f);
                        this.blockPane.layout();
                    });
                };
                frame.table(Tex.buttonEdge2, top -> {
                    this.topTable = top;
                    top.add(new Table()).growX().update(topTable -> {
                        boolean isHovered;
                        Displayable hovered = this.hover;
                        Block displayBlock = this.menuHoverBlock != null ? this.menuHoverBlock : Vars.control.input.block;
                        Object displayState = displayBlock != null ? displayBlock : hovered;
                        boolean bl = isHovered = displayBlock == null;
                        if (this.wasHovered == isHovered && this.lastDisplayState == displayState && this.lastTeam == Vars.player.team()) {
                            return;
                        }
                        topTable.clear();
                        topTable.top().left().margin(5.0f);
                        this.lastDisplayState = displayState;
                        this.wasHovered = isHovered;
                        this.lastTeam = Vars.player.team();
                        if (displayBlock != null) {
                            topTable.table(header -> {
                                String keyCombo = "";
                                if (!Vars.mobile) {
                                    Seq<Block> blocks = this.getByCategory(this.currentCategory);
                                    for (int i = 0; i < blocks.size; ++i) {
                                        if (blocks.get(i) != displayBlock || (i + 1) / 10 - 1 >= this.blockSelect.length) continue;
                                        keyCombo = Core.bundle.format("placement.blockselectkeys", this.blockSelect[this.currentCategory.ordinal()].value.key.toString()) + (i < 10 ? "" : this.blockSelect[(i + 1) / 10 - 1].value.key.toString() + ",") + this.blockSelect[i % 10].value.key.toString() + "]";
                                        break;
                                    }
                                }
                                String keyComboFinal = keyCombo;
                                header.left();
                                header.add(new Image(displayBlock.uiIcon)).size(32.0f);
                                header.labelWrap(() -> !this.unlocked(displayBlock) ? Core.bundle.get("block.unknown") : displayBlock.localizedName + keyComboFinal).left().width(190.0f).padLeft(5.0f);
                                header.add().growX();
                                if (this.unlocked(displayBlock)) {
                                    header.button("?", Styles.flatBordert, () -> {
                                        Vars.ui.content.show(displayBlock);
                                        Events.fire(new EventType.BlockInfoEvent());
                                    }).size(40.0f).padTop(-5.0f).padRight(-5.0f).right().grow().name("blockinfo");
                                }
                            }).growX().left();
                            topTable.row();
                            topTable.table(req -> {
                                req.top().left();
                                for (ItemStack stack : displayBlock.requirements) {
                                    req.table(line -> {
                                        line.left();
                                        line.image(stack.item.uiIcon).size(16.0f);
                                        line.add(stack.item.localizedName).maxWidth(140.0f).fillX().color(Color.lightGray).padLeft(2.0f).left().get().setEllipsis(true);
                                        line.labelWrap(() -> {
                                            CoreBlock.CoreBuild core = Vars.player.core();
                                            int stackamount = Math.round((float)stack.amount * Vars.state.rules.buildCostMultiplier);
                                            if (core == null || Vars.state.rules.infiniteResources) {
                                                return "*/" + stackamount;
                                            }
                                            int amount = core.items.get(stack.item);
                                            String color = (float)amount < (float)stackamount / 2.0f ? "[scarlet]" : (amount < stackamount ? "[accent]" : "[white]");
                                            return color + UI.formatAmount(amount) + "[white]/" + stackamount;
                                        }).padLeft(5.0f);
                                    }).left();
                                    req.row();
                                }
                            }).growX().left().margin(3.0f);
                            if (!(displayBlock.isPlaceable() && Vars.player.isBuilder() || Vars.state.rules.editor)) {
                                topTable.row();
                                topTable.table(b -> {
                                    b.image(Icon.cancel).padRight(2.0f).color(Color.scarlet);
                                    b.add(!Vars.player.isBuilder() ? "@unit.nobuild" : (!displayBlock.supportsEnv(Vars.state.rules.env) ? "@unsupported.environment" : "@banned")).width(190.0f).wrap();
                                    b.left();
                                }).padTop(2.0f).left();
                            }
                        } else if (hovered != null) {
                            hovered.display((Table)topTable);
                        }
                    });
                }).colspan(3).fillX().visible(this::hasInfoBox).touchable(Touchable.enabled).row();
                frame.image().color(Pal.gray).colspan(3).height(4.0f).growX().row();
                this.blockCatTable = new Table();
                this.commandTable = new Table(Tex.pane2);
                this.mainStack = new Stack();
                this.mainStack.update(() -> {
                    if (Vars.control.input.commandMode != this.wasCommandMode) {
                        this.mainStack.clearChildren();
                        this.mainStack.addChild(Vars.control.input.commandMode ? this.commandTable : this.blockCatTable);
                        if (Vars.control.input.commandMode) {
                            this.commandTable.getCells().peek().width(this.blockCatTable.getWidth() / Scl.scl(1.0f));
                        }
                        this.wasCommandMode = Vars.control.input.commandMode;
                    }
                });
                frame.add(this.mainStack).colspan(3).fill();
                frame.row();
                frame.rect((x, y, w, h) -> {
                    if (Core.scene.marginBottom > 0.0f) {
                        Tex.paneLeft.draw(x, 0.0f, w, y);
                    }
                }).colspan(3).fillX().row();
                this.commandTable.touchable = Touchable.enabled;
                this.commandTable.add(Core.bundle.get("commandmode.name")).fill().center().labelAlign(1).row();
                this.commandTable.image().color(Pal.accent).growX().pad(20.0f).padTop(0.0f).padBottom(4.0f).row();
                this.commandTable.table(u -> {
                    Bits activeCommands = new Bits(Vars.content.unitCommands().size);
                    Bits activeStances = new Bits(Vars.content.unitStances().size);
                    Bits availableCommands = new Bits(Vars.content.unitCommands().size);
                    Bits availableStances = new Bits(Vars.content.unitStances().size);
                    u.left();
                    int[] curCount = new int[]{0};
                    Bits usedCommands = new Bits(Vars.content.unitCommands().size);
                    Seq commands = new Seq();
                    Bits usedStances = new Bits(Vars.content.unitStances().size);
                    Seq stances = new Seq();
                    Seq stancesOut = new Seq();
                    this.rebuildCommand = () -> {
                        u.clearChildren();
                        Seq<Unit> units = Vars.control.input.selectedUnits;
                        if (units.size > 0) {
                            usedCommands.clear();
                            usedStances.clear();
                            commands.clear();
                            stances.clear();
                            int[] counts = new int[Vars.content.units().size];
                            for (Unit unit : units) {
                                short s = unit.type.id;
                                counts[s] = counts[s] + 1;
                                stancesOut.clear();
                                unit.type.getUnitStances(unit, stancesOut);
                                for (UnitStance stance : stancesOut) {
                                    if (usedStances.get(stance.id)) continue;
                                    stances.add(stance);
                                    usedStances.set(stance.id);
                                }
                            }
                            Table unitlist = u.table().growX().left().get();
                            unitlist.left();
                            int col = 0;
                            for (int i = 0; i < counts.length; ++i) {
                                if (counts[i] <= 0) continue;
                                UnitType type = Vars.content.unit(i);
                                unitlist.add(StatValues.stack(type, counts[i])).pad(4.0f).with(b -> {
                                    b.clearListeners();
                                    b.addListener(Tooltip.Tooltips.getInstance().create(type.localizedName, false));
                                    ClickListener listener = new ClickListener();
                                    b.clicked(KeyCode.mouseLeft, () -> {
                                        Vars.control.input.selectedUnits.removeAll(unit -> unit.type != type);
                                        Events.fire(EventType.Trigger.unitCommandChange);
                                    });
                                    b.clicked(KeyCode.mouseRight, () -> {
                                        Vars.control.input.selectedUnits.removeAll(unit -> unit.type == type);
                                        Events.fire(EventType.Trigger.unitCommandChange);
                                    });
                                    b.addListener(listener);
                                    b.addListener(new HandCursorListener());
                                    b.update(() -> ((Element)((Group)b.getChildren().first()).getChildren().first()).setColor(listener.isOver() ? Color.lightGray : Color.white));
                                });
                                if (++col % 7 == 0) {
                                    unitlist.row();
                                }
                                for (UnitCommand command : type.commands) {
                                    if (usedCommands.get(command.id)) continue;
                                    commands.add(command);
                                    usedCommands.set(command.id);
                                }
                            }
                            if (commands.size > 1) {
                                u.row();
                                u.table(coms -> {
                                    coms.left();
                                    int scol = 0;
                                    for (UnitCommand command : commands) {
                                        coms.button((Drawable)Icon.icons.get(command.icon, Icon.cancel), Styles.clearNoneTogglei, () -> Call.setUnitCommand(Vars.player, units.mapInt(un -> un.id, un -> un.type.allowCommand((Unit)un, command)).toArray(), command)).checked(i -> activeCommands.get(command.id)).size(50.0f).tooltip(command.localized(), true);
                                        if (++scol % 6 != 0) continue;
                                        coms.row();
                                    }
                                }).fillX().padTop(4.0f).left();
                            }
                            if (stances.size > 1) {
                                u.row();
                                if (commands.size > 1) {
                                    u.add(new Image(Tex.whiteui)).height(3.0f).color(Pal.gray).pad(7.0f).growX().row();
                                }
                                u.table(coms -> {
                                    coms.left();
                                    int scol = 0;
                                    for (UnitStance stance : stances) {
                                        coms.button((Drawable)stance.getIcon(), Styles.clearNoneTogglei, () -> Call.setUnitStance(Vars.player, units.mapInt(un -> un.id, un -> un.type.allowStance((Unit)un, stance)).toArray(), stance, !activeStances.get(stance.id))).checked(i -> activeStances.get(stance.id)).size(50.0f).tooltip(stance.localized(), true);
                                        if (++scol % 6 != 0) continue;
                                        coms.row();
                                    }
                                }).fillX().padTop(4.0f).left();
                            }
                        } else {
                            u.add(Core.bundle.get("commandmode.nounits")).color(Color.lightGray).growX().center().labelAlign(1).pad(6.0f);
                        }
                    };
                    u.update(() -> {
                        activeCommands.clear();
                        activeStances.clear();
                        availableCommands.clear();
                        availableStances.clear();
                        for (Unit unit : Vars.control.input.selectedUnits) {
                            UnitController patt28849$temp = unit.controller();
                            if (patt28849$temp instanceof CommandAI) {
                                Iterator<UnitCommand> cmd = (CommandAI)patt28849$temp;
                                activeCommands.set(((CommandAI)((Object)cmd)).command.id);
                                activeStances.set(((CommandAI)((Object)cmd)).stances);
                            }
                            stancesOut.clear();
                            unit.type.getUnitStances(unit, stancesOut);
                            for (UnitStance stance : stancesOut) {
                                availableStances.set(stance.id);
                            }
                            for (UnitCommand command : unit.type.commands) {
                                availableCommands.set(command.id);
                            }
                        }
                        int size = Vars.control.input.selectedUnits.size;
                        if (curCount[0] != size || !usedCommands.equals(availableCommands) || !usedStances.equals(availableStances)) {
                            if (curCount[0] + size != 0) {
                                this.rebuildCommand.run();
                            }
                            curCount[0] = size;
                        }
                        for (UnitStance stance : stances) {
                            if (stance.keybind == null || !Core.input.keyTap(stance.keybind)) continue;
                            Call.setUnitStance(Vars.player, Vars.control.input.selectedUnits.mapInt(un -> un.id, un -> un.type.allowStance((Unit)un, stance)).toArray(), stance, !activeStances.get(stance.id));
                        }
                        for (UnitCommand command : commands) {
                            if (command.keybind == null || !Core.input.keyTap(command.keybind)) continue;
                            Call.setUnitCommand(Vars.player, Vars.control.input.selectedUnits.mapInt(un -> un.id, un -> un.type.allowCommand((Unit)un, command)).toArray(), command);
                        }
                    });
                    this.rebuildCommand.run();
                }).grow();
                this.blockCatTable.table(Tex.pane2, blocksSelect -> {
                    blocksSelect.margin(4.0f).marginTop(0.0f);
                    this.blockPane = blocksSelect.pane(blocks -> {
                        this.blockTable = blocks;
                    }).height(194.0f).update(pane -> {
                        Element result;
                        if (pane.hasScroll() && ((result = Core.scene.getHoverElement()) == null || !result.isDescendantOf((Element)pane))) {
                            Core.scene.setScrollFocus(null);
                        }
                    }).grow().get();
                    this.blockPane.setStyle(Styles.smallPane);
                    blocksSelect.row();
                    blocksSelect.table(t -> {
                        t.image().color(Pal.gray).height(4.0f).colspan(4).growX();
                        t.row();
                        Vars.control.input.buildPlacementUI((Table)t);
                    }).name("inputTable").growX();
                }).fillY().bottom().touchable(Touchable.enabled);
                this.blockCatTable.table(categories -> {
                    categories.bottom();
                    categories.add(new Image(Styles.black6){

                        @Override
                        public void draw() {
                            if (this.height <= Scl.scl(3.0f)) {
                                return;
                            }
                            this.getDrawable().draw(this.x, this.y, this.width, this.height - Scl.scl(3.0f));
                        }
                    }).colspan(2).growX().growY().padTop(-3.0f).row();
                    categories.defaults().size(50.0f);
                    ButtonGroup group = new ButtonGroup();
                    for (Category cat : Category.all) {
                        Seq<Block> blocks = this.getUnlockedByCategory(cat);
                        this.categoryEmpty[cat.ordinal()] = blocks.isEmpty();
                    }
                    boolean needsAssign = this.categoryEmpty[this.currentCategory.ordinal()];
                    int f = 0;
                    for (Category cat : this.getCategories()) {
                        if (f++ % 2 == 0) {
                            categories.row();
                        }
                        if (this.categoryEmpty[cat.ordinal()]) {
                            categories.image(Styles.black6);
                            continue;
                        }
                        if (needsAssign) {
                            this.currentCategory = cat;
                            needsAssign = false;
                        }
                        categories.button((Drawable)Vars.ui.getIcon(cat.name()), Styles.clearTogglei, () -> {
                            this.currentCategory = cat;
                            if (Vars.control.input.block != null) {
                                Vars.control.input.block = this.getSelectedBlock(this.currentCategory);
                            }
                            rebuildCategory.run();
                        }).group(group).update(i -> i.setChecked(this.currentCategory == cat)).name("category-" + cat.name());
                    }
                }).fillY().bottom().touchable(Touchable.enabled);
                this.mainStack.add(this.blockCatTable);
                rebuildCategory.run();
                frame.update(() -> {
                    if (!Vars.control.input.commandMode && this.gridUpdate(Vars.control.input)) {
                        rebuildCategory.run();
                    }
                });
            });
        });
    }

    Seq<Category> getCategories() {
        return this.returnCatArray.clear().addAll((Category[])Category.all).sort((c1, c2) -> Boolean.compare(this.categoryEmpty[c1.ordinal()], this.categoryEmpty[c2.ordinal()]));
    }

    Seq<Block> getByCategory(Category cat) {
        return this.returnArray.selectFrom(Vars.content.blocks(), block -> block.category == cat && block.isVisible() && block.environmentBuildable());
    }

    Seq<Block> getUnlockedByCategory(Category cat) {
        return this.returnArray2.selectFrom(Vars.content.blocks(), block -> block.category == cat && block.isVisible() && this.unlocked((Block)block)).sort((b1, b2) -> Boolean.compare(!b1.isPlaceable(), !b2.isPlaceable()));
    }

    Block getSelectedBlock(Category cat) {
        return (Block)((Object)this.selectedBlocks.get(cat, (Block)((Object)((Prov<Block>)() -> this.getByCategory(cat).find(this::unlocked)))));
    }

    boolean unlocked(Block block) {
        return block.unlockedNowHost() && block.placeablePlayer && block.environmentBuildable() && block.supportsEnv(Vars.state.rules.env);
    }

    boolean hasInfoBox() {
        this.hover = this.hovered();
        return Vars.control.input.block != null || this.menuHoverBlock != null || this.hover != null;
    }

    @Nullable
    public Displayable hovered() {
        Vec2 v = this.topTable.stageToLocalCoordinates(Core.input.mouse());
        if (Core.scene.hasMouse(Core.input.mouseX(), Core.input.mouseY()) || this.topTable.hit(v.x, v.y, false) != null) {
            return null;
        }
        Unit unit = Units.closestOverlap(Vars.player.team(), Core.input.mouseWorldX(), Core.input.mouseWorldY(), 5.0f, u -> !u.isLocal() && u.displayable());
        if (unit != null) {
            return unit;
        }
        Tile hoverTile = Vars.world.tileWorld(Core.input.mouseWorld().x, Core.input.mouseWorld().y);
        if (hoverTile != null) {
            if (hoverTile.build != null && hoverTile.build.displayable() && !hoverTile.build.inFogTo(Vars.player.team())) {
                this.nextFlowBuild = hoverTile.build;
                return this.nextFlowBuild;
            }
            if (hoverTile.drop() != null && hoverTile.block() == Blocks.air || hoverTile.wallDrop() != null || hoverTile.floor().liquidDrop != null) {
                return hoverTile;
            }
        }
        return null;
    }
}

