/*
 * Decompiled with CFR 0.152.
 */
package mindustry.io.versions;

import arc.util.Pack;
import arc.util.io.Reads;
import java.io.DataInput;
import java.io.IOException;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.Team;
import mindustry.io.versions.LegacyRegionSaveVersion;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.WorldContext;

public abstract class LegacySaveVersion
extends LegacyRegionSaveVersion {
    public LegacySaveVersion(int version) {
        super(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readMap(DataInput stream, WorldContext context) throws IOException {
        int width = stream.readUnsignedShort();
        int height = stream.readUnsignedShort();
        boolean generating = context.isGenerating();
        if (!generating) {
            context.begin();
        }
        try {
            int i;
            context.resize(width, height);
            for (i = 0; i < width * height; ++i) {
                int x = i % width;
                int y = i / width;
                short floorid = stream.readShort();
                short oreid = stream.readShort();
                int consecutives = stream.readUnsignedByte();
                if (Vars.content.block(floorid) == Blocks.air) {
                    floorid = Blocks.stone.id;
                }
                context.create(x, y, floorid, oreid, 0);
                for (int j = i + 1; j < i + 1 + consecutives; ++j) {
                    int newx = j % width;
                    int newy = j / width;
                    context.create(newx, newy, floorid, oreid, 0);
                }
                i += consecutives;
            }
            for (i = 0; i < width * height; ++i) {
                boolean occupied;
                Block block = Vars.content.block(stream.readShort());
                Tile tile = context.tile(i);
                if (block == null) {
                    block = Blocks.air;
                }
                boolean bl = occupied = tile.build != null && !tile.isCenter() && (tile.build.block == block || block == Blocks.air);
                if (!occupied) {
                    tile.setBlock(block);
                }
                if (block.hasBuilding()) {
                    try {
                        this.readLegacyShortChunk(stream, (in, len) -> {
                            byte version = in.b();
                            tile.build.health = stream.readUnsignedShort();
                            byte packedrot = stream.readByte();
                            byte team = Pack.leftByte(packedrot) == 8 ? stream.readByte() : Pack.leftByte(packedrot);
                            byte rotation = Pack.rightByte(packedrot);
                            tile.setTeam(Team.get(team));
                            tile.build.rotation = rotation;
                            if (tile.build.items != null) {
                                tile.build.items.read((Reads)in, true);
                            }
                            if (tile.build.power != null) {
                                tile.build.power.read((Reads)in, true);
                            }
                            if (tile.build.liquids != null) {
                                tile.build.liquids.read((Reads)in, true);
                            }
                            stream.readByte();
                            tile.build.read((Reads)in, version);
                        });
                    }
                    catch (Throwable e) {
                        throw new IOException("Failed to read tile entity of block: " + block, e);
                    }
                    context.onReadBuilding();
                    continue;
                }
                int consecutives = stream.readUnsignedByte();
                if (block != Blocks.air) {
                    for (int j = i + 1; j < i + 1 + consecutives; ++j) {
                        context.tile(j).setBlock(block);
                    }
                }
                i += consecutives;
            }
        }
        finally {
            if (!generating) {
                context.end();
            }
        }
    }

    public void readLegacyEntities(DataInput stream) throws IOException {
        int groups = stream.readByte();
        for (int i = 0; i < groups; ++i) {
            int amount = stream.readInt();
            for (int j = 0; j < amount; ++j) {
                this.skipLegacyShortChunk(stream);
            }
        }
    }
}

