/*
 * Decompiled with CFR 0.152.
 */
package mindustry.content;

import arc.graphics.Color;
import mindustry.content.StatusEffects;
import mindustry.type.CellLiquid;
import mindustry.type.Liquid;

public class Liquids {
    public static Liquid water;
    public static Liquid slag;
    public static Liquid oil;
    public static Liquid cryofluid;
    public static Liquid arkycite;
    public static Liquid gallium;
    public static Liquid neoplasm;
    public static Liquid ozone;
    public static Liquid hydrogen;
    public static Liquid nitrogen;
    public static Liquid cyanogen;

    public static void load() {
        water = new Liquid("water", Color.valueOf("596ab8")){
            {
                this.heatCapacity = 0.4f;
                this.effect = StatusEffects.wet;
                this.boilPoint = 0.5f;
                this.gasColor = Color.grays(0.9f);
                this.alwaysUnlocked = true;
            }
        };
        slag = new Liquid("slag", Color.valueOf("ffa166")){
            {
                this.temperature = 1.0f;
                this.viscosity = 0.7f;
                this.effect = StatusEffects.melting;
                this.lightColor = Color.valueOf("f0511d").a(0.4f);
            }
        };
        oil = new Liquid("oil", Color.valueOf("313131")){
            {
                this.viscosity = 0.75f;
                this.flammability = 1.2f;
                this.explosiveness = 1.2f;
                this.heatCapacity = 0.7f;
                this.barColor = Color.valueOf("6b675f");
                this.effect = StatusEffects.tarred;
                this.boilPoint = 0.65f;
                this.gasColor = Color.grays(0.4f);
                this.canStayOn.add(water);
            }
        };
        cryofluid = new Liquid("cryofluid", Color.valueOf("6ecdec")){
            {
                this.heatCapacity = 0.9f;
                this.temperature = 0.25f;
                this.effect = StatusEffects.freezing;
                this.lightColor = Color.valueOf("0097f5").a(0.2f);
                this.boilPoint = 0.55f;
                this.gasColor = Color.valueOf("c1e8f5");
            }
        };
        neoplasm = new CellLiquid("neoplasm", Color.valueOf("c33e2b")){
            {
                this.heatCapacity = 0.4f;
                this.temperature = 0.54f;
                this.viscosity = 0.85f;
                this.flammability = 0.0f;
                this.capPuddles = false;
                this.spreadTarget = water;
                this.moveThroughBlocks = true;
                this.incinerable = false;
                this.blockReactive = false;
                this.canStayOn.addAll(water, oil, cryofluid);
                this.colorFrom = Color.valueOf("e8803f");
                this.colorTo = Color.valueOf("8c1225");
            }
        };
        arkycite = new Liquid("arkycite", Color.valueOf("84a94b")){
            {
                this.flammability = 0.4f;
                this.viscosity = 0.7f;
                Liquids.neoplasm.canStayOn.add(this);
            }
        };
        gallium = new Liquid("gallium", Color.valueOf("9a9dbf")){
            {
                this.coolant = false;
                this.hidden = true;
            }
        };
        ozone = new Liquid("ozone", Color.valueOf("fc81dd")){
            {
                this.gas = true;
                this.barColor = Color.valueOf("d699f0");
                this.explosiveness = 1.0f;
                this.flammability = 1.0f;
            }
        };
        hydrogen = new Liquid("hydrogen", Color.valueOf("9eabf7")){
            {
                this.gas = true;
                this.flammability = 1.0f;
            }
        };
        nitrogen = new Liquid("nitrogen", Color.valueOf("efe3ff")){
            {
                this.gas = true;
            }
        };
        cyanogen = new Liquid("cyanogen", Color.valueOf("89e8b6")){
            {
                this.gas = true;
                this.flammability = 2.0f;
            }
        };
    }
}

