/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.world.Block;
import mindustry.world.draw.DrawFlame;

public class DrawPlasma
extends DrawFlame {
    public TextureRegion[] regions;
    public String suffix = "-plasma-";
    public int plasmas = 4;
    public Color plasma1 = Color.valueOf("ffd06b");
    public Color plasma2 = Color.valueOf("ff361b");

    @Override
    public void load(Block block) {
        block.emitLight = true;
        this.regions = new TextureRegion[this.plasmas];
        for (int i = 0; i < this.regions.length; ++i) {
            this.regions[i] = Core.atlas.find(block.name + this.suffix + i);
        }
    }

    @Override
    public void drawLight(Building build) {
        Drawf.light(build.x, build.y, (110.0f + Mathf.absin(5.0f, 5.0f)) * build.warmup(), Tmp.c1.set(this.plasma2).lerp(this.plasma1, Mathf.absin(7.0f, 0.2f)), 0.8f * build.warmup());
    }

    @Override
    public void draw(Building build) {
        Draw.blend(Blending.additive);
        for (int i = 0; i < this.regions.length; ++i) {
            float r = (float)this.regions[i].width * this.regions[i].scl() - 3.0f + Mathf.absin(Time.time, 2.0f + (float)i * 1.0f, 5.0f - (float)i * 0.5f);
            Draw.color(this.plasma1, this.plasma2, (float)i / (float)this.regions.length);
            Draw.alpha((0.3f + Mathf.absin(Time.time, 2.0f + (float)i * 2.0f, 0.3f + (float)i * 0.05f)) * build.warmup());
            Draw.rect(this.regions[i], build.x, build.y, r, r, build.totalProgress() * (12.0f + (float)i * 6.0f));
        }
        Draw.color();
        Draw.blend();
    }
}

