/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawMultiWeave
extends DrawBlock {
    public TextureRegion weave;
    public TextureRegion glow;
    public float rotateSpeed = 1.0f;
    public float rotateSpeed2 = -0.9f;
    public boolean fadeWeave = false;
    public Color glowColor = new Color(1.0f, 0.4f, 0.4f, 0.8f);
    public Color weaveColor = Color.white.cpy();
    public float pulse = 0.3f;
    public float pulseScl = 10.0f;

    @Override
    public void draw(Building build) {
        Draw.color(this.weaveColor);
        if (this.fadeWeave) {
            Draw.alpha(build.warmup());
        }
        Draw.rect(this.weave, build.x, build.y, build.totalProgress() * this.rotateSpeed);
        Draw.rect(this.weave, build.x, build.y, build.totalProgress() * this.rotateSpeed * this.rotateSpeed2);
        Draw.blend(Blending.additive);
        Draw.color(this.glowColor, build.warmup() * (this.glowColor.a * (1.0f - this.pulse + Mathf.absin(this.pulseScl, this.pulse))));
        Draw.rect(this.glow, build.x, build.y, build.totalProgress() * this.rotateSpeed);
        Draw.rect(this.glow, build.x, build.y, build.totalProgress() * this.rotateSpeed * this.rotateSpeed2);
        Draw.blend();
        Draw.reset();
    }

    @Override
    public TextureRegion[] icons(Block block) {
        TextureRegion[] textureRegionArray;
        if (this.fadeWeave) {
            textureRegionArray = new TextureRegion[]{};
        } else {
            TextureRegion[] textureRegionArray2 = new TextureRegion[1];
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[0] = this.weave;
        }
        return textureRegionArray;
    }

    @Override
    public void load(Block block) {
        this.weave = Core.atlas.find(block.name + "-weave");
        this.glow = Core.atlas.find(block.name + "-weave-glow");
    }
}

