/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.g2d.PixmapRegion;
import mindustry.graphics.MultiPacker;
import mindustry.type.Item;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.OverlayFloor;

public class OreBlock
extends OverlayFloor {
    public OreBlock(String name, Item ore) {
        super(name);
        this.localizedName = ore.localizedName;
        this.itemDrop = ore;
        this.variants = 3;
        this.mapColor.set(ore.color);
        this.useColor = true;
    }

    public OreBlock(Item ore) {
        this("ore-" + ore.name, ore);
    }

    public OreBlock(String name) {
        super(name);
        this.useColor = true;
        this.variants = 3;
    }

    public void setup(Item ore) {
        this.localizedName = ore.localizedName + (this.wallOre ? " " + Core.bundle.get("wallore") : "");
        this.itemDrop = ore;
        this.mapColor.set(ore.color);
    }

    @Override
    public void createIcons(MultiPacker packer) {
        for (int i = 0; i < this.variants; ++i) {
            PixmapRegion shadow = Core.atlas.has(this.name + (i + 1)) ? Core.atlas.getPixmap(this.name + (i + 1)) : Core.atlas.getPixmap(this.itemDrop.name + (i + 1));
            Pixmap image = shadow.crop();
            int offset = image.width / 8 - 1;
            int shadowColor = Color.rgba8888(0.0f, 0.0f, 0.0f, 0.3f);
            for (int x = 0; x < image.width; ++x) {
                for (int y = offset; y < image.height; ++y) {
                    if (shadow.getA(x, y) != 0 || shadow.getA(x, y - offset) == 0) continue;
                    image.setRaw(x, y, shadowColor);
                }
            }
            packer.add(MultiPacker.PageType.environment, this.name + (i + 1), image);
            if (i == 0) {
                packer.add(MultiPacker.PageType.main, "block-" + this.name + "-full", image);
            }
            image.dispose();
        }
    }

    @Override
    public void init() {
        super.init();
        if (this.itemDrop == null) {
            throw new IllegalArgumentException(this.name + " must have an item drop!");
        }
        this.setup(this.itemDrop);
    }

    @Override
    public String getDisplayName(Tile tile) {
        return this.itemDrop.localizedName;
    }
}

