/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Time;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.ui.Links;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class AboutDialog
extends BaseDialog {
    Seq<String> contributors = new Seq();
    static ObjectSet<String> bannedItems = ObjectSet.with("google-play", "itch.io", "dev-builds", "f-droid");

    public AboutDialog() {
        super("@about.button");
        this.shown(() -> {
            this.contributors = Seq.with(Core.files.internal("contributors").readString("UTF-8").split("\n"));
            Core.app.post(this::setup);
        });
        this.shown(this::setup);
        this.onResize(this::setup);
    }

    void setup() {
        this.cont.clear();
        this.buttons.clear();
        float h = Core.graphics.isPortrait() ? 90.0f : 80.0f;
        float w = Core.graphics.isPortrait() ? 400.0f : 600.0f;
        Table in = new Table();
        ScrollPane pane = new ScrollPane((Element)in);
        for (Links.LinkEntry link : Links.getLinks()) {
            if ((Vars.ios || Vars.steam) && bannedItems.contains(link.name)) continue;
            Table table = new Table(Styles.grayPanel);
            table.margin(0.0f);
            table.table((Table img) -> {
                img.image().height(h - 5.0f).width(40.0f).color(link.color);
                img.row();
                img.image().height(5.0f).width(40.0f).color(link.color.cpy().mul(0.6f, 0.6f, 0.8f, 1.0f));
            }).expandY();
            table.table((Table i) -> {
                i.background(Styles.grayPanel);
                i.image(link.icon);
            }).size(h - 5.0f, h);
            table.table((Table inset) -> {
                inset.add("[accent]" + link.title).growX().left();
                inset.row();
                inset.labelWrap(link.description).width(w - 100.0f - h).color(Color.lightGray).growX();
            }).padLeft(8.0f);
            table.button((Drawable)Icon.link, Styles.clearNonei, () -> {
                if (link.name.equals("wiki")) {
                    Events.fire(EventType.Trigger.openWiki);
                }
                if (!Core.app.openURI(link.link)) {
                    Vars.ui.showErrorMessage("@linkfail");
                    Core.app.setClipboardText(link.link);
                }
            }).size(h - 5.0f, h);
            in.add(table).size(w, h).padTop(5.0f).row();
        }
        this.shown(() -> Time.run(1.0f, () -> Core.scene.setScrollFocus(pane)));
        this.cont.add(pane).growX();
        this.addCloseButton();
        this.buttons.button("@credits", this::showCredits).size(200.0f, 64.0f);
    }

    public void showCredits() {
        BaseDialog dialog = new BaseDialog("@credits");
        dialog.addCloseButton();
        dialog.cont.add("@credits.text").fillX().wrap().get().setAlignment(1);
        dialog.cont.row();
        if (!this.contributors.isEmpty()) {
            dialog.cont.image().color(Pal.accent).fillX().height(3.0f).pad(3.0f);
            dialog.cont.row();
            dialog.cont.add("@contributors");
            dialog.cont.row();
            dialog.cont.pane(new Table(){
                {
                    int i = 0;
                    this.left();
                    for (String c : AboutDialog.this.contributors) {
                        this.add("[lightgray]" + c).left().pad(3.0f).padLeft(6.0f).padRight(6.0f);
                        if (++i % 3 != 0) continue;
                        this.row();
                    }
                }
            });
        }
        dialog.show();
    }
}

