/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui;

import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.scene.style.Drawable;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Scl;
import mindustry.graphics.Pal;

public class BorderImage
extends Image {
    public float thickness = 4.0f;
    public float pad = 0.0f;
    public Color borderColor = Pal.gray;

    public BorderImage() {
    }

    public BorderImage(Texture texture) {
        super(texture);
    }

    public BorderImage(Texture texture, float thick) {
        super(texture);
        this.thickness = thick;
    }

    public BorderImage(TextureRegion region, float thick) {
        super(region);
        this.thickness = thick;
    }

    public BorderImage(Drawable region) {
        super(region);
    }

    public BorderImage border(Color color) {
        this.borderColor = color;
        return this;
    }

    @Override
    public void draw() {
        super.draw();
        Draw.color(this.borderColor);
        Draw.alpha(this.parentAlpha);
        Lines.stroke(Scl.scl(this.thickness));
        Lines.rect(this.x + this.imageX - this.pad, this.y + this.imageY - this.pad, this.imageWidth * this.scaleX + this.pad * 2.0f, this.imageHeight * this.scaleY + this.pad * 2.0f);
        Draw.reset();
    }
}

