/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Table;
import arc.struct.Bits;
import arc.struct.Queue;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pools;
import java.nio.FloatBuffer;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.ai.types.CommandAI;
import mindustry.ai.types.LogicAI;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.core.World;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.EntityCollisions;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.entities.units.AIController;
import mindustry.entities.units.BuildPlan;
import mindustry.entities.units.StatusEntry;
import mindustry.entities.units.UnitController;
import mindustry.entities.units.WeaponMount;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Builderc;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Call;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Itemsc;
import mindustry.gen.Minerc;
import mindustry.gen.Payloadc;
import mindustry.gen.Physicsc;
import mindustry.gen.Player;
import mindustry.gen.Posc;
import mindustry.gen.Rotc;
import mindustry.gen.Shieldc;
import mindustry.gen.Sounds;
import mindustry.gen.Statusc;
import mindustry.gen.Syncc;
import mindustry.gen.Teamc;
import mindustry.gen.TimedKillc;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.gen.Velc;
import mindustry.gen.WaterMovec;
import mindustry.gen.Weaponsc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Trail;
import mindustry.input.InputHandler;
import mindustry.io.TypeIO;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.Build;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.ExplosionShield;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.BlockFlag;

public class UnitWaterMove
extends Unit
implements Builderc,
Drawc,
Entityc,
Healthc,
Hitboxc,
Itemsc,
Minerc,
Physicsc,
Posc,
Rotc,
Shieldc,
Statusc,
Syncc,
Teamc,
Unitc,
Velc,
WaterMovec,
Weaponsc {
    public static final float hitDuration = 9.0f;
    protected static final Vec2 tmp1 = new Vec2();
    protected static final Vec2 tmp2 = new Vec2();
    public static final float warpDst = 8.0f;
    protected transient boolean added;
    protected transient Bits applied;
    protected transient float buildCounter;
    protected UnitController controller;
    protected transient boolean isRotate;
    protected transient BuildPlan lastActive;
    protected transient int lastSize;
    protected transient float resupplyTime;
    private transient float rotation_LAST_;
    private transient float rotation_TARGET_;
    protected Seq<StatusEntry> statuses;
    protected transient Trail tleft;
    protected transient Color trailColor;
    protected transient Trail tright;
    protected transient boolean wasFlying;
    protected transient boolean wasHealed;
    protected transient boolean wasPlayer;
    private transient float x_LAST_;
    private transient float x_TARGET_;
    private transient float y_LAST_;
    private transient float y_TARGET_;

    protected UnitWaterMove() {
        this.applied = new Bits(Vars.content.getBy((ContentType)ContentType.status).size);
        this.resupplyTime = Mathf.random(10.0f);
        this.statuses = new Seq(4);
        this.tleft = new Trail(1);
        this.trailColor = Blocks.water.mapColor.cpy().mul(1.5f);
        this.tright = new Trail(1);
    }

    @Override
    @Nullable
    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Override
    @Nullable
    public Player getPlayer() {
        return this.isPlayer() ? (Player)this.controller : null;
    }

    @Override
    @Nullable
    public String getControllerName() {
        if (this.isPlayer()) {
            return this.getPlayer().coloredName();
        }
        UnitController unitController = this.controller;
        if (unitController instanceof LogicAI) {
            LogicAI ai = (LogicAI)unitController;
            if (ai.controller != null) {
                return ai.controller.lastAccessed;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public BuildPlan buildPlan() {
        return this.plans.size == 0 ? null : (BuildPlan)this.plans.first();
    }

    @Override
    @Nullable
    public Item getMineResult(Tile tile) {
        Item result;
        if (tile == null) {
            return null;
        }
        if (this.type.mineFloor && tile.block() == Blocks.air) {
            result = tile.drop();
        } else if (this.type.mineWalls) {
            result = tile.wallDrop();
        } else {
            return null;
        }
        return this.canMine(result) ? result : null;
    }

    @Override
    @Nullable
    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    @Override
    @Nullable
    public Floor drownFloor() {
        return this.floorOn();
    }

    @Override
    @Nullable
    public CoreBlock.CoreBuild closestCore() {
        return Vars.state.teams.closestCore(this.x, this.y, this.team);
    }

    @Override
    @Nullable
    public CoreBlock.CoreBuild closestEnemyCore() {
        return Vars.state.teams.closestEnemyCore(this.x, this.y, this.team);
    }

    @Override
    @Nullable
    public CoreBlock.CoreBuild core() {
        return this.team.core();
    }

    @Override
    public boolean isRotate() {
        return this.isRotate;
    }

    @Override
    public int classId() {
        return 20;
    }

    @Override
    public void read(Reads read) {
        short REV = read.s();
        if (REV == 0) {
            this.ammo = read.f();
            read.f();
            this.controller = TypeIO.readController(read, this.controller);
            read.bool();
            this.elevation = read.f();
            this.health = read.f();
            this.isShooting = read.bool();
            this.mounts = TypeIO.readMounts(read, this.mounts);
            this.rotation = read.f();
            this.shield = read.f();
            this.spawnedByCore = read.bool();
            this.stack = TypeIO.readItems(read, this.stack);
            int statuses_LENGTH = read.i();
            this.statuses.clear();
            for (int INDEX = 0; INDEX < statuses_LENGTH; ++INDEX) {
                StatusEntry statuses_ITEM = TypeIO.readStatus(read);
                if (statuses_ITEM == null) continue;
                this.statuses.add(statuses_ITEM);
            }
            this.team = TypeIO.readTeam(read);
            this.type = (UnitType)Vars.content.getByID(ContentType.unit, read.s());
            this.x = read.f();
            this.y = read.f();
        } else if (REV == 1) {
            this.ammo = read.f();
            read.f();
            this.controller = TypeIO.readController(read, this.controller);
            this.elevation = read.f();
            this.health = read.f();
            this.isShooting = read.bool();
            this.mounts = TypeIO.readMounts(read, this.mounts);
            this.rotation = read.f();
            this.shield = read.f();
            this.spawnedByCore = read.bool();
            this.stack = TypeIO.readItems(read, this.stack);
            int statuses_LENGTH = read.i();
            this.statuses.clear();
            for (int INDEX = 0; INDEX < statuses_LENGTH; ++INDEX) {
                StatusEntry statuses_ITEM = TypeIO.readStatus(read);
                if (statuses_ITEM == null) continue;
                this.statuses.add(statuses_ITEM);
            }
            this.team = TypeIO.readTeam(read);
            this.type = (UnitType)Vars.content.getByID(ContentType.unit, read.s());
            this.x = read.f();
            this.y = read.f();
        } else if (REV == 2) {
            this.ammo = read.f();
            read.f();
            this.controller = TypeIO.readController(read, this.controller);
            this.elevation = read.f();
            this.flag = read.d();
            this.health = read.f();
            this.isShooting = read.bool();
            this.mounts = TypeIO.readMounts(read, this.mounts);
            this.rotation = read.f();
            this.shield = read.f();
            this.spawnedByCore = read.bool();
            this.stack = TypeIO.readItems(read, this.stack);
            int statuses_LENGTH = read.i();
            this.statuses.clear();
            for (int INDEX = 0; INDEX < statuses_LENGTH; ++INDEX) {
                StatusEntry statuses_ITEM = TypeIO.readStatus(read);
                if (statuses_ITEM == null) continue;
                this.statuses.add(statuses_ITEM);
            }
            this.team = TypeIO.readTeam(read);
            this.type = (UnitType)Vars.content.getByID(ContentType.unit, read.s());
            this.x = read.f();
            this.y = read.f();
        } else if (REV == 3) {
            this.ammo = read.f();
            read.f();
            this.controller = TypeIO.readController(read, this.controller);
            this.elevation = read.f();
            this.flag = read.d();
            this.health = read.f();
            this.isShooting = read.bool();
            this.mineTile = TypeIO.readTile(read);
            this.mounts = TypeIO.readMounts(read, this.mounts);
            this.rotation = read.f();
            this.shield = read.f();
            this.spawnedByCore = read.bool();
            this.stack = TypeIO.readItems(read, this.stack);
            int statuses_LENGTH = read.i();
            this.statuses.clear();
            for (int INDEX = 0; INDEX < statuses_LENGTH; ++INDEX) {
                StatusEntry statuses_ITEM = TypeIO.readStatus(read);
                if (statuses_ITEM == null) continue;
                this.statuses.add(statuses_ITEM);
            }
            this.team = TypeIO.readTeam(read);
            this.type = (UnitType)Vars.content.getByID(ContentType.unit, read.s());
            this.x = read.f();
            this.y = read.f();
        } else if (REV == 4) {
            this.ammo = read.f();
            read.f();
            this.controller = TypeIO.readController(read, this.controller);
            this.elevation = read.f();
            this.flag = read.d();
            this.health = read.f();
            this.isShooting = read.bool();
            this.mineTile = TypeIO.readTile(read);
            this.mounts = TypeIO.readMounts(read, this.mounts);
            this.plans = TypeIO.readPlansQueue(read);
            this.rotation = read.f();
            this.shield = read.f();
            this.spawnedByCore = read.bool();
            this.stack = TypeIO.readItems(read, this.stack);
            int statuses_LENGTH = read.i();
            this.statuses.clear();
            for (int INDEX = 0; INDEX < statuses_LENGTH; ++INDEX) {
                StatusEntry statuses_ITEM = TypeIO.readStatus(read);
                if (statuses_ITEM == null) continue;
                this.statuses.add(statuses_ITEM);
            }
            this.team = TypeIO.readTeam(read);
            this.type = (UnitType)Vars.content.getByID(ContentType.unit, read.s());
            this.x = read.f();
            this.y = read.f();
        } else if (REV == 5) {
            this.ammo = read.f();
            read.f();
            this.controller = TypeIO.readController(read, this.controller);
            this.elevation = read.f();
            this.flag = read.d();
            this.health = read.f();
            this.isShooting = read.bool();
            this.mineTile = TypeIO.readTile(read);
            this.mounts = TypeIO.readMounts(read, this.mounts);
            this.plans = TypeIO.readPlansQueue(read);
            this.rotation = read.f();
            this.shield = read.f();
            this.spawnedByCore = read.bool();
            this.stack = TypeIO.readItems(read, this.stack);
            int statuses_LENGTH = read.i();
            this.statuses.clear();
            for (int INDEX = 0; INDEX < statuses_LENGTH; ++INDEX) {
                StatusEntry statuses_ITEM = TypeIO.readStatus(read);
                if (statuses_ITEM == null) continue;
                this.statuses.add(statuses_ITEM);
            }
            this.team = TypeIO.readTeam(read);
            this.type = (UnitType)Vars.content.getByID(ContentType.unit, read.s());
            this.updateBuilding = read.bool();
            this.x = read.f();
            this.y = read.f();
        } else if (REV == 6) {
            this.ammo = read.f();
            this.controller = TypeIO.readController(read, this.controller);
            this.elevation = read.f();
            this.flag = read.d();
            this.health = read.f();
            this.isShooting = read.bool();
            this.mineTile = TypeIO.readTile(read);
            this.mounts = TypeIO.readMounts(read, this.mounts);
            this.plans = TypeIO.readPlansQueue(read);
            this.rotation = read.f();
            this.shield = read.f();
            this.spawnedByCore = read.bool();
            this.stack = TypeIO.readItems(read, this.stack);
            int statuses_LENGTH = read.i();
            this.statuses.clear();
            for (int INDEX = 0; INDEX < statuses_LENGTH; ++INDEX) {
                StatusEntry statuses_ITEM = TypeIO.readStatus(read);
                if (statuses_ITEM == null) continue;
                this.statuses.add(statuses_ITEM);
            }
            this.team = TypeIO.readTeam(read);
            this.type = (UnitType)Vars.content.getByID(ContentType.unit, read.s());
            this.updateBuilding = read.bool();
            this.vel = TypeIO.readVec2(read, this.vel);
            this.x = read.f();
            this.y = read.f();
        } else if (REV == 7) {
            this.abilities = TypeIO.readAbilities(read, this.abilities);
            this.ammo = read.f();
            this.controller = TypeIO.readController(read, this.controller);
            this.elevation = read.f();
            this.flag = read.d();
            this.health = read.f();
            this.isShooting = read.bool();
            this.mineTile = TypeIO.readTile(read);
            this.mounts = TypeIO.readMounts(read, this.mounts);
            this.plans = TypeIO.readPlansQueue(read);
            this.rotation = read.f();
            this.shield = read.f();
            this.spawnedByCore = read.bool();
            this.stack = TypeIO.readItems(read, this.stack);
            int statuses_LENGTH = read.i();
            this.statuses.clear();
            for (int INDEX = 0; INDEX < statuses_LENGTH; ++INDEX) {
                StatusEntry statuses_ITEM = TypeIO.readStatus(read);
                if (statuses_ITEM == null) continue;
                this.statuses.add(statuses_ITEM);
            }
            this.team = TypeIO.readTeam(read);
            this.type = (UnitType)Vars.content.getByID(ContentType.unit, read.s());
            this.updateBuilding = read.bool();
            this.vel = TypeIO.readVec2(read, this.vel);
            this.x = read.f();
            this.y = read.f();
        } else {
            throw new IllegalArgumentException("Unknown revision '" + REV + "' for entity type 'risso'");
        }
        this.afterRead();
    }

    @Override
    public void write(Writes write) {
        int INDEX;
        write.s(7);
        TypeIO.writeAbilities(write, this.abilities);
        write.f(this.ammo);
        TypeIO.writeController(write, this.controller);
        write.f(this.elevation);
        write.d(this.flag);
        write.f(this.health);
        write.bool(this.isShooting);
        TypeIO.writeTile(write, this.mineTile);
        TypeIO.writeMounts(write, this.mounts);
        write.i(this.plans.size);
        for (INDEX = 0; INDEX < this.plans.size; ++INDEX) {
            TypeIO.writePlan(write, (BuildPlan)this.plans.get(INDEX));
        }
        write.f(this.rotation);
        write.f(this.shield);
        write.bool(this.spawnedByCore);
        TypeIO.writeItems(write, this.stack);
        write.i(this.statuses.size);
        for (INDEX = 0; INDEX < this.statuses.size; ++INDEX) {
            TypeIO.writeStatus(write, this.statuses.get(INDEX));
        }
        TypeIO.writeTeam(write, this.team);
        write.s(this.type.id);
        write.bool(this.updateBuilding);
        TypeIO.writeVec2(write, this.vel);
        write.f(this.x);
        write.f(this.y);
    }

    @Override
    public <T extends Entityc> T self() {
        return (T)this;
    }

    @Override
    public <T> T as() {
        return (T)this;
    }

    @Override
    public Color statusColor() {
        if (this.statuses.size == 0) {
            return Tmp.c1.set(Color.white);
        }
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float total = 0.0f;
        for (StatusEntry entry : this.statuses) {
            float intensity = entry.time < 10.0f ? entry.time / 10.0f : 1.0f;
            r += entry.effect.color.r * intensity;
            g += entry.effect.color.g * intensity;
            b += entry.effect.color.b * intensity;
            total += intensity;
        }
        float count = (float)this.statuses.size + total;
        return Tmp.c1.set(r / count, g / count, b / count, 1.0f);
    }

    @Override
    public TextureRegion icon() {
        return this.type.uiIcon;
    }

    @Override
    public Bits statusBits() {
        return this.applied;
    }

    @Override
    public boolean acceptsItem(Item item) {
        return !this.hasItem() || item == this.stack.item && this.stack.amount + 1 <= this.itemCapacity();
    }

    @Override
    public boolean activelyBuilding() {
        if (this.isBuilding()) {
            BuildPlan plan = this.buildPlan();
            if (!Vars.state.isEditor() && plan != null && !this.within(plan, Vars.state.rules.infiniteResources ? Float.MAX_VALUE : this.type.buildRange)) {
                return false;
            }
        }
        return this.isBuilding() && this.updateBuilding;
    }

    @Override
    public boolean allowCommand() {
        return this.controller instanceof CommandAI;
    }

    @Override
    public boolean canBuild() {
        return this.type.buildSpeed > 0.0f && this.buildSpeedMultiplier > 0.0f;
    }

    @Override
    public boolean canDrown() {
        return this.isGrounded() && this.type.canDrown;
    }

    @Override
    public boolean canLand() {
        return !this.onSolid() && Units.count(this.x, this.y, this.physicSize(), f -> f != this && f.isGrounded()) == 0;
    }

    @Override
    public boolean canMine() {
        return this.type.mineSpeed * Vars.state.rules.unitMineSpeed(this.team()) > 0.0f && this.type.mineTier >= 0;
    }

    @Override
    public boolean canMine(Item item) {
        if (item == null) {
            return false;
        }
        return this.type.mineTier >= item.hardness;
    }

    @Override
    public boolean canPass(int tileX, int tileY) {
        EntityCollisions.SolidPred s = this.solidity();
        return s == null || !s.solid(tileX, tileY);
    }

    @Override
    public boolean canPassOn() {
        return this.canPass(this.tileX(), this.tileY());
    }

    @Override
    public boolean canShoot() {
        return !this.disarmed && (!this.type.canBoost || !this.isFlying());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canTarget(Teamc other) {
        if (other == null) return false;
        if (other instanceof Unit) {
            Unit u = (Unit)other;
            if (!u.checkTarget(this.type.targetAir, this.type.targetGround)) return false;
            return true;
        } else {
            if (!(other instanceof Building)) return false;
            Building b = (Building)other;
            if (!this.type.targetGround) return false;
        }
        return true;
    }

    @Override
    public boolean cheating() {
        return this.team.rules().cheat;
    }

    @Override
    public boolean checkTarget(boolean targetAir, boolean targetGround) {
        return this.isGrounded() && targetGround || this.isFlying() && targetAir;
    }

    @Override
    public boolean collides(Hitboxc other) {
        return this.hittable();
    }

    @Override
    public boolean damaged() {
        return this.health < this.maxHealth - 0.001f;
    }

    @Override
    public boolean displayable() {
        return this.type.hoverable;
    }

    @Override
    public boolean hasEffect(StatusEffect effect) {
        return this.applied.get(effect.id);
    }

    @Override
    public boolean hasItem() {
        return this.stack.amount > 0;
    }

    @Override
    public boolean hasWeapons() {
        return this.type.hasWeapons();
    }

    @Override
    public boolean hittable() {
        return this.type.hittable(this);
    }

    @Override
    public boolean ignoreSolids() {
        return false;
    }

    @Override
    public boolean inFogTo(Team viewer) {
        if (this.team == viewer || !Vars.state.rules.fog) {
            return false;
        }
        if (this.hitSize <= 16.0f) {
            return !Vars.fogControl.isVisible(viewer, this.x, this.y);
        }
        float trns = this.hitSize / 2.0f;
        for (Point2 p : Geometry.d8) {
            if (!Vars.fogControl.isVisible(viewer, this.x + (float)p.x * trns, this.y + (float)p.y * trns)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean inRange(Position other) {
        return this.within(other, this.type.range);
    }

    @Override
    public boolean isAI() {
        return this.controller instanceof AIController;
    }

    @Override
    public boolean isAdded() {
        return this.added;
    }

    @Override
    public boolean isBoss() {
        return this.hasEffect(StatusEffects.boss);
    }

    @Override
    public boolean isBuilding() {
        return this.plans.size != 0;
    }

    @Override
    public boolean isCommandable() {
        return this.controller instanceof CommandAI;
    }

    @Override
    public boolean isEnemy() {
        return this.type.isEnemy;
    }

    @Override
    public boolean isFlying() {
        return this.elevation >= 0.09f;
    }

    @Override
    public boolean isGrounded() {
        return this.elevation < 0.001f;
    }

    @Override
    public boolean isImmune(StatusEffect effect) {
        return this.type.immunities.contains(effect);
    }

    @Override
    public boolean isLocal() {
        Unitc u;
        UnitWaterMove unitWaterMove;
        return this == Vars.player || (unitWaterMove = this) instanceof Unitc && (u = (Unitc)unitWaterMove).controller() == Vars.player;
    }

    @Override
    public boolean isMissile() {
        return this instanceof TimedKillc;
    }

    @Override
    public boolean isPathImpassable(int tileX, int tileY) {
        return !this.type.flying && Vars.world.tiles.in(tileX, tileY) && this.type.pathCost.getCost(this.team.id, Vars.pathfinder.get(tileX, tileY)) == -1;
    }

    @Override
    public boolean isPlayer() {
        return this.controller instanceof Player;
    }

    @Override
    public boolean isRemote() {
        Unitc u;
        UnitWaterMove unitWaterMove = this;
        return unitWaterMove instanceof Unitc && (u = (Unitc)unitWaterMove).isPlayer() && !this.isLocal();
    }

    @Override
    public boolean isSyncHidden(Player player) {
        return !this.isShooting() && this.inFogTo(player.team());
    }

    @Override
    public boolean isValid() {
        return !this.dead && this.isAdded();
    }

    @Override
    public boolean killable() {
        return this.type.killable(this);
    }

    @Override
    public boolean mining() {
        return this.mineTile != null && !this.activelyBuilding();
    }

    @Override
    public boolean moving() {
        return !this.vel.isZero(0.01f);
    }

    @Override
    public boolean offloadImmediately() {
        return this.isPlayer();
    }

    @Override
    public boolean onLiquid() {
        Tile tile = this.tileOn();
        return tile != null && tile.floor().isLiquid;
    }

    @Override
    public boolean onSolid() {
        return EntityCollisions.waterSolid(this.tileX(), this.tileY());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean playerControllable() {
        if (!this.type.playerControllable) return false;
        UnitController unitController = this.controller;
        if (!(unitController instanceof LogicAI)) return true;
        LogicAI ai = (LogicAI)unitController;
        if (ai.controller == null) return true;
        if (ai.controller.block.privileged) return false;
        return true;
    }

    @Override
    public boolean serialize() {
        return true;
    }

    @Override
    public boolean shouldSkip(BuildPlan plan, Building core) {
        if (Vars.state.rules.infiniteResources || this.team.rules().infiniteResources || plan.breaking || core == null || plan.isRotation(this.team) || plan.isDerelictRepair()) {
            return false;
        }
        return plan.stuck && !core.items.has(plan.block.requirements) || Structs.contains(plan.block.requirements, i -> !core.items.has(i.item, Math.min(i.amount, 15)) && Mathf.round((float)i.amount * Vars.state.rules.buildCostMultiplier) > 0);
    }

    @Override
    public boolean shouldUpdateController() {
        return true;
    }

    @Override
    public boolean targetable(Team targeter) {
        return this.type.targetable(this, targeter);
    }

    @Override
    public boolean validMine(Tile tile) {
        return this.validMine(tile, true);
    }

    @Override
    public boolean validMine(Tile tile, boolean checkDst) {
        if (tile == null) {
            return false;
        }
        if (checkDst && !this.within(tile.worldx(), tile.worldy(), this.type.mineRange)) {
            return false;
        }
        return this.getMineResult(tile) != null;
    }

    @Override
    public double sense(Content content) {
        if (content == this.stack().item) {
            return this.stack().amount;
        }
        if (content instanceof UnitType) {
            Payloadc pay;
            UnitType u = (UnitType)content;
            UnitWaterMove unitWaterMove = this;
            return unitWaterMove instanceof Payloadc ? (double)((pay = (Payloadc)((Object)unitWaterMove)).payloads().isEmpty() ? 0 : pay.payloads().count(p -> {
                if (!(p instanceof UnitPayload)) return false;
                UnitPayload up = (UnitPayload)p;
                if (up.unit.type != u) return false;
                return true;
            })) : 0.0;
        }
        if (content instanceof Block) {
            Payloadc pay;
            Block b = (Block)content;
            UnitWaterMove unitWaterMove = this;
            return unitWaterMove instanceof Payloadc ? (double)((pay = (Payloadc)((Object)unitWaterMove)).payloads().isEmpty() ? 0 : pay.payloads().count(p -> {
                if (!(p instanceof BuildPayload)) return false;
                BuildPayload bp = (BuildPayload)p;
                if (bp.build.block != b) return false;
                return true;
            })) : 0.0;
        }
        return Double.NaN;
    }

    @Override
    public double sense(LAccess sensor) {
        double d;
        switch (sensor) {
            case totalItems: {
                d = this.stack().amount;
                break;
            }
            case itemCapacity: {
                d = this.type.itemCapacity;
                break;
            }
            case rotation: {
                d = this.rotation;
                break;
            }
            case health: {
                d = this.health;
                break;
            }
            case shield: {
                d = this.shield;
                break;
            }
            case maxHealth: {
                d = this.maxHealth;
                break;
            }
            case ammo: {
                if (!Vars.state.rules.unitAmmo) {
                    d = this.type.ammoCapacity;
                    break;
                }
                d = this.ammo;
                break;
            }
            case ammoCapacity: {
                d = this.type.ammoCapacity;
                break;
            }
            case x: {
                d = World.conv(this.x);
                break;
            }
            case y: {
                d = World.conv(this.y);
                break;
            }
            case velocityX: {
                d = this.vel.x * 60.0f / 8.0f;
                break;
            }
            case velocityY: {
                d = this.vel.y * 60.0f / 8.0f;
                break;
            }
            case dead: {
                if (this.dead || !this.isAdded()) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case team: {
                d = this.team.id;
                break;
            }
            case shooting: {
                if (this.isShooting()) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case boosting: {
                if (this.type.canBoost && this.isFlying()) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case range: {
                d = this.range() / 8.0f;
                break;
            }
            case shootX: {
                d = World.conv(this.aimX());
                break;
            }
            case shootY: {
                d = World.conv(this.aimY());
                break;
            }
            case cameraX: {
                float f;
                UnitController unitController = this.controller;
                if (unitController instanceof Player) {
                    Player player = (Player)unitController;
                    f = World.conv(player.con == null ? Core.camera.position.x : player.con.viewX);
                } else {
                    f = 0.0f;
                }
                d = f;
                break;
            }
            case cameraY: {
                float f;
                UnitController unitController = this.controller;
                if (unitController instanceof Player) {
                    Player player = (Player)unitController;
                    f = World.conv(player.con == null ? Core.camera.position.y : player.con.viewY);
                } else {
                    f = 0.0f;
                }
                d = f;
                break;
            }
            case cameraWidth: {
                float f;
                UnitController unitController = this.controller;
                if (unitController instanceof Player) {
                    Player player = (Player)unitController;
                    f = World.conv(player.con == null ? Core.camera.width : player.con.viewWidth);
                } else {
                    f = 0.0f;
                }
                d = f;
                break;
            }
            case cameraHeight: {
                float f;
                UnitController unitController = this.controller;
                if (unitController instanceof Player) {
                    Player player = (Player)unitController;
                    f = World.conv(player.con == null ? Core.camera.height : player.con.viewHeight);
                } else {
                    f = 0.0f;
                }
                d = f;
                break;
            }
            case mining: {
                if (this.mining()) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case mineX: {
                if (this.mining()) {
                    d = this.mineTile.x;
                    break;
                }
                d = -1.0;
                break;
            }
            case mineY: {
                if (this.mining()) {
                    d = this.mineTile.y;
                    break;
                }
                d = -1.0;
                break;
            }
            case armor: {
                if (this.armorOverride >= 0.0f) {
                    d = this.armorOverride;
                    break;
                }
                d = this.armor;
                break;
            }
            case flag: {
                d = this.flag;
                break;
            }
            case speed: {
                d = this.type.speed * 60.0f / 8.0f * this.speedMultiplier;
                break;
            }
            case controlled: {
                CommandAI command;
                UnitController unitController;
                d = !this.isValid() ? 0 : (this.controller instanceof LogicAI ? 1 : (this.controller instanceof Player ? 2 : ((unitController = this.controller) instanceof CommandAI && (command = (CommandAI)unitController).hasCommand() ? 3 : 0)));
                break;
            }
            case payloadCount: {
                UnitWaterMove unitWaterMove = this;
                if (unitWaterMove instanceof Payloadc) {
                    Payloadc pay = (Payloadc)((Object)unitWaterMove);
                    d = pay.payloads().size;
                    break;
                }
                d = 0.0;
                break;
            }
            case totalPayload: {
                UnitWaterMove unitWaterMove = this;
                if (unitWaterMove instanceof Payloadc) {
                    Payloadc pay = (Payloadc)((Object)unitWaterMove);
                    d = pay.payloadUsed() / 64.0f;
                    break;
                }
                d = 0.0;
                break;
            }
            case payloadCapacity: {
                d = this.type.payloadCapacity / 64.0f;
                break;
            }
            case size: {
                d = this.hitSize / 8.0f;
                break;
            }
            case color: {
                d = Color.toDoubleBits(this.team.color.r, this.team.color.g, this.team.color.b, 1.0f);
                break;
            }
            default: {
                d = Double.NaN;
            }
        }
        return d;
    }

    @Override
    public float ammof() {
        return this.ammo / (float)this.type.ammoCapacity;
    }

    @Override
    public float bounds() {
        return this.hitSize * 2.0f;
    }

    @Override
    public float clipSize() {
        if (this.isBuilding()) {
            return Vars.state.rules.infiniteResources ? Float.MAX_VALUE : Math.max(this.type.clipSize, (float)this.type.region.width) + this.type.buildRange + 32.0f;
        }
        if (this.mining()) {
            return this.type.clipSize + this.type.mineRange;
        }
        return this.type.clipSize;
    }

    @Override
    public float deltaAngle() {
        return Mathf.angle(this.deltaX, this.deltaY);
    }

    @Override
    public float deltaLen() {
        return Mathf.len(this.deltaX, this.deltaY);
    }

    @Override
    public float floorSpeedMultiplier() {
        Floor on = this.isFlying() ? Blocks.air.asFloor() : this.floorOn();
        return (on.shallow ? 1.0f : 1.3f) * this.speedMultiplier;
    }

    @Override
    public float getDuration(StatusEffect effect) {
        StatusEntry entry = this.statuses.find(e -> e.effect == effect);
        return entry == null ? 0.0f : entry.time;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float healthf() {
        return this.health / this.maxHealth;
    }

    @Override
    public float hitSize() {
        return this.hitSize;
    }

    @Override
    public float mass() {
        return this.hitSize * this.hitSize * (float)Math.PI;
    }

    @Override
    public float physicSize() {
        return this.hitSize * 0.7f;
    }

    @Override
    public float prefRotation() {
        if (this.activelyBuilding() && this.type.rotateToBuilding) {
            return this.angleTo(this.buildPlan());
        }
        if (this.mineTile != null) {
            return this.angleTo(this.mineTile);
        }
        if (this.moving() && this.type.omniMovement) {
            return this.vel().angle();
        }
        return this.rotation;
    }

    @Override
    public float range() {
        return this.type.maxRange;
    }

    @Override
    public float speed() {
        float strafePenalty = this.isGrounded() || !this.isPlayer() ? 1.0f : Mathf.lerp(1.0f, this.type.strafePenalty, Angles.angleDist(this.vel().angle(), this.rotation) / 180.0f);
        float boost = Mathf.lerp(1.0f, this.type.canBoost ? this.type.boostMultiplier : 1.0f, this.elevation);
        return this.type.speed * strafePenalty * boost * this.floorSpeedMultiplier();
    }

    @Override
    public int cap() {
        return Units.getCap(this.team);
    }

    @Override
    public int collisionLayer() {
        return this.type.allowLegStep && this.type.legPhysicsLayer ? 1 : (this.isGrounded() ? 0 : 2);
    }

    @Override
    public int count() {
        return this.team.data().countType(this.type);
    }

    @Override
    public int itemCapacity() {
        return this.type.itemCapacity;
    }

    @Override
    public int maxAccepted(Item item) {
        return this.stack.item != item && this.stack.amount > 0 ? 0 : this.itemCapacity() - this.stack.amount;
    }

    @Override
    public int tileX() {
        return World.toTile(this.x);
    }

    @Override
    public int tileY() {
        return World.toTile(this.y);
    }

    @Override
    public Object senseObject(LAccess sensor) {
        Object object;
        switch (sensor) {
            case type: {
                object = this.type;
                break;
            }
            case name: {
                UnitController unitController = this.controller;
                if (unitController instanceof Player) {
                    Player p = (Player)unitController;
                    object = p.name;
                    break;
                }
                object = null;
                break;
            }
            case firstItem: {
                if (this.stack().amount == 0) {
                    object = null;
                    break;
                }
                object = this.item();
                break;
            }
            case controller: {
                if (!this.isValid()) {
                    object = null;
                    break;
                }
                UnitController unitController = this.controller;
                if (unitController instanceof LogicAI) {
                    LogicAI log = (LogicAI)unitController;
                    object = log.controller;
                    break;
                }
                object = this;
                break;
            }
            case payloadType: {
                Position position = this;
                if (position instanceof Payloadc) {
                    Payloadc pay = (Payloadc)position;
                    if (pay.payloads().isEmpty()) {
                        object = null;
                        break;
                    }
                    position = pay.payloads().peek();
                    if (position instanceof UnitPayload) {
                        UnitPayload p1 = (UnitPayload)position;
                        object = p1.unit.type;
                        break;
                    }
                    position = pay.payloads().peek();
                    if (position instanceof BuildPayload) {
                        BuildPayload p2 = (BuildPayload)position;
                        object = p2.block();
                        break;
                    }
                    object = null;
                    break;
                }
                object = null;
                break;
            }
            default: {
                object = noSensed;
            }
        }
        return object;
    }

    @Override
    public String toString() {
        return "Unit#" + this.id() + ":" + this.type + " (" + this.x + ", " + this.y + ")";
    }

    @Override
    public CommandAI command() {
        UnitController unitController = this.controller;
        if (unitController instanceof CommandAI) {
            CommandAI ai = (CommandAI)unitController;
            return ai;
        }
        throw new IllegalArgumentException("Unit cannot be commanded - check isCommandable() first.");
    }

    @Override
    public EntityCollisions.SolidPred solidity() {
        return this.isFlying() || this.ignoreSolids() ? null : EntityCollisions::waterSolid;
    }

    @Override
    public StatusEntry applyDynamicStatus() {
        StatusEntry entry;
        if (this.hasEffect(StatusEffects.dynamic) && (entry = this.statuses.find(s -> s.effect.dynamic)) != null) {
            return entry;
        }
        entry = Pools.obtain(StatusEntry.class, StatusEntry::new);
        entry.set(StatusEffects.dynamic, Float.POSITIVE_INFINITY);
        this.statuses.add(entry);
        this.applied.set(StatusEffects.dynamic.id);
        entry.effect.applied(this, entry.time, false);
        return entry;
    }

    @Override
    public UnitController controller() {
        return this.controller;
    }

    @Override
    public Item item() {
        return this.stack.item;
    }

    @Override
    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    @Override
    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public static UnitWaterMove create() {
        return new UnitWaterMove();
    }

    @Override
    public void add() {
        if (this.added) {
            return;
        }
        this.index__all = Groups.all.addIndex(this);
        this.index__unit = Groups.unit.addIndex(this);
        this.index__sync = Groups.sync.addIndex(this);
        this.index__draw = Groups.draw.addIndex(this);
        this.added = true;
        this.updateLastPosition();
        this.team.data().updateCount(this.type, 1);
        if (this.type.useUnitCap && this.count() > this.cap() && !this.spawnedByCore && !this.dead && !Vars.state.rules.editor) {
            Call.unitCapDeath(this);
            this.team.data().updateCount(this.type, -1);
        }
        this.tleft.clear();
        this.tright.clear();
    }

    @Override
    public void addBuild(BuildPlan place) {
        this.addBuild(place, true);
    }

    @Override
    public void addBuild(BuildPlan place, boolean tail) {
        Building building;
        Tile tile;
        if (!this.canBuild()) {
            return;
        }
        BuildPlan replace = null;
        for (BuildPlan plan : this.plans) {
            if (plan.x != place.x || plan.y != place.y) continue;
            replace = plan;
            break;
        }
        if (replace != null) {
            this.plans.remove(replace);
        }
        if ((tile = Vars.world.tile(place.x, place.y)) != null && (building = tile.build) instanceof ConstructBlock.ConstructBuild) {
            ConstructBlock.ConstructBuild cons = (ConstructBlock.ConstructBuild)building;
            place.progress = cons.progress;
        }
        if (tail) {
            this.plans.addLast(place);
        } else {
            this.plans.addFirst(place);
        }
    }

    @Override
    public void addItem(Item item) {
        this.addItem(item, 1);
    }

    @Override
    public void addItem(Item item, int amount) {
        this.stack.amount = this.stack.item == item ? this.stack.amount + amount : amount;
        this.stack.item = item;
        this.stack.amount = Mathf.clamp(this.stack.amount, 0, this.itemCapacity());
    }

    @Override
    public void afterRead() {
        AIController ai;
        if (this.plans == null) {
            this.plans = new Queue(1);
        }
        this.updateLastPosition();
        this.setType(this.type);
        this.controller.unit(this);
        UnitController unitController = this.controller;
        if (!(unitController instanceof AIController) || !(ai = (AIController)unitController).keepState()) {
            this.controller(this.type.createController(this));
        }
    }

    @Override
    public void afterReadAll() {
        this.controller.afterRead(this);
    }

    @Override
    public void afterSync() {
        this.setType(this.type);
        this.controller.unit(this);
    }

    @Override
    public void aim(Position pos) {
        this.aim(pos.getX(), pos.getY());
    }

    @Override
    public void aim(float x, float y) {
        Tmp.v1.set(x, y).sub(this.x, this.y);
        if (Tmp.v1.len() < this.type.aimDst) {
            Tmp.v1.setLength(this.type.aimDst);
        }
        x = Tmp.v1.x + this.x;
        y = Tmp.v1.y + this.y;
        for (WeaponMount mount : this.mounts) {
            if (!mount.weapon.controllable) continue;
            mount.aimX = x;
            mount.aimY = y;
        }
        this.aimX = x;
        this.aimY = y;
    }

    @Override
    public void aimLook(Position pos) {
        this.aim(pos);
        this.lookAt(pos);
    }

    @Override
    public void aimLook(float x, float y) {
        this.aim(x, y);
        this.lookAt(x, y);
    }

    @Override
    public void apply(StatusEffect effect) {
        this.apply(effect, 1.0f);
    }

    @Override
    public void apply(StatusEffect effect, float duration) {
        if (effect == StatusEffects.none || effect == null || this.isImmune(effect)) {
            return;
        }
        if (Vars.state.isCampaign()) {
            effect.unlock();
        }
        if (this.statuses.size > 0) {
            for (int i = 0; i < this.statuses.size; ++i) {
                StatusEntry entry = this.statuses.get(i);
                if (entry.effect == effect) {
                    entry.time = Math.max(entry.time, duration);
                    effect.applied(this, entry.time, true);
                    return;
                }
                if (!entry.effect.applyTransition(this, effect, entry, duration)) continue;
                return;
            }
        }
        if (!effect.reactive) {
            StatusEntry entry = Pools.obtain(StatusEntry.class, StatusEntry::new);
            entry.damageTime = 0.0f;
            entry.set(effect, duration);
            this.applied.set(effect.id);
            this.statuses.add(entry);
            effect.applied(this, duration, false);
        }
    }

    @Override
    public void approach(Vec2 vector) {
        this.vel.approachDelta(vector, this.type.accel * this.speed());
    }

    @Override
    public void beforeWrite() {
    }

    @Override
    public void clampHealth() {
        this.health = Math.min(this.health, this.maxHealth);
        if (Float.isNaN(this.health)) {
            this.health = 0.0f;
        }
    }

    @Override
    public void clearBuilding() {
        this.plans.clear();
    }

    @Override
    public void clearItem() {
        this.stack.amount = 0;
    }

    @Override
    public void clearStatuses() {
        this.statuses.each(e -> e.effect.onRemoved(this));
        this.statuses.clear();
    }

    @Override
    public void collision(Hitboxc other, float x, float y) {
        if (other instanceof Bullet) {
            Bullet bullet = (Bullet)other;
            this.controller.hit(bullet);
        }
    }

    @Override
    public void controlWeapons(boolean rotate, boolean shoot) {
        for (WeaponMount mount : this.mounts) {
            if (!mount.weapon.controllable) continue;
            mount.rotate = rotate;
            mount.shoot = shoot;
        }
        this.isRotate = rotate;
        this.isShooting = shoot;
    }

    @Override
    public void controlWeapons(boolean rotateShoot) {
        this.controlWeapons(rotateShoot, rotateShoot);
    }

    @Override
    public void controller(UnitController next) {
        this.controller = next;
        if (this.controller.unit() != this) {
            this.controller.unit(this);
        }
    }

    @Override
    public void damage(float amount) {
        this.rawDamage(Damage.applyArmor(amount, this.armorOverride >= 0.0f ? this.armorOverride : this.armor) / this.healthMultiplier / Vars.state.rules.unitHealth(this.team));
    }

    @Override
    public void damage(float amount, boolean withEffect) {
        float pre = this.hitTime;
        this.damage(amount);
        if (!withEffect) {
            this.hitTime = pre;
        }
    }

    @Override
    public void damageContinuous(float amount) {
        this.damage(amount * Time.delta, this.hitTime <= -1.0f);
    }

    @Override
    public void damageContinuousPierce(float amount) {
        this.damagePierce(amount * Time.delta, this.hitTime <= -11.0f);
    }

    @Override
    public void damagePierce(float amount) {
        this.damagePierce(amount, true);
    }

    @Override
    public void damagePierce(float amount, boolean withEffect) {
        float pre = this.hitTime;
        this.rawDamage(amount / this.healthMultiplier / Vars.state.rules.unitHealth(this.team));
        if (!withEffect) {
            this.hitTime = pre;
        }
    }

    @Override
    public void destroy() {
        float shake;
        if (!this.isAdded() || !this.killable()) {
            return;
        }
        float explosiveness = 2.0f + this.item().explosiveness * (float)this.stack().amount * 1.53f;
        float flammability = this.item().flammability * (float)this.stack().amount / 1.9f;
        float power = this.item().charge * Mathf.pow((float)this.stack().amount, 1.11f) * 160.0f;
        if (!this.spawnedByCore) {
            Damage.dynamicExplosion(this.x, this.y, flammability, explosiveness, power, (this.bounds() + this.type.legLength / 1.7f) / 2.0f, Vars.state.rules.damageExplosions && Vars.state.rules.unitCrashDamage(this.team) > 0.0f, this.item().flammability > 1.0f, this.team, this.type.deathExplosionEffect);
        } else {
            this.type.deathExplosionEffect.at(this.x, this.y, this.bounds() / 2.0f / 8.0f);
        }
        float f = shake = this.type.deathShake < 0.0f ? this.hitSize / 3.0f : this.type.deathShake;
        if (this.type.createScorch) {
            Effect.scorch(this.x, this.y, (int)(this.hitSize / 5.0f));
        }
        Effect.shake(shake, shake, this);
        this.type.deathSound.at(this);
        Events.fire(new EventType.UnitDestroyEvent(this));
        if (explosiveness > 7.0f && (this.isLocal() || this.wasPlayer)) {
            Events.fire(EventType.Trigger.suicideBomb);
        }
        for (WeaponMount mount : this.mounts) {
            if (!mount.weapon.shootOnDeath || mount.weapon.bullet.killShooter && mount.totalShots > 0) continue;
            mount.reload = 0.0f;
            mount.shoot = true;
            mount.weapon.update(this, mount);
        }
        if (this.type.flying && !this.spawnedByCore && this.type.createWreck && Vars.state.rules.unitCrashDamage(this.team) > 0.0f) {
            Seq<Building> shields = Vars.indexer.getEnemy(this.team, BlockFlag.shield);
            float crashDamage = Mathf.pow(this.hitSize, 0.75f) * this.type.crashDamageMultiplier * 2.5f * Vars.state.rules.unitCrashDamage(this.team);
            if (shields.isEmpty() || !shields.contains((Building)((Object)((Boolf<Building>)b -> {
                ExplosionShield s;
                return b instanceof ExplosionShield && (s = (ExplosionShield)((Object)b)).absorbExplosion(this.x, this.y, crashDamage);
            })))) {
                Damage.damage(this.team, this.x, this.y, Mathf.pow(this.hitSize, 0.94f) * 1.25f, crashDamage, true, false, true);
            }
        }
        if (!Vars.headless && this.type.createScorch) {
            for (int i = 0; i < this.type.wreckRegions.length; ++i) {
                if (!this.type.wreckRegions[i].found()) continue;
                float range = this.type.hitSize / 4.0f;
                Tmp.v1.rnd(range);
                Effect.decal(this.type.wreckRegions[i], this.x + Tmp.v1.x, this.y + Tmp.v1.y, this.rotation - 90.0f);
            }
        }
        for (Ability a : this.abilities) {
            a.death(this);
        }
        this.type.killed(this);
        this.remove();
    }

    @Override
    public void display(Table table) {
        this.type.display(this, table);
    }

    @Override
    public void draw() {
        for (StatusEntry e : this.statuses) {
            e.effect.draw(this, e.time);
        }
        this.type.draw(this);
        float z = Draw.z();
        Draw.z(20.0f);
        Floor floor = this.tileOn() == null ? Blocks.air.asFloor() : this.tileOn().floor();
        Color color = Tmp.c1.set(floor.mapColor.equals(Color.black) ? Blocks.water.mapColor : floor.mapColor).mul(1.5f);
        this.trailColor.lerp(color, Mathf.clamp(Time.delta * 0.04f));
        this.tleft.draw(this.trailColor, this.type.trailScl);
        this.tright.draw(this.trailColor, this.type.trailScl);
        Draw.z(z);
    }

    @Override
    public void drawBuildPlans() {
        for (int i = 0; i < 2; ++i) {
            for (BuildPlan plan : this.plans) {
                if (plan.progress > 0.01f || this.buildPlan() == plan && plan.initialized && (this.within(plan.x * 8, plan.y * 8, this.type.buildRange) || Vars.state.isEditor())) continue;
                if (i == 0) {
                    this.drawPlan(plan, 1.0f);
                    continue;
                }
                this.drawPlanTop(plan, 1.0f);
            }
        }
        Draw.reset();
    }

    @Override
    public void drawBuilding() {
        boolean active = this.activelyBuilding();
        if (!active && this.lastActive == null) {
            return;
        }
        Draw.z(115.0f);
        BuildPlan plan = active ? this.buildPlan() : this.lastActive;
        Tile tile = plan.tile();
        CoreBlock.CoreBuild core = this.team.core();
        if (tile == null || !this.within(plan, Vars.state.rules.infiniteResources ? Float.MAX_VALUE : this.type.buildRange)) {
            return;
        }
        if (core != null && active && !this.isLocal() && !(tile.block() instanceof ConstructBlock)) {
            Draw.z(84.0f);
            this.drawPlan(plan, 0.5f);
            this.drawPlanTop(plan, 0.5f);
            Draw.z(115.0f);
        }
        if (this.type.drawBuildBeam) {
            float focusLen = this.type.buildBeamOffset + Mathf.absin(Time.time, 3.0f, 0.6f);
            float px = this.x + Angles.trnsx(this.rotation, focusLen);
            float py = this.y + Angles.trnsy(this.rotation, focusLen);
            this.drawBuildingBeam(px, py);
        }
    }

    @Override
    public void drawBuildingBeam(float px, float py) {
        boolean active = this.activelyBuilding();
        if (!active && this.lastActive == null) {
            return;
        }
        Draw.z(115.0f);
        BuildPlan plan = active ? this.buildPlan() : this.lastActive;
        Tile tile = Vars.world.tile(plan.x, plan.y);
        if (tile == null || !this.within(plan, Vars.state.rules.infiniteResources ? Float.MAX_VALUE : this.type.buildRange)) {
            return;
        }
        int size = plan.breaking ? (active ? tile.block().size : this.lastSize) : plan.block.size;
        float tx = plan.drawx();
        float ty = plan.drawy();
        Lines.stroke(1.0f, plan.breaking ? Pal.remove : Pal.accent);
        Draw.z(122.0f);
        Draw.alpha(this.buildAlpha);
        if (!active && !(tile.build instanceof ConstructBlock.ConstructBuild)) {
            Fill.square(plan.drawx(), plan.drawy(), (float)(size * 8) / 2.0f);
        }
        Drawf.buildBeam(px, py, tx, ty, (float)(8 * size) / 2.0f);
        Fill.square(px, py, 1.8f + Mathf.absin(Time.time, 2.2f, 1.1f), this.rotation + 45.0f);
        Draw.reset();
        Draw.z(115.0f);
    }

    @Override
    public void drawPlan(BuildPlan plan, float alpha) {
        plan.animScale = 1.0f;
        if (plan.breaking) {
            Vars.control.input.drawBreaking(plan);
        } else {
            plan.block.drawPlan(plan, Vars.control.input.allPlans(), Build.validPlace(plan.block, this.team, plan.x, plan.y, plan.rotation) || Vars.control.input.planMatches(plan), alpha);
        }
    }

    @Override
    public void drawPlanTop(BuildPlan plan, float alpha) {
        if (!plan.breaking) {
            Draw.reset();
            Draw.mixcol(Color.white, 0.24f + Mathf.absin(Time.globalTime, 6.0f, 0.28f));
            Draw.alpha(alpha);
            plan.block.drawPlanConfigTop(plan, this.plans);
        }
    }

    @Override
    public void getCollisions(Cons<QuadTree> consumer) {
    }

    @Override
    public void handleSyncHidden() {
        this.remove();
        Vars.netClient.clearRemovedEntity(this.id);
    }

    @Override
    public void heal() {
        this.dead = false;
        this.health = this.maxHealth;
    }

    @Override
    public void heal(float amount) {
        this.health += amount;
        this.clampHealth();
        if (this.health < this.maxHealth && amount > 0.0f) {
            this.wasHealed = true;
        }
    }

    @Override
    public void healFract(float amount) {
        this.heal(amount * this.maxHealth);
    }

    @Override
    public void hitbox(Rect rect) {
        rect.setCentered(this.x, this.y, this.hitSize, this.hitSize);
    }

    @Override
    public void hitboxTile(Rect rect) {
        float size = Math.min(this.hitSize * 0.66f, 7.8f);
        rect.setCentered(this.x, this.y, size, size);
    }

    @Override
    public void impulse(Vec2 v) {
        this.impulse(v.x, v.y);
    }

    @Override
    public void impulse(float x, float y) {
        float mass = this.mass();
        this.vel.add(x / mass, y / mass);
    }

    @Override
    public void impulseNet(Vec2 v) {
        this.impulse(v.x, v.y);
        if (this.isRemote()) {
            float mass = this.mass();
            this.move(v.x / mass, v.y / mass);
        }
    }

    @Override
    public void interpolate() {
        if (this.lastUpdated != 0L && this.updateSpacing != 0L) {
            float timeSinceUpdate = Time.timeSinceMillis(this.lastUpdated);
            float alpha = Math.min(timeSinceUpdate / (float)this.updateSpacing, 2.0f);
            this.rotation = Mathf.slerp(this.rotation_LAST_, this.rotation_TARGET_, alpha);
            this.x = Mathf.lerp(this.x_LAST_, this.x_TARGET_, alpha);
            this.y = Mathf.lerp(this.y_LAST_, this.y_TARGET_, alpha);
        } else if (this.lastUpdated != 0L) {
            this.rotation = this.rotation_TARGET_;
            this.x = this.x_TARGET_;
            this.y = this.y_TARGET_;
        }
    }

    @Override
    public void kill() {
        if (this.dead || Vars.net.client() || !this.killable()) {
            return;
        }
        Call.unitDeath(this.id);
    }

    @Override
    public void killed() {
        this.wasPlayer = this.isLocal();
        this.health = Math.min(this.health, 0.0f);
        this.dead = true;
        if (!this.type.flying || !this.type.createWreck) {
            this.destroy();
        }
    }

    @Override
    public void landed() {
        if (this.type.mechLandShake > 0.0f) {
            Effect.shake(this.type.mechLandShake, this.type.mechLandShake, this);
        }
        this.type.landed(this);
    }

    @Override
    public void lookAt(Position pos) {
        this.lookAt(this.angleTo(pos));
    }

    @Override
    public void lookAt(float angle) {
        this.rotation = Angles.moveToward(this.rotation, angle, this.type.rotateSpeed * Time.delta * this.speedMultiplier());
    }

    @Override
    public void lookAt(float x, float y) {
        this.lookAt(this.angleTo(x, y));
    }

    @Override
    public void move(Vec2 v) {
        this.move(v.x, v.y);
    }

    @Override
    public void move(float cx, float cy) {
        EntityCollisions.SolidPred check = this.solidity();
        if (check != null) {
            Vars.collisions.move(this, cx, cy, check);
        } else {
            this.x += cx;
            this.y += cy;
        }
    }

    @Override
    public void moveAt(Vec2 vector) {
        this.moveAt(vector, this.type.accel);
    }

    @Override
    public void moveAt(Vec2 vector, float acceleration) {
        Vec2 t = tmp1.set(vector);
        tmp2.set(t).sub(this.vel).limit(acceleration * vector.len() * Time.delta);
        this.vel.add(tmp2);
    }

    @Override
    public void movePref(Vec2 movement) {
        if (this.type.omniMovement) {
            this.moveAt(movement);
        } else {
            this.rotateMove(movement);
        }
    }

    @Override
    public void rawDamage(float amount) {
        boolean hadShields;
        boolean bl = hadShields = this.shield > 1.0E-4f;
        if (Float.isNaN(this.health)) {
            this.health = 0.0f;
        }
        if (hadShields) {
            this.shieldAlpha = 1.0f;
        }
        float shieldDamage = Math.min(Math.max(this.shield, 0.0f), amount);
        this.shield -= shieldDamage;
        this.hitTime = 1.0f;
        if ((amount -= shieldDamage) > 0.0f && this.type.killable) {
            this.health -= amount;
            if (this.health <= 0.0f && !this.dead) {
                this.kill();
            }
            if (hadShields && this.shield <= 1.0E-4f) {
                Fx.unitShieldBreak.at(this.x, this.y, 0.0f, this.type.shieldColor(this), this);
            }
        }
    }

    @Override
    public void readSync(Reads read) {
        if (this.lastUpdated != 0L) {
            this.updateSpacing = Time.timeSinceMillis(this.lastUpdated);
        }
        this.lastUpdated = Time.millis();
        boolean islocal = this.isLocal();
        this.abilities = TypeIO.readAbilities(read, this.abilities);
        this.ammo = read.f();
        this.controller = TypeIO.readController(read, this.controller);
        if (!islocal) {
            this.elevation = read.f();
        } else {
            read.f();
        }
        this.flag = read.d();
        this.health = read.f();
        this.isShooting = read.bool();
        if (!islocal) {
            this.mineTile = TypeIO.readTile(read);
        } else {
            TypeIO.readTile(read);
        }
        if (!islocal) {
            this.mounts = TypeIO.readMounts(read, this.mounts);
        } else {
            TypeIO.readMounts(read);
        }
        if (!islocal) {
            this.plans = TypeIO.readPlansQueue(read);
        } else {
            TypeIO.readPlansQueue(read);
        }
        if (!islocal) {
            this.rotation_LAST_ = this.rotation;
            this.rotation_TARGET_ = read.f();
        } else {
            read.f();
            this.rotation_LAST_ = this.rotation;
            this.rotation_TARGET_ = this.rotation;
        }
        this.shield = read.f();
        this.spawnedByCore = read.bool();
        this.stack = TypeIO.readItems(read, this.stack);
        int statuses_LENGTH = read.i();
        this.statuses.clear();
        for (int INDEX = 0; INDEX < statuses_LENGTH; ++INDEX) {
            StatusEntry statuses_ITEM = TypeIO.readStatus(read);
            if (statuses_ITEM == null) continue;
            this.statuses.add(statuses_ITEM);
        }
        this.team = TypeIO.readTeam(read);
        this.type = (UnitType)Vars.content.getByID(ContentType.unit, read.s());
        if (!islocal) {
            this.updateBuilding = read.bool();
        } else {
            read.bool();
        }
        if (!islocal) {
            this.vel = TypeIO.readVec2(read, this.vel);
        } else {
            TypeIO.readVec2(read);
        }
        if (!islocal) {
            this.x_LAST_ = this.x;
            this.x_TARGET_ = read.f();
        } else {
            read.f();
            this.x_LAST_ = this.x;
            this.x_TARGET_ = this.x;
        }
        if (!islocal) {
            this.y_LAST_ = this.y;
            this.y_TARGET_ = read.f();
        } else {
            read.f();
            this.y_LAST_ = this.y;
            this.y_TARGET_ = this.y;
        }
        this.afterSync();
    }

    @Override
    public void readSyncManual(FloatBuffer buffer) {
        if (this.lastUpdated != 0L) {
            this.updateSpacing = Time.timeSinceMillis(this.lastUpdated);
        }
        this.lastUpdated = Time.millis();
        this.rotation_LAST_ = this.rotation;
        this.rotation_TARGET_ = buffer.get();
        this.x_LAST_ = this.x;
        this.x_TARGET_ = buffer.get();
        this.y_LAST_ = this.y;
        this.y_TARGET_ = buffer.get();
    }

    @Override
    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.removeIndex(this, this.index__all);
        this.index__all = -1;
        Groups.unit.removeIndex(this, this.index__unit);
        this.index__unit = -1;
        Groups.sync.removeIndex(this, this.index__sync);
        this.index__sync = -1;
        Groups.draw.removeIndex(this, this.index__draw);
        this.index__draw = -1;
        this.added = false;
        if (Vars.net.client()) {
            Vars.netClient.addRemovedEntity(this.id());
        }
        this.team.data().updateCount(this.type, -1);
        this.controller.removed(this);
        if (this.trail != null && this.trail.size() > 0) {
            Fx.trailFade.at(this.x, this.y, this.trail.width(), this.type.trailColor == null ? this.team.color : this.type.trailColor, this.trail.copy());
        }
        for (WeaponMount mount : this.mounts) {
            if (mount.weapon.continuous && mount.bullet != null && mount.bullet.owner == this) {
                mount.bullet.time = mount.bullet.lifetime - 10.0f;
                mount.bullet = null;
            }
            if (mount.sound == null) continue;
            mount.sound.stop();
        }
    }

    @Override
    public void removeBuild(int x, int y, boolean breaking) {
        int idx = this.plans.indexOf(req -> req.breaking == breaking && req.x == x && req.y == y);
        if (idx != -1) {
            this.plans.removeIndex(idx);
        }
    }

    @Override
    public void resetController() {
        this.controller(this.type.createController(this));
    }

    @Override
    public void rotateMove(Vec2 vec) {
        this.moveAt(Tmp.v2.trns(this.rotation, vec.len()));
        if (!vec.isZero()) {
            this.rotation = Angles.moveToward(this.rotation, vec.angle(), this.type.rotateSpeed * Time.delta * this.speedMultiplier);
        }
    }

    @Override
    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    @Override
    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void set(UnitType def, UnitController controller) {
        if (this.type != def) {
            this.setType(def);
        }
        this.controller(controller);
    }

    @Override
    public void setProp(UnlockableContent content, double value) {
        if (content instanceof Item) {
            Item item;
            this.stack.item = item = (Item)content;
            this.stack.amount = Mathf.clamp((int)value, 0, this.type.itemCapacity);
        }
    }

    @Override
    public void setProp(LAccess prop, double value) {
        switch (prop) {
            case health: {
                this.health = (float)Mathf.clamp(value, 0.0, (double)this.maxHealth);
                if (!(this.health <= 0.0f) || this.dead) break;
                this.kill();
                break;
            }
            case shield: {
                this.shield = Math.max((float)value, 0.0f);
                break;
            }
            case x: {
                this.x = World.unconv((float)value);
                if (this.isLocal()) break;
                this.snapInterpolation();
                break;
            }
            case y: {
                this.y = World.unconv((float)value);
                if (this.isLocal()) break;
                this.snapInterpolation();
                break;
            }
            case velocityX: {
                this.vel.x = (float)(value * 8.0 / 60.0);
                break;
            }
            case velocityY: {
                this.vel.y = (float)(value * 8.0 / 60.0);
                break;
            }
            case rotation: {
                this.rotation = (float)value;
                break;
            }
            case team: {
                if (Vars.net.client()) break;
                Team team = Team.get((int)value);
                UnitController unitController = this.controller;
                if (unitController instanceof Player) {
                    Player p = (Player)unitController;
                    p.team(team);
                }
                this.team = team;
                break;
            }
            case flag: {
                this.flag = value;
                break;
            }
            case speed: {
                this.statusSpeed(Mathf.clamp((float)value, 0.0f, 1000.0f));
                break;
            }
            case armor: {
                this.statusArmor(Math.max((float)value, 0.0f));
            }
        }
    }

    @Override
    public void setProp(LAccess prop, Object value) {
        switch (prop) {
            case team: {
                if (!(value instanceof Team)) break;
                Team t = (Team)value;
                if (Vars.net.client()) break;
                UnitController unitController = this.controller;
                if (unitController instanceof Player) {
                    Player p = (Player)unitController;
                    p.team(t);
                }
                this.team = t;
                break;
            }
            case payloadType: {
                UnitWaterMove p = this;
                if (!(p instanceof Payloadc)) break;
                Payloadc pay = (Payloadc)((Object)p);
                if (Vars.net.client()) break;
                if (value instanceof Block) {
                    Building build;
                    Block b = (Block)value;
                    if (!b.synthetic() || !pay.canPickup(build = b.newBuilding().create(b, this.team()))) break;
                    pay.addPayload(new BuildPayload(build));
                    break;
                }
                if (value instanceof UnitType) {
                    UnitType ut = (UnitType)value;
                    Unit unit = ut.create(this.team());
                    if (!pay.canPickup(unit)) break;
                    pay.addPayload(new UnitPayload(unit));
                    break;
                }
                if (value != null || pay.payloads().size <= 0) break;
                pay.payloads().pop();
            }
        }
    }

    @Override
    public void setType(UnitType type) {
        this.type = type;
        this.maxHealth = type.health;
        this.drag = type.drag;
        this.armor = type.armor;
        this.hitSize = type.hitSize;
        if (this.mounts().length != type.weapons.size) {
            this.setupWeapons(type);
        }
        if (this.abilities.length != type.abilities.size) {
            this.abilities = new Ability[type.abilities.size];
            for (int i = 0; i < type.abilities.size; ++i) {
                this.abilities[i] = type.abilities.get(i).copy();
            }
        }
        if (this.controller == null) {
            this.controller(type.createController(this));
        }
    }

    @Override
    public void setWeaponRotation(float rotation) {
        for (WeaponMount mount : this.mounts) {
            mount.rotation = rotation;
        }
    }

    @Override
    public void setupWeapons(UnitType def) {
        this.mounts = new WeaponMount[def.weapons.size];
        for (int i = 0; i < this.mounts.length; ++i) {
            this.mounts[i] = def.weapons.get((int)i).mountType.get(def.weapons.get(i));
        }
    }

    @Override
    public void snapInterpolation() {
        this.updateSpacing = 16L;
        this.lastUpdated = Time.millis();
        this.rotation_LAST_ = this.rotation;
        this.rotation_TARGET_ = this.rotation;
        this.x_LAST_ = this.x;
        this.x_TARGET_ = this.x;
        this.y_LAST_ = this.y;
        this.y_TARGET_ = this.y;
    }

    @Override
    public void snapSync() {
        this.updateSpacing = 16L;
        this.lastUpdated = Time.millis();
        this.rotation_LAST_ = this.rotation_TARGET_;
        this.rotation = this.rotation_TARGET_;
        this.x_LAST_ = this.x_TARGET_;
        this.x = this.x_TARGET_;
        this.y_LAST_ = this.y_TARGET_;
        this.y = this.y_TARGET_;
    }

    @Override
    public void statusArmor(float armor) {
        this.applyDynamicStatus().armorOverride = armor;
    }

    @Override
    public void statusBuildSpeed(float buildSpeed) {
        this.applyDynamicStatus().buildSpeedMultiplier = buildSpeed / this.type.buildSpeed;
    }

    @Override
    public void statusDamageMultiplier(float damageMultiplier) {
        this.applyDynamicStatus().damageMultiplier = damageMultiplier;
    }

    @Override
    public void statusDrag(float drag) {
        this.applyDynamicStatus().dragMultiplier = this.type.drag == 0.0f ? 0.0f : drag / this.type.drag;
    }

    @Override
    public void statusMaxHealth(float health) {
        this.applyDynamicStatus().healthMultiplier = health / this.maxHealth;
    }

    @Override
    public void statusReloadMultiplier(float reloadMultiplier) {
        this.applyDynamicStatus().reloadMultiplier = reloadMultiplier;
    }

    @Override
    public void statusSpeed(float speed) {
        this.applyDynamicStatus().speedMultiplier = speed / (this.type.speed * 60.0f / 8.0f);
    }

    @Override
    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    @Override
    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    @Override
    public void unapply(StatusEffect effect) {
        this.statuses.remove(e -> {
            if (e.effect == effect) {
                e.effect.onRemoved(this);
                Pools.free(e);
                return true;
            }
            return false;
        });
    }

    @Override
    public void unloaded() {
    }

    @Override
    public void update() {
        float cy;
        if (!Vars.net.client() || this.isLocal()) {
            float px = this.x;
            float py = this.y;
            this.move(this.vel.x * Time.delta, this.vel.y * Time.delta);
            if (Mathf.equal(px, this.x)) {
                this.vel.x = 0.0f;
            }
            if (Mathf.equal(py, this.y)) {
                this.vel.y = 0.0f;
            }
            this.vel.scl(Math.max(1.0f - this.drag * Time.delta, 0.0f));
        }
        this.updateBuildLogic();
        this.hitTime -= Time.delta / 9.0f;
        this.stack.amount = Mathf.clamp(this.stack.amount, 0, this.itemCapacity());
        this.itemTime = Mathf.lerpDelta(this.itemTime, Mathf.num(this.hasItem()), 0.05f);
        if (this.mineTile != null) {
            int accepted;
            CoreBlock.CoreBuild core = this.closestCore();
            Item item = this.getMineResult(this.mineTile);
            if (core != null && item != null && !this.acceptsItem(item) && this.within(core, 220.0f) && !this.offloadImmediately() && (accepted = core.acceptStack(this.item(), this.stack().amount, this)) > 0) {
                Call.transferItemTo(this, this.item(), accepted, this.mineTile.worldx() + Mathf.range(4.0f), this.mineTile.worldy() + Mathf.range(4.0f), core);
                this.clearItem();
            }
            if (!(Vars.net.client() && !this.isLocal() || this.validMine(this.mineTile))) {
                this.mineTile = null;
                this.mineTimer = 0.0f;
            } else if (this.mining() && item != null) {
                this.mineTimer += Time.delta * this.type.mineSpeed * Vars.state.rules.unitMineSpeed(this.team());
                if (Mathf.chance(0.06 * (double)Time.delta)) {
                    Fx.pulverizeSmall.at(this.mineTile.worldx() + Mathf.range(4.0f), this.mineTile.worldy() + Mathf.range(4.0f), 0.0f, item.color);
                }
                float f = this.type.mineHardnessScaling ? (float)item.hardness * 15.0f : 15.0f;
                if (this.mineTimer >= 50.0f + f) {
                    this.mineTimer = 0.0f;
                    if (Vars.state.rules.sector != null && this.team() == Vars.state.rules.defaultTeam) {
                        Vars.state.rules.sector.info.handleProduction(item, 1);
                    }
                    if (core != null && this.within(core, 220.0f) && core.acceptStack(item, 1, this) == 1 && this.offloadImmediately()) {
                        if (this.item() == item && !Vars.net.client()) {
                            this.addItem(item);
                        }
                        Call.transferItemTo(this, item, 1, this.mineTile.worldx() + Mathf.range(4.0f), this.mineTile.worldy() + Mathf.range(4.0f), core);
                    } else if (this.acceptsItem(item)) {
                        InputHandler.transferItemToUnit(item, this.mineTile.worldx() + Mathf.range(4.0f), this.mineTile.worldy() + Mathf.range(4.0f), this);
                    } else {
                        this.mineTile = null;
                        this.mineTimer = 0.0f;
                    }
                }
                if (!Vars.headless) {
                    Vars.control.sound.loop(this.type.mineSound, this, this.type.mineSoundVolume);
                }
            }
        }
        this.shieldAlpha -= Time.delta / 15.0f;
        if (this.shieldAlpha < 0.0f) {
            this.shieldAlpha = 0.0f;
        }
        Floor floor = this.floorOn();
        if (this.isGrounded() && !this.type.hovering) {
            this.apply(floor.status, floor.statusDuration);
        }
        this.applied.clear();
        this.armorOverride = -1.0f;
        this.dragMultiplier = 1.0f;
        this.buildSpeedMultiplier = 1.0f;
        this.reloadMultiplier = 1.0f;
        this.healthMultiplier = 1.0f;
        this.damageMultiplier = 1.0f;
        this.speedMultiplier = 1.0f;
        this.disarmed = false;
        if (!this.statuses.isEmpty()) {
            int index = 0;
            while (index < this.statuses.size) {
                StatusEntry entry = this.statuses.get(index++);
                entry.time = Math.max(entry.time - Time.delta, 0.0f);
                if (entry.effect == null || entry.time <= 0.0f && !entry.effect.permanent) {
                    if (entry.effect != null) {
                        entry.effect.onRemoved(this);
                    }
                    Pools.free(entry);
                    this.statuses.remove(--index);
                    continue;
                }
                this.applied.set(entry.effect.id);
                if (entry.effect.dynamic) {
                    this.speedMultiplier *= entry.speedMultiplier;
                    this.healthMultiplier *= entry.healthMultiplier;
                    this.damageMultiplier *= entry.damageMultiplier;
                    this.reloadMultiplier *= entry.reloadMultiplier;
                    this.buildSpeedMultiplier *= entry.buildSpeedMultiplier;
                    this.dragMultiplier *= entry.dragMultiplier;
                    if (entry.armorOverride >= 0.0f) {
                        this.armorOverride = entry.armorOverride;
                    }
                } else {
                    this.speedMultiplier *= entry.effect.speedMultiplier;
                    this.healthMultiplier *= entry.effect.healthMultiplier;
                    this.damageMultiplier *= entry.effect.damageMultiplier;
                    this.reloadMultiplier *= entry.effect.reloadMultiplier;
                    this.buildSpeedMultiplier *= entry.effect.buildSpeedMultiplier;
                    this.dragMultiplier *= entry.effect.dragMultiplier;
                }
                this.disarmed |= entry.effect.disarm;
                entry.effect.update(this, entry);
            }
        }
        if (Vars.net.client() && !this.isLocal() || this.isRemote()) {
            this.interpolate();
        }
        this.type.update(this);
        if (this.type.bounded) {
            float bot = 0.0f;
            float left = 0.0f;
            float top = Vars.world.unitHeight();
            float right = Vars.world.unitWidth();
            if (Vars.state.rules.limitMapArea && !this.team.isAI()) {
                bot = Vars.state.rules.limitY * 8;
                left = Vars.state.rules.limitX * 8;
                top = (float)(Vars.state.rules.limitHeight * 8) + bot;
                right = (float)(Vars.state.rules.limitWidth * 8) + left;
            }
            if (!Vars.net.client() || this.isLocal()) {
                float dx = 0.0f;
                float dy = 0.0f;
                if (this.x < left) {
                    dx += -(this.x - left) / 8.0f;
                }
                if (this.y < bot) {
                    dy += -(this.y - bot) / 8.0f;
                }
                if (this.x > right - 8.0f) {
                    dx -= (this.x - (right - 8.0f)) / 8.0f;
                }
                if (this.y > top - 8.0f) {
                    dy -= (this.y - (top - 8.0f)) / 8.0f;
                }
                this.velAddNet(dx * Time.delta, dy * Time.delta);
                float margin = 8.0f;
                this.x = Mathf.clamp(this.x, left - margin, right - 8.0f + margin);
                this.y = Mathf.clamp(this.y, bot - margin, top - 8.0f + margin);
            }
            if (this.isGrounded()) {
                this.x = Mathf.clamp(this.x, left, right - 8.0f);
                this.y = Mathf.clamp(this.y, bot, top - 8.0f);
            }
            if (this.x < -250.0f + left || this.y < -250.0f + bot || this.x >= right + 250.0f || this.y >= top + 250.0f) {
                this.kill();
            }
        }
        floor = this.floorOn();
        Tile tile = this.tileOn();
        if (this.isFlying() != this.wasFlying) {
            if (this.wasFlying && tile != null) {
                Fx.unitLand.at(this.x, this.y, floor.isLiquid ? 1.0f : 0.5f, tile.floor().mapColor);
            }
            this.wasFlying = this.isFlying();
        }
        if (!this.type.hovering && this.isGrounded() && this.type.emitWalkEffect) {
            float f;
            this.splashTimer += Mathf.dst(this.deltaX(), this.deltaY());
            if (f >= 7.0f + this.hitSize() / 8.0f) {
                floor.walkEffect.at(this.x, this.y, this.hitSize() / 8.0f, floor.mapColor);
                this.splashTimer = 0.0f;
                if (this.type.emitWalkSound) {
                    floor.walkSound.at(this.x, this.y, Mathf.random(floor.walkSoundPitchMin, floor.walkSoundPitchMax), floor.walkSoundVolume);
                }
            }
        }
        this.updateDrowning();
        if (this.wasHealed && this.healTime <= -1.0f) {
            this.healTime = 1.0f;
        }
        this.healTime -= Time.delta / 20.0f;
        this.wasHealed = false;
        if (this.team.isOnlyAI() && Vars.state.isCampaign() && Vars.state.getSector().isCaptured()) {
            this.kill();
        }
        if (!Vars.headless && this.type.loopSound != Sounds.none) {
            Vars.control.sound.loop(this.type.loopSound, this, this.type.loopSoundVolume);
        }
        if (!this.type.supportsEnv(Vars.state.rules.env) && !this.dead) {
            Call.unitEnvDeath(this);
            this.team.data().updateCount(this.type, -1);
        }
        if (Vars.state.rules.unitAmmo && this.ammo < (float)this.type.ammoCapacity - 1.0E-4f) {
            this.resupplyTime += Time.delta;
            if (this.resupplyTime > 10.0f) {
                this.type.ammoType.resupply(this);
                this.resupplyTime = 0.0f;
            }
        }
        for (Ability a : this.abilities) {
            a.update(this);
        }
        if (this.trail != null) {
            this.trail.length = this.type.trailLength;
            float scale = this.type.useEngineElevation ? this.elevation : 1.0f;
            float offset = this.type.engineOffset / 2.0f + this.type.engineOffset / 2.0f * scale;
            float cx = this.x + Angles.trnsx(this.rotation + 180.0f, offset);
            cy = this.y + Angles.trnsy(this.rotation + 180.0f, offset);
            this.trail.update(cx, cy);
        }
        this.drag = this.type.drag * (this.isGrounded() ? this.floorOn().dragMultiplier : 1.0f) * this.dragMultiplier * Vars.state.rules.dragMultiplier;
        if (this.team != Vars.state.rules.waveTeam && Vars.state.hasSpawns() && (!Vars.net.client() || this.isLocal()) && this.hittable()) {
            float relativeSize = Vars.state.rules.dropZoneRadius + this.hitSize / 2.0f + 1.0f;
            for (Tile spawn : Vars.spawner.getSpawns()) {
                if (!this.within(spawn.worldx(), spawn.worldy(), relativeSize)) continue;
                this.velAddNet(Tmp.v1.set(this).sub(spawn.worldx(), spawn.worldy()).setLength(1.1f - this.dst(spawn) / relativeSize).scl(0.45f * Time.delta));
            }
        }
        if (this.dead || this.health <= 0.0f) {
            this.drag = 0.01f;
            if (Mathf.chanceDelta(0.1)) {
                Tmp.v1.rnd(Mathf.range(this.hitSize));
                this.type.fallEffect.at(this.x + Tmp.v1.x, this.y + Tmp.v1.y);
            }
            if (Mathf.chanceDelta(0.2)) {
                float offset = this.type.engineOffset / 2.0f + this.type.engineOffset / 2.0f * this.elevation;
                float range = Mathf.range(this.type.engineSize);
                this.type.fallEngineEffect.at(this.x + Angles.trnsx(this.rotation + 180.0f, offset) + Mathf.range(range), this.y + Angles.trnsy(this.rotation + 180.0f, offset) + Mathf.range(range), Mathf.random());
            }
            this.elevation -= this.type.fallSpeed * Time.delta;
            if (this.isGrounded() || this.health <= -this.maxHealth * this.type.wreckHealthMultiplier) {
                Call.unitDestroy(this.id);
            }
        }
        if (tile != null && tile.build != null) {
            tile.build.unitOnAny(this);
        }
        if (tile != null && this.isGrounded() && !this.type.hovering) {
            if (tile.build != null) {
                tile.build.unitOn(this);
            }
            if (floor.damageTaken > 0.0f) {
                this.damageContinuous(floor.damageTaken);
            }
        }
        if (tile != null && !this.canPassOn()) {
            if (this.type.canBoost) {
                this.elevation = 1.0f;
            } else if (!Vars.net.client()) {
                this.kill();
            }
        }
        if (!Vars.net.client() && !this.dead && this.shouldUpdateController()) {
            this.controller.updateUnit();
        }
        if (!this.controller.isValidController()) {
            this.resetController();
        }
        if (this.spawnedByCore && !this.isPlayer() && !this.dead) {
            Call.unitDespawn(this);
        }
        boolean flying = this.isFlying();
        for (int i = 0; i < 2; ++i) {
            Trail t = i == 0 ? this.tleft : this.tright;
            t.length = this.type.trailLength;
            int sign = i == 0 ? -1 : 1;
            float cx = Angles.trnsx(this.rotation - 90.0f, this.type.waveTrailX * (float)sign, this.type.waveTrailY) + this.x;
            cy = Angles.trnsy(this.rotation - 90.0f, this.type.waveTrailX * (float)sign, this.type.waveTrailY) + this.y;
            t.update(cx, cy, Vars.world.floorWorld((float)cx, (float)cy).isLiquid && !flying ? 1.0f : 0.0f);
        }
        for (WeaponMount mount : this.mounts) {
            mount.weapon.update(this, mount);
        }
    }

    @Override
    public void updateBoosting(boolean boost) {
        if (!this.type.canBoost || this.dead) {
            return;
        }
        this.elevation = Mathf.approachDelta(this.elevation, this.type.canBoost ? (float)Mathf.num(boost || this.onSolid() || this.isFlying() && !this.canLand()) : 0.0f, this.type.riseSpeed);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateBuildLogic() {
        if (this.type.buildSpeed <= 0.0f) {
            return;
        }
        if (!Vars.headless) {
            if (this.lastActive != null && this.buildAlpha <= 0.01f) {
                this.lastActive = null;
            }
            this.buildAlpha = Mathf.lerpDelta(this.buildAlpha, this.activelyBuilding() ? 1.0f : 0.0f, 0.15f);
        }
        this.validatePlans();
        if (!this.updateBuilding || !this.canBuild()) {
            return;
        }
        float finalPlaceDst = Vars.state.rules.infiniteResources ? Float.MAX_VALUE : this.type.buildRange;
        boolean infinite = Vars.state.rules.infiniteResources || this.team().rules().infiniteResources;
        this.buildCounter += Time.delta;
        if (Float.isNaN(this.buildCounter) || Float.isInfinite(this.buildCounter)) {
            this.buildCounter = 0.0f;
        }
        this.buildCounter = Math.min(this.buildCounter, 10.0f);
        boolean instant = Vars.state.rules.instantBuild && Vars.state.rules.infiniteResources;
        int maxPerFrame = instant ? this.plans.size : 10;
        int count = 0;
        CoreBlock.CoreBuild core = this.core();
        if (core == null && !infinite) {
            return;
        }
        while (true) {
            Building hasAll2;
            Tile tile;
            BuildPlan current;
            block30: {
                block38: {
                    ConstructBlock.ConstructBuild cb;
                    block35: {
                        block36: {
                            block37: {
                                block34: {
                                    Building foundAny2;
                                    block32: {
                                        int bestIndex;
                                        boolean foundAny2;
                                        float bestDst;
                                        int size;
                                        block33: {
                                            block31: {
                                                if (!(this.buildCounter >= 1.0f) && !instant || count++ >= maxPerFrame || this.plans.size <= 0) break block31;
                                                this.buildCounter -= 1.0f;
                                                if (this.plans.size <= 1) break block32;
                                                size = this.plans.size;
                                                bestDst = Float.MAX_VALUE;
                                                foundAny2 = false;
                                                bestIndex = -1;
                                                break block33;
                                            }
                                            return;
                                        }
                                        for (int total = 0; total < size; ++total) {
                                            boolean within;
                                            BuildPlan plan = this.buildPlan();
                                            float dst = plan.dst2(this);
                                            boolean bl = within = dst <= finalPlaceDst * finalPlaceDst;
                                            if (within && !this.shouldSkip(plan, core)) {
                                                foundAny2 = true;
                                                break;
                                            }
                                            if (within && dst < bestDst) {
                                                bestIndex = total;
                                                bestDst = dst;
                                            }
                                            this.plans.removeFirst();
                                            this.plans.addLast(plan);
                                        }
                                        if (!foundAny2 && bestIndex > 0 && !this.within(this.buildPlan(), finalPlaceDst)) {
                                            for (int i2 = 0; i2 < bestIndex; ++i2) {
                                                this.plans.addLast((BuildPlan)this.plans.removeFirst());
                                            }
                                        }
                                    }
                                    current = this.buildPlan();
                                    tile = current.tile();
                                    this.lastActive = current;
                                    this.buildAlpha = 1.0f;
                                    if (current.breaking) {
                                        this.lastSize = tile.block().size;
                                    }
                                    if (!this.within(tile, finalPlaceDst)) continue;
                                    if (!Vars.headless) {
                                        Vars.control.sound.loop(Sounds.build, tile, 0.15f);
                                    }
                                    if (!((foundAny2 = tile.build) instanceof ConstructBlock.ConstructBuild)) break block34;
                                    cb = (ConstructBlock.ConstructBuild)foundAny2;
                                    if (tile.team() == this.team) break block35;
                                    break block36;
                                }
                                if (current.initialized || current.breaking || !Build.validPlaceIgnoreUnits(current.block, this.team, current.x, current.y, current.rotation, true, true)) break block37;
                                if (Build.checkNoUnitOverlap(current.block, current.x, current.y)) {
                                    boolean hasAll2;
                                    boolean bl = hasAll2 = infinite || current.isRotation(this.team) || tile.team() == Team.derelict && tile.block() == current.block && tile.build != null && tile.block().allowDerelictRepair && Vars.state.rules.derelictRepair || !Structs.contains(current.block.requirements, i -> !core.items.has(i.item, Math.min(Mathf.round((float)i.amount * Vars.state.rules.buildCostMultiplier), 1)));
                                    if (hasAll2) {
                                        Call.beginPlace(this, current.block, this.team, current.x, current.y, current.rotation, current.block.instantBuild ? current.config : null);
                                        if (!Vars.net.client() && current.block.instantBuild) {
                                            if (this.plans.size <= 0) continue;
                                            this.plans.removeFirst();
                                            continue;
                                        }
                                        break block30;
                                    } else {
                                        current.stuck = true;
                                    }
                                    break block30;
                                } else {
                                    this.plans.removeFirst();
                                    this.plans.addLast(current);
                                    continue;
                                }
                            }
                            if (!current.initialized && current.breaking && Build.validBreak(this.team, current.x, current.y)) {
                                Call.beginBreak(this, this.team, current.x, current.y);
                                break block30;
                            } else {
                                this.plans.removeFirst();
                                continue;
                            }
                        }
                        if (tile.team() != Team.derelict) break block38;
                    }
                    if (current.breaking || cb.current == current.block && cb.tile == current.tile()) break block30;
                }
                this.plans.removeFirst();
                continue;
            }
            if (tile.build instanceof ConstructBlock.ConstructBuild && !current.initialized) {
                Events.fire(new EventType.BuildSelectEvent(tile, this.team, this, current.breaking));
                current.initialized = true;
            }
            if (!((hasAll2 = tile.build) instanceof ConstructBlock.ConstructBuild)) continue;
            ConstructBlock.ConstructBuild entity = (ConstructBlock.ConstructBuild)hasAll2;
            float bs = 1.0f / entity.buildCost * this.type.buildSpeed * this.buildSpeedMultiplier * Vars.state.rules.buildSpeed(this.team);
            if (current.breaking) {
                entity.deconstruct(this, core, bs);
            } else if (entity.current != null && (Vars.state.isEditor() || Vars.state.rules.waves && this.team == Vars.state.rules.waveTeam && entity.current.isVisible() || entity.current.unlockedNowHost() && entity.current.environmentBuildable() && entity.current.isPlaceable())) {
                entity.construct(this, core, bs, current.config);
            }
            current.stuck = Mathf.equal(current.progress, entity.progress);
            current.progress = entity.progress;
        }
    }

    @Override
    public void updateDrowning() {
        Floor floor = this.drownFloor();
        if (floor != null && floor.isLiquid && floor.drownTime > 0.0f && this.canDrown()) {
            this.lastDrownFloor = floor;
            this.drownTime += Time.delta / (this.hitSize / 8.0f * this.type.drownTimeMultiplier * floor.drownTime);
            if (Mathf.chanceDelta(0.05f)) {
                floor.drownUpdateEffect.at(this.x, this.y, this.hitSize, floor.mapColor);
            }
            if (this.drownTime >= 0.999f && !Vars.net.client()) {
                this.kill();
                Events.fire(new EventType.UnitDrownEvent(this));
            }
        } else {
            this.drownTime -= Time.delta / 50.0f;
        }
        this.drownTime = Mathf.clamp(this.drownTime);
    }

    @Override
    public void updateLastPosition() {
        this.deltaX = this.x - this.lastX;
        this.deltaY = this.y - this.lastY;
        this.lastX = this.x;
        this.lastY = this.y;
    }

    @Override
    public void validatePlans() {
        if (this.plans.size > 0) {
            Iterator it = this.plans.iterator();
            while (it.hasNext()) {
                boolean isSameDerelict;
                BuildPlan plan = (BuildPlan)it.next();
                Tile tile = Vars.world.tile(plan.x, plan.y);
                boolean bl = isSameDerelict = tile != null && tile.build != null && tile.block() == plan.block && tile.build.tileX() == plan.x && tile.build.tileY() == plan.y && tile.team() == Team.derelict;
                if (tile != null && (!plan.breaking || tile.block() != Blocks.air) && (plan.breaking || (tile.build == null || tile.build.rotation != plan.rotation || isSameDerelict) && plan.block.rotate || (tile.block() != plan.block || isSameDerelict) && (plan.block == null || (!plan.block.isOverlay() || plan.block != tile.overlay()) && (!plan.block.isFloor() || plan.block != tile.floor())))) continue;
                it.remove();
            }
        }
    }

    @Override
    public void velAddNet(Vec2 v) {
        this.vel.add(v);
        if (this.isRemote()) {
            this.x += v.x;
            this.y += v.y;
        }
    }

    @Override
    public void velAddNet(float vx, float vy) {
        this.vel.add(vx, vy);
        if (this.isRemote()) {
            this.x += vx;
            this.y += vy;
        }
    }

    @Override
    public void wobble() {
        this.x += Mathf.sin(Time.time + (float)(this.id % 10 * 12), 25.0f, 0.05f) * Time.delta * this.elevation;
        this.y += Mathf.cos(Time.time + (float)(this.id % 10 * 12), 25.0f, 0.05f) * Time.delta * this.elevation;
    }

    @Override
    public void writeSync(Writes write) {
        TypeIO.writeAbilities(write, this.abilities);
        write.f(this.ammo);
        TypeIO.writeController(write, this.controller);
        write.f(this.elevation);
        write.d(this.flag);
        write.f(this.health);
        write.bool(this.isShooting);
        TypeIO.writeTile(write, this.mineTile);
        TypeIO.writeMounts(write, this.mounts);
        TypeIO.writePlansQueueNet(write, this.plans);
        write.f(this.rotation);
        write.f(this.shield);
        write.bool(this.spawnedByCore);
        TypeIO.writeItems(write, this.stack);
        write.i(this.statuses.size);
        for (int INDEX = 0; INDEX < this.statuses.size; ++INDEX) {
            TypeIO.writeStatus(write, this.statuses.get(INDEX));
        }
        TypeIO.writeTeam(write, this.team);
        write.s(this.type.id);
        write.bool(this.updateBuilding);
        TypeIO.writeVec2(write, this.vel);
        write.f(this.x);
        write.f(this.y);
    }

    @Override
    public void writeSyncManual(FloatBuffer buffer) {
        buffer.put(this.rotation);
        buffer.put(this.x);
        buffer.put(this.y);
    }
}

