/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

public final class IntraEdge {
    public static final long bitMaskDir = 255L;
    public static final long bitMaskPortal = 65280L;
    public static final long bitMaskCost = 0xFFFFFFFF0000L;

    public static int dir(long intraedge) {
        return (int)(intraedge >>> 0 & 0xFFL);
    }

    public static long dir(long intraedge, int value) {
        return intraedge & 0xFFFFFFFFFFFFFF00L | (long)value << 0;
    }

    public static int portal(long intraedge) {
        return (int)(intraedge >>> 8 & 0xFFL);
    }

    public static long portal(long intraedge, int value) {
        return intraedge & 0xFFFFFFFFFFFF00FFL | (long)value << 8;
    }

    public static float cost(long intraedge) {
        return Float.intBitsToFloat((int)(intraedge >>> 16 & 0xFFFFFFFFL));
    }

    public static long cost(long intraedge, float value) {
        return intraedge & 0xFFFF00000000FFFFL | (long)Float.floatToIntBits(value) << 16;
    }

    public static long get(int dir, int portal, float cost) {
        return (long)dir << 0 & 0xFFL | (long)portal << 8 & 0xFF00L | (long)Float.floatToIntBits(cost) << 16;
    }
}

