/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.func.Cons;
import arc.func.Floatf;
import arc.graphics.Color;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.Label;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.editor.MapObjectivesDialog;
import mindustry.editor.WaveGraph;
import mindustry.game.SpawnGroup;
import mindustry.game.Waves;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Tile;

public class WaveInfoDialog
extends BaseDialog {
    Seq<SpawnGroup> groups = new Seq();
    @Nullable
    private SpawnGroup expandedGroup;
    private Table table;
    private int search = -1;
    @Nullable
    private UnitType filterType;
    private Sort sort = Sort.begin;
    private boolean reverseSort = false;
    private boolean checkedSpawns;
    private WaveGraph graph = new WaveGraph();

    public WaveInfoDialog() {
        super("@waves.title");
        this.shown(() -> {
            this.checkedSpawns = false;
            this.setup();
        });
        this.hidden(() -> {
            Vars.state.rules.spawns = this.groups;
        });
        this.addCloseButton();
        this.buttons.button("@waves.edit", Icon.edit, () -> {
            BaseDialog dialog = new BaseDialog("@waves.edit");
            dialog.addCloseButton();
            dialog.setFillParent(false);
            dialog.cont.table(Tex.button, t -> {
                TextButton.TextButtonStyle style = Styles.cleart;
                t.defaults().size(280.0f, 64.0f).pad(2.0f);
                t.button("@waves.copy", (Drawable)Icon.copy, style, () -> {
                    Vars.ui.showInfoFade("@waves.copied");
                    Core.app.setClipboardText(Vars.maps.writeWaves(this.groups));
                    dialog.hide();
                }).disabled(b -> this.groups == null || this.groups.isEmpty()).marginLeft(12.0f).row();
                t.button("@waves.load", (Drawable)Icon.download, style, () -> {
                    try {
                        this.groups = Vars.maps.readWaves(Core.app.getClipboardText());
                        this.buildGroups();
                    }
                    catch (Exception e) {
                        Log.err(e);
                        Vars.ui.showErrorMessage("@waves.invalid");
                    }
                    dialog.hide();
                }).disabled(Core.app.getClipboardText() == null || !Core.app.getClipboardText().startsWith("[")).marginLeft(12.0f).row();
                t.button("@clear", (Drawable)Icon.none, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clear.confirm", () -> {
                    this.groups.clear();
                    this.buildGroups();
                    dialog.hide();
                })).marginLeft(12.0f).row();
                t.button("@settings.reset", (Drawable)Icon.refresh, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clear.confirm", () -> {
                    this.groups = JsonIO.copy(Vars.waves.get());
                    this.buildGroups();
                    dialog.hide();
                })).marginLeft(12.0f);
            });
            dialog.show();
        }).size(250.0f, 64.0f);
        this.buttons.button(Core.bundle.get("waves.random"), Icon.refresh, () -> {
            this.groups.clear();
            this.groups = Waves.generate(0.1f);
            this.buildGroups();
        }).width(200.0f);
    }

    void setup() {
        this.groups = JsonIO.copy(Vars.state.rules.spawns.isEmpty() ? Vars.waves.get() : Vars.state.rules.spawns);
        if (this.groups == null) {
            this.groups = new Seq();
        }
        this.cont.clear();
        this.cont.stack(new Table(Tex.clear, main -> {
            main.table((Table s) -> {
                s.image(Icon.zoom).padRight(8.0f);
                s.field(this.search < 0 ? "" : this.search + 1 + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                    this.search = this.groups.any() ? Strings.parseInt(text, 0) - 1 : -1;
                    this.buildGroups();
                }).growX().maxTextLength(8).get().setMessageText("@waves.search");
                s.button((Drawable)Icon.units, Styles.emptyi, () -> this.showUnits(type -> {
                    this.filterType = type;
                }, true)).size(46.0f).tooltip("@waves.filter").update((T b) -> {
                    b.getStyle().imageUp = this.filterType != null ? new TextureRegionDrawable(this.filterType.uiIcon) : Icon.filter;
                });
            }).growX().pad(6.0f).row();
            main.pane((Table t) -> {
                this.table = t;
            }).grow().padRight(8.0f).scrollX(false).row();
            main.table((Table t) -> {
                t.button("@add", () -> {
                    this.showUnits(type -> {
                        this.expandedGroup = new SpawnGroup((UnitType)type);
                        this.groups.add(this.expandedGroup);
                    }, false);
                    this.buildGroups();
                }).growX().height(70.0f);
                t.button(Icon.filter, () -> {
                    BaseDialog dialog = new BaseDialog("@waves.sort");
                    dialog.setFillParent(false);
                    dialog.cont.table(Tex.button, f -> {
                        for (Sort s : Sort.all) {
                            f.button("@waves.sort." + (Object)((Object)s), Styles.flatTogglet, () -> {
                                this.sort = s;
                                dialog.hide();
                                this.buildGroups();
                            }).size(150.0f, 60.0f).checked(s == this.sort);
                        }
                    }).row();
                    dialog.cont.check("@waves.sort.reverse", b -> {
                        this.reverseSort = b;
                        this.buildGroups();
                    }).padTop(4.0f).checked(this.reverseSort).padBottom(8.0f);
                    dialog.addCloseButton();
                    dialog.show();
                }).size(64.0f, 70.0f).padLeft(6.0f);
            }).growX();
        }), new Label("@waves.none"){
            {
                this.visible(() -> WaveInfoDialog.this.groups.isEmpty());
                this.touchable = Touchable.disabled;
                this.setWrap(true);
                this.setAlignment(1, 1);
            }
        }).width(390.0f).growY();
        this.graph = new WaveGraph();
        this.cont.add(this.graph).grow();
        this.buildGroups();
    }

    void buildGroups() {
        this.table.clear();
        this.table.top();
        this.table.margin(10.0f);
        if (this.groups != null) {
            this.groups.sort(Structs.comps(Structs.comparingFloat(this.sort.sort), Structs.comparingFloat(this.sort.secondary)));
            if (this.reverseSort) {
                this.groups.reverse();
            }
            for (SpawnGroup group : this.groups) {
                if (group.effect == StatusEffects.none) {
                    group.effect = null;
                }
                if (this.search >= 0 && group.getSpawned(this.search) <= 0 || this.filterType != null && group.type != this.filterType) continue;
                this.table.table(Tex.button, t -> {
                    t.margin(0.0f).defaults().pad(3.0f).padLeft(5.0f).growX().left();
                    t.button((Button b) -> {
                        b.left();
                        b.image(group.type.uiIcon).size(32.0f).padRight(3.0f).scaling(Scaling.fit);
                        b.add(group.type.localizedName).ellipsis(true).width(110.0f).left().color(Pal.accent);
                        b.add().growX();
                        b.label(() -> group.begin + 1 + "").color(Color.lightGray).minWidth(45.0f).labelAlign(8).left();
                        b.button((Drawable)Icon.copySmall, Styles.emptyi, () -> {
                            this.expandedGroup = group.copy();
                            this.groups.insert(this.groups.indexOf(group) + 1, this.expandedGroup);
                            this.buildGroups();
                        }).pad(-6.0f).size(46.0f).tooltip("@editor.copy");
                        b.button((Drawable)(group.effect != null ? new TextureRegionDrawable(group.effect.uiIcon) : Icon.logicSmall), Styles.emptyi, () -> this.showEffects(group)).pad(-6.0f).size(46.0f).scaling(Scaling.fit).tooltip(group.effect != null ? group.effect.localizedName : "@none");
                        b.button((Drawable)Icon.unitsSmall, Styles.emptyi, () -> this.showUnits(type -> {
                            group.type = type;
                        }, false)).pad(-6.0f).size(46.0f).tooltip("@stat.unittype");
                        b.button((Drawable)Icon.cancel, Styles.emptyi, () -> {
                            this.groups.remove(group);
                            if (this.expandedGroup == group) {
                                this.expandedGroup = null;
                            }
                            this.table.getCell(t).pad(0.0f);
                            t.remove();
                            this.buildGroups();
                        }).pad(-6.0f).size(46.0f).padRight(-12.0f).tooltip("@waves.remove");
                        b.clicked(KeyCode.mouseMiddle, () -> {
                            this.expandedGroup = group.copy();
                            this.groups.insert(this.groups.indexOf(group) + 1, this.expandedGroup);
                            this.buildGroups();
                        });
                    }, () -> {
                        this.expandedGroup = this.expandedGroup == group ? null : group;
                        this.buildGroups();
                    }).height(46.0f).pad(-6.0f).padBottom(0.0f).row();
                    if (this.expandedGroup == group) {
                        t.table((Table spawns) -> {
                            spawns.field("" + (group.begin + 1), TextField.TextFieldFilter.digitsOnly, (String text) -> {
                                if (Strings.canParsePositiveInt(text)) {
                                    group.begin = Strings.parseInt(text) - 1;
                                    this.updateWaves();
                                }
                            }).width(100.0f);
                            spawns.add("@waves.to").padLeft(4.0f).padRight(4.0f);
                            spawns.field(group.end == Integer.MAX_VALUE ? "" : group.end + 1 + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                                if (Strings.canParsePositiveInt(text)) {
                                    group.end = Strings.parseInt(text) - 1;
                                    this.updateWaves();
                                } else if (text.isEmpty()) {
                                    group.end = Integer.MAX_VALUE;
                                    this.updateWaves();
                                }
                            }).width(100.0f).get().setMessageText("\u221e");
                        }).row();
                        t.table((Table p) -> {
                            p.add("@waves.every").padRight(4.0f);
                            p.field(group.spacing + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                                if (Strings.canParsePositiveInt(text) && Strings.parseInt(text) > 0) {
                                    group.spacing = Strings.parseInt(text);
                                    this.updateWaves();
                                }
                            }).width(100.0f);
                            p.add("@waves.waves").padLeft(4.0f);
                        }).row();
                        t.table((Table a) -> {
                            a.field(group.unitAmount + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                                if (Strings.canParsePositiveInt(text)) {
                                    group.unitAmount = Strings.parseInt(text);
                                    this.updateWaves();
                                }
                            }).width(80.0f);
                            a.add(" + ");
                            a.field(Strings.fixed(Math.max(Mathf.zero(group.unitScaling) ? 0.0f : 1.0f / group.unitScaling, 0.0f), 2), TextField.TextFieldFilter.floatsOnly, (String text) -> {
                                if (Strings.canParsePositiveFloat(text)) {
                                    group.unitScaling = 1.0f / Strings.parseFloat(text);
                                    this.updateWaves();
                                }
                            }).width(80.0f);
                            a.add("@waves.perspawn").padLeft(4.0f);
                        }).row();
                        t.table((Table a) -> {
                            a.field(group.max + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                                if (Strings.canParsePositiveInt(text)) {
                                    group.max = Strings.parseInt(text);
                                    this.updateWaves();
                                }
                            }).width(80.0f);
                            a.add("@waves.max").padLeft(5.0f);
                        }).row();
                        t.table((Table a) -> {
                            a.field((int)group.shields + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                                if (Strings.canParsePositiveInt(text)) {
                                    group.shields = Strings.parseInt(text);
                                    this.updateWaves();
                                }
                            }).width(80.0f);
                            a.add(" + ");
                            a.field((int)group.shieldScaling + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                                if (Strings.canParsePositiveInt(text)) {
                                    group.shieldScaling = Strings.parseInt(text);
                                    this.updateWaves();
                                }
                            }).width(80.0f);
                            a.add("@waves.shields").padLeft(4.0f);
                        }).row();
                        t.check("@waves.guardian", b -> {
                            group.effect = b ? StatusEffects.boss : null;
                            this.buildGroups();
                        }).padTop(4.0f).update((T b) -> b.setChecked(group.effect == StatusEffects.boss)).padBottom(8.0f).row();
                        t.table((Table a) -> {
                            a.add("@waves.team").padRight(8.0f);
                            a.button((Button b) -> b.image(Tex.whiteui).size(24.0f).update((T i) -> i.setColor(group.team == null ? Color.clear : group.team.color)), (Button.ButtonStyle)Styles.squarei, () -> MapObjectivesDialog.showTeamSelect(true, team -> {
                                group.team = team;
                            })).size(38.0f);
                        }).padTop(0.0f).row();
                        t.table((Table a) -> {
                            a.add("@waves.spawn").padRight(8.0f);
                            a.button("", () -> {
                                if (!this.checkedSpawns) {
                                    Vars.spawner.reset();
                                    this.checkedSpawns = true;
                                }
                                BaseDialog dialog = new BaseDialog("@waves.spawn.select");
                                dialog.cont.pane((Table p) -> {
                                    p.background(Tex.button).margin(10.0f);
                                    int i = 0;
                                    int cols = 4;
                                    int max = 20;
                                    if (Vars.spawner.getSpawns().size >= max) {
                                        p.add("[lightgray](first " + max + ")").colspan(cols).padBottom(4.0f).row();
                                    }
                                    for (Tile spawn : Vars.spawner.getSpawns()) {
                                        p.button(spawn.x + ", " + spawn.y, Styles.flatTogglet, () -> {
                                            group.spawn = Point2.pack(spawn.x, spawn.y);
                                            dialog.hide();
                                        }).size(110.0f, 45.0f).checked(spawn.pos() == group.spawn);
                                        if (++i % cols == 0) {
                                            p.row();
                                        }
                                        if (i < 20) continue;
                                        break;
                                    }
                                    if (Vars.spawner.getSpawns().isEmpty()) {
                                        p.add("@waves.spawn.none");
                                    } else {
                                        p.button("@waves.spawn.all", Styles.flatTogglet, () -> {
                                            group.spawn = -1;
                                            dialog.hide();
                                        }).size(110.0f, 45.0f).checked(-1 == group.spawn);
                                    }
                                }).grow();
                                dialog.setFillParent(false);
                                dialog.addCloseButton();
                                dialog.show();
                            }).width(160.0f).height(36.0f).get().getLabel().setText(() -> group.spawn == -1 ? "@waves.spawn.all" : Point2.x(group.spawn) + ", " + Point2.y(group.spawn));
                        }).padBottom(8.0f).row();
                    }
                }).width(340.0f).pad(8.0f);
                this.table.row();
            }
            if (this.table.getChildren().isEmpty() && this.groups.any()) {
                this.table.add("@none.found");
            }
        } else {
            this.table.add("@editor.default");
        }
        this.updateWaves();
    }

    void showUnits(Cons<UnitType> cons, boolean reset) {
        BaseDialog dialog = new BaseDialog(reset ? "@waves.filter" : "");
        dialog.cont.pane((Table p) -> {
            p.defaults().pad(2.0f).fillX();
            if (reset) {
                p.button((Button t) -> {
                    t.left();
                    t.image(Icon.none).size(32.0f).scaling(Scaling.fit).padRight(2.0f);
                    t.add("@settings.resetKey");
                }, () -> {
                    cons.get(null);
                    dialog.hide();
                    this.buildGroups();
                }).margin(12.0f);
            }
            int i = reset ? 1 : 0;
            for (UnitType type : Vars.content.units()) {
                if (type.isHidden()) continue;
                p.button((Button t) -> {
                    t.left();
                    t.image(type.uiIcon).size(32.0f).scaling(Scaling.fit).padRight(2.0f);
                    t.add(type.localizedName);
                }, () -> {
                    cons.get(type);
                    dialog.hide();
                    this.buildGroups();
                }).margin(12.0f);
                if (++i % 3 != 0) continue;
                p.row();
            }
        }).growX().scrollX(false);
        dialog.addCloseButton();
        dialog.show();
    }

    void showEffects(SpawnGroup group) {
        BaseDialog dialog = new BaseDialog("");
        dialog.cont.pane((Table p) -> {
            p.defaults().pad(2.0f).fillX();
            p.button((Button t) -> {
                t.left();
                t.image(Icon.none).size(32.0f).scaling(Scaling.fit).padRight(2.0f);
                t.add("@settings.resetKey");
            }, () -> {
                group.effect = null;
                dialog.hide();
                this.buildGroups();
            }).margin(12.0f);
            int i = 1;
            for (StatusEffect effect : Vars.content.statusEffects()) {
                if (effect.isHidden() || effect.reactive) continue;
                p.button((Button t) -> {
                    t.left();
                    t.image(effect.uiIcon).size(32.0f).scaling(Scaling.fit).padRight(2.0f);
                    t.add(effect.localizedName);
                }, () -> {
                    group.effect = effect;
                    dialog.hide();
                    this.buildGroups();
                }).margin(12.0f);
                if (++i % 3 != 0) continue;
                p.row();
            }
        }).growX().scrollX(false);
        dialog.addCloseButton();
        dialog.show();
    }

    void updateWaves() {
        this.graph.groups = this.groups;
        this.graph.rebuild();
    }

    static enum Sort {
        begin(g -> g.begin, g -> g.type.id),
        health(g -> g.type.health),
        type(g -> g.type.id);

        static final Sort[] all;
        final Floatf<SpawnGroup> sort;
        final Floatf<SpawnGroup> secondary;

        private Sort(Floatf<SpawnGroup> sort) {
            this(sort, g -> g.begin);
        }

        private Sort(Floatf<SpawnGroup> sort, Floatf<SpawnGroup> secondary) {
            this.sort = sort;
            this.secondary = secondary;
        }

        static {
            all = Sort.values();
        }
    }
}

