/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.util.ArcRuntimeException;

public class PathfindQueue {
    private static final double CAPACITY_RATIO_LOW = 1.5;
    private static final double CAPACITY_RATIO_HI = 2.0;
    public int[] queue;
    public float[] weights;
    public int size = 0;

    public PathfindQueue() {
        this(12);
    }

    public PathfindQueue(int initialCapacity) {
        this.queue = new int[initialCapacity];
        this.weights = new float[initialCapacity];
    }

    public boolean empty() {
        return this.size == 0;
    }

    public boolean add(int e, float weight) {
        int i = this.size;
        if (i >= this.queue.length) {
            this.growToSize(i + 1);
        }
        this.size = i + 1;
        if (i == 0) {
            this.queue[0] = e;
            this.weights[0] = weight;
        } else {
            this.siftUp(i, e, weight);
        }
        return true;
    }

    public int peek() {
        return this.size == 0 ? 0 : this.queue[0];
    }

    public void clear() {
        this.size = 0;
    }

    public int poll() {
        if (this.size == 0) {
            return 0;
        }
        int s = --this.size;
        int result = this.queue[0];
        int x = this.queue[s];
        if (s != 0) {
            this.siftDown(0, x, this.weights[s]);
        }
        return result;
    }

    private void siftUp(int k, int x, float weight) {
        while (k > 0) {
            int parent = k - 1 >>> 1;
            int e = this.queue[parent];
            if (weight >= this.weights[parent]) break;
            this.queue[k] = e;
            this.weights[k] = this.weights[parent];
            k = parent;
        }
        this.queue[k] = x;
        this.weights[k] = weight;
    }

    private void siftDown(int k, int x, float weight) {
        int half = this.size >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            int c = this.queue[child];
            int right = child + 1;
            if (right < this.size && this.weights[child] > this.weights[right]) {
                child = right;
                c = this.queue[child];
            }
            if (weight <= this.weights[child]) break;
            this.queue[k] = c;
            this.weights[k] = this.weights[child];
            k = child;
        }
        this.queue[k] = x;
        this.weights[k] = weight;
    }

    private void growToSize(int minCapacity) {
        if (minCapacity < 0) {
            throw new ArcRuntimeException("Capacity upper limit exceeded.");
        }
        int oldCapacity = this.queue.length;
        int newCapacity = (int)(oldCapacity < 64 ? (double)(oldCapacity + 1) * 2.0 : (double)oldCapacity * 1.5);
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        }
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        int[] newQueue = new int[newCapacity];
        float[] newWeights = new float[newCapacity];
        System.arraycopy(this.queue, 0, newQueue, 0, this.size);
        System.arraycopy(this.weights, 0, newWeights, 0, this.size);
        this.queue = newQueue;
        this.weights = newWeights;
    }
}

