/*
 * Decompiled with CFR 0.152.
 */
package arc.scene.ui;

import arc.Core;
import arc.func.Cons;
import arc.func.Func;
import arc.input.KeyCode;
import arc.math.Interp;
import arc.math.geom.Vec2;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.Scene;
import arc.scene.actions.Actions;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Table;
import arc.util.Timer;

public class Tooltip
extends InputListener {
    static Vec2 tmp = new Vec2();
    public final Tooltips manager;
    public final Table container;
    public boolean allowMobile;
    public boolean instant = true;
    public boolean always;
    protected Element targetActor;
    protected Runnable show;

    public Tooltip(Cons<Table> contents) {
        this(contents, Tooltips.getInstance());
    }

    public Tooltip(Cons<Table> contents, Runnable show) {
        this(contents, Tooltips.getInstance());
        this.show = show;
    }

    public Tooltip(Cons<Table> contents, Tooltips manager) {
        this.manager = manager;
        this.container = new Table(){

            @Override
            public void act(float delta) {
                super.act(delta);
                if (Tooltip.this.targetActor != null && Tooltip.this.targetActor.getScene() == null) {
                    this.remove();
                }
            }
        };
        contents.get(this.container);
        this.container.color.a = 0.2f;
        this.container.setScale(0.05f);
        this.container.touchable = Touchable.disabled;
    }

    public Tooltips getManager() {
        return this.manager;
    }

    public Table getContainer() {
        return this.container;
    }

    public void setInstant(boolean instant) {
        this.instant = instant;
    }

    public void setAlways(boolean always) {
        this.always = always;
    }

    @Override
    public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
        if (this.allowMobile && Core.app.isMobile()) {
            this.show(event.listenerActor, x, y);
        }
        if (this.instant) {
            this.container.toFront();
            return true;
        }
        this.manager.touchDown(this);
        return true;
    }

    @Override
    public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
        if (Core.app.isMobile() && this.allowMobile) {
            this.hide();
        }
    }

    @Override
    public boolean mouseMoved(InputEvent event, float x, float y) {
        if (this.container.hasParent()) {
            return false;
        }
        this.setContainerPosition(event.listenerActor, x, y);
        return true;
    }

    protected void setContainerPosition(Element element, float x, float y) {
        this.targetActor = element;
        Scene stage = element.getScene();
        if (stage == null) {
            return;
        }
        this.container.pack();
        float offsetX = this.manager.offsetX;
        float offsetY = this.manager.offsetY;
        float dist = this.manager.edgeDistance;
        Vec2 point = element.localToStageCoordinates(tmp.set(x + offsetX, y - offsetY - this.container.getHeight()));
        if (point.y < dist) {
            point = element.localToStageCoordinates(tmp.set(x + offsetX, y + offsetY));
        }
        if (point.x < dist) {
            point.x = dist;
        }
        if (point.x + this.container.getWidth() > stage.getWidth() - dist) {
            point.x = stage.getWidth() - dist - this.container.getWidth();
        }
        if (point.y + this.container.getHeight() > stage.getHeight() - dist) {
            point.y = stage.getHeight() - dist - this.container.getHeight();
        }
        this.container.setPosition(point.x, point.y);
        point = element.localToStageCoordinates(tmp.set(element.getWidth() / 2.0f, element.getHeight() / 2.0f));
        point.sub(this.container.x, this.container.y);
        this.container.setOrigin(point.x, point.y);
    }

    @Override
    public void enter(InputEvent event, float x, float y, int pointer, Element fromActor) {
        if (Core.app.isMobile()) {
            return;
        }
        if ((pointer != -1 || Core.input.isTouched()) && !this.allowMobile) {
            return;
        }
        Element element = event.listenerActor;
        if (fromActor != null && fromActor.isDescendantOf(element)) {
            return;
        }
        this.show(element, x, y);
    }

    @Override
    public void exit(InputEvent event, float x, float y, int pointer, Element toActor) {
        if (this.allowMobile && Core.app.isMobile()) {
            return;
        }
        if (toActor != null && toActor.isDescendantOf(event.listenerActor)) {
            return;
        }
        this.hide();
    }

    public void show(Element element, float x, float y) {
        this.setContainerPosition(element, x, y);
        this.manager.enter(this);
        this.container.pack();
        if (this.show != null) {
            this.show.run();
        }
    }

    public void hide() {
        this.manager.hide(this);
    }

    public static class Tooltips {
        private static Tooltips instance;
        public Func<String, Tooltip> textProvider = text -> new Tooltip(t -> t.add((CharSequence)text));
        public float initialTime = 2.0f;
        public float subsequentTime = 0.0f;
        public float resetTime = 1.5f;
        public boolean enabled = true;
        public boolean animations = false;
        public float offsetX = 15.0f;
        public float offsetY = 19.0f;
        public float edgeDistance = 7.0f;
        float time = this.initialTime;
        final Timer.Task resetTask = new Timer.Task(){

            @Override
            public void run() {
                time = initialTime;
            }
        };
        Tooltip showTooltip;
        final Timer.Task showTask = new Timer.Task(){

            @Override
            public void run() {
                if (showTooltip == null) {
                    return;
                }
                Scene stage = showTooltip.targetActor.getScene();
                if (stage == null) {
                    return;
                }
                stage.add(showTooltip.container);
                showTooltip.container.toFront();
                showTooltip.container.clearActions();
                this.showAction(showTooltip);
                if (!showTooltip.instant) {
                    time = subsequentTime;
                    resetTask.cancel();
                }
            }
        };

        public static Tooltips getInstance() {
            if (instance == null) {
                instance = new Tooltips();
            }
            return instance;
        }

        public Tooltip create(String text) {
            return this.textProvider.get(text);
        }

        public Tooltip create(String text, boolean mobile) {
            Tooltip result = this.textProvider.get(text);
            result.allowMobile = mobile;
            return result;
        }

        public void touchDown(Tooltip tooltip) {
            this.showTask.cancel();
            if (tooltip.container.remove()) {
                this.resetTask.cancel();
            }
            this.resetTask.run();
            if (this.enabled || tooltip.always) {
                this.showTooltip = tooltip;
                Timer.schedule(this.showTask, this.time);
            }
        }

        public void enter(Tooltip tooltip) {
            this.showTooltip = tooltip;
            this.showTask.cancel();
            if (this.enabled || tooltip.always) {
                if (this.time == 0.0f || tooltip.instant) {
                    this.showTask.run();
                } else {
                    Timer.schedule(this.showTask, this.time);
                }
            }
        }

        public void hide(Tooltip tooltip) {
            this.showTooltip = null;
            this.showTask.cancel();
            if (tooltip.container.hasParent()) {
                this.hideAction(tooltip);
                this.resetTask.cancel();
                Timer.schedule(this.resetTask, this.resetTime);
            }
        }

        protected void showAction(Tooltip tooltip) {
            float actionTime = this.animations ? (this.time > 0.0f ? 0.5f : 0.15f) : 0.1f;
            tooltip.container.setTransform(true);
            tooltip.container.addAction(Actions.parallel((Action)Actions.fadeIn(actionTime, Interp.fade), (Action)Actions.scaleTo(1.0f, 1.0f, actionTime, Interp.fade)));
        }

        protected void hideAction(Tooltip tooltip) {
            tooltip.container.addAction(Actions.sequence((Action)Actions.parallel((Action)Actions.alpha(0.2f, 0.2f, Interp.fade), (Action)Actions.scaleTo(0.05f, 0.05f, 0.2f, Interp.fade)), (Action)Actions.remove()));
        }

        public void instant() {
            this.time = 0.0f;
            this.showTask.run();
            this.showTask.cancel();
        }
    }
}

