/*
 * Decompiled with CFR 0.152.
 */
package arc.scene.style;

import arc.graphics.Color;
import arc.graphics.g2d.NinePatch;
import arc.scene.style.BaseDrawable;
import arc.scene.style.TransformDrawable;

public class NinePatchDrawable
extends BaseDrawable
implements TransformDrawable {
    protected NinePatch patch;

    public NinePatchDrawable() {
    }

    public NinePatchDrawable(NinePatch patch) {
        this.setPatch(patch);
    }

    public NinePatchDrawable(NinePatchDrawable drawable) {
        super(drawable);
        this.setPatch(drawable.patch);
    }

    @Override
    public void draw(float x, float y, float width, float height) {
        this.patch.draw(x, y, width, height);
    }

    @Override
    public void draw(float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        this.patch.draw(x, y, originX, originY, width, height, scaleX, scaleY, rotation);
    }

    public NinePatch getPatch() {
        return this.patch;
    }

    public void setPatch(NinePatch patch) {
        this.patch = patch;
        this.setMinWidth(patch.getTotalWidth());
        this.setMinHeight(patch.getTotalHeight());
        this.setTopHeight(patch.getPadTop());
        this.setRightWidth(patch.getPadRight());
        this.setBottomHeight(patch.getPadBottom());
        this.setLeftWidth(patch.getPadLeft());
    }

    public NinePatchDrawable tint(Color tint) {
        NinePatchDrawable drawable = new NinePatchDrawable(this);
        drawable.setPatch(new NinePatch(drawable.getPatch(), tint));
        return drawable;
    }
}

