/*
 * Decompiled with CFR 0.152.
 */
package arc.backend.sdl;

import arc.Files;
import arc.files.Fi;
import arc.util.ArcRuntimeException;
import arc.util.OS;
import java.io.File;

public final class SdlFiles
implements Files {
    public static final String externalPath = OS.userHome + File.separator;
    public static final String localPath = new File("").getAbsolutePath() + File.separator;

    @Override
    public Fi get(String fileName, Files.FileType type) {
        return new SdlFi(fileName, type);
    }

    @Override
    public String getExternalStoragePath() {
        return externalPath;
    }

    @Override
    public boolean isExternalStorageAvailable() {
        return true;
    }

    @Override
    public String getLocalStoragePath() {
        return localPath;
    }

    @Override
    public boolean isLocalStorageAvailable() {
        return true;
    }

    public static final class SdlFi
    extends Fi {
        public SdlFi(String fileName, Files.FileType type) {
            super(fileName, type);
        }

        public SdlFi(File file, Files.FileType type) {
            super(file, type);
        }

        @Override
        public Fi child(String name) {
            if (this.file.getPath().length() == 0) {
                return new SdlFi(new File(name), this.type);
            }
            return new SdlFi(new File(this.file, name), this.type);
        }

        @Override
        public Fi sibling(String name) {
            if (this.file.getPath().length() == 0) {
                throw new ArcRuntimeException("Cannot get the sibling of the root.");
            }
            return new SdlFi(new File(this.file.getParent(), name), this.type);
        }

        @Override
        public File file() {
            if (this.type == Files.FileType.external) {
                return new File(externalPath, this.file.getPath());
            }
            if (this.type == Files.FileType.local) {
                return new File(localPath, this.file.getPath());
            }
            return this.file;
        }
    }
}

