/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.units;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Time;
import mindustry.entities.Units;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.Ranged;
import mindustry.world.Block;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class RepairTower
extends Block {
    static final float refreshInterval = 6.0f;
    public float range = 80.0f;
    public Color circleColor = Pal.heal;
    public Color glowColor = Pal.heal.cpy().a(0.5f);
    public float circleSpeed = 120.0f;
    public float circleStroke = 3.0f;
    public float squareRad = 3.0f;
    public float squareSpinScl = 0.8f;
    public float glowMag = 0.5f;
    public float glowScl = 8.0f;
    public float healAmount = 1.0f;
    public TextureRegion glow;

    public RepairTower(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.suppressable = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.range, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.repairSpeed, this.healAmount * 60.0f, StatUnit.perSecond);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range, Pal.placing);
    }

    public class RepairTowerBuild
    extends Building
    implements Ranged {
        public float refresh = Mathf.random(6.0f);
        public float warmup = 0.0f;
        public float totalProgress = 0.0f;
        public Seq<Unit> targets = new Seq();

        @Override
        public void updateTile() {
            if (this.potentialEfficiency > 0.0f) {
                float f;
                this.refresh += Time.delta;
                if (f >= 6.0f) {
                    this.targets.clear();
                    this.refresh = 0.0f;
                    Units.nearby(this.team, this.x, this.y, RepairTower.this.range, u -> {
                        if (u.damaged()) {
                            this.targets.add((Unit)u);
                        }
                    });
                }
            }
            if (this.checkSuppression()) {
                this.warmup = 0.0f;
                return;
            }
            boolean any = false;
            if (this.efficiency > 0.0f) {
                for (Unit target : this.targets) {
                    if (!target.damaged()) continue;
                    target.heal(RepairTower.this.healAmount * this.edelta());
                    any = true;
                }
            }
            this.warmup = Mathf.lerpDelta(this.warmup, any ? this.efficiency : 0.0f, 0.08f);
            this.totalProgress += Time.delta / RepairTower.this.circleSpeed;
        }

        @Override
        public boolean shouldConsume() {
            return this.targets.size > 0;
        }

        @Override
        public void draw() {
            super.draw();
            if (this.warmup <= 0.001f) {
                return;
            }
            Draw.z(110.0f);
            float mod = this.totalProgress % 1.0f;
            Draw.color(RepairTower.this.circleColor);
            Lines.stroke(RepairTower.this.circleStroke * (1.0f - mod) * this.warmup);
            Lines.circle(this.x, this.y, RepairTower.this.range * mod);
            Draw.color(Pal.heal);
            Fill.square(this.x, this.y, RepairTower.this.squareRad * this.warmup, Time.time / RepairTower.this.squareSpinScl);
            Draw.reset();
            Drawf.additive(RepairTower.this.glow, RepairTower.this.glowColor, this.warmup * (1.0f - RepairTower.this.glowMag + Mathf.absin(Time.time, RepairTower.this.glowScl, RepairTower.this.glowMag)), this.x, this.y, 0.0f, 31.0f);
        }

        @Override
        public float range() {
            return RepairTower.this.range;
        }

        @Override
        public float warmup() {
            return this.warmup;
        }

        @Override
        public void drawSelect() {
            Drawf.dashCircle(this.x, this.y, RepairTower.this.range, Pal.placing);
        }
    }
}

