/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.EnumSet;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.world.Block;
import mindustry.world.meta.BlockFlag;

public class Radar
extends Block {
    public float discoveryTime = 600.0f;
    public float rotateSpeed = 2.0f;
    public TextureRegion baseRegion;
    public TextureRegion glowRegion;
    public Color glowColor = Pal.turretHeat;
    public float glowScl = 5.0f;
    public float glowMag = 0.6f;

    public Radar(String name) {
        super(name);
        this.solid = true;
        this.update = true;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.hasFogRadius});
        this.outlineIcon = true;
        this.fogRadius = 10;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.baseRegion, this.region};
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.fogRadius * 8, Pal.accent);
    }

    public class RadarBuild
    extends Building {
        public float progress;
        public float lastRadius = 0.0f;
        public float smoothEfficiency = 1.0f;
        public float totalProgress;

        @Override
        public float fogRadius() {
            return (float)Radar.this.fogRadius * this.progress * this.smoothEfficiency;
        }

        @Override
        public void updateTile() {
            this.smoothEfficiency = Mathf.lerpDelta(this.smoothEfficiency, this.efficiency, 0.05f);
            if (Math.abs(this.fogRadius() - this.lastRadius) >= 0.5f) {
                Vars.fogControl.forceUpdate(this.team, this);
                this.lastRadius = this.fogRadius();
            }
            this.progress += this.edelta() / Radar.this.discoveryTime;
            this.progress = Mathf.clamp(this.progress);
            this.totalProgress += this.efficiency * this.edelta();
        }

        @Override
        public boolean canPickup() {
            return false;
        }

        @Override
        public void drawSelect() {
            Drawf.dashCircle(this.x, this.y, this.fogRadius() * 8.0f, Pal.accent);
        }

        @Override
        public void draw() {
            Draw.rect(Radar.this.baseRegion, this.x, this.y);
            Draw.rect(Radar.this.region, this.x, this.y, Radar.this.rotateSpeed * this.totalProgress);
            Drawf.additive(Radar.this.glowRegion, Radar.this.glowColor, Radar.this.glowColor.a * (1.0f - Radar.this.glowMag + Mathf.absin(Radar.this.glowScl, Radar.this.glowMag)), this.x, this.y, Radar.this.rotateSpeed * this.totalProgress, 31.0f);
        }

        @Override
        public float progress() {
            return this.progress;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.progress = read.f();
        }
    }
}

